extends Area2D

@onready var game = get_tree().get_first_node_in_group("game")

var secret_ending := false
var fake := false
var invisible := false


func _ready() -> void:
	update_props()


func update_props() -> void:
	%Collision.disabled = fake
	%Sprite.visible = not secret_ending
	%Sprite3.visible = secret_ending


# In process so they can see it in the editor
func _process(delta: float) -> void:
	%Sprite.visible = not invisible and not secret_ending
	%Sprite2.visible = not invisible
	%Sprite3.visible = not invisible and secret_ending


func _on_body_entered(body: Node2D) -> void:
	game.win(self)
