extends CanvasLayer

@onready var game = get_tree().get_first_node_in_group("game")


func _process(delta: float) -> void:
	%HealthContainer.visible = game.show_health
	%HealthLabel.text = "%d" % max(game.health, 0)
	if game.health >= 1_000_000:
		%HealthLabel.text = "∞"
		
	if game.max_jumps >= 0:
		%JumpsLabel.text = "%d" % (game.max_jumps - get_tree().get_first_node_in_group("player").jumps)
		%JumpsContainer.show()
	else:
		%JumpsContainer.hide()
	
	%CoinsContainer.visible = game.show_coin_count
	if game.coins < game.min_coins:
		%CoinCount.text = "%d/%d" % [game.coins, game.min_coins]
	else:
		%CoinCount.text = "%d" % game.coins
	
	if game.max_time <= 0 or not game.show_time_left:
		%TimeLeft.hide()
	else:
		%TimeLeft.show()
		var time_display = game.max_time - game.time_spent
		time_display = max(time_display, 0)
		%TimeLeft.text = "%d" % ceil(time_display)
	
	if game.progress_source != game.ProgressSource.NONE:
		%ProgressBar.show()
		%ProgressBar.value = floor(game.get_progress() * 100 * 100) / 100
	else:
		%ProgressBar.hide()
		
	%TimerContainer.visible = OptionsManager.show_timer
	%Timer.text = "%.1fs" % (game.checkpoint_time + game.time_spent + game.added_time)
	%CheckpointTime.visible = game.checkpoint_time > 0.0
	%CheckpointTime.text = "%.2fs" % game.checkpoint_time
	
	%TotalJumps.text = "%d jumps" % (game.checkpoint_jumps + get_tree().get_first_node_in_group("player").jumps + game.added_jumps)
	
	%RunButton.visible = game.sprint_mode == game.SprintMode.NORMAL
	if Input.is_action_pressed("run"):
		%RunButton.modulate = Color.from_hsv(0.0, 0.0, 0.5)
	else:
		%RunButton.modulate = Color.WHITE
	
	%PauseButton.visible = OptionsManager.pause_visible


func _on_run_button_pressed() -> void:
	var run_event = InputEventAction.new()
	run_event.action = "run"
	run_event.pressed = not Input.is_action_pressed("run")
	Input.parse_input_event(run_event)
