extends CharacterBody2D


const SPEED = 200.0
var dead := false
var first_physics_process := true
var moving_up = false


func _physics_process(delta: float) -> void:
	if dead:
		return
	
	if first_physics_process:
		first_physics_process = false
		velocity.x = SPEED * (1 if %Sprite.flip_h else -1)
	
	if is_on_wall() and %TurnTimer.is_stopped():
		%TurnTimer.start()
		%Sprite.flip_h = not %Sprite.flip_h
		velocity.x = SPEED * (1 if %Sprite.flip_h else -1)
	
	velocity.x = move_toward(velocity.x, SPEED * (1 if %Sprite.flip_h else -1), 10 * 60 * delta)
	velocity.y = move_toward(velocity.y, 100 * (-1 if moving_up else 1), 5 * 60 * delta)
	
	move_and_slide()
	
	for body in %HurtArea.get_overlapping_bodies():
		var margin = 96.0
		if body.global_position.y + 128 - margin > %HurtCollision.global_position.y - (%HurtCollision.shape.size.y / 2):
			if body.has_method("damage"):
				body.damage(self)
		
		else:
			if body.has_method("bounce"):
				body.bounce(self)
			damage(body)


func damage(body = null, amount: int = 1) -> void:
	dead = true
	
	%Collision.set_deferred("disabled", true)
	%HurtCollision.set_deferred("disabled", true)
	%Sprite.stop()
	%Sprite.scale.y = 0.5
	%Sprite.position.y = 64.0
	%AnimationPlayer.play("die")
	%Sprite.reset_physics_interpolation()
	if body:
		%KillSound.play()


func _on_animation_player_animation_finished(anim_name: StringName) -> void:
	if anim_name == "die":
		queue_free()


func _on_hover_timer_timeout() -> void:
	moving_up = not moving_up
