extends Control

@onready var game = get_tree().get_first_node_in_group("game")
var entity = null
var controls := {}

func _ready() -> void:
	get_tree().paused = true
	%DoneButton.grab_focus.call_deferred()
	var completed_checkpoint_rush = LevelManager.get_level_stats("checkpoint_rush").get("completed", false)
	var props = game.entity_properties.get(game.get_id_from_node(entity))
	for prop_id in props.keys():
		if not completed_checkpoint_rush and (prop_id == "fake" or prop_id == "invisible"):
			continue
		
		var prop = props.get(prop_id)
		var ctrl = null
		if prop.type == "int":
			var title = Label.new()
			title.text = prop.title
			%Props.add_child(title)
			ctrl = SpinBox.new()
			ctrl.rounded = true
			ctrl.value = entity[prop_id]
			ctrl.min_value = prop.min
			ctrl.max_value = prop.max
		elif prop.type == "float":
			var title = Label.new()
			title.text = prop.title
			%Props.add_child(title)
			ctrl = SpinBox.new()
			if prop.step != null:
				ctrl.step = prop.step
			ctrl.value = entity[prop_id]
			ctrl.min_value = prop.min
			ctrl.max_value = prop.max
		elif prop.type == "bool":
			ctrl = CheckButton.new()
			ctrl.text = prop.title
			ctrl.button_pressed = entity[prop_id]
		%Props.add_child(ctrl)
		controls.set(prop_id, ctrl)
	
	if controls.size() == 0:
		_on_done_button_pressed()
	

func _process(delta: float) -> void:
	if Input.is_action_just_pressed("back"):
		_on_done_button_pressed()


func _on_done_button_pressed() -> void:
	var props = game.entity_properties.get(game.get_id_from_node(entity))
	for prop_id in props.keys():
		var prop = props.get(prop_id)
		var ctrl = controls.get(prop_id)
		if ctrl:
			if prop.type == "int" or prop.type == "float":
				entity[prop_id] = ctrl.value
			elif prop.type == "bool":
				entity[prop_id] = ctrl.button_pressed
	
	if "update_props" in entity:
		entity.update_props()
	
	get_tree().paused = false
	queue_free()
