extends CanvasLayer


@onready var game = get_tree().get_first_node_in_group("game")
var level_settings_scene: PackedScene = load("res://scenes/level_settings_menu.tscn")


func _ready() -> void:
	%ScrollLeftButton.visible = DisplayServer.is_touchscreen_available()
	%ScrollRightButton.visible = DisplayServer.is_touchscreen_available()
	%RotateButton.visible = DisplayServer.is_touchscreen_available()
	%FlipButton.visible = DisplayServer.is_touchscreen_available()
	%PropsButton.visible = DisplayServer.is_touchscreen_available()
	%PauseButton.visible = OptionsManager.pause_visible

	if LevelManager.get_level_stats("the_world_of_play_maker").get("beat_secret_ending", false):
		%GrassDecorationAButton.show()
		%BrownMushroomButton.show()
		%RedMushroomButton.show()

	if OptionsManager.got_first_level_extra_secret:
		%BackgroundChangerButton.show()
		%MusicChangerButton.show()
	
	if LevelManager.get_level_stats("switching").get("completed", false):
		%BlueBlockButton.show()
		%RedBlockButton.show()
		%BlueSwitchButton.show()
		%RedSwitchButton.show()
	
	if LevelManager.get_level_stats("cant_stop").get("completed", false):
		%SignButton.show()

	if LevelManager.get_level_stats("sandy_plains").get("completed", false):
		%SandButton.show()
	
	if LevelManager.get_level_stats("precision_hill").get("completed", false):
		%PurpleSwitchButton.show()
		%PurpleBlockButton.show()
		%IceButton.show()
	
	if LevelManager.get_level_stats("blocky_descent").get("completed", false):
		%ClearEffectsButton.show()
		%InvertButton.show()
		%PixelateButton.show()
		%FlipVerticallyButton.show()
		%FlipHorizontallyButton.show()
		%GrayscaleButton.show()
		%HideScreenButton.show()
	
	if LevelManager.get_level_stats("checkpoint_rush").get("completed", false):
		%BrickButton.show()
	
	if LevelManager.get_level_stats("trial_of_the_saws").get("completed", false):
		%GravestoneButton.show()


func _on_settings_button_pressed() -> void:
	game.get_node("%Menu").add_child(level_settings_scene.instantiate())


func _on_scroll_left_button_pressed() -> void:
	# The + 32 is the seperation for the hbox
	%ScrollContainer.scroll_horizontal -= (256 + 32) * 7


func _on_scroll_right_button_pressed() -> void:
	# The + 32 is the seperation for the hbox
	%ScrollContainer.scroll_horizontal += (256 + 32) * 7
