extends Control

var account_scene: PackedScene = load("res://scenes/account_menu.tscn")
var options_menu_scene: PackedScene = load("res://scenes/options_menu.tscn")


func _ready() -> void:
	%Password.grab_focus.call_deferred()


func _process(delta: float) -> void:
	if Input.is_action_just_pressed("back"):
		_on_cancel_button_pressed()


func _on_cancel_button_pressed() -> void:
	get_tree().change_scene_to_packed(account_scene)


func _on_delete_account_button_pressed() -> void:
	if %Confirm.text.strip_edges().to_lower() != "delete my account":
		%Status.text = "Type the confirmation text to delete your account"
		return
	
	%Password.editable = false
	%Confirm.editable = false
	%CancelButton.disabled = true
	%DeleteAccountButton.disabled = true
	%Status.text = "Loading..."
	
	var json = JSON.stringify({
		"password": %Password.text
	})
	
	var headers = ["Content-Type: application/json", "Authorization: Bearer %s" % OptionsManager.login_token]
	%DeleteAccountReq.request("%s/delete_account" % OptionsManager.server_base_url, headers, HTTPClient.METHOD_POST, json)


func _on_delete_account_req_request_completed(result: int, response_code: int, headers: PackedStringArray, body: PackedByteArray) -> void:
	%Password.editable = true
	%Confirm.editable = true
	%CancelButton.disabled = false
	%DeleteAccountButton.disabled = false
	
	var err = Globals.get_req_error(result, response_code, body)
	if err:
		%Status.text = err
		return
		
	OptionsManager.login_token = null
	OptionsManager.save_options()
	get_tree().change_scene_to_packed(options_menu_scene)
