extends StaticBody2D


@onready var game = get_tree().get_first_node_in_group("game")
var target_speed := 4096.0 * 1.25

var fake := false
var invisible := false


func _ready() -> void:
	update_props()


func update_props() -> void:
	%Collision.disabled = fake
	%MoveCollision.disabled = fake


# In process so they can see it in the editor
func _process(delta: float) -> void:
	%Sprite.visible = not invisible


func _physics_process(delta: float) -> void:
	var accel := 0.2
	if game.physics_mode == game.PhysicsMode.STRICT_V2:
		accel = 0.1
	
	var cur_speed := target_speed
	if %Sprite.flip_h:
		cur_speed *= -1
	
	var flip = 1 if %Sprite.flip_h else 0
	var rot = int(round(rotation_degrees / 90)) % 4
	var dir_id = "%d_%d" % [rot, flip]
	
	for body in %MoveArea.get_overlapping_bodies():
		if body.has_meta("conveyor_tracker_%s" % dir_id) and body.get_meta("conveyor_tracker_%s" % dir_id) != self and body in body.get_meta("conveyor_tracker_%s" % dir_id).get_node("%MoveArea").get_overlapping_bodies():
			continue
		 
		body.set_meta("conveyor_tracker_%s" % dir_id, self)
		if rot == 0:
			body.velocity.x = lerp(body.velocity.x, cur_speed, 1 - pow(accel, delta))
		elif rot == 1:
			body.velocity.y = lerp(body.velocity.y, cur_speed, 1 - pow(accel, delta))
		elif rot == 2:
			body.velocity.x = lerp(body.velocity.x, -cur_speed, 1 - pow(accel, delta))
		elif rot == 3:
			body.velocity.y = lerp(body.velocity.y, -cur_speed, 1 - pow(accel, delta))
