extends PanelContainer

var secret_ending_item = load("res://misc/comment_item_secret_ending.tres")

@export var author := "Author"
@export var author_suffix = null
@export var message := "Message goes here..."
@export var upload_time = null
@export var best_time = null
@export var beat_secret_ending = null


func _ready() -> void:
	%AuthorAndTime.text = author
	if author_suffix:
		%AuthorAndTime.text += " " + author_suffix
	if best_time != null:
		%AuthorAndTime.text += " - %.2fs" % best_time
	%Message.text = message
	var month_names = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
	var date = Time.get_date_dict_from_unix_time(upload_time)
	%UploadTime.text = "%s %d, %d" % [month_names[date.month - 1], date.day, date.year]
	if beat_secret_ending:
		add_theme_stylebox_override("panel", secret_ending_item)
