extends Area2D

@onready var game = get_tree().get_first_node_in_group("game")
var amount := 1
var entity_id := -1


func _ready() -> void:
	update_props()
	if game.background == game.Background.RED_SKY\
	and LevelManager.level_id == "the_world_of_play_maker"\
	and game.game_mode == game.GameMode.PLAYING:
		if position.y > -58*256.0:
			queue_free()


func update_props() -> void:
	%AmountLabel.visible = amount != 1
	%AmountLabel.text = str(amount)


func _on_body_entered(body: Node2D) -> void:
	%Collision.queue_free()
	%CollectAudio.play()
	%AnimationPlayer.play("collect")
	game.collected.push_back(entity_id)
	collect()


func collect(the_game = null) -> void:
	if the_game == null:
		the_game = game
	the_game.coins += amount


func _on_animation_player_animation_finished(anim_name: StringName) -> void:
	if anim_name == "collect":
		queue_free()
