extends Area2D

@onready var game = get_tree().get_first_node_in_group("game")


var fake := false
var invisible := false
var respawn_health := 0
var immediate_health := false 


func _ready() -> void:
	update_claimed()
	update_props()


func _process(delta: float) -> void:
	update_claimed()
	%Sprite.visible = not invisible
	%Sprite2.visible = not invisible


func update_claimed() -> void:
	if Vector2i(floor(position / 256)) == game.checkpoint_pos:
		%Sprite.play("claimed")
	else:
		%Sprite.play("unclaimed")


func _on_body_entered(body: Node2D) -> void:
	game.set_checkpoint(self)


func update_props() -> void:
	%Collision.disabled = fake
