extends Control

var account_scene: PackedScene = load("res://scenes/account_menu.tscn")


func _ready() -> void:
	%Username.grab_focus.call_deferred()


func _process(delta: float) -> void:
	if Input.is_action_just_pressed("back"):
		_on_cancel_button_pressed()


func _on_cancel_button_pressed() -> void:
	get_tree().change_scene_to_packed(account_scene)


func _on_change_username_button_pressed() -> void:
	%Username.editable = false
	%CancelButton.disabled = true
	%ChangeUsernameButton.disabled = true
	%Status.text = "Loading..."
	
	var json = JSON.stringify({
		"username": %Username.text
	})
	
	var headers = ["Content-Type: application/json", "Authorization: Bearer %s" % OptionsManager.login_token]
	%ChangeUsernameReq.request("%s/change_username" % OptionsManager.server_base_url, headers, HTTPClient.METHOD_POST, json)


func _on_change_username_req_request_completed(result: int, response_code: int, headers: PackedStringArray, body: PackedByteArray) -> void:
	%Username.editable = true
	%CancelButton.disabled = false
	%ChangeUsernameButton.disabled = false
	
	var err = Globals.get_req_error(result, response_code, body)
	if err:
		%Status.text = err
		return
	
	get_tree().change_scene_to_packed(account_scene)
