extends Control

var main_menu_scene: PackedScene = load("res://scenes/main_menu.tscn")
var online_levels_scene: PackedScene = load("res://scenes/online_levels_menu.tscn")
var game_scene: PackedScene = load("res://scenes/game.tscn")


func _ready() -> void:
	get_tree().paused = false
	%ColorOverlay.modulate = Color.TRANSPARENT
	%ColorOverlay.hide()
	
	%BackButton.grab_focus.call_deferred()
	var since_completed := 1
	for level_item in %Levels.get_children():
		if LevelManager.get_level_stats(level_item.built_in_level_id).completed:
			since_completed = 0
		if since_completed < 2:
			level_item.get_node("%PlayButton").connect("pressed", open_level.bind(level_item.built_in_level_id))
		else:
			level_item.get_node("%PlayButton").hide()
		since_completed += 1
	

func _process(delta: float) -> void:
	if Input.is_action_just_pressed("back"):
		_on_back_button_pressed()


func open_level(level_id: String) -> void:
	LevelManager.level_source = LevelManager.LevelSource.BUILT_IN
	LevelManager.level_id = level_id
	LevelManager.level_data = LevelManager.get_built_in_level_data(LevelManager.level_id)
	LevelManager.editing = false
	LevelManager.verifying = false
	DisplayServer.mouse_set_mode(DisplayServer.MOUSE_MODE_CAPTURED)
	%ColorOverlay.show()
	%AnimationPlayer.play("fade_exit")


func _on_back_button_pressed() -> void:
	get_tree().change_scene_to_packed(main_menu_scene)


func _on_animation_player_animation_finished(anim_name: StringName) -> void:
	if anim_name == "fade_exit":
		get_tree().change_scene_to_packed(game_scene)


func _on_online_button_pressed() -> void:
	get_tree().change_scene_to_packed(online_levels_scene)
