extends Control

var options_menu_scene: PackedScene = load("res://scenes/options_menu.tscn")
var change_username_scene: PackedScene = load("res://scenes/change_username_menu.tscn")
var change_password_scene: PackedScene = load("res://scenes/change_password_menu.tscn")
var delete_account_scene: PackedScene = load("res://scenes/delete_account_menu.tscn")
var login_menu_scene: PackedScene = load("res://scenes/login_menu.tscn")
var server_website := ""
var server_source_code := ""
var server_mastodon := ""
var server_lemmy := ""
var server_peertube := ""
var server_simplex_chat := ""
var server_matrix := ""
var server_xmpp := ""
var server_session_messenger := ""
var server_donation := ""
var expert := false


func _ready() -> void:
	%ServerWebsiteButton.hide()
	%ServerSourceCodeButton.hide()
	%ServerMastodonButton.hide()
	%ServerLemmyButton.hide()
	%ServerPeerTubeButton.hide()
	%ServerSimplexButton.hide()
	%ServerMatrixButton.hide()
	%ServerXmppButton.hide()
	%ServerSessionButton.hide()
	%ServerDonateButton.hide()
	%MotdLabel.hide()
	%ExpertButton.visible = LevelManager.get_level_stats("underground_race").get("completed", false)
	%BackButton.grab_focus.call_deferred()
	
	var headers = ["Content-Type: application/json", "Authorization: Bearer %s" % OptionsManager.login_token]
	%AccountInfoReq.request("%s/account" % OptionsManager.server_base_url, headers)


func _process(delta: float) -> void:
	if Input.is_action_just_pressed("back"):
		_on_back_button_pressed()


func _on_back_button_pressed() -> void:
	get_tree().change_scene_to_packed(options_menu_scene)


func _on_sign_out_button_pressed() -> void:
	OptionsManager.login_token = null
	OptionsManager.save_options()
	_on_back_button_pressed()


func is_website(text: String) -> bool:
	return not text.contains(" ") and not text.contains("\t") and not text.contains("\n") and (text.begins_with("https://") or text.begins_with("http://"))


func _on_account_info_req_request_completed(result: int, response_code: int, headers: PackedStringArray, body: PackedByteArray) -> void:
	var err = Globals.get_req_error(result, response_code, body)
	if err:
		%UsernameStatusLabel.text = err
		%ExpertButton.text = "Expert: " + err
		if err.contains("Invalid login token"):
			OptionsManager.login_token = null
			OptionsManager.save_options()
			get_tree().change_scene_to_packed(login_menu_scene)
		return
	
	var json = JSON.parse_string(body.get_string_from_utf8())
	%UsernameStatusLabel.text = "Username: " + json.get("username")
	
	expert = json.get("expert")
	%ExpertButton.text = "Expert: " + ("Enabled" if expert else "Disabled")
	%ExpertButton.disabled = false
	
	server_website = json.get("server_website", "") if json.get("server_website", "") else ""
	if server_website and is_website(server_website):
		%ServerWebsiteButton.show()
	
	server_source_code = json.get("server_source_code", "") if json.get("server_source_code", "") else ""
	if server_source_code and is_website(server_source_code):
		%ServerSourceCodeButton.show()
	
	server_mastodon = json.get("server_mastodon", "") if json.get("server_mastodon", "") else ""
	if server_mastodon and is_website(server_mastodon):
		%ServerMastodonButton.show()
	
	server_lemmy = json.get("server_lemmy", "") if json.get("server_lemmy", "") else ""
	if server_lemmy and is_website(server_lemmy):
		%ServerLemmyButton.show()
	
	server_peertube = json.get("server_peertube", "") if json.get("server_peertube", "") else ""
	if server_peertube and is_website(server_peertube):
		%ServerPeerTubeButton.show()
	
	server_simplex_chat = json.get("server_simplex_chat", "") if json.get("server_simplex_chat", "") else ""
	if server_simplex_chat and is_website(server_simplex_chat):
		%ServerSimplexButton.show()

	server_matrix = json.get("server_matrix", "") if json.get("server_matrix", "") else ""
	if server_matrix and is_website(server_matrix):
		%ServerMatrixButton.show()
	
	server_xmpp = json.get("server_xmpp", "") if json.get("server_xmpp", "") else ""
	if server_xmpp and is_website(server_xmpp):
		%ServerXmppButton.show()

	server_session_messenger = json.get("server_session_messenger", "") if json.get("server_session_messenger", "") else ""
	if server_session_messenger and is_website(server_session_messenger):
		%ServerSessionButton.show()
	
	server_donation = json.get("server_donation", "") if json.get("server_donation", "") else ""
	if server_donation and is_website(server_donation):
		%ServerDonateButton.show()
	
	var motd = json.get("motd")
	if motd:
		%MotdLabel.text = "MOTD: %s" % motd
		%MotdLabel.show()


func _on_change_username_button_pressed() -> void:
	get_tree().change_scene_to_packed(change_username_scene)


func _on_change_password_button_pressed() -> void:
	get_tree().change_scene_to_packed(change_password_scene)


func _on_delete_account_button_pressed() -> void:
	get_tree().change_scene_to_packed(delete_account_scene)


func _on_server_website_button_pressed() -> void:
	OS.shell_open(server_website)


func _on_server_source_code_button_pressed() -> void:
	OS.shell_open(server_source_code)


func _on_server_mastodon_button_pressed() -> void:
	OS.shell_open(server_mastodon)


func _on_server_lemmy_button_pressed() -> void:
	OS.shell_open(server_lemmy)


func _on_server_peer_tube_button_pressed() -> void:
	OS.shell_open(server_peertube)


func _on_server_simplex_button_pressed() -> void:
	OS.shell_open(server_simplex_chat)


func _on_server_matrix_button_pressed() -> void:
	OS.shell_open(server_matrix)


func _on_server_xmpp_button_pressed() -> void:
	OS.shell_open(server_xmpp)


func _on_server_session_button_pressed() -> void:
	OS.shell_open(server_session_messenger)


func _on_server_donate_button_pressed() -> void:
	OS.shell_open(server_donation)


func _on_expert_button_pressed() -> void:
	for child in %Controls.get_children():
		if "disabled" in child:
			child.disabled = true
	%BackButton.disabled = true
	
	%ExpertButton.text = "Expert: Loading..."
	
	var json = JSON.stringify({
		"expert": not expert
	})
	
	var headers = ["Content-Type: application/json", "Authorization: Bearer %s" % OptionsManager.login_token]
	%ExpertReq.request("%s/expert" % OptionsManager.server_base_url, headers, HTTPClient.METHOD_POST, json)


func _on_expert_req_request_completed(result: int, response_code: int, headers: PackedStringArray, body: PackedByteArray) -> void:
	for child in %Controls.get_children():
		if "disabled" in child:
			child.disabled = false
	%BackButton.disabled = false
	
	var err = Globals.get_req_error(result, response_code, body, false)
	if err:
		%ExpertButton.text = "Expert: " + err
		return
	
	expert = not expert
	%ExpertButton.text = "Expert: " + ("Enabled" if expert else "Disabled")
