/*  Copyright (C) 2025 Thomas Kuehne

    This file is part of Gadgetbridge.

    Gadgetbridge is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published
    by the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Gadgetbridge is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>. */

package nodomain.freeyourgadget.gadgetbridge.service.btle.actions;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothGatt;
import android.os.Build;

import androidx.annotation.RequiresApi;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import nodomain.freeyourgadget.gadgetbridge.service.btle.BtLEAction;
import nodomain.freeyourgadget.gadgetbridge.service.btle.GattCallback;


/// Calls {@link BluetoothGatt#readPhy()}.  The result will be made available asynchronously through
/// {@link GattCallback#onPhyRead(BluetoothGatt, int, int, int)}
@RequiresApi(api = Build.VERSION_CODES.O)
public class ReadPhyAction extends BtLEAction {
    private static final Logger LOG = LoggerFactory.getLogger(ReadPhyAction.class);

    public ReadPhyAction() {
        super(null);
    }

    @Override
    public boolean expectsResult() {
        return true;
    }

    @SuppressLint("MissingPermission")
    @Override
    public boolean run(BluetoothGatt gatt) {
        try {
            gatt.readPhy();
            return true;
        } catch (final Throwable ex) {
            LOG.warn("BluetoothGatt.readPhy failed", ex);
            return false;
        }
    }

    @Override
    public String toString() {
        return getCreationTime() + " " + getClass().getSimpleName();
    }
}
