/*  Copyright (C) 2023-2024 Arjan Schrijver, Gordon Williams

    This file is part of Gadgetbridge.

    Gadgetbridge is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published
    by the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Gadgetbridge is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>. */
package nodomain.freeyourgadget.gadgetbridge.externalevents.notifications;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.PowerManager;
import android.service.notification.StatusBarNotification;

import androidx.core.app.NotificationCompat;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import nodomain.freeyourgadget.gadgetbridge.GBApplication;
import nodomain.freeyourgadget.gadgetbridge.model.NavigationInfoSpec;
import nodomain.freeyourgadget.gadgetbridge.util.Prefs;

public class GoogleMapsNotificationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleMapsNotificationHandler.class);

    private boolean shouldSendNavigation = false;

    static class IconType {
        int[] icon;
        int iconType;

        public IconType(int iconType, int[] icon) {
            this.icon = icon;
            this.iconType = iconType;
        }
    }

    private final List<IconType> knownImages;

    public GoogleMapsNotificationHandler() {
        knownImages = new ArrayList<>();
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_CONTINUE, new int[]{
                0b00000000000000000000000000000000, // Straight on with gaps
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000001000000000000000,
                0b00000000000000011100000000000000,
                0b00000000000000111110000000000000,
                0b00000000000011111111000000000000,
                0b00000000000111111111100000000000,
                0b00000000001111111111110000000000,
                0b00000000011111111111111000000000,
                0b00000000111110111101111100000000,
                0b00000000111100111100111100000000,
                0b00000000011000111100011100000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_CONTINUE, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000001000000000000000,
                0b00000000000000011100000000000000,
                0b00000000000000111110000000000000,
                0b00000000000011111111000000000000,
                0b00000000000111111111100000000000,
                0b00000000001111111111110000000000,
                0b00000000011111111111111000000000,
                0b00000000111110111101111100000000,
                0b00000000111100111100111100000000,
                0b00000000011000111100011100000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_TURN_LEFT, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000001100000000000000000000,
                0b00000000011110000000000000000000,
                0b00000000111110000000000000000000,
                0b00000001111100000000000000000000,
                0b00000011111000000000000000000000,
                0b00000111110000000000000000000000,
                0b00001111111111111111111110000000,
                0b00011111111111111111111111100000,
                0b00001111111111111111111111110000,
                0b00000111100000000000000111111000,
                0b00000011110000000000000001111000,
                0b00000011111000000000000000111000,
                0b00000001111100000000000000111000,
                0b00000000111110000000000000111000,
                0b00000000011110000000000000111000,
                0b00000000000100000000000000111000,
                0b00000000000000000000000000111000,
                0b00000000000000000000000000111000,
                0b00000000000000000000000000111000,
                0b00000000000000000000000000111000,
                0b00000000000000000000000000111000,
                0b00000000000000000000000000111000,
                0b00000000000000000000000000111000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_TURN_RIGHT, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000110000000000,
                0b00000000000000000001111000000000,
                0b00000000000000000001111100000000,
                0b00000000000000000000111110000000,
                0b00000000000000000000011111000000,
                0b00000000000000000000001111100000,
                0b00000001111111111111111111110000,
                0b00000111111111111111111111111000,
                0b00001111111111111111111111111000,
                0b00001111100000000000000111110000,
                0b00011110000000000000001111100000,
                0b00011100000000000000011111000000,
                0b00011100000000000000111110000000,
                0b00011100000000000001111100000000,
                0b00011100000000000001111000000000,
                0b00011100000000000000100000000000,
                0b00011100000000000000000000000000,
                0b00011100000000000000000000000000,
                0b00011100000000000000000000000000,
                0b00011100000000000000000000000000,
                0b00011100000000000000000000000000,
                0b00011100000000000000000000000000,
                0b00011100000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_TURN_LEFT_SLIGHTLY, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000111111111111000000000000,
                0b00000000111111111111000000000000,
                0b00000000111111111111000000000000,
                0b00000000111111000000000000000000,
                0b00000000111111100000000000000000,
                0b00000000111111110000000000000000,
                0b00000000111011111000000000000000,
                0b00000000111001111100000000000000,
                0b00000000111000111110000000000000,
                0b00000000111000011111000000000000,
                0b00000000111000001111100000000000,
                0b00000000111000000111110000000000,
                0b00000000000000000011111000000000,
                0b00000000000000000001111000000000,
                0b00000000000000000000111100000000,
                0b00000000000000000000011100000000,
                0b00000000000000000000011110000000,
                0b00000000000000000000011110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_TURN_LEFT_SLIGHTLY, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000011111111111000000000000000,
                0b00000111111111111000000000000000,
                0b00000111111111111000000000000000,
                0b00000111111100000000000000000000,
                0b00000111111100000000000000000000,
                0b00000111111110000000000000000000,
                0b00000111111111000000000000000000,
                0b00000111101111100000000000000000,
                0b00000111100011110000000000000000,
                0b00000111100011111000000000000000,
                0b00000111100001111100000000000000,
                0b00000011000000111110000000000000,
                0b00000000000000011110000000000000,
                0b00000000000000011111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_TURN_LEFT_SLIGHTLY, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000111111111111000000000000000,
                0b00000111111111111000000000000000,
                0b00000111111111111000000000000000,
                0b00000111111000000000000000000000,
                0b00000111111100000000000000000000,
                0b00000111111110000000000000000000,
                0b00000111111111000000000000000000,
                0b00000111101111100000000000000000,
                0b00000111100111110000000000000000,
                0b00000111100011111000000000000000,
                0b00000111100001111100000000000000,
                0b00000011000000111100000000000000,
                0b00000000000000011110000000000000,
                0b00000000000000011110000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_TURN_RIGHT_SLIGHTLY, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000011111111111100000000,
                0b00000000000011111111111100000000,
                0b00000000000011111111111100000000,
                0b00000000000000000011111100000000,
                0b00000000000000000111111100000000,
                0b00000000000000001111111100000000,
                0b00000000000000011111011100000000,
                0b00000000000000111110011100000000,
                0b00000000000001111100011100000000,
                0b00000000000011111000011100000000,
                0b00000000000111110000011100000000,
                0b00000000001111100000011100000000,
                0b00000000011111000000000000000000,
                0b00000000011110000000000000000000,
                0b00000000111100000000000000000000,
                0b00000000111000000000000000000000,
                0b00000001111000000000000000000000,
                0b00000001111000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_TURN_RIGHT_SLIGHTLY, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000111110000000000,
                0b00000000000000000111111000000000,
                0b00000000000000000011111110000000,
                0b00000000000000000000111111100000,
                0b00000000000000000000011111110000,
                0b00000000000000000001111111110000,
                0b00000000000000001111111111110000,
                0b00000000000000111111111111100000,
                0b00000000000011111111101111100000,
                0b00000000000111111100001111000000,
                0b00000000011111100000001110000000,
                0b00000011111110000000011110000000,
                0b00000011111100000000111100000000,
                0b00000011111000000000011100000000,
                0b00000011111000000000001000000000,
                0b00000011110000000000000000000000,
                0b00000011100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_TURN_RIGHT_SLIGHTLY, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000011111111111100000,
                0b00000000000000011111111111100000,
                0b00000000000000011111111111100000,
                0b00000000000000000000011111100000,
                0b00000000000000000000111111100000,
                0b00000000000000000001111111100000,
                0b00000000000000000011111111100000,
                0b00000000000000000111110111100000,
                0b00000000000000001111100111100000,
                0b00000000000000011111000111100000,
                0b00000000000000111110000111100000,
                0b00000000000000111100000011000000,
                0b00000000000001111000000000000000,
                0b00000000000001111000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_TURN_RIGHT_SLIGHTLY, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000011000000000000,
                0b00000000000000000011100000000000,
                0b00000000000000000111111000000000,
                0b00000000000000000011111110000000,
                0b00000000000000000000111111100000,
                0b00000000000000000000001111110000,
                0b00000000000000000000111111110000,
                0b00000000000000001111111111110000,
                0b00000000000000111111111111100000,
                0b00000000000011111111110111100000,
                0b00000000000111111100001111000000,
                0b00000000001111100000001111000000,
                0b00000000111110000000011110000000,
                0b00000001111100000000011100000000,
                0b00000001111000000000111100000000,
                0b00000011111000000000001000000000,
                0b00000011110000000000000000000000,
                0b00000011110000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_TURN_RIGHT_SLIGHTLY, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000011111111111100000,
                0b00000000000000011111111111100000,
                0b00000000000000011111111111100000,
                0b00000000000000000000011111100000,
                0b00000000000000000000111111100000,
                0b00000000000000000001111111100000,
                0b00000000000000000011111111100000,
                0b00000000000000000111110111100000,
                0b00000000000000001111100111100000,
                0b00000000000000011111000111100000,
                0b00000000000000111110000111100000,
                0b00000000000000111100000011000000,
                0b00000000000001111000000000000000,
                0b00000000000001111000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000011110000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_UTURN_LEFT, new int[]{
                0b00000000000000000000000000000000, // LHD
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000001111110000000000,
                0b00000000000000111111111100000000,
                0b00000000000001111111111110000000,
                0b00000000000011111000111111000000,
                0b00000000000111100000001111100000,
                0b00000000001111000000000111100000,
                0b00000000001111000000000011110000,
                0b00000000001110000000000011110000,
                0b00000000001110000000000001110000,
                0b00000000001110000000000001110000,
                0b00000000001110000000000001110000,
                0b00001100001110001100000001110000,
                0b00011110001110011110000001110000,
                0b00001111001110111110000001110000,
                0b00001111101111111100000001110000,
                0b00000111111111111000000001110000,
                0b00000011111111110000000001110000,
                0b00000001111111100000000001110000,
                0b00000000111111000000000001110000,
                0b00000000001110000000000001110000,
                0b00000000001100000000000001110000,
                0b00000000000000000000000001110000,
                0b00000000000000000000000001110000,
                0b00000000000000000000000001110000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_UTURN_RIGHT, new int[]{
                0b00000000000000000000000000000000, // RHD
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000001111110000000000000000,
                0b00000000111111111100000000000000,
                0b00000001111111111110000000000000,
                0b00000011111100011111000000000000,
                0b00000111110000000111100000000000,
                0b00000111100000000011110000000000,
                0b00001111000000000011110000000000,
                0b00001111000000000001110000000000,
                0b00001110000000000001110000000000,
                0b00001110000000000001110000000000,
                0b00001110000000000001110000000000,
                0b00001110000000110001110000110000,
                0b00001110000001111001110001111000,
                0b00001110000001111101110011110000,
                0b00001110000000111111110111110000,
                0b00001110000000011111111111100000,
                0b00001110000000001111111111000000,
                0b00001110000000000111111110000000,
                0b00001110000000000011111100000000,
                0b00001110000000000001110000000000,
                0b00001110000000000000110000000000,
                0b00001110000000000000000000000000,
                0b00001110000000000000000000000000,
                0b00001110000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_KEEP_LEFT, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000001000000000000000,
                0b00000000000000011100000000000000,
                0b00000000000001111110000000000000,
                0b00000000000001111111000000000000,
                0b00000000000011111111100000000000,
                0b00000000001111111111110000000000,
                0b00000000011111011111111000000000,
                0b00000000011110011101111100000000,
                0b00000000111100011100111100000000,
                0b00000000011000011100011000000000,
                0b00000000000000011100000000000000,
                0b00000000000000011100000000000000,
                0b00000000000000011110000000000000,
                0b00000000000000011110000000000000,
                0b00000000000000011111000000000000,
                0b00000000000000001111100000000000,
                0b00000000000000000111110000000000,
                0b00000000000000000011111000000000,
                0b00000000000000000001111000000000,
                0b00000000000000000000111100000000,
                0b00000000000000000000011100000000,
                0b00000000000000000000011110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_KEEP_RIGHT, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000010000000000000000,
                0b00000000000000111000000000000000,
                0b00000000000001111110000000000000,
                0b00000000000011111110000000000000,
                0b00000000000111111111000000000000,
                0b00000000001111111111110000000000,
                0b00000000011111111011111000000000,
                0b00000000111110111001111000000000,
                0b00000000111100111000111100000000,
                0b00000000011000111000011000000000,
                0b00000000000000111000000000000000,
                0b00000000000000111000000000000000,
                0b00000000000001111000000000000000,
                0b00000000000001111000000000000000,
                0b00000000000011111000000000000000,
                0b00000000000111110000000000000000,
                0b00000000001111100000000000000000,
                0b00000000011111000000000000000000,
                0b00000000011110000000000000000000,
                0b00000000111100000000000000000000,
                0b00000000111000000000000000000000,
                0b00000001111000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
        }));

        knownImages.add(new IconType(NavigationInfoSpec.ACTION_FINISH, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000011111111000000000000,
                0b00000000001111111111110000000000,
                0b00000000011111000011111000000000,
                0b00000000111100000000111100000000,
                0b00000001111000000000011110000000,
                0b00000001110000000000001110000000,
                0b00000011100000000000000111000000,
                0b00000011100000000000000111000000,
                0b00000011000000111100000011000000,
                0b00000111000001111110000011100000,
                0b00000111000001111110000011100000,
                0b00000111000000111100000011100000,
                0b00000111000000111100000011100000,
                0b00000011000000000000000011000000,
                0b00000011100000000000000111000000,
                0b00000011100000000000000111000000,
                0b00000001110000000000001110000000,
                0b00000000111000000000011100000000,
                0b00000000111100000000111100000000,
                0b00000000011100000000111000000000,
                0b00000000001110000001110000000000,
                0b00000000000111000011100000000000,
                0b00000000000011111111000000000000,
                0b00000000000001111110000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000011000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_FINISH, new int[]{
                0b00000000000000000000000000000000, // RHD
                0b00000000111000000000000000000000,
                0b00000111111110000000000000000000,
                0b00001111111111100000000000000000,
                0b00011110000011110000000000000000,
                0b00111100000001110000000000000000,
                0b00111000000000111000000000000000,
                0b00110000010000111000000000000000,
                0b01110000111000011000000000000000,
                0b01110001111000011000000000000000,
                0b01110000111000011000000000000000,
                0b00110000000000111000000000000000,
                0b00111000000000111000000000000000,
                0b00111000000001110000000000000000,
                0b00011100000001110000000000000000,
                0b00011100000011100011000111100000,
                0b00001110000011100111000111100000,
                0b00001111000111000111111111110000,
                0b00000111001111001111111111110000,
                0b00000011101110011111111111110000,
                0b00000011111100011111000111110000,
                0b00000001111000111111000111111000,
                0b00000000111000111111000111111000,
                0b00000000010001111111111111111000,
                0b00000000000001111111111111111100,
                0b00000000000001111111000111111100,
                0b00000000000011111111000111111100,
                0b00000000000011111111000111111110,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_FINISH, new int[]{
                0b00000000000000000000000000000000, // LHD
                0b00000000000000000000011100000000,
                0b00000000000000000011111111100000,
                0b00000000000000000111111111110000,
                0b00000000000000001111000001111000,
                0b00000000000000001110000000111100,
                0b00000000000000011100000000011100,
                0b00000000000000011100001000001100,
                0b00000000000000011000011100001110,
                0b00000000000000011000011110001110,
                0b00000000000000011000011100001110,
                0b00000000000000011100000000001100,
                0b00000000000000011100000000011100,
                0b00000000000000001110000000011100,
                0b00000000000000001110000000111000,
                0b00000111100011000111000000111000,
                0b00000111100011100111000001110000,
                0b00000111111111100011100011110000,
                0b00001111111111110011110011100000,
                0b00001111111111111001110111000000,
                0b00001111100011111000111110000000,
                0b00011111100011111100011110000000,
                0b00011111100011111100011100000000,
                0b00011111111111111110001000000000,
                0b00111111111111111110000000000000,
                0b00111111100011111110000000000000,
                0b00111111100011111111000000000000,
                0b01111111100011111111000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_ROUNDABOUT_LEFT, new int[]{
                0b000000000000000000000000000000000,
                0b000000000000000000000000000000000,
                0b000000000000000000000000000000000,
                0b000000000000000000000000000000000,
                0b000000001111111111100000000000000,
                0b000000001111111111110000000000000,
                0b000000001111111111110000000000000,
                0b000000001111100000000000000000000,
                0b000000001111110000000000000000000,
                0b000000001111111000000000000000000,
                0b000000001111111100000000000000000,
                0b000000001110111110000000000000000,
                0b000000001110011111000000000000000,
                0b000000001110001111100000000000000,
                0b000000001110001111000000000000000,
                0b000000001110011110000000000000000,
                0b000000000000011110000000000000000,
                0b000000000000011100000000000000000,
                0b000000000000011100000000000000000,
                0b000000000000011110000000000000000,
                0b000000000000011110000000000000000,
                0b000000000000001111000000000000000,
                0b000000000000000111111100000000000,
                0b000000000000000111111100000000000,
                0b000000000000000001111100000000000,
                0b000000000000000000011100000000000,
                0b000000000000000000011100000000000,
                0b000000000000000000011100000000000,
                0b000000000000000000000000000000000,
                0b000000000000000000000000000000000,
                0b000000000000000000000000000000000,
                0b000000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_ROUNDABOUT_RIGHT, new int[]{
                0b00000000000000000000000000000000,// GUESSED - this may not be an exact match
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000111111111110000000,
                0b00000000000001111111111110000000,
                0b00000000000001111111111110000000,
                0b00000000000000000000111110000000,
                0b00000000000000000001111110000000,
                0b00000000000000000011111110000000,
                0b00000000000000000111111110000000,
                0b00000000000000001111101110000000,
                0b00000000000000011111001110000000,
                0b00000000000000111110001110000000,
                0b00000000000000011110001110000000,
                0b00000000000000001111001110000000,
                0b00000000000000001111000000000000,
                0b00000000000000000111000000000000,
                0b00000000000000000111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000000011110000000000000,
                0b00000000000111111100000000000000,
                0b00000000000111111100000000000000,
                0b00000000000111110000000000000000,
                0b00000000000111000000000000000000,
                0b00000000000111000000000000000000,
                0b00000000000111000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_ROUNDABOUT_STRAIGHT, new int[]{
                0b00000000000000000000000000000000,// GUESSED - this may not be an exact match
                0b00000000000000011000000000000000,
                0b00000000000000111100000000000000,
                0b00000000000001111110000000000000,
                0b00000000000011111111000000000000,
                0b00000000000111111111100000000000,
                0b00000000001111111111110000000000,
                0b00000000011110111101111000000000,
                0b00000000111100111100111100000000,
                0b00000000111000111100011100000000,
                0b00000000000000111100000000000000,
                0b00000000000011111100000000000000,
                0b00000000000111111100000000000000,
                0b00000000001111111100000000000000,
                0b00000000011111000000000000000000,
                0b00000000011110000000000000000000,
                0b00000000011100000000000000000000,
                0b00000000011100000000000000000000,
                0b00000000011100000000000000000000,
                0b00000000011100000000000000000000,
                0b00000000011110000000000000000000,
                0b00000000011111000000000000000000,
                0b00000000001111111100000000000000,
                0b00000000000111111100000000000000,
                0b00000000000011111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_ROUNDABOUT_STRAIGHT, new int[]{
                0b00000000000000000000000000000000,// GUESSED - this may not be an exact match
                0b00000000000000011000000000000000,
                0b00000000000000111100000000000000,
                0b00000000000001111110000000000000,
                0b00000000000011111111000000000000,
                0b00000000000111111111100000000000,
                0b00000000001111111111110000000000,
                0b00000000011110111101111000000000,
                0b00000000111100111100111100000000,
                0b00000000111000111100011100000000,
                0b00000000000000111100000000000000,
                0b00000000000000111111000000000000,
                0b00000000000000111111100000000000,
                0b00000000000000111111110000000000,
                0b00000000000000000011111000000000,
                0b00000000000000000001111000000000,
                0b00000000000000000000111000000000,
                0b00000000000000000000111000000000,
                0b00000000000000000000111000000000,
                0b00000000000000000000111000000000,
                0b00000000000000000001111000000000,
                0b00000000000000000011111000000000,
                0b00000000000000111111110000000000,
                0b00000000000000111111100000000000,
                0b00000000000000111111000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_ROUNDABOUT_LEFT, new int[]{
                0b00000000000000000000000000000000,// GUESSED - this may not be an exact match
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000011000000000000000000000,
                0b00000000111100000000000000000000,
                0b00000001111100000000000000000000,
                0b00000011111000000000000000000000,
                0b00000111110000000000000000000000,
                0b00001111100000000000000000000000,
                0b00011111111111111110000000000000,
                0b00111111111111111110000000000000,
                0b00111111111111111111000000000000,
                0b00011111111111111111000000000000,
                0b00001111100000001111000000000000,
                0b00000111110000000111110000000000,
                0b00000011111000000011111110000000,
                0b00000001111100000011111111000000,
                0b00000000111100000000111110000000,
                0b00000000011000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_ROUNDABOUT_RIGHT, new int[]{
                0b00000000000000000000000000000000,// GUESSED - this may not be an exact match
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000011000000000,
                0b00000000000000000000111100000000,
                0b00000000000000000000111110000000,
                0b00000000000000000000011111000000,
                0b00000000000000000000001111100000,
                0b00000000000000000000000111110000,
                0b00000000000001111111111111111000,
                0b00000000000001111111111111111100,
                0b00000000000011111111111111111100,
                0b00000000000011111111111111111000,
                0b00000000000011110000000111110000,
                0b00000000001111100000001111100000,
                0b00000001111111000000011111000000,
                0b00000011111111000000111110000000,
                0b00000001111100000000111100000000,
                0b00000001110000000000011000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_ROUNDABOUT_LEFT, new int[]{
                0b00000000000000000000000000000000,// GUESSED - this may not be an exact match
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000111111111111000000000000000,
                0b00000111111111111000000000000000,
                0b00000111111111111000000000000000,
                0b00000111111100000000000000000000,
                0b00000111111100000000000000000000,
                0b00000111111110000000000000000000,
                0b00000111111111000000000000000000,
                0b00000111101111101111111000000000,
                0b00000111100111111111111100000000,
                0b00000111100011111111111110000000,
                0b00000111100001111100011111000000,
                0b00000011000000110000001111000000,
                0b00000000000000000000000111100000,
                0b00000000000000000000000111100000,
                0b00000000000000000000000111100000,
                0b00000000000000000000000111100000,
                0b00000000000000000000001111000000,
                0b00000000000000000000011111000000,
                0b00000000000000000111111110000000,
                0b00000000000000000111111100000000,
                0b00000000000000000111111000000000,
                0b00000000000000000011100000000000,
                0b00000000000000000011100000000000,
                0b00000000000000000011100000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_ROUNDABOUT_RIGHT, new int[]{
                0b00000000000000000000000000000000,// GUESSED - this may not be an exact match
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000011111111111100000,
                0b00000000000000011111111111100000,
                0b00000000000000011111111111100000,
                0b00000000000000000000111111100000,
                0b00000000000000000000111111100000,
                0b00000000000000000001111111100000,
                0b00000000000000000011111111100000,
                0b00000000011111110111110111100000,
                0b00000000111111111111100111100000,
                0b00000001111111111111000111100000,
                0b00000011111000111110000111100000,
                0b00000011110000001100000011000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000111100000000000000000000000,
                0b00000011110000000000000000000000,
                0b00000011111000000000000000000000,
                0b00000001111111100000000000000000,
                0b00000000111111100000000000000000,
                0b00000000011111100000000000000000,
                0b00000000000111000000000000000000,
                0b00000000000111000000000000000000,
                0b00000000000111000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_ROUNDABOUT_LEFT, new int[]{
                0b00000000000000000000000000000000,// GUESSED - this may not be an exact match
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000011000000000000000000000,
                0b00000000111100000000111111100000,
                0b00000001111100000011111111110000,
                0b00000011111000000111111111111000,
                0b00000111110000000111110001111100,
                0b00001111100000001111000000111100,
                0b00011111111111111111000000011110,
                0b00111111111111111110000000011110,
                0b00111111111111111110000000011110,
                0b00011111111111111110000000011110,
                0b00001111100000000000000000111100,
                0b00000111110000000000000001111100,
                0b00000011111000000000011111111000,
                0b00000001111100000000011111110000,
                0b00000000111100000000011111100000,
                0b00000000011000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000001110000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_ROUNDABOUT_RIGHT, new int[]{
                0b00000000000000000000000000000000,// GUESSED - this may not be an exact match
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000011000000000,
                0b00000111111100000000111100000000,
                0b00001111111111000000111110000000,
                0b00011111111111100000011111000000,
                0b00111110001111100000001111100000,
                0b00111100000011110000000111110000,
                0b01111000000011111111111111111000,
                0b01111000000001111111111111111100,
                0b01111000000001111111111111111100,
                0b01111000000001111111111111111000,
                0b00111100000000000000000111110000,
                0b00111110000000000000001111100000,
                0b00011111111000000000011111000000,
                0b00001111111000000000111110000000,
                0b00000111111000000000111100000000,
                0b00000001110000000000011000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000001110000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_ROUNDABOUT_UTURN, new int[]{
                0b00000000000000000000000000000000, // LHD
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000001111111000000000000,
                0b00000000000011111111110000000000,
                0b00000000000111111111110000000000,
                0b00000000001111100001111000000000,
                0b00000000001111000000111100000000,
                0b00000000011110000000111100000000,
                0b00000000011110000000011100000000,
                0b00000000011110000000011100000000,
                0b00000000011110000000111100000000,
                0b00000000001111000000111100000000,
                0b00000000001111100001111000000000,
                0b00000000000111110011110000000000,
                0b00000000000011110011110000000000,
                0b00000000000011110010000000000000,
                0b00000000000011110000000000000000,
                0b00000001100011110001100000000000,
                0b00000011110011110011110000000000,
                0b00000001111011110111110000000000,
                0b00000000111111111111100000000000,
                0b00000000011111111111000000000000,
                0b00000000001111111110100000000000,
                0b00000000000111111101100000000000,
                0b00000000000011111011100000000000,
                0b00000000000001110011100000000000,
                0b00000000000000100011100000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_ROUNDABOUT_UTURN, new int[]{
                0b00000000000000000000000000000000, // RHD
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000011111110000000000000,
                0b00000000001111111111000000000000,
                0b00000000001111111111100000000000,
                0b00000000011110000111110000000000,
                0b00000000111100000011110000000000,
                0b00000000111100000001111000000000,
                0b00000000111000000001111000000000,
                0b00000000111000000001111000000000,
                0b00000000111100000001111000000000,
                0b00000000111100000011110000000000,
                0b00000000011110000111110000000000,
                0b00000000001111001111100000000000,
                0b00000000001111001111000000000000,
                0b00000000000001001111000000000000,
                0b00000000000000001111000000000000,
                0b00000000000110001111000110000000,
                0b00000000001111001111001111000000,
                0b00000000001111101111011110000000,
                0b00000000000111111111111100000000,
                0b00000000000011111111111000000000,
                0b00000000000101111111110000000000,
                0b00000000000110111111100000000000,
                0b00000000000111011111000000000000,
                0b00000000000111001110000000000000,
                0b00000000000111000100000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_MERGE, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000011000000000000000,
                0b00000000000000111100000000000000,
                0b00000000000001111110000000000000,
                0b00000000000011111111000000000000,
                0b00000000000111111111100000000000,
                0b00000000001111111111110000000000,
                0b00000000011111111111111000000000,
                0b00000000011111111111111000000000,
                0b00000000111100111100111100000000,
                0b00000000011000111100011000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000001111110000000000000,
                0b00000000000001111110000000000000,
                0b00000000000011111111000000000000,
                0b00000000000111100111100000000000,
                0b00000000001111100111110000000000,
                0b00000000011111000011110000000000,
                0b00000000011110000001111000000000,
                0b00000000011100000000111000000000,
                0b00000000111100000000111100000000,
                0b00000000111100000000111100000000,
                0b00000000111000000000011100000000,
                0b00000000111000000000011100000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
        knownImages.add(new IconType(NavigationInfoSpec.ACTION_MERGE, new int[]{
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000011000000000000000,
                0b00000000000000111100000000000000,
                0b00000000000001111110000000000000,
                0b00000000000011111111000000000000,
                0b00000000000111111111100000000000,
                0b00000000001111111111110000000000,
                0b00000000011111111111111000000000,
                0b00000000111110111101111100000000,
                0b00000000111100111100111100000000,
                0b00000000011000111100011000000000,
                0b00000000000000111100000000000000,
                0b00000000000000111100000000000000,
                0b00000000000001111110000000000000,
                0b00000000000001111110000000000000,
                0b00000000000011111111000000000000,
                0b00000000000111100111100000000000,
                0b00000000001111000011110000000000,
                0b00000000001111000011110000000000,
                0b00000000011110000001111000000000,
                0b00000000011100000000111000000000,
                0b00000000111100000000111100000000,
                0b00000000111000000000011100000000,
                0b00000000111000000000011100000000,
                0b00000000111000000000011100000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000,
                0b00000000000000000000000000000000
        }));
    }

    public boolean handle(Context context, StatusBarNotification sbn) {
        if (sbn.getPackageName().equals("com.google.android.apps.maps")) {
            checkShouldSendNavigation(context);
            if (!shouldSendNavigation) return false;
            Notification notification = sbn.getNotification();
            if (!NotificationCompat.getLocalOnly(notification))
                return false; // ignore non-local notifications

            final String distance = Optional.ofNullable(notification.extras.get("android.title")).orElse("").toString(); // eg 100 yd
            final String instruction = Optional.ofNullable(notification.extras.get("android.text")).orElse("").toString();  // eg: High St towards Blah
            final String navLine = Optional.ofNullable(notification.extras.get("android.subText")).orElse("").toString()
                    .replaceAll("\u00A0", " "); // eg: 13 min · 4.6 mi · 11:55 ETA

            final String[] navLines = navLine.split("·");
            for (int i = 0; i < navLines.length; i++) navLines[i] = navLines[i].trim();
            if (navLines.length < 3)
                return false; // not in the format we expected - might be 'Shared with you' notification
            // navLines now has at least 3 elements
            LOG.info("Google Maps notification: {},{},{},{},{}", instruction, distance, navLines[0], navLines[1], navLines[2]);
            int matchedIcon = -1;
            // getLargeIcon only works in API 23+ - don't try and get icons on older devices
            Icon icon = notification.getLargeIcon();
            if (icon != null) {
                // We convert the icon to a bitmap, then to x 32x32 1bpp which we'll check against known images
                Drawable drawable = icon.loadDrawable(context);
                Bitmap bitmap = Bitmap.createBitmap(32, 32, Bitmap.Config.ARGB_8888); // Single color bitmap will be created of 1x1 pixel
                Canvas canvas = new Canvas(bitmap);
                drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                drawable.draw(canvas);
                int[] pixelsRGBA = new int[32 * 32];
                bitmap.getPixels(pixelsRGBA, 0, 32, 0, 0, 32, 32);
                int[] pixelPack = new int[32]; // pixels packed down 1bpp
                char[] pixelStringChars = new char[33 * 32];

                for (int y = 0; y < 32; y++) {
                    int pack = 0;
                    for (int x = 0; x < 32; x++) {
                        int pixel = ((pixelsRGBA[(y * 32) + x] & 0x80000000) != 0) ? 1 : 0;
                        pack = (pack << 1) | pixel; // check top bit (=alpha)
                        pixelStringChars[x + y * 33] = (pixel != 0) ? '1' : '0';
                    }
                    pixelStringChars[32 + y * 33] = '\n';
                    pixelPack[y] = pack;
                }
                // This is now a printable string showing the image, which we can log if we don't recognise it
                String pixelString = new String(pixelStringChars);

                int bestDiff = 100;
                for (int i = 0; i < knownImages.size(); i++) {
                    IconType knownImage = knownImages.get(i);
                    int diff = 0;
                    // Work out how many bits differ over the whole image
                    for (int j = 0; j < 32; j++)
                        diff += Integer.bitCount(knownImage.icon[j] ^ pixelPack[j]);
                    // if it's close enough, match
                    if (diff < 32 && diff < bestDiff) {
                        matchedIcon = knownImage.iconType;
                        bestDiff = diff;
                    }
                }
                if (matchedIcon < 0) {
                    LOG.warn("New Google Maps icon:\n{}", pixelString);
                    knownImages.add(new IconType(255, pixelPack));
                }
            }
            final NavigationInfoSpec navInfo = new NavigationInfoSpec();
            if (matchedIcon >= 0)
                navInfo.nextAction = matchedIcon;
            navInfo.instruction = instruction;
            if (!distance.isBlank())
                navInfo.distanceToTurn = distance;
            if (navLines[2].contains("ETA"))
                navInfo.ETA = navLines[2].replace("ETA", "").trim();

            LOG.info("Parsed navigation: {}", navInfo);

            GBApplication.deviceService().onSetNavigationInfo(navInfo);

            return true;
        }
        return false;
    }

    public boolean handleRemove(final StatusBarNotification sbn) {
        if (sbn.getPackageName().equals("com.google.android.apps.maps")) {
            if (!shouldSendNavigation) return false;
            Notification notification = sbn.getNotification();
            if (!NotificationCompat.getLocalOnly(notification))
                return false; // ignore non-local notifications
            NavigationInfoSpec navInfo = new NavigationInfoSpec(); // send a blank one to remove
            GBApplication.deviceService().onSetNavigationInfo(navInfo);
            return true;
        }
        return false;
    }

    private void checkShouldSendNavigation(final Context context) {
        final Prefs prefs = GBApplication.getPrefs();

        final boolean navigationForward = prefs.getBoolean("navigation_forward", true);
        final boolean navigationGMaps = prefs.getBoolean("navigation_app_gmaps", true);
        if (!navigationForward || !navigationGMaps) {
            shouldSendNavigation = false;
            return;
        }

        final boolean navigationScreenOn = prefs.getBoolean("nagivation_screen_on", true);
        if (!navigationScreenOn) {
            PowerManager powermanager = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
            if (powermanager != null && powermanager.isScreenOn()) {
                LOG.info("Not forwarding navigation instructions, screen seems to be on and settings do not allow this");
                shouldSendNavigation = false;
                return;
            }
        }

        shouldSendNavigation = true;
    }
}
