/*  Copyright (C) 2015-2024 Andreas Shimokawa

    This file is part of Gadgetbridge.

    Gadgetbridge is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published
    by the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Gadgetbridge is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>. */
package nodomain.freeyourgadget.gadgetbridge.devices.pebble;

public final class PebbleIconID {

    public static final int NOTIFICATION_GENERIC = 1;
    public static final int TIMELINE_MISSED_CALL = 2;
    public static final int NOTIFICATION_REMINDER = 3;
    public static final int NOTIFICATION_FLAG = 4;
    public static final int NOTIFICATION_WHATSAPP = 5;
    public static final int NOTIFICATION_TWITTER = 6;
    public static final int NOTIFICATION_TELEGRAM = 7;
    public static final int NOTIFICATION_GOOGLE_HANGOUTS = 8;
    public static final int NOTIFICATION_GMAIL = 9;
    public static final int NOTIFICATION_FACEBOOK_MESSENGER = 10;
    public static final int NOTIFICATION_FACEBOOK = 11;
    public static final int AUDIO_CASSETTE = 12;
    public static final int ALARM_CLOCK = 13;
    public static final int TIMELINE_WEATHER = 14;
    public static final int TIMELINE_SUN = 16;
    public static final int TIMELINE_SPORTS = 17;
    public static final int GENERIC_EMAIL = 19;
    public static final int AMERICAN_FOOTBALL = 20;
    public static final int TIMELINE_CALENDAR = 21;
    public static final int TIMELINE_BASEBALL = 22;
    public static final int BIRTHDAY_EVENT = 23;
    public static final int CAR_RENTAL = 24;
    public static final int CLOUDY_DAY = 25;
    public static final int CRICKET_GAME = 26;
    public static final int DINNER_RESERVATION = 27;
    public static final int GENERIC_WARNING = 28;
    public static final int GLUCOSE_MONITOR = 29;
    public static final int HOCKEY_GAME = 30;
    public static final int HOTEL_RESERVATION = 31;
    public static final int LIGHT_RAIN = 32;
    public static final int LIGHT_SNOW = 33;
    public static final int MOVIE_EVENT = 34;
    public static final int MUSIC_EVENT = 35;
    public static final int NEWS_EVENT = 36;
    public static final int PARTLY_CLOUDY = 37;
    public static final int PAY_BILL = 38;
    public static final int RADIO_SHOW = 39;
    public static final int SCHEDULED_EVENT = 40;
    public static final int SOCCER_GAME = 41;
    public static final int STOCKS_EVENT = 42;
    public static final int RESULT_DELETED = 43;
    public static final int CHECK_INTERNET_CONNECTION = 44;
    public static final int GENERIC_SMS = 45;
    public static final int RESULT_MUTE = 46;
    public static final int RESULT_SENT = 47;
    public static final int WATCH_DISCONNECTED = 48;
    public static final int DURING_PHONE_CALL = 49;
    public static final int TIDE_IS_HIGH = 50;
    public static final int RESULT_DISMISSED = 51;
    public static final int HEAVY_RAIN = 52;
    public static final int HEAVY_SNOW = 53;
    public static final int SCHEDULED_FLIGHT = 54;
    public static final int GENERIC_CONFIRMATION = 55;
    public static final int DAY_SEPARATOR = 56;
    public static final int NO_EVENTS = 57;
    public static final int NOTIFICATION_BLACKBERRY_MESSENGER = 58;
    public static final int NOTIFICATION_INSTAGRAM = 59;
    public static final int NOTIFICATION_MAILBOX = 60;
    public static final int NOTIFICATION_GOOGLE_INBOX = 61;
    public static final int RESULT_FAILED = 62;
    public static final int GENERIC_QUESTION = 63;
    public static final int NOTIFICATION_OUTLOOK = 64;
    public static final int RAINING_AND_SNOWING = 65;
    public static final int REACHED_FITNESS_GOAL = 66;
    public static final int NOTIFICATION_LINE = 67;
    public static final int NOTIFICATION_SKYPE = 68;
    public static final int NOTIFICATION_SNAPCHAT = 69;
    public static final int NOTIFICATION_VIBER = 70;
    public static final int NOTIFICATION_WECHAT = 71;
    public static final int NOTIFICATION_YAHOO_MAIL = 72;
    public static final int TV_SHOW = 73;
    public static final int BASKETBALL = 74;
    public static final int DISMISSED_PHONE_CALL = 75;
    public static final int NOTIFICATION_GOOGLE_MESSENGER = 76;
    public static final int NOTIFICATION_HIPCHAT = 77;
    public static final int INCOMING_PHONE_CALL = 78;
    public static final int NOTIFICATION_KAKAOTALK = 79;
    public static final int NOTIFICATION_KIK = 80;
    public static final int NOTIFICATION_LIGHTHOUSE = 81;
    public static final int LOCATION = 82;
    public static final int SETTINGS = 83;
    public static final int SUNRISE = 84;
    public static final int SUNSET = 85;
    public static final int RESULT_UNMUTE = 86;
    public static final int RESULT_UNMUTE_ALT = 94;
    public static final int DURING_PHONE_CALL_CENTERED = 95;
    public static final int TIMELINE_EMPTY_CALENDAR = 96;
    public static final int THUMBS_UP = 97;
    public static final int ARROW_UP = 98;
    public static final int ARROW_DOWN = 99;
    public static final int ACTIVITY = 100;
    public static final int SLEEP = 101;
    public static final int REWARD_BAD = 102;
    public static final int REWARD_GOOD = 103;
    public static final int REWARD_AVERAGE = 104;
    public static final int NOTIFICATION_FACETIME = 110;

    // >=4.0 only from here
    public static final int NOTIFICATION_AMAZON = 111;
    public static final int NOTIFICATION_GOOGLE_MAPS = 112;
    public static final int NOTIFICATION_GOOGLE_PHOTOS = 113;
    public static final int NOTIFICATION_IOS_PHOTOS = 114;
    public static final int NOTIFICATION_LINKEDIN = 115;
    public static final int NOTIFICATION_SLACK = 116;

    // >=4.9 only from here (core devices)
    public static final int NOTIFICATION_BEEPER = 120;
    public static final int NOTIFICATION_DISCORD = 121;
    public static final int NOTIFICATION_BLUESKY = 122;
    public static final int NOTIFICATION_DUOLINGO = 123;
    public static final int NOTIFICATION_ELEMENT = 124;
    public static final int NOTIFICATION_GOOGLE_CHAT = 125;
    public static final int NOTIFICATION_GOOGLE_TASKS = 126;
    public static final int NOTIFICATION_HOME_ASSISTANT = 127;
    public static final int NOTIFICATION_STEAM = 128;
    public static final int NOTIFICATION_TEAMS = 129;
    public static final int NOTIFICATION_THREADS = 130;
    public static final int NOTIFICATION_UNIFI_PROTECT = 131;
    public static final int NOTIFICATION_ZOOM = 132;
    public static final int NOTIFICATION_EBAY = 133;
}
