// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'Y'.
class PartY {
  /// Applies the Yaldevi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yaldevi
  static TextStyle yaldevi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '01d784070789652eba80646aae811ab4e91be2285acc590b6e4e11389383407c',
        265716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ab427c9fad89f47afd6f17f1bad129750fbfbe5037c1f3a3dcab27ca9ca531ae',
        266340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '911a8d73d5596b0867f83aba4b4e0b8b41282c700583451a742644cda469d864',
        266552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c03eadee56f99b14ef0207bd52b5eb43d59bc4ba61edc8e1bc8803569d3d6d64',
        266668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bf668a0ffb6a6ad07d20b65b94848d6495a27738c8c35edece2ec7bf8952d369',
        266816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fafafaf3f6901d980a8820ae9c0915a2278a7a7d63b6028b0eff748800e8475f',
        266040,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Yaldevi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yaldevi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yaldevi
  static TextTheme yaldeviTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yaldevi(textStyle: textTheme.displayLarge),
      displayMedium: yaldevi(textStyle: textTheme.displayMedium),
      displaySmall: yaldevi(textStyle: textTheme.displaySmall),
      headlineLarge: yaldevi(textStyle: textTheme.headlineLarge),
      headlineMedium: yaldevi(textStyle: textTheme.headlineMedium),
      headlineSmall: yaldevi(textStyle: textTheme.headlineSmall),
      titleLarge: yaldevi(textStyle: textTheme.titleLarge),
      titleMedium: yaldevi(textStyle: textTheme.titleMedium),
      titleSmall: yaldevi(textStyle: textTheme.titleSmall),
      bodyLarge: yaldevi(textStyle: textTheme.bodyLarge),
      bodyMedium: yaldevi(textStyle: textTheme.bodyMedium),
      bodySmall: yaldevi(textStyle: textTheme.bodySmall),
      labelLarge: yaldevi(textStyle: textTheme.labelLarge),
      labelMedium: yaldevi(textStyle: textTheme.labelMedium),
      labelSmall: yaldevi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yanone Kaffeesatz font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yanone+Kaffeesatz
  static TextStyle yanoneKaffeesatz({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3de80e7ab510ebd8fef26d5f336d566b678f51745ed36d5b02c76977e305fd0e',
        70824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b7f78a5dd059c43c523e1cd1c99d5c82fcb002468daf0c20a17dac7ef5b14c62',
        71232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae44591f2894f8bf51d1c6c363fffecbd33cd543a5a526991e2e44318e6b6253',
        71252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a526f728eff0facc7cba48b72a875386586beeafaedf8fc6725b1d9d4a5a98b7',
        71276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9383477344a19f0ef57b99a1fe0a8d0de67b8f020d9a701a05f17a7336cba0a1',
        71204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02f3a6a61665a42c7050f3fc4634fac8d3a6c1e7dd852e4b80423e46d45f616c',
        71080,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YanoneKaffeesatz',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yanone Kaffeesatz font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yanone+Kaffeesatz
  static TextTheme yanoneKaffeesatzTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yanoneKaffeesatz(textStyle: textTheme.displayLarge),
      displayMedium: yanoneKaffeesatz(textStyle: textTheme.displayMedium),
      displaySmall: yanoneKaffeesatz(textStyle: textTheme.displaySmall),
      headlineLarge: yanoneKaffeesatz(textStyle: textTheme.headlineLarge),
      headlineMedium: yanoneKaffeesatz(textStyle: textTheme.headlineMedium),
      headlineSmall: yanoneKaffeesatz(textStyle: textTheme.headlineSmall),
      titleLarge: yanoneKaffeesatz(textStyle: textTheme.titleLarge),
      titleMedium: yanoneKaffeesatz(textStyle: textTheme.titleMedium),
      titleSmall: yanoneKaffeesatz(textStyle: textTheme.titleSmall),
      bodyLarge: yanoneKaffeesatz(textStyle: textTheme.bodyLarge),
      bodyMedium: yanoneKaffeesatz(textStyle: textTheme.bodyMedium),
      bodySmall: yanoneKaffeesatz(textStyle: textTheme.bodySmall),
      labelLarge: yanoneKaffeesatz(textStyle: textTheme.labelLarge),
      labelMedium: yanoneKaffeesatz(textStyle: textTheme.labelMedium),
      labelSmall: yanoneKaffeesatz(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yantramanav font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yantramanav
  static TextStyle yantramanav({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f8f821f9254c1ee4ecea7437fd67cd27c149b11d8296aeacbdffbf992c2998e',
        100516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '75b590ebf7b02489e059eafe9ffe1c9cde5b4a431947359d83cf562e3342e6c9',
        98840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba40b6246a83ce74fb3bf05b7ee892ea531feb9f4e869fb3c2c759976cf8b852',
        98748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc240eb9595734f0b1047c9d10dc728797e54173912cbf4098848d2dcbedff2f',
        97680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '42cb4a2a758648f5405d8cfbd8821a04704a37d0ad5c86201cf5ca1055aaa4d6',
        98144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc57c0cf68b6eaa6d0676269df4aade8e22c06f6085520d608b197dfdbf3834e',
        97960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Yantramanav',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yantramanav font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yantramanav
  static TextTheme yantramanavTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yantramanav(textStyle: textTheme.displayLarge),
      displayMedium: yantramanav(textStyle: textTheme.displayMedium),
      displaySmall: yantramanav(textStyle: textTheme.displaySmall),
      headlineLarge: yantramanav(textStyle: textTheme.headlineLarge),
      headlineMedium: yantramanav(textStyle: textTheme.headlineMedium),
      headlineSmall: yantramanav(textStyle: textTheme.headlineSmall),
      titleLarge: yantramanav(textStyle: textTheme.titleLarge),
      titleMedium: yantramanav(textStyle: textTheme.titleMedium),
      titleSmall: yantramanav(textStyle: textTheme.titleSmall),
      bodyLarge: yantramanav(textStyle: textTheme.bodyLarge),
      bodyMedium: yantramanav(textStyle: textTheme.bodyMedium),
      bodySmall: yantramanav(textStyle: textTheme.bodySmall),
      labelLarge: yantramanav(textStyle: textTheme.labelLarge),
      labelMedium: yantramanav(textStyle: textTheme.labelMedium),
      labelSmall: yantramanav(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yatra One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yatra+One
  static TextStyle yatraOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1186b7bd1945106e35a4ce4e71402db39e66d631aa1ac349ea3d94f36443d7ae',
        195904,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YatraOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yatra One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yatra+One
  static TextTheme yatraOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yatraOne(textStyle: textTheme.displayLarge),
      displayMedium: yatraOne(textStyle: textTheme.displayMedium),
      displaySmall: yatraOne(textStyle: textTheme.displaySmall),
      headlineLarge: yatraOne(textStyle: textTheme.headlineLarge),
      headlineMedium: yatraOne(textStyle: textTheme.headlineMedium),
      headlineSmall: yatraOne(textStyle: textTheme.headlineSmall),
      titleLarge: yatraOne(textStyle: textTheme.titleLarge),
      titleMedium: yatraOne(textStyle: textTheme.titleMedium),
      titleSmall: yatraOne(textStyle: textTheme.titleSmall),
      bodyLarge: yatraOne(textStyle: textTheme.bodyLarge),
      bodyMedium: yatraOne(textStyle: textTheme.bodyMedium),
      bodySmall: yatraOne(textStyle: textTheme.bodySmall),
      labelLarge: yatraOne(textStyle: textTheme.labelLarge),
      labelMedium: yatraOne(textStyle: textTheme.labelMedium),
      labelSmall: yatraOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yellowtail font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yellowtail
  static TextStyle yellowtail({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae2bea559dbbd682ec8df15b94994a2407f9ddcb4cc88312a8c8a4cadf2cb665',
        60864,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Yellowtail',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yellowtail font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yellowtail
  static TextTheme yellowtailTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yellowtail(textStyle: textTheme.displayLarge),
      displayMedium: yellowtail(textStyle: textTheme.displayMedium),
      displaySmall: yellowtail(textStyle: textTheme.displaySmall),
      headlineLarge: yellowtail(textStyle: textTheme.headlineLarge),
      headlineMedium: yellowtail(textStyle: textTheme.headlineMedium),
      headlineSmall: yellowtail(textStyle: textTheme.headlineSmall),
      titleLarge: yellowtail(textStyle: textTheme.titleLarge),
      titleMedium: yellowtail(textStyle: textTheme.titleMedium),
      titleSmall: yellowtail(textStyle: textTheme.titleSmall),
      bodyLarge: yellowtail(textStyle: textTheme.bodyLarge),
      bodyMedium: yellowtail(textStyle: textTheme.bodyMedium),
      bodySmall: yellowtail(textStyle: textTheme.bodySmall),
      labelLarge: yellowtail(textStyle: textTheme.labelLarge),
      labelMedium: yellowtail(textStyle: textTheme.labelMedium),
      labelSmall: yellowtail(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yeon Sung font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yeon+Sung
  static TextStyle yeonSung({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2df96f5b33472f315b4b95c979fbc86e16cf6cb3be06d844568b067525f83c3c',
        1698764,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YeonSung',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yeon Sung font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yeon+Sung
  static TextTheme yeonSungTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yeonSung(textStyle: textTheme.displayLarge),
      displayMedium: yeonSung(textStyle: textTheme.displayMedium),
      displaySmall: yeonSung(textStyle: textTheme.displaySmall),
      headlineLarge: yeonSung(textStyle: textTheme.headlineLarge),
      headlineMedium: yeonSung(textStyle: textTheme.headlineMedium),
      headlineSmall: yeonSung(textStyle: textTheme.headlineSmall),
      titleLarge: yeonSung(textStyle: textTheme.titleLarge),
      titleMedium: yeonSung(textStyle: textTheme.titleMedium),
      titleSmall: yeonSung(textStyle: textTheme.titleSmall),
      bodyLarge: yeonSung(textStyle: textTheme.bodyLarge),
      bodyMedium: yeonSung(textStyle: textTheme.bodyMedium),
      bodySmall: yeonSung(textStyle: textTheme.bodySmall),
      labelLarge: yeonSung(textStyle: textTheme.labelLarge),
      labelMedium: yeonSung(textStyle: textTheme.labelMedium),
      labelSmall: yeonSung(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yeseva One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yeseva+One
  static TextStyle yesevaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0f40d9b1cef5ab4f5a9e945257e5528a6165674bfd3746fface336197e65d42d',
        70252,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YesevaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yeseva One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yeseva+One
  static TextTheme yesevaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yesevaOne(textStyle: textTheme.displayLarge),
      displayMedium: yesevaOne(textStyle: textTheme.displayMedium),
      displaySmall: yesevaOne(textStyle: textTheme.displaySmall),
      headlineLarge: yesevaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: yesevaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: yesevaOne(textStyle: textTheme.headlineSmall),
      titleLarge: yesevaOne(textStyle: textTheme.titleLarge),
      titleMedium: yesevaOne(textStyle: textTheme.titleMedium),
      titleSmall: yesevaOne(textStyle: textTheme.titleSmall),
      bodyLarge: yesevaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: yesevaOne(textStyle: textTheme.bodyMedium),
      bodySmall: yesevaOne(textStyle: textTheme.bodySmall),
      labelLarge: yesevaOne(textStyle: textTheme.labelLarge),
      labelMedium: yesevaOne(textStyle: textTheme.labelMedium),
      labelSmall: yesevaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yesteryear font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yesteryear
  static TextStyle yesteryear({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e598b4311acf938fde3d479d9331d911d3edbf7b025d4c3db27d8bff2277e96c',
        60736,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Yesteryear',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yesteryear font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yesteryear
  static TextTheme yesteryearTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yesteryear(textStyle: textTheme.displayLarge),
      displayMedium: yesteryear(textStyle: textTheme.displayMedium),
      displaySmall: yesteryear(textStyle: textTheme.displaySmall),
      headlineLarge: yesteryear(textStyle: textTheme.headlineLarge),
      headlineMedium: yesteryear(textStyle: textTheme.headlineMedium),
      headlineSmall: yesteryear(textStyle: textTheme.headlineSmall),
      titleLarge: yesteryear(textStyle: textTheme.titleLarge),
      titleMedium: yesteryear(textStyle: textTheme.titleMedium),
      titleSmall: yesteryear(textStyle: textTheme.titleSmall),
      bodyLarge: yesteryear(textStyle: textTheme.bodyLarge),
      bodyMedium: yesteryear(textStyle: textTheme.bodyMedium),
      bodySmall: yesteryear(textStyle: textTheme.bodySmall),
      labelLarge: yesteryear(textStyle: textTheme.labelLarge),
      labelMedium: yesteryear(textStyle: textTheme.labelMedium),
      labelSmall: yesteryear(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yomogi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yomogi
  static TextStyle yomogi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '248551e8412573c3ba73d74b62f10b4691668fe2f37351f99d7d85eb6be1532a',
        4033948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Yomogi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yomogi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yomogi
  static TextTheme yomogiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yomogi(textStyle: textTheme.displayLarge),
      displayMedium: yomogi(textStyle: textTheme.displayMedium),
      displaySmall: yomogi(textStyle: textTheme.displaySmall),
      headlineLarge: yomogi(textStyle: textTheme.headlineLarge),
      headlineMedium: yomogi(textStyle: textTheme.headlineMedium),
      headlineSmall: yomogi(textStyle: textTheme.headlineSmall),
      titleLarge: yomogi(textStyle: textTheme.titleLarge),
      titleMedium: yomogi(textStyle: textTheme.titleMedium),
      titleSmall: yomogi(textStyle: textTheme.titleSmall),
      bodyLarge: yomogi(textStyle: textTheme.bodyLarge),
      bodyMedium: yomogi(textStyle: textTheme.bodyMedium),
      bodySmall: yomogi(textStyle: textTheme.bodySmall),
      labelLarge: yomogi(textStyle: textTheme.labelLarge),
      labelMedium: yomogi(textStyle: textTheme.labelMedium),
      labelSmall: yomogi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yrsa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yrsa
  static TextStyle yrsa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a38ee67425620355a3aebcaeb06b763249a78c34d2239bb3e98437025c620f5f',
        114724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4093a43a011befc898beb6eb48b4543de39a5ee7a13bac0840246be2f2db2434',
        114980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e351dc4b7449c4acfe6c0eeb242198682c38b66e54453bc17df1cc5f646eea55',
        115032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '284884fe11d549aaa04dd224332a79aa9a3923f022620f59a84315888a1efa6d',
        115120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '190934276fcb1e8782c619708b577a330d310a5d4a2759be92d9df6fbf82794c',
        114424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6a82287a8181a39ac9d7a225c90c8c00ca733baeca1e4d96b9e9623d21a0ef97',
        148544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dd306532549a3e66009d1c94ab81a7a776328e8e20a6e86b0b8a628ddb87f279',
        148460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '11e022d3ce90023e4e151faf00b8e4bbcaa691cd9639efaade983a72937cad33',
        148536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cd90fd330610600c92ed43da5c35c3437c5a7272abf0d4c8d3d0a982c1b24bf4',
        148660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '15ee1b646387e54475ae131d9fe26251e55bc64002d8efc49cf88c3806295c5f',
        147788,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Yrsa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yrsa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yrsa
  static TextTheme yrsaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yrsa(textStyle: textTheme.displayLarge),
      displayMedium: yrsa(textStyle: textTheme.displayMedium),
      displaySmall: yrsa(textStyle: textTheme.displaySmall),
      headlineLarge: yrsa(textStyle: textTheme.headlineLarge),
      headlineMedium: yrsa(textStyle: textTheme.headlineMedium),
      headlineSmall: yrsa(textStyle: textTheme.headlineSmall),
      titleLarge: yrsa(textStyle: textTheme.titleLarge),
      titleMedium: yrsa(textStyle: textTheme.titleMedium),
      titleSmall: yrsa(textStyle: textTheme.titleSmall),
      bodyLarge: yrsa(textStyle: textTheme.bodyLarge),
      bodyMedium: yrsa(textStyle: textTheme.bodyMedium),
      bodySmall: yrsa(textStyle: textTheme.bodySmall),
      labelLarge: yrsa(textStyle: textTheme.labelLarge),
      labelMedium: yrsa(textStyle: textTheme.labelMedium),
      labelSmall: yrsa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ysabeau font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau
  static TextStyle ysabeau({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46a9f5b6b3fdd4055f8039f4ef7f42afc679ec186228db3abd0e78756c92dd60',
        129156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4596ffe7cfddc2e702ef6e94bbb57278085373a325d4ed6904f33a0173956535',
        129232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '968e2c3fdd784a59f151029d5b5aee1ad330cb4215e8ba8ec9f38e2bc1b39239',
        129212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c4a1fbeb322910c08a55abec2b0dde5f49dd315b87de46c7cdaa2a81a0b76c90',
        129292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd366684292f5a434cd81475539ea878bfd1a1500ad11940acc1dfc7a640daffd',
        129204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a7642818c00b64deba44fa9bc99ea50377d986d2eaefdf0b2a2e179dc666d57',
        129612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cfbdcf170a2bcd5a3e749b3c719ccd17d158dbd2567c4c9aaa538a0e6d34193f',
        129304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '77667702210af816615ccd77129e2a869011741f6a286a6655eb10d5b113b182',
        130216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7fdd25d4399340af1308331c8a93115e7d3b288a11530c1f719309e4114d099b',
        130968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '17fc7c74c4aca82b5a9b2d2225130c5be4c5d76d55855dc5534fe8fa75189b88',
        137484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3e6c0d74992da8cf2a19730b400c667ad707797e656a0611be88af941b96bbef',
        137736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f3e54487d047d772869018d9206c32c1fcb832440b0a63cc0ec3e6747e906388',
        137556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '93d564599fe8de27294b8afeca2edc4e0c0bcd5168792330b73551bf5a765fa7',
        137488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '92dd8818cae4bb32ca8aa9843700f783e5f81fff338eb3b0ea6c540e78e2000a',
        137688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6eba3f9290df92d303bfbee965de3550b7b36d5a1be7631ccfc97bde71febbcc',
        137884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '96e3dce6c1d98225f10cd6084c2ddaa6fe22d80105ae5737bd69526c9b120be9',
        137636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c79097aab30f9af9910ed8068054e18e47281785a7523ac5f4e75fd4bc94d14a',
        138668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5e4716408e6061a9d3d9df14d743087f3d277ff38e1b788ed994159ab4f43cbb',
        138888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ysabeau',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ysabeau font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau
  static TextTheme ysabeauTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ysabeau(textStyle: textTheme.displayLarge),
      displayMedium: ysabeau(textStyle: textTheme.displayMedium),
      displaySmall: ysabeau(textStyle: textTheme.displaySmall),
      headlineLarge: ysabeau(textStyle: textTheme.headlineLarge),
      headlineMedium: ysabeau(textStyle: textTheme.headlineMedium),
      headlineSmall: ysabeau(textStyle: textTheme.headlineSmall),
      titleLarge: ysabeau(textStyle: textTheme.titleLarge),
      titleMedium: ysabeau(textStyle: textTheme.titleMedium),
      titleSmall: ysabeau(textStyle: textTheme.titleSmall),
      bodyLarge: ysabeau(textStyle: textTheme.bodyLarge),
      bodyMedium: ysabeau(textStyle: textTheme.bodyMedium),
      bodySmall: ysabeau(textStyle: textTheme.bodySmall),
      labelLarge: ysabeau(textStyle: textTheme.labelLarge),
      labelMedium: ysabeau(textStyle: textTheme.labelMedium),
      labelSmall: ysabeau(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ysabeau Infant font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau+Infant
  static TextStyle ysabeauInfant({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8e7b053774d2edd6af18d620e4ec1801af6c5d05c4c0d72aedfc3300dbef6504',
        123008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7976a9ea425729cca3cacce16269d6cccefddffba268009d6d7f452fbc40e297',
        123056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ce078bf8c07726ec949c187715eba4407b77011fa29e28621d7089d87fe8c3e',
        123040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11e90bd0aac5cf3fb9c6d53089e32f82969c5e13d2984e6f712288b44d6e3fe2',
        123152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69f7035043f98cf31c68249460d9599c2c13f4cf10598870bd05fcb43a0a4df5',
        123184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7564c12a9aded6ab017717f5e73fb7a2fdba46bd3e2f8d46e63addd579d54c8e',
        123156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7cdf713d2989469d27565209b1cde83a179e58767ed52f4edbce732a5392c256',
        122896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3cc9bbba659ed9551e96faee984eae31a0c97bb82893a8a9372bba1aa85e9ddd',
        123436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '65f31349125d73a9fcc370f76e2558dc2b6095ccb2fe537a3e4544e452ccd579',
        123524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e74eff36924ff8d446faec5ede5adeaaefcce0fd6fd210db42bba000a9b8404b',
        129652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ffaf8585cc1abdbdbcbc4cfa240764a93ce433912d9774d40c67409d009fd0bf',
        129868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '227f9f3cb3f2e6d594f1f8427afd9c8e222c4eb27acbf0896f3e89bdc837a010',
        129664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '056641768b2f8a3c215ffe948732451ad11d37b043e1eba2b863ecabb85f757a',
        129596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b008ab99fb0e3775e55d5e2280358239a182a18afb4d333d138c78bc877f81bb',
        129804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'baa9bb9f5e1cca8deafd332561b1d19f0e480d26be2715459bbba26f294fec38',
        129672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '342d6b839a8b086cb9ce14aa5af2c67cb72347c402e0802e4262df5cd9af67d4',
        129436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cb55465eec4d3291f199938804d34c1e2435f7ede1ac2eb6259b535b555bda6d',
        129896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd5624e411515e7242016efa0e909ae2ca4d62e1844f6277b64b65867b1c465a0',
        129808,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YsabeauInfant',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ysabeau Infant font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau+Infant
  static TextTheme ysabeauInfantTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ysabeauInfant(textStyle: textTheme.displayLarge),
      displayMedium: ysabeauInfant(textStyle: textTheme.displayMedium),
      displaySmall: ysabeauInfant(textStyle: textTheme.displaySmall),
      headlineLarge: ysabeauInfant(textStyle: textTheme.headlineLarge),
      headlineMedium: ysabeauInfant(textStyle: textTheme.headlineMedium),
      headlineSmall: ysabeauInfant(textStyle: textTheme.headlineSmall),
      titleLarge: ysabeauInfant(textStyle: textTheme.titleLarge),
      titleMedium: ysabeauInfant(textStyle: textTheme.titleMedium),
      titleSmall: ysabeauInfant(textStyle: textTheme.titleSmall),
      bodyLarge: ysabeauInfant(textStyle: textTheme.bodyLarge),
      bodyMedium: ysabeauInfant(textStyle: textTheme.bodyMedium),
      bodySmall: ysabeauInfant(textStyle: textTheme.bodySmall),
      labelLarge: ysabeauInfant(textStyle: textTheme.labelLarge),
      labelMedium: ysabeauInfant(textStyle: textTheme.labelMedium),
      labelSmall: ysabeauInfant(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ysabeau Office font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau+Office
  static TextStyle ysabeauOffice({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11eb01205250714f9c9f782c714ddeddd23a1946966ab2a52e217553180dec55',
        123432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ecc4a1ef57cb985cef0a5247d2f803970df8b30c53da4354c46cb64a193b8284',
        123500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81e06f88a1d37b1b86d04d66a766cd8d2d84e2c7e724556cb875169eeccd7e6f',
        123484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '717c427073035581b53dac8723186aa8c4fdd892d44a24338783aa5753e4d6e7',
        123564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '093d95a7111771631e837726afdc35d527efa54edffffd7acf7b386bd0cc80b8',
        123488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8d58e7c8633fe3dfe3fef618d9a0b7a2870f2f196ba93176492e777c1069864',
        123584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7159c776475f13c767f4c3c2a123e49a65149362e8e8a147007708849ff4fac3',
        123284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f4f7d1b36db6a89e3344ca28f7033c24aad0bb4112eb49f14f2a56041701b07',
        123788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e2221f00248db1973f8fe77084b96c81aeb003810320d57d9c21ee7370d06f6',
        123896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e72c88f21b341d1eb378f6618241c817f7fafc53e4c29c58c789f641df6d38da',
        130492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd70232da6d6b63e2c23c6213d162c771f3856a8c39d3d3ebd508aeb82b799d19',
        130728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3d453af576d08dbe71f5128cafe55b06894c92b217f360af2915774afaee581d',
        130516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9f4a667ddf53d3f5e249b85410f727a5666ee717670b1b50f7a3c4562f744f66',
        130456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6e5dd99ed824b77143a2d58abe981454a1e502309a3840315a957d2ad2cb5201',
        130664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b7e401b1bb0281f8d7276f9a2ff3b46cd18ac645b563b21765b789100a27e7e6',
        130520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ebe3660c92f11415f772dc67ac768abba567fcc78e9a1867a7d460271d2ed6cb',
        130272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e7404e4505436712c830fa1284d386ca7d36c542935a9bba2b3d0e46f7ff83f4',
        130756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c1d2ec60e25b2a593f33ea999dbae92401299246717825b1447b73d8a43204e3',
        130660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YsabeauOffice',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ysabeau Office font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau+Office
  static TextTheme ysabeauOfficeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ysabeauOffice(textStyle: textTheme.displayLarge),
      displayMedium: ysabeauOffice(textStyle: textTheme.displayMedium),
      displaySmall: ysabeauOffice(textStyle: textTheme.displaySmall),
      headlineLarge: ysabeauOffice(textStyle: textTheme.headlineLarge),
      headlineMedium: ysabeauOffice(textStyle: textTheme.headlineMedium),
      headlineSmall: ysabeauOffice(textStyle: textTheme.headlineSmall),
      titleLarge: ysabeauOffice(textStyle: textTheme.titleLarge),
      titleMedium: ysabeauOffice(textStyle: textTheme.titleMedium),
      titleSmall: ysabeauOffice(textStyle: textTheme.titleSmall),
      bodyLarge: ysabeauOffice(textStyle: textTheme.bodyLarge),
      bodyMedium: ysabeauOffice(textStyle: textTheme.bodyMedium),
      bodySmall: ysabeauOffice(textStyle: textTheme.bodySmall),
      labelLarge: ysabeauOffice(textStyle: textTheme.labelLarge),
      labelMedium: ysabeauOffice(textStyle: textTheme.labelMedium),
      labelSmall: ysabeauOffice(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ysabeau SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau+SC
  static TextStyle ysabeauSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5706aaefd068b13ae9738396ffcab4b03d31527e1af6153ffcab2916785ab961',
        103020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '58927b8e5685eebe0aa3f0112d713611a42053e92657cfd488e3f0ac5b6c815d',
        103028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df4a7e0fce37728b1480142454925f4881eac91e1b08ba1b9d3037ab4859e325',
        103024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5896e4baf3889c57ff38a1447147e459909a31698cb535e38c809d43df28b78',
        103044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a29a6d53b7b9e16b9a12e06e66e6f5afe69ea6966cb3eeb3961804d5e1ea3ef4',
        103036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '080d0ef19acdc569ed550cad9c2d50099336c53b7836aabd1f248a37d6d0e1dc',
        103040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f87df3fbd3f0a88b59720bbc00826a3a1a682528292e0461485cdc5f21d2d8f9',
        102940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '084a99b8bcde48ec217f4da8c8b80b0b6a76af2ea65b0fa9a216c3571e004fcf',
        103144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd6b188b244835b6094e2a4bb1e2eac8ce84e278ed34b730174fbbb8be59d5b7',
        103228,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YsabeauSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ysabeau SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau+SC
  static TextTheme ysabeauScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ysabeauSc(textStyle: textTheme.displayLarge),
      displayMedium: ysabeauSc(textStyle: textTheme.displayMedium),
      displaySmall: ysabeauSc(textStyle: textTheme.displaySmall),
      headlineLarge: ysabeauSc(textStyle: textTheme.headlineLarge),
      headlineMedium: ysabeauSc(textStyle: textTheme.headlineMedium),
      headlineSmall: ysabeauSc(textStyle: textTheme.headlineSmall),
      titleLarge: ysabeauSc(textStyle: textTheme.titleLarge),
      titleMedium: ysabeauSc(textStyle: textTheme.titleMedium),
      titleSmall: ysabeauSc(textStyle: textTheme.titleSmall),
      bodyLarge: ysabeauSc(textStyle: textTheme.bodyLarge),
      bodyMedium: ysabeauSc(textStyle: textTheme.bodyMedium),
      bodySmall: ysabeauSc(textStyle: textTheme.bodySmall),
      labelLarge: ysabeauSc(textStyle: textTheme.labelLarge),
      labelMedium: ysabeauSc(textStyle: textTheme.labelMedium),
      labelSmall: ysabeauSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yuji Boku font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Boku
  static TextStyle yujiBoku({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d03c76f62b49981fee9d4f9b3d186a70ac8613d232a75b7a334bd667ef8f49a',
        7847404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YujiBoku',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yuji Boku font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Boku
  static TextTheme yujiBokuTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yujiBoku(textStyle: textTheme.displayLarge),
      displayMedium: yujiBoku(textStyle: textTheme.displayMedium),
      displaySmall: yujiBoku(textStyle: textTheme.displaySmall),
      headlineLarge: yujiBoku(textStyle: textTheme.headlineLarge),
      headlineMedium: yujiBoku(textStyle: textTheme.headlineMedium),
      headlineSmall: yujiBoku(textStyle: textTheme.headlineSmall),
      titleLarge: yujiBoku(textStyle: textTheme.titleLarge),
      titleMedium: yujiBoku(textStyle: textTheme.titleMedium),
      titleSmall: yujiBoku(textStyle: textTheme.titleSmall),
      bodyLarge: yujiBoku(textStyle: textTheme.bodyLarge),
      bodyMedium: yujiBoku(textStyle: textTheme.bodyMedium),
      bodySmall: yujiBoku(textStyle: textTheme.bodySmall),
      labelLarge: yujiBoku(textStyle: textTheme.labelLarge),
      labelMedium: yujiBoku(textStyle: textTheme.labelMedium),
      labelSmall: yujiBoku(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yuji Hentaigana Akari font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Hentaigana+Akari
  static TextStyle yujiHentaiganaAkari({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a8dcdb8f12d0708b4cf45b14a42f9c2e15de0a98783e7a324f6f888abfc4dfc5',
        90668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YujiHentaiganaAkari',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yuji Hentaigana Akari font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Hentaigana+Akari
  static TextTheme yujiHentaiganaAkariTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yujiHentaiganaAkari(textStyle: textTheme.displayLarge),
      displayMedium: yujiHentaiganaAkari(textStyle: textTheme.displayMedium),
      displaySmall: yujiHentaiganaAkari(textStyle: textTheme.displaySmall),
      headlineLarge: yujiHentaiganaAkari(textStyle: textTheme.headlineLarge),
      headlineMedium: yujiHentaiganaAkari(textStyle: textTheme.headlineMedium),
      headlineSmall: yujiHentaiganaAkari(textStyle: textTheme.headlineSmall),
      titleLarge: yujiHentaiganaAkari(textStyle: textTheme.titleLarge),
      titleMedium: yujiHentaiganaAkari(textStyle: textTheme.titleMedium),
      titleSmall: yujiHentaiganaAkari(textStyle: textTheme.titleSmall),
      bodyLarge: yujiHentaiganaAkari(textStyle: textTheme.bodyLarge),
      bodyMedium: yujiHentaiganaAkari(textStyle: textTheme.bodyMedium),
      bodySmall: yujiHentaiganaAkari(textStyle: textTheme.bodySmall),
      labelLarge: yujiHentaiganaAkari(textStyle: textTheme.labelLarge),
      labelMedium: yujiHentaiganaAkari(textStyle: textTheme.labelMedium),
      labelSmall: yujiHentaiganaAkari(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yuji Hentaigana Akebono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Hentaigana+Akebono
  static TextStyle yujiHentaiganaAkebono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6953c8bd49f227d2152f7981ab5a9cc8a860caeac6be190ad87e0b57ff265ecb',
        96272,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YujiHentaiganaAkebono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yuji Hentaigana Akebono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Hentaigana+Akebono
  static TextTheme yujiHentaiganaAkebonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yujiHentaiganaAkebono(textStyle: textTheme.displayLarge),
      displayMedium: yujiHentaiganaAkebono(textStyle: textTheme.displayMedium),
      displaySmall: yujiHentaiganaAkebono(textStyle: textTheme.displaySmall),
      headlineLarge: yujiHentaiganaAkebono(textStyle: textTheme.headlineLarge),
      headlineMedium:
          yujiHentaiganaAkebono(textStyle: textTheme.headlineMedium),
      headlineSmall: yujiHentaiganaAkebono(textStyle: textTheme.headlineSmall),
      titleLarge: yujiHentaiganaAkebono(textStyle: textTheme.titleLarge),
      titleMedium: yujiHentaiganaAkebono(textStyle: textTheme.titleMedium),
      titleSmall: yujiHentaiganaAkebono(textStyle: textTheme.titleSmall),
      bodyLarge: yujiHentaiganaAkebono(textStyle: textTheme.bodyLarge),
      bodyMedium: yujiHentaiganaAkebono(textStyle: textTheme.bodyMedium),
      bodySmall: yujiHentaiganaAkebono(textStyle: textTheme.bodySmall),
      labelLarge: yujiHentaiganaAkebono(textStyle: textTheme.labelLarge),
      labelMedium: yujiHentaiganaAkebono(textStyle: textTheme.labelMedium),
      labelSmall: yujiHentaiganaAkebono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yuji Mai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Mai
  static TextStyle yujiMai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6741e6df72abe0287210735f84bb297fb8704e9e44ae1bd53e9366f75215ce8',
        7830152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YujiMai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yuji Mai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Mai
  static TextTheme yujiMaiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yujiMai(textStyle: textTheme.displayLarge),
      displayMedium: yujiMai(textStyle: textTheme.displayMedium),
      displaySmall: yujiMai(textStyle: textTheme.displaySmall),
      headlineLarge: yujiMai(textStyle: textTheme.headlineLarge),
      headlineMedium: yujiMai(textStyle: textTheme.headlineMedium),
      headlineSmall: yujiMai(textStyle: textTheme.headlineSmall),
      titleLarge: yujiMai(textStyle: textTheme.titleLarge),
      titleMedium: yujiMai(textStyle: textTheme.titleMedium),
      titleSmall: yujiMai(textStyle: textTheme.titleSmall),
      bodyLarge: yujiMai(textStyle: textTheme.bodyLarge),
      bodyMedium: yujiMai(textStyle: textTheme.bodyMedium),
      bodySmall: yujiMai(textStyle: textTheme.bodySmall),
      labelLarge: yujiMai(textStyle: textTheme.labelLarge),
      labelMedium: yujiMai(textStyle: textTheme.labelMedium),
      labelSmall: yujiMai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yuji Syuku font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Syuku
  static TextStyle yujiSyuku({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0647d204ae1a4232cce1a635b3e9503bc9ad48ac3bcaa4114131e2514c49f7e8',
        7779080,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YujiSyuku',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yuji Syuku font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Syuku
  static TextTheme yujiSyukuTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yujiSyuku(textStyle: textTheme.displayLarge),
      displayMedium: yujiSyuku(textStyle: textTheme.displayMedium),
      displaySmall: yujiSyuku(textStyle: textTheme.displaySmall),
      headlineLarge: yujiSyuku(textStyle: textTheme.headlineLarge),
      headlineMedium: yujiSyuku(textStyle: textTheme.headlineMedium),
      headlineSmall: yujiSyuku(textStyle: textTheme.headlineSmall),
      titleLarge: yujiSyuku(textStyle: textTheme.titleLarge),
      titleMedium: yujiSyuku(textStyle: textTheme.titleMedium),
      titleSmall: yujiSyuku(textStyle: textTheme.titleSmall),
      bodyLarge: yujiSyuku(textStyle: textTheme.bodyLarge),
      bodyMedium: yujiSyuku(textStyle: textTheme.bodyMedium),
      bodySmall: yujiSyuku(textStyle: textTheme.bodySmall),
      labelLarge: yujiSyuku(textStyle: textTheme.labelLarge),
      labelMedium: yujiSyuku(textStyle: textTheme.labelMedium),
      labelSmall: yujiSyuku(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yusei Magic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yusei+Magic
  static TextStyle yuseiMagic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9386186a8664fa5a6aba964e82e856d0ff81ca2a37c1e30a3cbe9d8d1e6afff',
        3129936,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YuseiMagic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yusei Magic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yusei+Magic
  static TextTheme yuseiMagicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yuseiMagic(textStyle: textTheme.displayLarge),
      displayMedium: yuseiMagic(textStyle: textTheme.displayMedium),
      displaySmall: yuseiMagic(textStyle: textTheme.displaySmall),
      headlineLarge: yuseiMagic(textStyle: textTheme.headlineLarge),
      headlineMedium: yuseiMagic(textStyle: textTheme.headlineMedium),
      headlineSmall: yuseiMagic(textStyle: textTheme.headlineSmall),
      titleLarge: yuseiMagic(textStyle: textTheme.titleLarge),
      titleMedium: yuseiMagic(textStyle: textTheme.titleMedium),
      titleSmall: yuseiMagic(textStyle: textTheme.titleSmall),
      bodyLarge: yuseiMagic(textStyle: textTheme.bodyLarge),
      bodyMedium: yuseiMagic(textStyle: textTheme.bodyMedium),
      bodySmall: yuseiMagic(textStyle: textTheme.bodySmall),
      labelLarge: yuseiMagic(textStyle: textTheme.labelLarge),
      labelMedium: yuseiMagic(textStyle: textTheme.labelMedium),
      labelSmall: yuseiMagic(textStyle: textTheme.labelSmall),
    );
  }
}
