// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'W'.
class PartW {
  /// Applies the Waiting for the Sunrise font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Waiting+for+the+Sunrise
  static TextStyle waitingForTheSunrise({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6deb7c8add2991efb92b567a02210a32276681a0b5096332e10db1c2ce94a82',
        41060,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WaitingfortheSunrise',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Waiting for the Sunrise font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Waiting+for+the+Sunrise
  static TextTheme waitingForTheSunriseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: waitingForTheSunrise(textStyle: textTheme.displayLarge),
      displayMedium: waitingForTheSunrise(textStyle: textTheme.displayMedium),
      displaySmall: waitingForTheSunrise(textStyle: textTheme.displaySmall),
      headlineLarge: waitingForTheSunrise(textStyle: textTheme.headlineLarge),
      headlineMedium: waitingForTheSunrise(textStyle: textTheme.headlineMedium),
      headlineSmall: waitingForTheSunrise(textStyle: textTheme.headlineSmall),
      titleLarge: waitingForTheSunrise(textStyle: textTheme.titleLarge),
      titleMedium: waitingForTheSunrise(textStyle: textTheme.titleMedium),
      titleSmall: waitingForTheSunrise(textStyle: textTheme.titleSmall),
      bodyLarge: waitingForTheSunrise(textStyle: textTheme.bodyLarge),
      bodyMedium: waitingForTheSunrise(textStyle: textTheme.bodyMedium),
      bodySmall: waitingForTheSunrise(textStyle: textTheme.bodySmall),
      labelLarge: waitingForTheSunrise(textStyle: textTheme.labelLarge),
      labelMedium: waitingForTheSunrise(textStyle: textTheme.labelMedium),
      labelSmall: waitingForTheSunrise(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wallpoet font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wallpoet
  static TextStyle wallpoet({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1176ac005f40018b7e49da74c93a4edfc69b9c18b4b835313ea101cc15b59885',
        20836,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Wallpoet',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wallpoet font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wallpoet
  static TextTheme wallpoetTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wallpoet(textStyle: textTheme.displayLarge),
      displayMedium: wallpoet(textStyle: textTheme.displayMedium),
      displaySmall: wallpoet(textStyle: textTheme.displaySmall),
      headlineLarge: wallpoet(textStyle: textTheme.headlineLarge),
      headlineMedium: wallpoet(textStyle: textTheme.headlineMedium),
      headlineSmall: wallpoet(textStyle: textTheme.headlineSmall),
      titleLarge: wallpoet(textStyle: textTheme.titleLarge),
      titleMedium: wallpoet(textStyle: textTheme.titleMedium),
      titleSmall: wallpoet(textStyle: textTheme.titleSmall),
      bodyLarge: wallpoet(textStyle: textTheme.bodyLarge),
      bodyMedium: wallpoet(textStyle: textTheme.bodyMedium),
      bodySmall: wallpoet(textStyle: textTheme.bodySmall),
      labelLarge: wallpoet(textStyle: textTheme.labelLarge),
      labelMedium: wallpoet(textStyle: textTheme.labelMedium),
      labelSmall: wallpoet(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Walter Turncoat font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Walter+Turncoat
  static TextStyle walterTurncoat({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f994e4cc7bcc900c5e0b1451e3b7bce6a7e58f0e8ed10f5938e8916a42608acd',
        151768,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WalterTurncoat',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Walter Turncoat font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Walter+Turncoat
  static TextTheme walterTurncoatTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: walterTurncoat(textStyle: textTheme.displayLarge),
      displayMedium: walterTurncoat(textStyle: textTheme.displayMedium),
      displaySmall: walterTurncoat(textStyle: textTheme.displaySmall),
      headlineLarge: walterTurncoat(textStyle: textTheme.headlineLarge),
      headlineMedium: walterTurncoat(textStyle: textTheme.headlineMedium),
      headlineSmall: walterTurncoat(textStyle: textTheme.headlineSmall),
      titleLarge: walterTurncoat(textStyle: textTheme.titleLarge),
      titleMedium: walterTurncoat(textStyle: textTheme.titleMedium),
      titleSmall: walterTurncoat(textStyle: textTheme.titleSmall),
      bodyLarge: walterTurncoat(textStyle: textTheme.bodyLarge),
      bodyMedium: walterTurncoat(textStyle: textTheme.bodyMedium),
      bodySmall: walterTurncoat(textStyle: textTheme.bodySmall),
      labelLarge: walterTurncoat(textStyle: textTheme.labelLarge),
      labelMedium: walterTurncoat(textStyle: textTheme.labelMedium),
      labelSmall: walterTurncoat(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Warnes font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Warnes
  static TextStyle warnes({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1e2b0440a70a23a81be9d81f13b64884876d3fd72a6225e58480e49e0e79129',
        45216,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Warnes',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Warnes font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Warnes
  static TextTheme warnesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: warnes(textStyle: textTheme.displayLarge),
      displayMedium: warnes(textStyle: textTheme.displayMedium),
      displaySmall: warnes(textStyle: textTheme.displaySmall),
      headlineLarge: warnes(textStyle: textTheme.headlineLarge),
      headlineMedium: warnes(textStyle: textTheme.headlineMedium),
      headlineSmall: warnes(textStyle: textTheme.headlineSmall),
      titleLarge: warnes(textStyle: textTheme.titleLarge),
      titleMedium: warnes(textStyle: textTheme.titleMedium),
      titleSmall: warnes(textStyle: textTheme.titleSmall),
      bodyLarge: warnes(textStyle: textTheme.bodyLarge),
      bodyMedium: warnes(textStyle: textTheme.bodyMedium),
      bodySmall: warnes(textStyle: textTheme.bodySmall),
      labelLarge: warnes(textStyle: textTheme.labelLarge),
      labelMedium: warnes(textStyle: textTheme.labelMedium),
      labelSmall: warnes(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Water Brush font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Water+Brush
  static TextStyle waterBrush({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '549c589ffe4dc4065a20d92cea7f7ceffe11c630f4f469aee96ad97cee0fc07f',
        237016,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WaterBrush',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Water Brush font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Water+Brush
  static TextTheme waterBrushTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: waterBrush(textStyle: textTheme.displayLarge),
      displayMedium: waterBrush(textStyle: textTheme.displayMedium),
      displaySmall: waterBrush(textStyle: textTheme.displaySmall),
      headlineLarge: waterBrush(textStyle: textTheme.headlineLarge),
      headlineMedium: waterBrush(textStyle: textTheme.headlineMedium),
      headlineSmall: waterBrush(textStyle: textTheme.headlineSmall),
      titleLarge: waterBrush(textStyle: textTheme.titleLarge),
      titleMedium: waterBrush(textStyle: textTheme.titleMedium),
      titleSmall: waterBrush(textStyle: textTheme.titleSmall),
      bodyLarge: waterBrush(textStyle: textTheme.bodyLarge),
      bodyMedium: waterBrush(textStyle: textTheme.bodyMedium),
      bodySmall: waterBrush(textStyle: textTheme.bodySmall),
      labelLarge: waterBrush(textStyle: textTheme.labelLarge),
      labelMedium: waterBrush(textStyle: textTheme.labelMedium),
      labelSmall: waterBrush(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Waterfall font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Waterfall
  static TextStyle waterfall({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4795938e9619ba759a9f32f5d941d652732c7cc848ca6128159a0ae84619107b',
        138024,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Waterfall',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Waterfall font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Waterfall
  static TextTheme waterfallTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: waterfall(textStyle: textTheme.displayLarge),
      displayMedium: waterfall(textStyle: textTheme.displayMedium),
      displaySmall: waterfall(textStyle: textTheme.displaySmall),
      headlineLarge: waterfall(textStyle: textTheme.headlineLarge),
      headlineMedium: waterfall(textStyle: textTheme.headlineMedium),
      headlineSmall: waterfall(textStyle: textTheme.headlineSmall),
      titleLarge: waterfall(textStyle: textTheme.titleLarge),
      titleMedium: waterfall(textStyle: textTheme.titleMedium),
      titleSmall: waterfall(textStyle: textTheme.titleSmall),
      bodyLarge: waterfall(textStyle: textTheme.bodyLarge),
      bodyMedium: waterfall(textStyle: textTheme.bodyMedium),
      bodySmall: waterfall(textStyle: textTheme.bodySmall),
      labelLarge: waterfall(textStyle: textTheme.labelLarge),
      labelMedium: waterfall(textStyle: textTheme.labelMedium),
      labelSmall: waterfall(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wavefont font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wavefont
  static TextStyle wavefont({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1bba7cc18ac51f126d3233b1605784be87339c90e6442253a0b1551669aea9b',
        26860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7d5a9565b221fad659ad70f9ed6c1b44422c0195743f39b43c93f7bd2058788c',
        26992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6f17f482e7e92fbea8911b7ff13cd1ba229f601d5ee466019eda1cbff1a160c',
        27128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f22b466d976adefdad20d38d08be990e705c06fd304a853bbdfac6fc3bb269d6',
        27284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c159e1fd8a9695272778929fce43284dc9cb5e6a47024da5c44af0e6b9440ca',
        27476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9ff2c7043c0be619d16bee25e73f7cee98bf84586158ebc633fd9a9f1265b7a',
        27748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45c78e541edec7e379ff29fd78ed4f6d2115d4e3a4d038bf3e3ab1700bc3b6c1',
        27856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ff5e6f56d0def16260a9544651f22d7978f7ac8e1a72147fdba3895b0edaf7a',
        28276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c8af8914bbe46f6dddd3184cb0dc21c69bc1ba8cd9fc481ccebd65f624f18c32',
        28508,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Wavefont',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wavefont font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wavefont
  static TextTheme wavefontTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wavefont(textStyle: textTheme.displayLarge),
      displayMedium: wavefont(textStyle: textTheme.displayMedium),
      displaySmall: wavefont(textStyle: textTheme.displaySmall),
      headlineLarge: wavefont(textStyle: textTheme.headlineLarge),
      headlineMedium: wavefont(textStyle: textTheme.headlineMedium),
      headlineSmall: wavefont(textStyle: textTheme.headlineSmall),
      titleLarge: wavefont(textStyle: textTheme.titleLarge),
      titleMedium: wavefont(textStyle: textTheme.titleMedium),
      titleSmall: wavefont(textStyle: textTheme.titleSmall),
      bodyLarge: wavefont(textStyle: textTheme.bodyLarge),
      bodyMedium: wavefont(textStyle: textTheme.bodyMedium),
      bodySmall: wavefont(textStyle: textTheme.bodySmall),
      labelLarge: wavefont(textStyle: textTheme.labelLarge),
      labelMedium: wavefont(textStyle: textTheme.labelMedium),
      labelSmall: wavefont(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wellfleet font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wellfleet
  static TextStyle wellfleet({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f946bb26765cf986cbeb53e945fe051c63bb44ba8b1f3cbfab4e0e85f0f1e2d3',
        77544,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Wellfleet',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wellfleet font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wellfleet
  static TextTheme wellfleetTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wellfleet(textStyle: textTheme.displayLarge),
      displayMedium: wellfleet(textStyle: textTheme.displayMedium),
      displaySmall: wellfleet(textStyle: textTheme.displaySmall),
      headlineLarge: wellfleet(textStyle: textTheme.headlineLarge),
      headlineMedium: wellfleet(textStyle: textTheme.headlineMedium),
      headlineSmall: wellfleet(textStyle: textTheme.headlineSmall),
      titleLarge: wellfleet(textStyle: textTheme.titleLarge),
      titleMedium: wellfleet(textStyle: textTheme.titleMedium),
      titleSmall: wellfleet(textStyle: textTheme.titleSmall),
      bodyLarge: wellfleet(textStyle: textTheme.bodyLarge),
      bodyMedium: wellfleet(textStyle: textTheme.bodyMedium),
      bodySmall: wellfleet(textStyle: textTheme.bodySmall),
      labelLarge: wellfleet(textStyle: textTheme.labelLarge),
      labelMedium: wellfleet(textStyle: textTheme.labelMedium),
      labelSmall: wellfleet(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wendy One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wendy+One
  static TextStyle wendyOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8060a04d16597d47480194de94a665dc025abbd8dbf8eb82280b474884d7259a',
        21064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WendyOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wendy One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wendy+One
  static TextTheme wendyOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wendyOne(textStyle: textTheme.displayLarge),
      displayMedium: wendyOne(textStyle: textTheme.displayMedium),
      displaySmall: wendyOne(textStyle: textTheme.displaySmall),
      headlineLarge: wendyOne(textStyle: textTheme.headlineLarge),
      headlineMedium: wendyOne(textStyle: textTheme.headlineMedium),
      headlineSmall: wendyOne(textStyle: textTheme.headlineSmall),
      titleLarge: wendyOne(textStyle: textTheme.titleLarge),
      titleMedium: wendyOne(textStyle: textTheme.titleMedium),
      titleSmall: wendyOne(textStyle: textTheme.titleSmall),
      bodyLarge: wendyOne(textStyle: textTheme.bodyLarge),
      bodyMedium: wendyOne(textStyle: textTheme.bodyMedium),
      bodySmall: wendyOne(textStyle: textTheme.bodySmall),
      labelLarge: wendyOne(textStyle: textTheme.labelLarge),
      labelMedium: wendyOne(textStyle: textTheme.labelMedium),
      labelSmall: wendyOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Whisper font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Whisper
  static TextStyle whisper({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6189f3f04a5104117c97b107afc997747f520f90b8cc526ff7203713954e7b09',
        85764,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Whisper',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Whisper font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Whisper
  static TextTheme whisperTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: whisper(textStyle: textTheme.displayLarge),
      displayMedium: whisper(textStyle: textTheme.displayMedium),
      displaySmall: whisper(textStyle: textTheme.displaySmall),
      headlineLarge: whisper(textStyle: textTheme.headlineLarge),
      headlineMedium: whisper(textStyle: textTheme.headlineMedium),
      headlineSmall: whisper(textStyle: textTheme.headlineSmall),
      titleLarge: whisper(textStyle: textTheme.titleLarge),
      titleMedium: whisper(textStyle: textTheme.titleMedium),
      titleSmall: whisper(textStyle: textTheme.titleSmall),
      bodyLarge: whisper(textStyle: textTheme.bodyLarge),
      bodyMedium: whisper(textStyle: textTheme.bodyMedium),
      bodySmall: whisper(textStyle: textTheme.bodySmall),
      labelLarge: whisper(textStyle: textTheme.labelLarge),
      labelMedium: whisper(textStyle: textTheme.labelMedium),
      labelSmall: whisper(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the WindSong font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/WindSong
  static TextStyle windSong({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdda975ccb09915cb2f76bdb7fdb3c360c84bda543041149cf77bc8130b0ad70',
        102256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b1b28c604ffda10da35548449eb24d78def6927efe58e279e9b8b835a9d1a74',
        109364,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WindSong',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the WindSong font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/WindSong
  static TextTheme windSongTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: windSong(textStyle: textTheme.displayLarge),
      displayMedium: windSong(textStyle: textTheme.displayMedium),
      displaySmall: windSong(textStyle: textTheme.displaySmall),
      headlineLarge: windSong(textStyle: textTheme.headlineLarge),
      headlineMedium: windSong(textStyle: textTheme.headlineMedium),
      headlineSmall: windSong(textStyle: textTheme.headlineSmall),
      titleLarge: windSong(textStyle: textTheme.titleLarge),
      titleMedium: windSong(textStyle: textTheme.titleMedium),
      titleSmall: windSong(textStyle: textTheme.titleSmall),
      bodyLarge: windSong(textStyle: textTheme.bodyLarge),
      bodyMedium: windSong(textStyle: textTheme.bodyMedium),
      bodySmall: windSong(textStyle: textTheme.bodySmall),
      labelLarge: windSong(textStyle: textTheme.labelLarge),
      labelMedium: windSong(textStyle: textTheme.labelMedium),
      labelSmall: windSong(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wire One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wire+One
  static TextStyle wireOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e5ae3f6da3031a2c4c124c9a743d75a08b3dfccb4aaca3e57793927efc448dde',
        31832,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WireOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wire One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wire+One
  static TextTheme wireOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wireOne(textStyle: textTheme.displayLarge),
      displayMedium: wireOne(textStyle: textTheme.displayMedium),
      displaySmall: wireOne(textStyle: textTheme.displaySmall),
      headlineLarge: wireOne(textStyle: textTheme.headlineLarge),
      headlineMedium: wireOne(textStyle: textTheme.headlineMedium),
      headlineSmall: wireOne(textStyle: textTheme.headlineSmall),
      titleLarge: wireOne(textStyle: textTheme.titleLarge),
      titleMedium: wireOne(textStyle: textTheme.titleMedium),
      titleSmall: wireOne(textStyle: textTheme.titleSmall),
      bodyLarge: wireOne(textStyle: textTheme.bodyLarge),
      bodyMedium: wireOne(textStyle: textTheme.bodyMedium),
      bodySmall: wireOne(textStyle: textTheme.bodySmall),
      labelLarge: wireOne(textStyle: textTheme.labelLarge),
      labelMedium: wireOne(textStyle: textTheme.labelMedium),
      labelSmall: wireOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wix Madefor Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wix+Madefor+Display
  static TextStyle wixMadeforDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c94be2684a65ca858233f7cfd85c2e80891217de98e9817401994dab034898e',
        83700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d56936c7ef90d585f49369f61435ce708a6cd35f62629e34abfe52e4c7340d9',
        83812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45d3f65407e7b154b1d72a747fe5e97a396d4e7c1075ade899b3fad7593437b9',
        83808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f4ec63c7579c0b9ff13a212b8a7ab02b2c5a3d229e396d97990d920991714ed',
        83756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '58d8d6ca939736eb2a1e64cf8b8efe7dc5a9c16060d7d3fe33cc454b481ed93c',
        83840,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WixMadeforDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wix Madefor Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wix+Madefor+Display
  static TextTheme wixMadeforDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wixMadeforDisplay(textStyle: textTheme.displayLarge),
      displayMedium: wixMadeforDisplay(textStyle: textTheme.displayMedium),
      displaySmall: wixMadeforDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: wixMadeforDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: wixMadeforDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: wixMadeforDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: wixMadeforDisplay(textStyle: textTheme.titleLarge),
      titleMedium: wixMadeforDisplay(textStyle: textTheme.titleMedium),
      titleSmall: wixMadeforDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: wixMadeforDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: wixMadeforDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: wixMadeforDisplay(textStyle: textTheme.bodySmall),
      labelLarge: wixMadeforDisplay(textStyle: textTheme.labelLarge),
      labelMedium: wixMadeforDisplay(textStyle: textTheme.labelMedium),
      labelSmall: wixMadeforDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Wix Madefor Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wix+Madefor+Text
  static TextStyle wixMadeforText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '39e06b688bd1ebcac84cd3759a704dc4f07cbfc9766b9fe51b017fb25f65cf4e',
        79164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0cd22715b493d44eba74e0e5956b0b32747cf8247ddd15278827655553ac777f',
        44864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9b7460af2a02f518c7186931e27cae83074ddb867fdbba241df65c23f4c806f',
        79880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '44ee304e328bf67d0bb50e1ac9e5f76b54d113a28158cf7f369908aeb364bc62',
        46480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '12f02f1a25eaaaa71cd86c17299589316bf2deed43fba246e7c9a192d4d7e749',
        79956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '26f1a055852f876a4e13795de29bace472d47ba80a8d5236c611680c90486ca7',
        46496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87735b24f074c316e7cfea8a1ec4cfc5bbdf51124b63a78ee0ebbe69d8080552',
        79900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a463a59c035d40adbeca2593f8e4a1d0351422ad3275f6cc9955416fc8a85354',
        46008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e810e1c3c5cd47087a9f12a8a574aa553cceb7f560e6b2d7d80c98068a867aec',
        79804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8d40b445ab580c15ec73c82a83cc470ffb3e92c7f2fe546106f2f19769b1dc11',
        45936,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WixMadeforText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Wix Madefor Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Wix+Madefor+Text
  static TextTheme wixMadeforTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: wixMadeforText(textStyle: textTheme.displayLarge),
      displayMedium: wixMadeforText(textStyle: textTheme.displayMedium),
      displaySmall: wixMadeforText(textStyle: textTheme.displaySmall),
      headlineLarge: wixMadeforText(textStyle: textTheme.headlineLarge),
      headlineMedium: wixMadeforText(textStyle: textTheme.headlineMedium),
      headlineSmall: wixMadeforText(textStyle: textTheme.headlineSmall),
      titleLarge: wixMadeforText(textStyle: textTheme.titleLarge),
      titleMedium: wixMadeforText(textStyle: textTheme.titleMedium),
      titleSmall: wixMadeforText(textStyle: textTheme.titleSmall),
      bodyLarge: wixMadeforText(textStyle: textTheme.bodyLarge),
      bodyMedium: wixMadeforText(textStyle: textTheme.bodyMedium),
      bodySmall: wixMadeforText(textStyle: textTheme.bodySmall),
      labelLarge: wixMadeforText(textStyle: textTheme.labelLarge),
      labelMedium: wixMadeforText(textStyle: textTheme.labelMedium),
      labelSmall: wixMadeforText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Work Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Work+Sans
  static TextStyle workSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a81cf4612e1205a70dac916c617ff8c43182f6cac021685038f896e88975c72',
        116724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8efe3d2a544c4fab1aa1c2aafa0915509de6d2ba2932e87d585618ffda15972d',
        117084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b2a8063da063e55ea2dd6e28fabc97a964d58f55053cb4647f3cb17308955df',
        117072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60f88dc2cce3ddf583afe9022585e7c6df3b11f992537a49f3052f0d978f6174',
        116940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe1d427cdb46d1777afc6b35a9565560d6add95a8e2fa536882e84cbef857c63',
        117220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '912ca20e7c96a44e28e00add833fe861585447ef83ac84b09635c4986bc7d615',
        117272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b8a69b6f7d4de8bf52d22c217a91fdd83a325888d1615a9107a40b645c1953c',
        117208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '942dcfe4da0a9d613dec0e85281b2095a81ee0e342cc0ca4e26ab718eb1a5a64',
        117280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e89bcdbfa62cf271d810a7d58a2949beef8bb901ca83d16ed849e22dd536eba',
        116908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'de4e53e5c4292366667b2d362d0e00b6e3e250f7eb982d4a0220646da7f268a1',
        111332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '24de90a8224a549319ee740a1a1f223555ed45b87402a1a3dc2d2e7819be8e3d',
        111576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cc557d9332dcbda21103661462e6d59c6648b03f513e60b7215d836418210271',
        111512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2a4d53725d76fc3408d62acb4174afbed74a14f73807a0a5ffd7a93808ec94e5',
        111208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '27167c4064c2e7652b6f83562b2c2c2e61d566dd1ebd7a41b8943c91e9d996ea',
        111728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a274ce5f864b8b4c01118d4984515464db701976204c9a3002c632a8dedabc88',
        111736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cb511f615f3d1d5cc44d05837920dae0ed6167d3a0f2921af054782af9058e36',
        111636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '02f27e4d1aa7c21dd9d2ee551a31d57494b5711376cab9a7e52b43a086dfa967',
        111724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8ac10e180a0d236260a7459dc8be75c2bd9e0d8306dc621e4c6351bfdf3431a4',
        111576,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'WorkSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Work Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Work+Sans
  static TextTheme workSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: workSans(textStyle: textTheme.displayLarge),
      displayMedium: workSans(textStyle: textTheme.displayMedium),
      displaySmall: workSans(textStyle: textTheme.displaySmall),
      headlineLarge: workSans(textStyle: textTheme.headlineLarge),
      headlineMedium: workSans(textStyle: textTheme.headlineMedium),
      headlineSmall: workSans(textStyle: textTheme.headlineSmall),
      titleLarge: workSans(textStyle: textTheme.titleLarge),
      titleMedium: workSans(textStyle: textTheme.titleMedium),
      titleSmall: workSans(textStyle: textTheme.titleSmall),
      bodyLarge: workSans(textStyle: textTheme.bodyLarge),
      bodyMedium: workSans(textStyle: textTheme.bodyMedium),
      bodySmall: workSans(textStyle: textTheme.bodySmall),
      labelLarge: workSans(textStyle: textTheme.labelLarge),
      labelMedium: workSans(textStyle: textTheme.labelMedium),
      labelSmall: workSans(textStyle: textTheme.labelSmall),
    );
  }
}
