// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'R'.
class PartR {
  /// Applies the REM font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/REM
  static TextStyle rem({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c27a7474ddacb2e529146819a795e041ed58a315f8e836b4a9a99c62afd3adb',
        70860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1617f1348b143674c6b732e5884255e141b0a477905ecaeca6613903454e5c99',
        70976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '144110b7cbbe6d75b44464d2ed2db6096ccd119f18418277e6e4a80d58f6e634',
        70940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '72f250e5c05cb54f9a63c4592dd0a8dc38e96aa8ceea40bcb591649f9102f657',
        70876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04f09dcff9e3dcde49a6c69764761e7bb8a44db95749c1a1c8d17859a72d6174',
        70836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a52c3f08d2879982aca0483ea8799c0047127ceac68bf620bf2f043d981d9e55',
        72124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ae30e4cb5df9e661fd0ff2ffe2c6e8515fb1578961a1f4089adc73a1da262e5',
        72072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9580ed4527705c0542f1dbc4412ca0b54871ac3d2bc7e263d23272e206487c96',
        73096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '251b6aaa2ffafbe52064be05b1e1a43f034f9c949612a862561a2188863d4edb',
        72980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd0be4a539f2645e9b24ef891561e56cf74b460501eb28a0000607b4dbc339720',
        72180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2f808fb6b0d48ff08444d5defbfc5ef0ac1aaeade126eda4a7f1b17163a9c798',
        72316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fbcc57d34778054a760a198350313f136849a2379c43e842929e005126602529',
        72264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '94b906ba250fd1b74ef38cd9cdb711376d4db0a2ba0e78da8fbb7fea21059e7c',
        72144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1a0ff8af7b88e980799bc55e395a1cc777230e50c4fce4e74f87376b5c002b76',
        72224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ac10b9a47ed577e6d7aff1573b36c5d2106e0239e29d2f327e5bbcf2ea7a24ad',
        73520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b42bf8546fe9a63fba2f97febc5ca47b10f182f999db742a7ec3a9f81d1e4f91',
        73432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '312afe79cf96870f09f65bfa695a7b3b835f85afa4656821b6dcf88145532bf2',
        74496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '05161a797c845260fee7d53de97200669108001b366d63f11605ac4fb0b0c3fc',
        74328,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'REM',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the REM font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/REM
  static TextTheme remTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rem(textStyle: textTheme.displayLarge),
      displayMedium: rem(textStyle: textTheme.displayMedium),
      displaySmall: rem(textStyle: textTheme.displaySmall),
      headlineLarge: rem(textStyle: textTheme.headlineLarge),
      headlineMedium: rem(textStyle: textTheme.headlineMedium),
      headlineSmall: rem(textStyle: textTheme.headlineSmall),
      titleLarge: rem(textStyle: textTheme.titleLarge),
      titleMedium: rem(textStyle: textTheme.titleMedium),
      titleSmall: rem(textStyle: textTheme.titleSmall),
      bodyLarge: rem(textStyle: textTheme.bodyLarge),
      bodyMedium: rem(textStyle: textTheme.bodyMedium),
      bodySmall: rem(textStyle: textTheme.bodySmall),
      labelLarge: rem(textStyle: textTheme.labelLarge),
      labelMedium: rem(textStyle: textTheme.labelMedium),
      labelSmall: rem(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Racing Sans One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Racing+Sans+One
  static TextStyle racingSansOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6492db146d419a7d6762601db2fb05ccb0ab668746577e29448986ba403b451',
        75196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RacingSansOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Racing Sans One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Racing+Sans+One
  static TextTheme racingSansOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: racingSansOne(textStyle: textTheme.displayLarge),
      displayMedium: racingSansOne(textStyle: textTheme.displayMedium),
      displaySmall: racingSansOne(textStyle: textTheme.displaySmall),
      headlineLarge: racingSansOne(textStyle: textTheme.headlineLarge),
      headlineMedium: racingSansOne(textStyle: textTheme.headlineMedium),
      headlineSmall: racingSansOne(textStyle: textTheme.headlineSmall),
      titleLarge: racingSansOne(textStyle: textTheme.titleLarge),
      titleMedium: racingSansOne(textStyle: textTheme.titleMedium),
      titleSmall: racingSansOne(textStyle: textTheme.titleSmall),
      bodyLarge: racingSansOne(textStyle: textTheme.bodyLarge),
      bodyMedium: racingSansOne(textStyle: textTheme.bodyMedium),
      bodySmall: racingSansOne(textStyle: textTheme.bodySmall),
      labelLarge: racingSansOne(textStyle: textTheme.labelLarge),
      labelMedium: racingSansOne(textStyle: textTheme.labelMedium),
      labelSmall: racingSansOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Radio Canada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Radio+Canada
  static TextStyle radioCanada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '32257abdedd7c86b2a543c1e858519793222f5da20ef2b84900c319d05c5d36a',
        126584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14af91ccbde862456321fed42b9c8bbc390ab7937404a2f2577190031dc7ca9d',
        126892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '368137944448577c0e3788bf4c5cdf4ebde73e3d3a28b25b2b5732397cad1420',
        127668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '674d2d64f0ccff3d714349dd27e205e8168e4fbc0f7bf1fb261da978181489be',
        127636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e695540eed85b5a1353eff2d8294ba7d091804efaacd28d10551f347642be304',
        127388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fc74e4ca34d6d1ea27808ce28a5cd4c7cfff8b6158e2f47d38792da19ea6bdd4',
        130016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0c7939b540846137e75d73ca4c2252faee9c87778847a983c3774a114eb03279',
        130272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e9da5155c675d5c6ddcc68e1dbb9ee8716f5bb77f30b0b891dd686c7896a780d',
        131044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '70ef578c70112c7ba0b5a0678afec6f5e87b378bf8dad30efdcf24ca4b570d7b',
        131020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3ef6c7927b971da5675ce08c0785ec55c81e9e4c6fa44f3b8bf978fe73b5e24c',
        130776,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RadioCanada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Radio Canada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Radio+Canada
  static TextTheme radioCanadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: radioCanada(textStyle: textTheme.displayLarge),
      displayMedium: radioCanada(textStyle: textTheme.displayMedium),
      displaySmall: radioCanada(textStyle: textTheme.displaySmall),
      headlineLarge: radioCanada(textStyle: textTheme.headlineLarge),
      headlineMedium: radioCanada(textStyle: textTheme.headlineMedium),
      headlineSmall: radioCanada(textStyle: textTheme.headlineSmall),
      titleLarge: radioCanada(textStyle: textTheme.titleLarge),
      titleMedium: radioCanada(textStyle: textTheme.titleMedium),
      titleSmall: radioCanada(textStyle: textTheme.titleSmall),
      bodyLarge: radioCanada(textStyle: textTheme.bodyLarge),
      bodyMedium: radioCanada(textStyle: textTheme.bodyMedium),
      bodySmall: radioCanada(textStyle: textTheme.bodySmall),
      labelLarge: radioCanada(textStyle: textTheme.labelLarge),
      labelMedium: radioCanada(textStyle: textTheme.labelMedium),
      labelSmall: radioCanada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Radley font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Radley
  static TextStyle radley({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2fceb10b6e99ab5c511ebbc946bbe5d9d990e077bf378c9b0a1407343487a29b',
        52080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3f32bb11fb764c9e5794b8f9fb5c4b914545a85abd6afbfc417c15e71bb7399a',
        46560,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Radley',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Radley font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Radley
  static TextTheme radleyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: radley(textStyle: textTheme.displayLarge),
      displayMedium: radley(textStyle: textTheme.displayMedium),
      displaySmall: radley(textStyle: textTheme.displaySmall),
      headlineLarge: radley(textStyle: textTheme.headlineLarge),
      headlineMedium: radley(textStyle: textTheme.headlineMedium),
      headlineSmall: radley(textStyle: textTheme.headlineSmall),
      titleLarge: radley(textStyle: textTheme.titleLarge),
      titleMedium: radley(textStyle: textTheme.titleMedium),
      titleSmall: radley(textStyle: textTheme.titleSmall),
      bodyLarge: radley(textStyle: textTheme.bodyLarge),
      bodyMedium: radley(textStyle: textTheme.bodyMedium),
      bodySmall: radley(textStyle: textTheme.bodySmall),
      labelLarge: radley(textStyle: textTheme.labelLarge),
      labelMedium: radley(textStyle: textTheme.labelMedium),
      labelSmall: radley(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rajdhani font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rajdhani
  static TextStyle rajdhani({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '192b606d14e81260b70011c0b0c5112d9a3e9c65afa4f26b77ad0c86b40d5898',
        217500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff6e72fe9cf36e9a1c242b9bfd96b5428d8fffa2f1e051aedb763e7541541cd1',
        216760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aaaec9e0132fad7581bc52138b8093c83ba03a319a3c304e6c011afbbf789b6d',
        214792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28f91a9ceab5666fd1bce81d641f74b66cf748a3d4c71d3ff448c4e68d15a738',
        214296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9daa5a92fd35dd5dacf143f23fe31b929d06731e83fb82f5e2890ba9dd642111',
        216528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rajdhani',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rajdhani font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rajdhani
  static TextTheme rajdhaniTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rajdhani(textStyle: textTheme.displayLarge),
      displayMedium: rajdhani(textStyle: textTheme.displayMedium),
      displaySmall: rajdhani(textStyle: textTheme.displaySmall),
      headlineLarge: rajdhani(textStyle: textTheme.headlineLarge),
      headlineMedium: rajdhani(textStyle: textTheme.headlineMedium),
      headlineSmall: rajdhani(textStyle: textTheme.headlineSmall),
      titleLarge: rajdhani(textStyle: textTheme.titleLarge),
      titleMedium: rajdhani(textStyle: textTheme.titleMedium),
      titleSmall: rajdhani(textStyle: textTheme.titleSmall),
      bodyLarge: rajdhani(textStyle: textTheme.bodyLarge),
      bodyMedium: rajdhani(textStyle: textTheme.bodyMedium),
      bodySmall: rajdhani(textStyle: textTheme.bodySmall),
      labelLarge: rajdhani(textStyle: textTheme.labelLarge),
      labelMedium: rajdhani(textStyle: textTheme.labelMedium),
      labelSmall: rajdhani(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rakkas font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rakkas
  static TextStyle rakkas({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a0251e564daba93e12cd57ba0f8d690c2c184c5dde185fca3839466a065ff45',
        92700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rakkas',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rakkas font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rakkas
  static TextTheme rakkasTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rakkas(textStyle: textTheme.displayLarge),
      displayMedium: rakkas(textStyle: textTheme.displayMedium),
      displaySmall: rakkas(textStyle: textTheme.displaySmall),
      headlineLarge: rakkas(textStyle: textTheme.headlineLarge),
      headlineMedium: rakkas(textStyle: textTheme.headlineMedium),
      headlineSmall: rakkas(textStyle: textTheme.headlineSmall),
      titleLarge: rakkas(textStyle: textTheme.titleLarge),
      titleMedium: rakkas(textStyle: textTheme.titleMedium),
      titleSmall: rakkas(textStyle: textTheme.titleSmall),
      bodyLarge: rakkas(textStyle: textTheme.bodyLarge),
      bodyMedium: rakkas(textStyle: textTheme.bodyMedium),
      bodySmall: rakkas(textStyle: textTheme.bodySmall),
      labelLarge: rakkas(textStyle: textTheme.labelLarge),
      labelMedium: rakkas(textStyle: textTheme.labelMedium),
      labelSmall: rakkas(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Raleway font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Raleway
  static TextStyle raleway({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '224ecf762c40f4aac88f48353d6b0ce62eeb5d90556e26b7704d024632195809',
        117352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1c11109ae4f18bfa1065ec0bdfe95ee1d85071b476cdcd7fb5bb7a02eeb79ff',
        117548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0479039177e871c2b2b4eef8fa0108c929b804f1cae8a0b8de30dd0e701b7112',
        117448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e549403e4a007249673d041c55e7205d754210d79b962001d95a8313191aa3c2',
        117388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc2640fc16a60883b8f9db92bd4ff12c5049d45d8b17bceed4fcb21827d76961',
        117392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dce4cd0ac8892078aa945c86610d15a0d3566a26a8ad62eb0ba48b51dc4a6a66',
        117404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dc6ebfa9c6e8cb7de1831117fc3b905b63aafc63320665a4f4c722da65f0f76a',
        117312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8c6b02dc280974028f39e99d29505c52f275c1e935c741ae6319c94f6022fb1',
        117376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d6b10ef732abfb934319e7890bc547c62b0c2f55204eab80601435d045df3a0',
        117060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a6b001e19ef8909bebaa35afb3823eefe97413a8f5fe209f9a27556355b16c45',
        115344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3b9a92f6091065537a6fa412ec540204988693313176daacf991e71b0056b3c8',
        115444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2a57af68d557365701e21f71034bdb64961e599768a02901851405b45f8f113d',
        115424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6597b943f258602aa9b409278ffc9bed9780c34675313453146044af80113f03',
        115232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9c58b776ba9e08f651f83df1c6e3e7a09c95d29c0dd58d3ab607a72ccdb23a87',
        115300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a18b9a23bd09f74381cefe7b868bd094815c56a0bc711f97c6f6888e388491d8',
        115388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fb540d416ec2fb8b6a2bd5de94c89576ab0059ea372e4f44adbe5dbdaee03d18',
        115252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '066aae67341d1789840a58b02741533b290f599fe2874e2d08c54592c4f34610',
        115396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '845342512e0567b18bc0db3fc6e29e6905ef4ea3b06f677081c1025149cd709c',
        115020,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Raleway',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Raleway font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Raleway
  static TextTheme ralewayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: raleway(textStyle: textTheme.displayLarge),
      displayMedium: raleway(textStyle: textTheme.displayMedium),
      displaySmall: raleway(textStyle: textTheme.displaySmall),
      headlineLarge: raleway(textStyle: textTheme.headlineLarge),
      headlineMedium: raleway(textStyle: textTheme.headlineMedium),
      headlineSmall: raleway(textStyle: textTheme.headlineSmall),
      titleLarge: raleway(textStyle: textTheme.titleLarge),
      titleMedium: raleway(textStyle: textTheme.titleMedium),
      titleSmall: raleway(textStyle: textTheme.titleSmall),
      bodyLarge: raleway(textStyle: textTheme.bodyLarge),
      bodyMedium: raleway(textStyle: textTheme.bodyMedium),
      bodySmall: raleway(textStyle: textTheme.bodySmall),
      labelLarge: raleway(textStyle: textTheme.labelLarge),
      labelMedium: raleway(textStyle: textTheme.labelMedium),
      labelSmall: raleway(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Raleway Dots font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Raleway+Dots
  static TextStyle ralewayDots({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d5cbeee558af619a3f7f0d4a5fa151b91eb94d076f17741c493350d35d3a9e2',
        188964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RalewayDots',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Raleway Dots font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Raleway+Dots
  static TextTheme ralewayDotsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ralewayDots(textStyle: textTheme.displayLarge),
      displayMedium: ralewayDots(textStyle: textTheme.displayMedium),
      displaySmall: ralewayDots(textStyle: textTheme.displaySmall),
      headlineLarge: ralewayDots(textStyle: textTheme.headlineLarge),
      headlineMedium: ralewayDots(textStyle: textTheme.headlineMedium),
      headlineSmall: ralewayDots(textStyle: textTheme.headlineSmall),
      titleLarge: ralewayDots(textStyle: textTheme.titleLarge),
      titleMedium: ralewayDots(textStyle: textTheme.titleMedium),
      titleSmall: ralewayDots(textStyle: textTheme.titleSmall),
      bodyLarge: ralewayDots(textStyle: textTheme.bodyLarge),
      bodyMedium: ralewayDots(textStyle: textTheme.bodyMedium),
      bodySmall: ralewayDots(textStyle: textTheme.bodySmall),
      labelLarge: ralewayDots(textStyle: textTheme.labelLarge),
      labelMedium: ralewayDots(textStyle: textTheme.labelMedium),
      labelSmall: ralewayDots(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ramabhadra font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ramabhadra
  static TextStyle ramabhadra({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b475183d7a82e6754bbfebdeadda687af1ee9a3223b405314dfba9236a5acf3d',
        319564,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ramabhadra',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ramabhadra font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ramabhadra
  static TextTheme ramabhadraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ramabhadra(textStyle: textTheme.displayLarge),
      displayMedium: ramabhadra(textStyle: textTheme.displayMedium),
      displaySmall: ramabhadra(textStyle: textTheme.displaySmall),
      headlineLarge: ramabhadra(textStyle: textTheme.headlineLarge),
      headlineMedium: ramabhadra(textStyle: textTheme.headlineMedium),
      headlineSmall: ramabhadra(textStyle: textTheme.headlineSmall),
      titleLarge: ramabhadra(textStyle: textTheme.titleLarge),
      titleMedium: ramabhadra(textStyle: textTheme.titleMedium),
      titleSmall: ramabhadra(textStyle: textTheme.titleSmall),
      bodyLarge: ramabhadra(textStyle: textTheme.bodyLarge),
      bodyMedium: ramabhadra(textStyle: textTheme.bodyMedium),
      bodySmall: ramabhadra(textStyle: textTheme.bodySmall),
      labelLarge: ramabhadra(textStyle: textTheme.labelLarge),
      labelMedium: ramabhadra(textStyle: textTheme.labelMedium),
      labelSmall: ramabhadra(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ramaraja font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ramaraja
  static TextStyle ramaraja({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17595caf1dbf5c3235c44859d0b4543d12923808268604b0967ecc4fa1e7dff8',
        440392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ramaraja',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ramaraja font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ramaraja
  static TextTheme ramarajaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ramaraja(textStyle: textTheme.displayLarge),
      displayMedium: ramaraja(textStyle: textTheme.displayMedium),
      displaySmall: ramaraja(textStyle: textTheme.displaySmall),
      headlineLarge: ramaraja(textStyle: textTheme.headlineLarge),
      headlineMedium: ramaraja(textStyle: textTheme.headlineMedium),
      headlineSmall: ramaraja(textStyle: textTheme.headlineSmall),
      titleLarge: ramaraja(textStyle: textTheme.titleLarge),
      titleMedium: ramaraja(textStyle: textTheme.titleMedium),
      titleSmall: ramaraja(textStyle: textTheme.titleSmall),
      bodyLarge: ramaraja(textStyle: textTheme.bodyLarge),
      bodyMedium: ramaraja(textStyle: textTheme.bodyMedium),
      bodySmall: ramaraja(textStyle: textTheme.bodySmall),
      labelLarge: ramaraja(textStyle: textTheme.labelLarge),
      labelMedium: ramaraja(textStyle: textTheme.labelMedium),
      labelSmall: ramaraja(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rambla font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rambla
  static TextStyle rambla({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '445f78a8f5be7d9ef22efa54929a0e53c95c5212fd40e5323bc5ee27ff263adc',
        32208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f8559dd68b1e4ec33ea8e82aef88e2ac65b5208e90aedcc3570b9e258dde3858',
        34992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd2ab0095a5821055695a33234b3576af18a07613dcc2864526bb1c5c6e4fecbc',
        32248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4595e357da22bc7ae81a691962b115024e2cfc624fda09673d4785f4761d7f9b',
        34820,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rambla',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rambla font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rambla
  static TextTheme ramblaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rambla(textStyle: textTheme.displayLarge),
      displayMedium: rambla(textStyle: textTheme.displayMedium),
      displaySmall: rambla(textStyle: textTheme.displaySmall),
      headlineLarge: rambla(textStyle: textTheme.headlineLarge),
      headlineMedium: rambla(textStyle: textTheme.headlineMedium),
      headlineSmall: rambla(textStyle: textTheme.headlineSmall),
      titleLarge: rambla(textStyle: textTheme.titleLarge),
      titleMedium: rambla(textStyle: textTheme.titleMedium),
      titleSmall: rambla(textStyle: textTheme.titleSmall),
      bodyLarge: rambla(textStyle: textTheme.bodyLarge),
      bodyMedium: rambla(textStyle: textTheme.bodyMedium),
      bodySmall: rambla(textStyle: textTheme.bodySmall),
      labelLarge: rambla(textStyle: textTheme.labelLarge),
      labelMedium: rambla(textStyle: textTheme.labelMedium),
      labelSmall: rambla(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rammetto One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rammetto+One
  static TextStyle rammettoOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6d60047f1fef7602ab10a7e8b9513ec1ada634bceed44d7f1c87b1c46852845a',
        28124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RammettoOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rammetto One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rammetto+One
  static TextTheme rammettoOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rammettoOne(textStyle: textTheme.displayLarge),
      displayMedium: rammettoOne(textStyle: textTheme.displayMedium),
      displaySmall: rammettoOne(textStyle: textTheme.displaySmall),
      headlineLarge: rammettoOne(textStyle: textTheme.headlineLarge),
      headlineMedium: rammettoOne(textStyle: textTheme.headlineMedium),
      headlineSmall: rammettoOne(textStyle: textTheme.headlineSmall),
      titleLarge: rammettoOne(textStyle: textTheme.titleLarge),
      titleMedium: rammettoOne(textStyle: textTheme.titleMedium),
      titleSmall: rammettoOne(textStyle: textTheme.titleSmall),
      bodyLarge: rammettoOne(textStyle: textTheme.bodyLarge),
      bodyMedium: rammettoOne(textStyle: textTheme.bodyMedium),
      bodySmall: rammettoOne(textStyle: textTheme.bodySmall),
      labelLarge: rammettoOne(textStyle: textTheme.labelLarge),
      labelMedium: rammettoOne(textStyle: textTheme.labelMedium),
      labelSmall: rammettoOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rampart One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rampart+One
  static TextStyle rampartOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df668f90decf9f8af77d5e3d28d925a74b7dce3d8a9972daa5a42f350d308292',
        3404536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RampartOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rampart One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rampart+One
  static TextTheme rampartOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rampartOne(textStyle: textTheme.displayLarge),
      displayMedium: rampartOne(textStyle: textTheme.displayMedium),
      displaySmall: rampartOne(textStyle: textTheme.displaySmall),
      headlineLarge: rampartOne(textStyle: textTheme.headlineLarge),
      headlineMedium: rampartOne(textStyle: textTheme.headlineMedium),
      headlineSmall: rampartOne(textStyle: textTheme.headlineSmall),
      titleLarge: rampartOne(textStyle: textTheme.titleLarge),
      titleMedium: rampartOne(textStyle: textTheme.titleMedium),
      titleSmall: rampartOne(textStyle: textTheme.titleSmall),
      bodyLarge: rampartOne(textStyle: textTheme.bodyLarge),
      bodyMedium: rampartOne(textStyle: textTheme.bodyMedium),
      bodySmall: rampartOne(textStyle: textTheme.bodySmall),
      labelLarge: rampartOne(textStyle: textTheme.labelLarge),
      labelMedium: rampartOne(textStyle: textTheme.labelMedium),
      labelSmall: rampartOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ranchers font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ranchers
  static TextStyle ranchers({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30959d0aee674a57c2064a0453d3568bf69f436b1add896dc68f5c563c752806',
        90044,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ranchers',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ranchers font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ranchers
  static TextTheme ranchersTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ranchers(textStyle: textTheme.displayLarge),
      displayMedium: ranchers(textStyle: textTheme.displayMedium),
      displaySmall: ranchers(textStyle: textTheme.displaySmall),
      headlineLarge: ranchers(textStyle: textTheme.headlineLarge),
      headlineMedium: ranchers(textStyle: textTheme.headlineMedium),
      headlineSmall: ranchers(textStyle: textTheme.headlineSmall),
      titleLarge: ranchers(textStyle: textTheme.titleLarge),
      titleMedium: ranchers(textStyle: textTheme.titleMedium),
      titleSmall: ranchers(textStyle: textTheme.titleSmall),
      bodyLarge: ranchers(textStyle: textTheme.bodyLarge),
      bodyMedium: ranchers(textStyle: textTheme.bodyMedium),
      bodySmall: ranchers(textStyle: textTheme.bodySmall),
      labelLarge: ranchers(textStyle: textTheme.labelLarge),
      labelMedium: ranchers(textStyle: textTheme.labelMedium),
      labelSmall: ranchers(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rancho font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rancho
  static TextStyle rancho({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c3447da70ebae60ab0ecbfc27349188fe3a9de380aab5dd639760493c9493966',
        43096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rancho',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rancho font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rancho
  static TextTheme ranchoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rancho(textStyle: textTheme.displayLarge),
      displayMedium: rancho(textStyle: textTheme.displayMedium),
      displaySmall: rancho(textStyle: textTheme.displaySmall),
      headlineLarge: rancho(textStyle: textTheme.headlineLarge),
      headlineMedium: rancho(textStyle: textTheme.headlineMedium),
      headlineSmall: rancho(textStyle: textTheme.headlineSmall),
      titleLarge: rancho(textStyle: textTheme.titleLarge),
      titleMedium: rancho(textStyle: textTheme.titleMedium),
      titleSmall: rancho(textStyle: textTheme.titleSmall),
      bodyLarge: rancho(textStyle: textTheme.bodyLarge),
      bodyMedium: rancho(textStyle: textTheme.bodyMedium),
      bodySmall: rancho(textStyle: textTheme.bodySmall),
      labelLarge: rancho(textStyle: textTheme.labelLarge),
      labelMedium: rancho(textStyle: textTheme.labelMedium),
      labelSmall: rancho(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ranga font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ranga
  static TextStyle ranga({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c63c0af4da5a4e20b84dbfdb056c7ac1c61d5e48372906d8cf76ce80ce5c9af',
        105756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '961432ef0728647b8fb1733b50f24f6fd6be11f65a4c8970d4726fd301f83c9a',
        113056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ranga',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ranga font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ranga
  static TextTheme rangaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ranga(textStyle: textTheme.displayLarge),
      displayMedium: ranga(textStyle: textTheme.displayMedium),
      displaySmall: ranga(textStyle: textTheme.displaySmall),
      headlineLarge: ranga(textStyle: textTheme.headlineLarge),
      headlineMedium: ranga(textStyle: textTheme.headlineMedium),
      headlineSmall: ranga(textStyle: textTheme.headlineSmall),
      titleLarge: ranga(textStyle: textTheme.titleLarge),
      titleMedium: ranga(textStyle: textTheme.titleMedium),
      titleSmall: ranga(textStyle: textTheme.titleSmall),
      bodyLarge: ranga(textStyle: textTheme.bodyLarge),
      bodyMedium: ranga(textStyle: textTheme.bodyMedium),
      bodySmall: ranga(textStyle: textTheme.bodySmall),
      labelLarge: ranga(textStyle: textTheme.labelLarge),
      labelMedium: ranga(textStyle: textTheme.labelMedium),
      labelSmall: ranga(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rasa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rasa
  static TextStyle rasa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '218c26c408884cf1d34d09427a58a6e59f7d24b5f2bd1f49910bab2722dea657',
        244980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a5271399da41e8b1e31e915c0b98acc0ed864f38d5773e65df4e626178664df',
        245792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc178c509ac3fd0e8da2aa46a983a36f11e5847a95bbdcb7f26a56787e53466d',
        245796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f96b681ebe3e8d196e877a542fde58d2abf66d21ed43c61de8c535062219235',
        245912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbb33fcde96fe046c617cc97b1cde74d43ccd00636219162c2163b139b50fc43',
        245080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ec02d2a4b0891757dc252b2f8c78c7bb252cbeb33b8c5bb3b668600a61a56199',
        148584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b43c1f80404deff3892b0dacc848c5d1edb3b5d4493f8affcec5820c5ee0874c',
        148504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '799ccf0289a2e612c150f688e18b9fc39238e3c9873b88fd5feb78487e012391',
        148580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0c5dd074640c478bbc91d3ed8cd1da24c4c65cec8b31b3983f5b47c3b366c27e',
        148704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '66faaec965d4b628821c26b2b410dde57bf45eea186843f9de6fc11511ea50c4',
        147832,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rasa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rasa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rasa
  static TextTheme rasaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rasa(textStyle: textTheme.displayLarge),
      displayMedium: rasa(textStyle: textTheme.displayMedium),
      displaySmall: rasa(textStyle: textTheme.displaySmall),
      headlineLarge: rasa(textStyle: textTheme.headlineLarge),
      headlineMedium: rasa(textStyle: textTheme.headlineMedium),
      headlineSmall: rasa(textStyle: textTheme.headlineSmall),
      titleLarge: rasa(textStyle: textTheme.titleLarge),
      titleMedium: rasa(textStyle: textTheme.titleMedium),
      titleSmall: rasa(textStyle: textTheme.titleSmall),
      bodyLarge: rasa(textStyle: textTheme.bodyLarge),
      bodyMedium: rasa(textStyle: textTheme.bodyMedium),
      bodySmall: rasa(textStyle: textTheme.bodySmall),
      labelLarge: rasa(textStyle: textTheme.labelLarge),
      labelMedium: rasa(textStyle: textTheme.labelMedium),
      labelSmall: rasa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rationale font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rationale
  static TextStyle rationale({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ca296c443dbda669330e89426f990de63efe15a7521771226bb4158e3aef57f',
        24460,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rationale',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rationale font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rationale
  static TextTheme rationaleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rationale(textStyle: textTheme.displayLarge),
      displayMedium: rationale(textStyle: textTheme.displayMedium),
      displaySmall: rationale(textStyle: textTheme.displaySmall),
      headlineLarge: rationale(textStyle: textTheme.headlineLarge),
      headlineMedium: rationale(textStyle: textTheme.headlineMedium),
      headlineSmall: rationale(textStyle: textTheme.headlineSmall),
      titleLarge: rationale(textStyle: textTheme.titleLarge),
      titleMedium: rationale(textStyle: textTheme.titleMedium),
      titleSmall: rationale(textStyle: textTheme.titleSmall),
      bodyLarge: rationale(textStyle: textTheme.bodyLarge),
      bodyMedium: rationale(textStyle: textTheme.bodyMedium),
      bodySmall: rationale(textStyle: textTheme.bodySmall),
      labelLarge: rationale(textStyle: textTheme.labelLarge),
      labelMedium: rationale(textStyle: textTheme.labelMedium),
      labelSmall: rationale(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ravi Prakash font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ravi+Prakash
  static TextStyle raviPrakash({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c5f4ae0672f4c453482ad920569bda880a2e8f64f9569606544cba6be6463a2',
        214764,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RaviPrakash',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ravi Prakash font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ravi+Prakash
  static TextTheme raviPrakashTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: raviPrakash(textStyle: textTheme.displayLarge),
      displayMedium: raviPrakash(textStyle: textTheme.displayMedium),
      displaySmall: raviPrakash(textStyle: textTheme.displaySmall),
      headlineLarge: raviPrakash(textStyle: textTheme.headlineLarge),
      headlineMedium: raviPrakash(textStyle: textTheme.headlineMedium),
      headlineSmall: raviPrakash(textStyle: textTheme.headlineSmall),
      titleLarge: raviPrakash(textStyle: textTheme.titleLarge),
      titleMedium: raviPrakash(textStyle: textTheme.titleMedium),
      titleSmall: raviPrakash(textStyle: textTheme.titleSmall),
      bodyLarge: raviPrakash(textStyle: textTheme.bodyLarge),
      bodyMedium: raviPrakash(textStyle: textTheme.bodyMedium),
      bodySmall: raviPrakash(textStyle: textTheme.bodySmall),
      labelLarge: raviPrakash(textStyle: textTheme.labelLarge),
      labelMedium: raviPrakash(textStyle: textTheme.labelMedium),
      labelSmall: raviPrakash(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Readex Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Readex+Pro
  static TextStyle readexPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '870a3330a3749a6f77ae6869705a73e7cac177a535bebe60323fc706f632267c',
        93952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '38b0632b8ef49efc7781f129be6231d9e8f2191fe9522a7af3c63f514a1db7c8',
        94064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7782ff7d5dea5d731043a6a9485f9c129227a140122a8d5b066a4139b6db2dcb',
        93604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dd123b1e15265f38bb1e7ea3130a5b50529e1dd2701fd815a7a2c5ebd773cbf7',
        94112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6416f2670653f40b5d522b959fa9cef26de93f1eb07383cd74add81cd540223',
        94252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ea6ca5c476dff3996be03d6f357b8fc79d536b3324a74a2b8cd8d95b0c2d7cec',
        94224,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ReadexPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Readex Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Readex+Pro
  static TextTheme readexProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: readexPro(textStyle: textTheme.displayLarge),
      displayMedium: readexPro(textStyle: textTheme.displayMedium),
      displaySmall: readexPro(textStyle: textTheme.displaySmall),
      headlineLarge: readexPro(textStyle: textTheme.headlineLarge),
      headlineMedium: readexPro(textStyle: textTheme.headlineMedium),
      headlineSmall: readexPro(textStyle: textTheme.headlineSmall),
      titleLarge: readexPro(textStyle: textTheme.titleLarge),
      titleMedium: readexPro(textStyle: textTheme.titleMedium),
      titleSmall: readexPro(textStyle: textTheme.titleSmall),
      bodyLarge: readexPro(textStyle: textTheme.bodyLarge),
      bodyMedium: readexPro(textStyle: textTheme.bodyMedium),
      bodySmall: readexPro(textStyle: textTheme.bodySmall),
      labelLarge: readexPro(textStyle: textTheme.labelLarge),
      labelMedium: readexPro(textStyle: textTheme.labelMedium),
      labelSmall: readexPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Recursive font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Recursive
  static TextStyle recursive({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2bde03485b4ea0545c742934e0b1afa69d18cb98ef784a8beb6a3951dc23feb4',
        156188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c4a8737161e0528d703d65242ce220409c763d81e020c56574e2231d55e42e69',
        156372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ea489828daaba13e9f6e263aa76e1d5a22b2e609d8d5bcc71618dc3070c53d0d',
        156356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1099b5f49242cb96ee63e52a0c7274cb4c83d51212340e455653bf18c84b13de',
        156368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52c0471e0aaca3cc716d082e756410794fabd13bc720b4049dc94d345ec68ff6',
        156224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5352dbf3234228a5f2f1c85253d3ae5cfe059604b431df4f1ce6f82f56142c6c',
        156156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7023fb1d6b76c8f7c9b956c4fbfa0dd19b591fdb1f10421b8c78986edea52bcd',
        156364,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Recursive',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Recursive font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Recursive
  static TextTheme recursiveTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: recursive(textStyle: textTheme.displayLarge),
      displayMedium: recursive(textStyle: textTheme.displayMedium),
      displaySmall: recursive(textStyle: textTheme.displaySmall),
      headlineLarge: recursive(textStyle: textTheme.headlineLarge),
      headlineMedium: recursive(textStyle: textTheme.headlineMedium),
      headlineSmall: recursive(textStyle: textTheme.headlineSmall),
      titleLarge: recursive(textStyle: textTheme.titleLarge),
      titleMedium: recursive(textStyle: textTheme.titleMedium),
      titleSmall: recursive(textStyle: textTheme.titleSmall),
      bodyLarge: recursive(textStyle: textTheme.bodyLarge),
      bodyMedium: recursive(textStyle: textTheme.bodyMedium),
      bodySmall: recursive(textStyle: textTheme.bodySmall),
      labelLarge: recursive(textStyle: textTheme.labelLarge),
      labelMedium: recursive(textStyle: textTheme.labelMedium),
      labelSmall: recursive(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Red Hat Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Hat+Display
  static TextStyle redHatDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70007905adda13fc218dd33a3346c0a7652b31466a4de2af4626e5329f10f3c9',
        43332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6cb14e9f56379700f63f32e6e6a324c1f31d34c43af28a494cfbe291331c098d',
        43284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1741b1542ec8a72dc07ecb6346eaba419c6771e44af1c6659e4c9773c1391da7',
        43320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09db67258b0f12c485007d0dac9a2e0f8455a2e2212ab026630be6fc21cdfecc',
        43332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f3fc7776a329d45c9ec8c3a7f7e5e8db3f9647173add45cb6c7223d7a64aac4',
        43248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5d508d39bc9caee10223ae430a6957408f494cdc3befbf03cd77fc70d37c5d5',
        43324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3d11cbf79abbbcfd4b540ba92077aa17b7a6b3e75d238c81f3db9ad9957a1b4',
        43252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '13df11daa17b3a82abb58237406b14fa34fdcca54bbf4688e6feeceededd5632',
        44824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fdd4fcae1c5a1deba31b1652e0066f0cbbf35bd74a48856a0f91f8d6c48f009d',
        44676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4797f8d11c5e0f71f591f47d81d95ef7ee23cb14a91986793dee9e6b5dcde1e3',
        44808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c35a172652686b30739abbb39e7193c8f810712557057a5b874b8d1f09564f45',
        44832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f49fe81d7560d659456be7794d51e26a60ca73436a9e51b5f1f952c16c7d1c9f',
        44700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '47c9e8ccf897a70c057b655fdc90a8fb0fbe2ebe0e61474b29a079b1c0912d4f',
        44824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8f792d930567c8220f54cbd036a945acae43a7bfdd32b64540995a21dcf72acc',
        44764,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedHatDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Red Hat Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Hat+Display
  static TextTheme redHatDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redHatDisplay(textStyle: textTheme.displayLarge),
      displayMedium: redHatDisplay(textStyle: textTheme.displayMedium),
      displaySmall: redHatDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: redHatDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: redHatDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: redHatDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: redHatDisplay(textStyle: textTheme.titleLarge),
      titleMedium: redHatDisplay(textStyle: textTheme.titleMedium),
      titleSmall: redHatDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: redHatDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: redHatDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: redHatDisplay(textStyle: textTheme.bodySmall),
      labelLarge: redHatDisplay(textStyle: textTheme.labelLarge),
      labelMedium: redHatDisplay(textStyle: textTheme.labelMedium),
      labelSmall: redHatDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Red Hat Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Hat+Mono
  static TextStyle redHatMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87b8dbca2925e68c75916924ce29fc63605b003bc73ce31a00d77dbb622f5b6a',
        29048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff08e544abd325e9c4bc4a640a7ca443b55751126c6a6f0f48c5b9a3ac3b9145',
        28996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '57f2cc69860281dd3e6614f755d9afc941ab8cdc845e5d9cf1fc4dd46deb3f95',
        28972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7fc5042dc502a91cc598290729e3a2ec2e6d2bc4960099876fd552b9ab437467',
        28988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ce2186525a945f3b28be88f165550d488c5996cfa68539c5921dae1120eab10',
        28888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6b7b9bd748ad3eb82ca370863a81967a42ca3800b51153485d289a8eab63fa1d',
        30564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bb1fdbd2bb52dd09f6a58369e032b67bd9b0ddadba3e3b6a4ada834734e7e6ce',
        30388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1540971f844835d0fb7815bd63b7721281c242e81ffa6cc024df0f6ceebb5f46',
        30492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a8f2975226be63f738687110aa5017337cc2de88e06f51214abe54619d98b784',
        30516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0fc2fce442aceb9864555ecc6ec28904d24928a3798c3525191934034abf5cf8',
        30412,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedHatMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Red Hat Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Hat+Mono
  static TextTheme redHatMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redHatMono(textStyle: textTheme.displayLarge),
      displayMedium: redHatMono(textStyle: textTheme.displayMedium),
      displaySmall: redHatMono(textStyle: textTheme.displaySmall),
      headlineLarge: redHatMono(textStyle: textTheme.headlineLarge),
      headlineMedium: redHatMono(textStyle: textTheme.headlineMedium),
      headlineSmall: redHatMono(textStyle: textTheme.headlineSmall),
      titleLarge: redHatMono(textStyle: textTheme.titleLarge),
      titleMedium: redHatMono(textStyle: textTheme.titleMedium),
      titleSmall: redHatMono(textStyle: textTheme.titleSmall),
      bodyLarge: redHatMono(textStyle: textTheme.bodyLarge),
      bodyMedium: redHatMono(textStyle: textTheme.bodyMedium),
      bodySmall: redHatMono(textStyle: textTheme.bodySmall),
      labelLarge: redHatMono(textStyle: textTheme.labelLarge),
      labelMedium: redHatMono(textStyle: textTheme.labelMedium),
      labelSmall: redHatMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Red Hat Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Hat+Text
  static TextStyle redHatText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4752624ebdca6a69289a1b6536d83391fd908e8902a706bfa562c3d46d2cd394',
        43364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67a7cb611cb66b94ac1b6f742e6023747f439ad20e58c29a72898782804302ad',
        43352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0612d362d8b1863cff5a84136904c7ad349031c98313c482d723fe2e2c6c2f7f',
        43360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05870d5e585fce023a4b25c9bf0540c525262e7d15d23bc618752775ec1e422c',
        43376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '01a4fa61be760893c16187b9f5ba88dbab66556f5bace0e7517de8775d8e4498',
        43272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9c683ffb14040a3db383e89e2e13a842ce8c28c168f8e4fed0b138b4565834b0',
        45004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '15ae777c644ce918afa4483879e350a980563e4449175443e7a509c24cd58bf2',
        44900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fa21aebdf69a9af5bc9136bf70c317155a5c3b0c235fef575aebc07c2e028e5d',
        45040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '698c4f468b4279b88ab6bc760521fe62a9488dbb54789efcd56e468728ecefd8',
        45064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '31f2de7ba05fc26b352b54e582b124a4cb95fca5f75b08d9cfdcc1af1ae5f69a',
        44932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedHatText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Red Hat Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Hat+Text
  static TextTheme redHatTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redHatText(textStyle: textTheme.displayLarge),
      displayMedium: redHatText(textStyle: textTheme.displayMedium),
      displaySmall: redHatText(textStyle: textTheme.displaySmall),
      headlineLarge: redHatText(textStyle: textTheme.headlineLarge),
      headlineMedium: redHatText(textStyle: textTheme.headlineMedium),
      headlineSmall: redHatText(textStyle: textTheme.headlineSmall),
      titleLarge: redHatText(textStyle: textTheme.titleLarge),
      titleMedium: redHatText(textStyle: textTheme.titleMedium),
      titleSmall: redHatText(textStyle: textTheme.titleSmall),
      bodyLarge: redHatText(textStyle: textTheme.bodyLarge),
      bodyMedium: redHatText(textStyle: textTheme.bodyMedium),
      bodySmall: redHatText(textStyle: textTheme.bodySmall),
      labelLarge: redHatText(textStyle: textTheme.labelLarge),
      labelMedium: redHatText(textStyle: textTheme.labelMedium),
      labelSmall: redHatText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Red Rose font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Rose
  static TextStyle redRose({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46c14c3e0ff65c270e74f12d703c9342654ba7569cc691865ed95d4d3bad8c45',
        62016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '978beaa148a6104947ae25c087fa6751b40720f1319b22440a3e17b2451801de',
        62060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '490deaed68387998fb55ab8a1ea94b2417c79d9a8ad36ceb151f2702be3399a2',
        62104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f10a411a2b5cdac67cf96d6fd27c22aabc2cb2658e57ae87f65e9fe7675f0942',
        62132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e188bda7580dcc1ab6915b5fb16d6125d2f765979166be1883a24e71b3ca89dc',
        62052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedRose',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Red Rose font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Rose
  static TextTheme redRoseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redRose(textStyle: textTheme.displayLarge),
      displayMedium: redRose(textStyle: textTheme.displayMedium),
      displaySmall: redRose(textStyle: textTheme.displaySmall),
      headlineLarge: redRose(textStyle: textTheme.headlineLarge),
      headlineMedium: redRose(textStyle: textTheme.headlineMedium),
      headlineSmall: redRose(textStyle: textTheme.headlineSmall),
      titleLarge: redRose(textStyle: textTheme.titleLarge),
      titleMedium: redRose(textStyle: textTheme.titleMedium),
      titleSmall: redRose(textStyle: textTheme.titleSmall),
      bodyLarge: redRose(textStyle: textTheme.bodyLarge),
      bodyMedium: redRose(textStyle: textTheme.bodyMedium),
      bodySmall: redRose(textStyle: textTheme.bodySmall),
      labelLarge: redRose(textStyle: textTheme.labelLarge),
      labelMedium: redRose(textStyle: textTheme.labelMedium),
      labelSmall: redRose(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Redacted font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Redacted
  static TextStyle redacted({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '181d9572bd91a3e91087f45a2c8846a80bf92ec73cc0911e082031377e412d34',
        11404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Redacted',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Redacted font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Redacted
  static TextTheme redactedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redacted(textStyle: textTheme.displayLarge),
      displayMedium: redacted(textStyle: textTheme.displayMedium),
      displaySmall: redacted(textStyle: textTheme.displaySmall),
      headlineLarge: redacted(textStyle: textTheme.headlineLarge),
      headlineMedium: redacted(textStyle: textTheme.headlineMedium),
      headlineSmall: redacted(textStyle: textTheme.headlineSmall),
      titleLarge: redacted(textStyle: textTheme.titleLarge),
      titleMedium: redacted(textStyle: textTheme.titleMedium),
      titleSmall: redacted(textStyle: textTheme.titleSmall),
      bodyLarge: redacted(textStyle: textTheme.bodyLarge),
      bodyMedium: redacted(textStyle: textTheme.bodyMedium),
      bodySmall: redacted(textStyle: textTheme.bodySmall),
      labelLarge: redacted(textStyle: textTheme.labelLarge),
      labelMedium: redacted(textStyle: textTheme.labelMedium),
      labelSmall: redacted(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Redacted Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Redacted+Script
  static TextStyle redactedScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e7784827341a4a812e71d0aa01a7325fc0b8c1eef709d744657c17f7781c926',
        70708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd8a8e3c46fa17ed6e1ea768d109b1309bf6174c5a8e64e9bcdab61fcb47370c',
        70188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e7045615530585024ca8f4b1b4d1ddfa1b4191836087d820c27af41939d9842',
        68168,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedactedScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Redacted Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Redacted+Script
  static TextTheme redactedScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redactedScript(textStyle: textTheme.displayLarge),
      displayMedium: redactedScript(textStyle: textTheme.displayMedium),
      displaySmall: redactedScript(textStyle: textTheme.displaySmall),
      headlineLarge: redactedScript(textStyle: textTheme.headlineLarge),
      headlineMedium: redactedScript(textStyle: textTheme.headlineMedium),
      headlineSmall: redactedScript(textStyle: textTheme.headlineSmall),
      titleLarge: redactedScript(textStyle: textTheme.titleLarge),
      titleMedium: redactedScript(textStyle: textTheme.titleMedium),
      titleSmall: redactedScript(textStyle: textTheme.titleSmall),
      bodyLarge: redactedScript(textStyle: textTheme.bodyLarge),
      bodyMedium: redactedScript(textStyle: textTheme.bodyMedium),
      bodySmall: redactedScript(textStyle: textTheme.bodySmall),
      labelLarge: redactedScript(textStyle: textTheme.labelLarge),
      labelMedium: redactedScript(textStyle: textTheme.labelMedium),
      labelSmall: redactedScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Redressed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Redressed
  static TextStyle redressed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dcac3ad9bff550045d438a43282a4eb3a20ee265d660ff104f1a9f427dc5000e',
        64388,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Redressed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Redressed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Redressed
  static TextTheme redressedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redressed(textStyle: textTheme.displayLarge),
      displayMedium: redressed(textStyle: textTheme.displayMedium),
      displaySmall: redressed(textStyle: textTheme.displaySmall),
      headlineLarge: redressed(textStyle: textTheme.headlineLarge),
      headlineMedium: redressed(textStyle: textTheme.headlineMedium),
      headlineSmall: redressed(textStyle: textTheme.headlineSmall),
      titleLarge: redressed(textStyle: textTheme.titleLarge),
      titleMedium: redressed(textStyle: textTheme.titleMedium),
      titleSmall: redressed(textStyle: textTheme.titleSmall),
      bodyLarge: redressed(textStyle: textTheme.bodyLarge),
      bodyMedium: redressed(textStyle: textTheme.bodyMedium),
      bodySmall: redressed(textStyle: textTheme.bodySmall),
      labelLarge: redressed(textStyle: textTheme.labelLarge),
      labelMedium: redressed(textStyle: textTheme.labelMedium),
      labelSmall: redressed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reem Kufi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reem+Kufi
  static TextStyle reemKufi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '15507a42fe8d7be5c5f000e9f46a6fe00c0fd0966739ec01a1141590e9cbfff1',
        83008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93a0ecaf59594d3a375fe669d43f1db09f91dc573dc6b04563ce44cd39e31382',
        83144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2836a3962fd68e8a1ac1e8a3e969b75ebb9e2b1520c46441aeb93e7cb495225f',
        83180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46b72538b8b38d7afaf1e43a80aef4f5432e25c31b60808a0bc2b3f65af34a4e',
        82912,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ReemKufi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reem Kufi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reem+Kufi
  static TextTheme reemKufiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: reemKufi(textStyle: textTheme.displayLarge),
      displayMedium: reemKufi(textStyle: textTheme.displayMedium),
      displaySmall: reemKufi(textStyle: textTheme.displaySmall),
      headlineLarge: reemKufi(textStyle: textTheme.headlineLarge),
      headlineMedium: reemKufi(textStyle: textTheme.headlineMedium),
      headlineSmall: reemKufi(textStyle: textTheme.headlineSmall),
      titleLarge: reemKufi(textStyle: textTheme.titleLarge),
      titleMedium: reemKufi(textStyle: textTheme.titleMedium),
      titleSmall: reemKufi(textStyle: textTheme.titleSmall),
      bodyLarge: reemKufi(textStyle: textTheme.bodyLarge),
      bodyMedium: reemKufi(textStyle: textTheme.bodyMedium),
      bodySmall: reemKufi(textStyle: textTheme.bodySmall),
      labelLarge: reemKufi(textStyle: textTheme.labelLarge),
      labelMedium: reemKufi(textStyle: textTheme.labelMedium),
      labelSmall: reemKufi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reem Kufi Fun font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reem+Kufi+Fun
  static TextStyle reemKufiFun({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e41a7b66d21d31c96fae5c92413012f5095b315b654dea7cf12f898dacb9b64a',
        93284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f2c38eb5f04435c89a859e4066dae197b702b1a03f2f17621905675cc90ac618',
        93404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c430d0353d9ba16c242c257c157cff186361dcb724b5c4f184d0346418ae5b3d',
        93444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28f1225852aaf4e8d4c39aa2a843cbcc5c29c14ec231aa1ffc9bd90d6d1515ca',
        93184,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ReemKufiFun',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reem Kufi Fun font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reem+Kufi+Fun
  static TextTheme reemKufiFunTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: reemKufiFun(textStyle: textTheme.displayLarge),
      displayMedium: reemKufiFun(textStyle: textTheme.displayMedium),
      displaySmall: reemKufiFun(textStyle: textTheme.displaySmall),
      headlineLarge: reemKufiFun(textStyle: textTheme.headlineLarge),
      headlineMedium: reemKufiFun(textStyle: textTheme.headlineMedium),
      headlineSmall: reemKufiFun(textStyle: textTheme.headlineSmall),
      titleLarge: reemKufiFun(textStyle: textTheme.titleLarge),
      titleMedium: reemKufiFun(textStyle: textTheme.titleMedium),
      titleSmall: reemKufiFun(textStyle: textTheme.titleSmall),
      bodyLarge: reemKufiFun(textStyle: textTheme.bodyLarge),
      bodyMedium: reemKufiFun(textStyle: textTheme.bodyMedium),
      bodySmall: reemKufiFun(textStyle: textTheme.bodySmall),
      labelLarge: reemKufiFun(textStyle: textTheme.labelLarge),
      labelMedium: reemKufiFun(textStyle: textTheme.labelMedium),
      labelSmall: reemKufiFun(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reem Kufi Ink font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reem+Kufi+Ink
  static TextStyle reemKufiInk({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cb4fb620ee225e201cb8abf3a6edfa0836617a372e390956d059a8eb1553bcac',
        233828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ReemKufiInk',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reem Kufi Ink font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reem+Kufi+Ink
  static TextTheme reemKufiInkTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: reemKufiInk(textStyle: textTheme.displayLarge),
      displayMedium: reemKufiInk(textStyle: textTheme.displayMedium),
      displaySmall: reemKufiInk(textStyle: textTheme.displaySmall),
      headlineLarge: reemKufiInk(textStyle: textTheme.headlineLarge),
      headlineMedium: reemKufiInk(textStyle: textTheme.headlineMedium),
      headlineSmall: reemKufiInk(textStyle: textTheme.headlineSmall),
      titleLarge: reemKufiInk(textStyle: textTheme.titleLarge),
      titleMedium: reemKufiInk(textStyle: textTheme.titleMedium),
      titleSmall: reemKufiInk(textStyle: textTheme.titleSmall),
      bodyLarge: reemKufiInk(textStyle: textTheme.bodyLarge),
      bodyMedium: reemKufiInk(textStyle: textTheme.bodyMedium),
      bodySmall: reemKufiInk(textStyle: textTheme.bodySmall),
      labelLarge: reemKufiInk(textStyle: textTheme.labelLarge),
      labelMedium: reemKufiInk(textStyle: textTheme.labelMedium),
      labelSmall: reemKufiInk(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reenie Beanie font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reenie+Beanie
  static TextStyle reenieBeanie({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03a88319ca67ab7296033210507a7cea6f5cdb6b2c53958a9546934fdcaf5d29',
        74092,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ReenieBeanie',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reenie Beanie font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reenie+Beanie
  static TextTheme reenieBeanieTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: reenieBeanie(textStyle: textTheme.displayLarge),
      displayMedium: reenieBeanie(textStyle: textTheme.displayMedium),
      displaySmall: reenieBeanie(textStyle: textTheme.displaySmall),
      headlineLarge: reenieBeanie(textStyle: textTheme.headlineLarge),
      headlineMedium: reenieBeanie(textStyle: textTheme.headlineMedium),
      headlineSmall: reenieBeanie(textStyle: textTheme.headlineSmall),
      titleLarge: reenieBeanie(textStyle: textTheme.titleLarge),
      titleMedium: reenieBeanie(textStyle: textTheme.titleMedium),
      titleSmall: reenieBeanie(textStyle: textTheme.titleSmall),
      bodyLarge: reenieBeanie(textStyle: textTheme.bodyLarge),
      bodyMedium: reenieBeanie(textStyle: textTheme.bodyMedium),
      bodySmall: reenieBeanie(textStyle: textTheme.bodySmall),
      labelLarge: reenieBeanie(textStyle: textTheme.labelLarge),
      labelMedium: reenieBeanie(textStyle: textTheme.labelMedium),
      labelSmall: reenieBeanie(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reggae One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reggae+One
  static TextStyle reggaeOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02517b6ae44f0449c2e10bce7c730d395b316647a6a5f18fef2239b58029edcc',
        1967072,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ReggaeOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reggae One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reggae+One
  static TextTheme reggaeOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: reggaeOne(textStyle: textTheme.displayLarge),
      displayMedium: reggaeOne(textStyle: textTheme.displayMedium),
      displaySmall: reggaeOne(textStyle: textTheme.displaySmall),
      headlineLarge: reggaeOne(textStyle: textTheme.headlineLarge),
      headlineMedium: reggaeOne(textStyle: textTheme.headlineMedium),
      headlineSmall: reggaeOne(textStyle: textTheme.headlineSmall),
      titleLarge: reggaeOne(textStyle: textTheme.titleLarge),
      titleMedium: reggaeOne(textStyle: textTheme.titleMedium),
      titleSmall: reggaeOne(textStyle: textTheme.titleSmall),
      bodyLarge: reggaeOne(textStyle: textTheme.bodyLarge),
      bodyMedium: reggaeOne(textStyle: textTheme.bodyMedium),
      bodySmall: reggaeOne(textStyle: textTheme.bodySmall),
      labelLarge: reggaeOne(textStyle: textTheme.labelLarge),
      labelMedium: reggaeOne(textStyle: textTheme.labelMedium),
      labelSmall: reggaeOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Revalia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Revalia
  static TextStyle revalia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6913ffe382b2840e368ae186f438a8d34616ca662839b936acb9f85f19422bc',
        32240,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Revalia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Revalia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Revalia
  static TextTheme revaliaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: revalia(textStyle: textTheme.displayLarge),
      displayMedium: revalia(textStyle: textTheme.displayMedium),
      displaySmall: revalia(textStyle: textTheme.displaySmall),
      headlineLarge: revalia(textStyle: textTheme.headlineLarge),
      headlineMedium: revalia(textStyle: textTheme.headlineMedium),
      headlineSmall: revalia(textStyle: textTheme.headlineSmall),
      titleLarge: revalia(textStyle: textTheme.titleLarge),
      titleMedium: revalia(textStyle: textTheme.titleMedium),
      titleSmall: revalia(textStyle: textTheme.titleSmall),
      bodyLarge: revalia(textStyle: textTheme.bodyLarge),
      bodyMedium: revalia(textStyle: textTheme.bodyMedium),
      bodySmall: revalia(textStyle: textTheme.bodySmall),
      labelLarge: revalia(textStyle: textTheme.labelLarge),
      labelMedium: revalia(textStyle: textTheme.labelMedium),
      labelSmall: revalia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rhodium Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rhodium+Libre
  static TextStyle rhodiumLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8141e124491cb47820dd1b5f6ec1b32890a202f60c996db7d769a5287d1a34e',
        141492,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RhodiumLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rhodium Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rhodium+Libre
  static TextTheme rhodiumLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rhodiumLibre(textStyle: textTheme.displayLarge),
      displayMedium: rhodiumLibre(textStyle: textTheme.displayMedium),
      displaySmall: rhodiumLibre(textStyle: textTheme.displaySmall),
      headlineLarge: rhodiumLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: rhodiumLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: rhodiumLibre(textStyle: textTheme.headlineSmall),
      titleLarge: rhodiumLibre(textStyle: textTheme.titleLarge),
      titleMedium: rhodiumLibre(textStyle: textTheme.titleMedium),
      titleSmall: rhodiumLibre(textStyle: textTheme.titleSmall),
      bodyLarge: rhodiumLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: rhodiumLibre(textStyle: textTheme.bodyMedium),
      bodySmall: rhodiumLibre(textStyle: textTheme.bodySmall),
      labelLarge: rhodiumLibre(textStyle: textTheme.labelLarge),
      labelMedium: rhodiumLibre(textStyle: textTheme.labelMedium),
      labelSmall: rhodiumLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ribeye font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ribeye
  static TextStyle ribeye({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c828bd1f5213ab0a7470cb4b16b50c5c5da647bb41f9aed5cb6f04de7dbbd63b',
        75984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ribeye',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ribeye font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ribeye
  static TextTheme ribeyeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ribeye(textStyle: textTheme.displayLarge),
      displayMedium: ribeye(textStyle: textTheme.displayMedium),
      displaySmall: ribeye(textStyle: textTheme.displaySmall),
      headlineLarge: ribeye(textStyle: textTheme.headlineLarge),
      headlineMedium: ribeye(textStyle: textTheme.headlineMedium),
      headlineSmall: ribeye(textStyle: textTheme.headlineSmall),
      titleLarge: ribeye(textStyle: textTheme.titleLarge),
      titleMedium: ribeye(textStyle: textTheme.titleMedium),
      titleSmall: ribeye(textStyle: textTheme.titleSmall),
      bodyLarge: ribeye(textStyle: textTheme.bodyLarge),
      bodyMedium: ribeye(textStyle: textTheme.bodyMedium),
      bodySmall: ribeye(textStyle: textTheme.bodySmall),
      labelLarge: ribeye(textStyle: textTheme.labelLarge),
      labelMedium: ribeye(textStyle: textTheme.labelMedium),
      labelSmall: ribeye(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ribeye Marrow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ribeye+Marrow
  static TextStyle ribeyeMarrow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '337d7a1e2971cbd62bc80377bc5c68bbd22d303ca2fd111a110678d011fab8b0',
        73628,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RibeyeMarrow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ribeye Marrow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ribeye+Marrow
  static TextTheme ribeyeMarrowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ribeyeMarrow(textStyle: textTheme.displayLarge),
      displayMedium: ribeyeMarrow(textStyle: textTheme.displayMedium),
      displaySmall: ribeyeMarrow(textStyle: textTheme.displaySmall),
      headlineLarge: ribeyeMarrow(textStyle: textTheme.headlineLarge),
      headlineMedium: ribeyeMarrow(textStyle: textTheme.headlineMedium),
      headlineSmall: ribeyeMarrow(textStyle: textTheme.headlineSmall),
      titleLarge: ribeyeMarrow(textStyle: textTheme.titleLarge),
      titleMedium: ribeyeMarrow(textStyle: textTheme.titleMedium),
      titleSmall: ribeyeMarrow(textStyle: textTheme.titleSmall),
      bodyLarge: ribeyeMarrow(textStyle: textTheme.bodyLarge),
      bodyMedium: ribeyeMarrow(textStyle: textTheme.bodyMedium),
      bodySmall: ribeyeMarrow(textStyle: textTheme.bodySmall),
      labelLarge: ribeyeMarrow(textStyle: textTheme.labelLarge),
      labelMedium: ribeyeMarrow(textStyle: textTheme.labelMedium),
      labelSmall: ribeyeMarrow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Righteous font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Righteous
  static TextStyle righteous({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40569bf6a851892a48f3108cf90ab6573b3b3974a3578cfc221e25f868268ca2',
        38828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Righteous',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Righteous font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Righteous
  static TextTheme righteousTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: righteous(textStyle: textTheme.displayLarge),
      displayMedium: righteous(textStyle: textTheme.displayMedium),
      displaySmall: righteous(textStyle: textTheme.displaySmall),
      headlineLarge: righteous(textStyle: textTheme.headlineLarge),
      headlineMedium: righteous(textStyle: textTheme.headlineMedium),
      headlineSmall: righteous(textStyle: textTheme.headlineSmall),
      titleLarge: righteous(textStyle: textTheme.titleLarge),
      titleMedium: righteous(textStyle: textTheme.titleMedium),
      titleSmall: righteous(textStyle: textTheme.titleSmall),
      bodyLarge: righteous(textStyle: textTheme.bodyLarge),
      bodyMedium: righteous(textStyle: textTheme.bodyMedium),
      bodySmall: righteous(textStyle: textTheme.bodySmall),
      labelLarge: righteous(textStyle: textTheme.labelLarge),
      labelMedium: righteous(textStyle: textTheme.labelMedium),
      labelSmall: righteous(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Risque font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Risque
  static TextStyle risque({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e50df4434dbf73404d5e26334f71ac8959d1be599d98ea908dc8b585542f943',
        56472,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Risque',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Risque font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Risque
  static TextTheme risqueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: risque(textStyle: textTheme.displayLarge),
      displayMedium: risque(textStyle: textTheme.displayMedium),
      displaySmall: risque(textStyle: textTheme.displaySmall),
      headlineLarge: risque(textStyle: textTheme.headlineLarge),
      headlineMedium: risque(textStyle: textTheme.headlineMedium),
      headlineSmall: risque(textStyle: textTheme.headlineSmall),
      titleLarge: risque(textStyle: textTheme.titleLarge),
      titleMedium: risque(textStyle: textTheme.titleMedium),
      titleSmall: risque(textStyle: textTheme.titleSmall),
      bodyLarge: risque(textStyle: textTheme.bodyLarge),
      bodyMedium: risque(textStyle: textTheme.bodyMedium),
      bodySmall: risque(textStyle: textTheme.bodySmall),
      labelLarge: risque(textStyle: textTheme.labelLarge),
      labelMedium: risque(textStyle: textTheme.labelMedium),
      labelSmall: risque(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Road Rage font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Road+Rage
  static TextStyle roadRage({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e1fa5681ec36690c7fc65e4a74279998ff907d9b426e9d887f41001caf8ea17',
        425896,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RoadRage',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Road Rage font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Road+Rage
  static TextTheme roadRageTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: roadRage(textStyle: textTheme.displayLarge),
      displayMedium: roadRage(textStyle: textTheme.displayMedium),
      displaySmall: roadRage(textStyle: textTheme.displaySmall),
      headlineLarge: roadRage(textStyle: textTheme.headlineLarge),
      headlineMedium: roadRage(textStyle: textTheme.headlineMedium),
      headlineSmall: roadRage(textStyle: textTheme.headlineSmall),
      titleLarge: roadRage(textStyle: textTheme.titleLarge),
      titleMedium: roadRage(textStyle: textTheme.titleMedium),
      titleSmall: roadRage(textStyle: textTheme.titleSmall),
      bodyLarge: roadRage(textStyle: textTheme.bodyLarge),
      bodyMedium: roadRage(textStyle: textTheme.bodyMedium),
      bodySmall: roadRage(textStyle: textTheme.bodySmall),
      labelLarge: roadRage(textStyle: textTheme.labelLarge),
      labelMedium: roadRage(textStyle: textTheme.labelMedium),
      labelSmall: roadRage(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Roboto font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto
  static TextStyle roboto({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ef133d43418a8f7f3ff94acf0d988529de27cb6cb23930482ea51a550df693c5',
        82272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd2a7927713af0acbdc77ab152426a365a2eacd8d9c5af8037961cee2862e4719',
        87224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bbec9513a9c2e908ad0daf806d486b5d81670e0cb6e048d90c526c39c7226986',
        81704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f351e28c00d79a9aeb2372efa5626827f4e6a1b7401321dc578fe9917ac40a83',
        86944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1d7c5f4500eeb1a09e051781906c3642015a3f6c9b69046b905c8bf34c6ad60',
        81044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '02323a7160fcc356c056f7167dc9fdea07b9573ec2e8720914c6c2128be051f0',
        86224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec3a64e46e2ee5f546845582e1d5409107780cef55bc43b052ee962f9807aee6',
        82628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '18b1d7709525b550b77288cfa86d25c90744384cb3158eeafb24e61211beee59',
        87948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05b2d0935046846efe2c8786ad1c5d909a11c3431787eea52f2fc70f2a8a6edf',
        82928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ac35b475460fbf9d94b44ba54ee3d3e7e208c75705f4c6acb7781d0d94cdeb63',
        88076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1839e6182fe1be6a6f6ae74edaa1aa16d27b9787ff44aeef04baa0ba2404a9d',
        82956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4d7232f96ac551205759111c413af725e706eacab3477e429b72b66c74ecdf0a',
        88160,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Roboto',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Roboto font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto
  static TextTheme robotoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: roboto(textStyle: textTheme.displayLarge),
      displayMedium: roboto(textStyle: textTheme.displayMedium),
      displaySmall: roboto(textStyle: textTheme.displaySmall),
      headlineLarge: roboto(textStyle: textTheme.headlineLarge),
      headlineMedium: roboto(textStyle: textTheme.headlineMedium),
      headlineSmall: roboto(textStyle: textTheme.headlineSmall),
      titleLarge: roboto(textStyle: textTheme.titleLarge),
      titleMedium: roboto(textStyle: textTheme.titleMedium),
      titleSmall: roboto(textStyle: textTheme.titleSmall),
      bodyLarge: roboto(textStyle: textTheme.bodyLarge),
      bodyMedium: roboto(textStyle: textTheme.bodyMedium),
      bodySmall: roboto(textStyle: textTheme.bodySmall),
      labelLarge: roboto(textStyle: textTheme.labelLarge),
      labelMedium: roboto(textStyle: textTheme.labelMedium),
      labelSmall: roboto(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Roboto Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Condensed
  static TextStyle robotoCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f94c0ff2d341c4c6533e828199343c80668cb5728c0936d2f32823d55540686b',
        80904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5d3383a4476bc585ab3a2d122966fc3ac2156372f18f97749f5bf2caf55bf39f',
        86504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7580458a2610261a73df8676e738eb2640d45953d64b6ac206aa7fc591755538',
        80400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0cfb77c93d4ae6a534a1f4a50ea2be208c1821f62b53cf759febb79d0b0c7c56',
        85968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4828d8acdd8e41a0230d63f2359c5e243e9d2a3f36149c647f1e6aa3c9e64fe9',
        82280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6d54207482d2128d951b3ead9fcec3d75eeae3c7405952e364b41564a92d4832',
        87508,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RobotoCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Roboto Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Condensed
  static TextTheme robotoCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: robotoCondensed(textStyle: textTheme.displayLarge),
      displayMedium: robotoCondensed(textStyle: textTheme.displayMedium),
      displaySmall: robotoCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: robotoCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: robotoCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: robotoCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: robotoCondensed(textStyle: textTheme.titleLarge),
      titleMedium: robotoCondensed(textStyle: textTheme.titleMedium),
      titleSmall: robotoCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: robotoCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: robotoCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: robotoCondensed(textStyle: textTheme.bodySmall),
      labelLarge: robotoCondensed(textStyle: textTheme.labelLarge),
      labelMedium: robotoCondensed(textStyle: textTheme.labelMedium),
      labelSmall: robotoCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Roboto Flex font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Flex
  static TextStyle robotoFlex({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a9c2a586b937d52f01ee47cb4d33c8d560a0807967a6e2b65ed7d03ec43782b',
        109836,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RobotoFlex',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Roboto Flex font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Flex
  static TextTheme robotoFlexTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: robotoFlex(textStyle: textTheme.displayLarge),
      displayMedium: robotoFlex(textStyle: textTheme.displayMedium),
      displaySmall: robotoFlex(textStyle: textTheme.displaySmall),
      headlineLarge: robotoFlex(textStyle: textTheme.headlineLarge),
      headlineMedium: robotoFlex(textStyle: textTheme.headlineMedium),
      headlineSmall: robotoFlex(textStyle: textTheme.headlineSmall),
      titleLarge: robotoFlex(textStyle: textTheme.titleLarge),
      titleMedium: robotoFlex(textStyle: textTheme.titleMedium),
      titleSmall: robotoFlex(textStyle: textTheme.titleSmall),
      bodyLarge: robotoFlex(textStyle: textTheme.bodyLarge),
      bodyMedium: robotoFlex(textStyle: textTheme.bodyMedium),
      bodySmall: robotoFlex(textStyle: textTheme.bodySmall),
      labelLarge: robotoFlex(textStyle: textTheme.labelLarge),
      labelMedium: robotoFlex(textStyle: textTheme.labelMedium),
      labelSmall: robotoFlex(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Roboto Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Mono
  static TextStyle robotoMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f047fa51322d92d4d9c9e48ef88451169c44080203b15a2465cc597d12cd55a4',
        79960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d3ad626fcc3d0231d74b70b54e5398f30e29545dc0af8b5e44ab6da5a9e9245',
        79876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d804343851f927a78e9af4007fca4a299988035b8cb9487a0bfc6c39cbd2728',
        79680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a2542a94e3d0aad0964930b21a56f151752d3d54b6f1dfdc3cfa5f55032715d8',
        78972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '740b306cdb4b73cc1a4388c853c13ac72b44ac5c32a35c083685abc2eac5caed',
        78924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd25f50c005434a6c4f13993054a84f2837266938868b11aa652069b2025b4c4a',
        79164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60cdc9d3853d6c78cae6cad2bf9bbb8cdab3c335b0beeb9624ba4b83d7d3ec7e',
        79112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '643a7ae06ac509a905c6f462447774ee43701b2820776955228ced2154129bae',
        84892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7e7f80eaacc95d55f5462a6b67bdca6b5f017bbad5adc7e49244a7957f106ed0',
        85228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3d74298ad48d333e5016b5309241fafc0b2585fae6cffa30f76f9c6a0ebe61f8',
        85560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'faabd0bf11fd9eeeb8adce842a6d1da8bd0ae9ecf70984b8758994543423ee48',
        85680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2dc402aa9fb74da8e0614789116fd7fab05cb2312b08aa51af02b5293937e68a',
        85732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '32793be71a98bcabde639be6c87af8225aedea9dfa5b9e9c14c732e73c33abc8',
        85732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '463ceca2ced7fe3215fe9ce1451cbf92fd55a14aca660b33cd1fb1441a77d817',
        85908,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RobotoMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Roboto Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Mono
  static TextTheme robotoMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: robotoMono(textStyle: textTheme.displayLarge),
      displayMedium: robotoMono(textStyle: textTheme.displayMedium),
      displaySmall: robotoMono(textStyle: textTheme.displaySmall),
      headlineLarge: robotoMono(textStyle: textTheme.headlineLarge),
      headlineMedium: robotoMono(textStyle: textTheme.headlineMedium),
      headlineSmall: robotoMono(textStyle: textTheme.headlineSmall),
      titleLarge: robotoMono(textStyle: textTheme.titleLarge),
      titleMedium: robotoMono(textStyle: textTheme.titleMedium),
      titleSmall: robotoMono(textStyle: textTheme.titleSmall),
      bodyLarge: robotoMono(textStyle: textTheme.bodyLarge),
      bodyMedium: robotoMono(textStyle: textTheme.bodyMedium),
      bodySmall: robotoMono(textStyle: textTheme.bodySmall),
      labelLarge: robotoMono(textStyle: textTheme.labelLarge),
      labelMedium: robotoMono(textStyle: textTheme.labelMedium),
      labelSmall: robotoMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Roboto Serif font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Serif
  static TextStyle robotoSerif({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2e2cf3ffd3d81cbf08a033c97c8deb37be639d761e285beb4e7b45e6027b861',
        215352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '97cd6e8fc29891932cb635632c959d60c91b8175a501bcb868d43dfe1cf75ae1',
        215584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4fa36908daa0094bdfb5caf5e1a90e36906ebcd0d477288bdf7c1f3a56a35ab',
        215600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69021861aa51e4e568f4018fbeb92955b63c9333bc20e9d51a0e8a6e8b0e6eac',
        215648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a56c48dccc823c4268ca8ac1a84e29c11963759f6ffef7d0cdde9b81d9afa9b',
        216028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bf6132ef1170917cd69c5c78a7e1e90687395c98c53f14584c3d72c2ad128430',
        216056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6b9347e365c57ae79fee47b058a3fbf35af9796d92cc8d4793b0de4d3a0d450',
        216100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ead326923215959a53ba13206bf2536e1674fe82cab40f4d897f6f83d2d7f57',
        216192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '21c4ab92088db8b86a40f6b23f4c241d825cde6f6041216f1acf16cab263f345',
        216144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ab610e6fa570a097e91e8e2ba3d7ebc960593a5c72c27ca84acacd75d6112fc4',
        220092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2a623a13d833f9afd4497f3944ad4dbe34135b9edeb03544af3f25d7a968e59a',
        221052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c441d489398491c43e293fc4f3b6e8554b9a3906a4834377ca496bc701d2a029',
        221044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a9fcb5f638e1316794a3396ff440440609a77bc187848f6ba7763dd78626abbd',
        220952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '622e1e61a788d30a752f69bf784764153236ee810b7f7af3afedadb6678d970e',
        221664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e35463558f701e8eef05c68cd9565d0ac15f030bc2a4db486ca1a656b683f1d1',
        221768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cacc545a15a73e6b4ee8981dcb95c6ce6d4d4e358c9f9946ca8f5b4534c78d11',
        221668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ec05008dd4c1c2d3ffa451c90a36610d76456d9ea5abdb0ab16d035dc4b8f877',
        221860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '97f7abff9df24acce90c57a399bbb39bcf542f55236da352b6ed2d0f934949fc',
        220208,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RobotoSerif',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Roboto Serif font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Serif
  static TextTheme robotoSerifTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: robotoSerif(textStyle: textTheme.displayLarge),
      displayMedium: robotoSerif(textStyle: textTheme.displayMedium),
      displaySmall: robotoSerif(textStyle: textTheme.displaySmall),
      headlineLarge: robotoSerif(textStyle: textTheme.headlineLarge),
      headlineMedium: robotoSerif(textStyle: textTheme.headlineMedium),
      headlineSmall: robotoSerif(textStyle: textTheme.headlineSmall),
      titleLarge: robotoSerif(textStyle: textTheme.titleLarge),
      titleMedium: robotoSerif(textStyle: textTheme.titleMedium),
      titleSmall: robotoSerif(textStyle: textTheme.titleSmall),
      bodyLarge: robotoSerif(textStyle: textTheme.bodyLarge),
      bodyMedium: robotoSerif(textStyle: textTheme.bodyMedium),
      bodySmall: robotoSerif(textStyle: textTheme.bodySmall),
      labelLarge: robotoSerif(textStyle: textTheme.labelLarge),
      labelMedium: robotoSerif(textStyle: textTheme.labelMedium),
      labelSmall: robotoSerif(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Roboto Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Slab
  static TextStyle robotoSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc1ba976fc5d0484a2a093c6205a1b25c5ec98222c33ab6edd343a3d0cba7474',
        100912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7476319c07fa84a5625150a779b8dedb013352edfe7d9175ecf7e0fe6f55d925',
        101920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5dade0064c3557e2d27e56eefe5de5c6a7f64922586f56764bb3eab10ed57596',
        101896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b81ee8e2f9805c313667644c9faa1697e31f12c97762181cc1bcd19c7906a39c',
        101568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d024d73b55f36d3ca34f3761c941754c4a08a1c7d7fd7b8565d8d890698ed16',
        102264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b2a952603cf1abb5756b7439b277376ad5f9d6f20b0273f8b62d21a3ca0b0fd',
        102388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce46cc5453fd06ef0e593e6e0cd5743c1f4df6da385b348b8d26a98d1eb7572b',
        102244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d7c23f9eea2b0cf64cd30a7849dd7cf53cad40e38ea836b7a43b73e984dec5a',
        102432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2080b30e14474cb0f3f732182f63a77d596f0f9cd44ef091443f58628cc87664',
        102504,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RobotoSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Roboto Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Slab
  static TextTheme robotoSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: robotoSlab(textStyle: textTheme.displayLarge),
      displayMedium: robotoSlab(textStyle: textTheme.displayMedium),
      displaySmall: robotoSlab(textStyle: textTheme.displaySmall),
      headlineLarge: robotoSlab(textStyle: textTheme.headlineLarge),
      headlineMedium: robotoSlab(textStyle: textTheme.headlineMedium),
      headlineSmall: robotoSlab(textStyle: textTheme.headlineSmall),
      titleLarge: robotoSlab(textStyle: textTheme.titleLarge),
      titleMedium: robotoSlab(textStyle: textTheme.titleMedium),
      titleSmall: robotoSlab(textStyle: textTheme.titleSmall),
      bodyLarge: robotoSlab(textStyle: textTheme.bodyLarge),
      bodyMedium: robotoSlab(textStyle: textTheme.bodyMedium),
      bodySmall: robotoSlab(textStyle: textTheme.bodySmall),
      labelLarge: robotoSlab(textStyle: textTheme.labelLarge),
      labelMedium: robotoSlab(textStyle: textTheme.labelMedium),
      labelSmall: robotoSlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rochester font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rochester
  static TextStyle rochester({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '809cdfa7b0c9ea45e05fdc97f3c6eae321187df5bdb3e31aacec8e2fe113cfc8',
        35504,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rochester',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rochester font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rochester
  static TextTheme rochesterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rochester(textStyle: textTheme.displayLarge),
      displayMedium: rochester(textStyle: textTheme.displayMedium),
      displaySmall: rochester(textStyle: textTheme.displaySmall),
      headlineLarge: rochester(textStyle: textTheme.headlineLarge),
      headlineMedium: rochester(textStyle: textTheme.headlineMedium),
      headlineSmall: rochester(textStyle: textTheme.headlineSmall),
      titleLarge: rochester(textStyle: textTheme.titleLarge),
      titleMedium: rochester(textStyle: textTheme.titleMedium),
      titleSmall: rochester(textStyle: textTheme.titleSmall),
      bodyLarge: rochester(textStyle: textTheme.bodyLarge),
      bodyMedium: rochester(textStyle: textTheme.bodyMedium),
      bodySmall: rochester(textStyle: textTheme.bodySmall),
      labelLarge: rochester(textStyle: textTheme.labelLarge),
      labelMedium: rochester(textStyle: textTheme.labelMedium),
      labelSmall: rochester(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rock 3D font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rock+3D
  static TextStyle rock3d({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '257929ed9f965f1453c094a5a17977ff0a4c6330b00c29c890d256f80b67c24b',
        443884,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rock3D',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rock 3D font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rock+3D
  static TextTheme rock3dTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rock3d(textStyle: textTheme.displayLarge),
      displayMedium: rock3d(textStyle: textTheme.displayMedium),
      displaySmall: rock3d(textStyle: textTheme.displaySmall),
      headlineLarge: rock3d(textStyle: textTheme.headlineLarge),
      headlineMedium: rock3d(textStyle: textTheme.headlineMedium),
      headlineSmall: rock3d(textStyle: textTheme.headlineSmall),
      titleLarge: rock3d(textStyle: textTheme.titleLarge),
      titleMedium: rock3d(textStyle: textTheme.titleMedium),
      titleSmall: rock3d(textStyle: textTheme.titleSmall),
      bodyLarge: rock3d(textStyle: textTheme.bodyLarge),
      bodyMedium: rock3d(textStyle: textTheme.bodyMedium),
      bodySmall: rock3d(textStyle: textTheme.bodySmall),
      labelLarge: rock3d(textStyle: textTheme.labelLarge),
      labelMedium: rock3d(textStyle: textTheme.labelMedium),
      labelSmall: rock3d(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rock Salt font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rock+Salt
  static TextStyle rockSalt({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e396fb1212e462672f50c76ad6efb72862fc49db710720edc57a273147151aaa',
        103688,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RockSalt',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rock Salt font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rock+Salt
  static TextTheme rockSaltTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rockSalt(textStyle: textTheme.displayLarge),
      displayMedium: rockSalt(textStyle: textTheme.displayMedium),
      displaySmall: rockSalt(textStyle: textTheme.displaySmall),
      headlineLarge: rockSalt(textStyle: textTheme.headlineLarge),
      headlineMedium: rockSalt(textStyle: textTheme.headlineMedium),
      headlineSmall: rockSalt(textStyle: textTheme.headlineSmall),
      titleLarge: rockSalt(textStyle: textTheme.titleLarge),
      titleMedium: rockSalt(textStyle: textTheme.titleMedium),
      titleSmall: rockSalt(textStyle: textTheme.titleSmall),
      bodyLarge: rockSalt(textStyle: textTheme.bodyLarge),
      bodyMedium: rockSalt(textStyle: textTheme.bodyMedium),
      bodySmall: rockSalt(textStyle: textTheme.bodySmall),
      labelLarge: rockSalt(textStyle: textTheme.labelLarge),
      labelMedium: rockSalt(textStyle: textTheme.labelMedium),
      labelSmall: rockSalt(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the RocknRoll One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/RocknRoll+One
  static TextStyle rocknRollOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4438510a00a1b616f7fa3eb24c641378f59d70240ae08e2613a7537dec7199e7',
        2463076,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RocknRollOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the RocknRoll One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/RocknRoll+One
  static TextTheme rocknRollOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rocknRollOne(textStyle: textTheme.displayLarge),
      displayMedium: rocknRollOne(textStyle: textTheme.displayMedium),
      displaySmall: rocknRollOne(textStyle: textTheme.displaySmall),
      headlineLarge: rocknRollOne(textStyle: textTheme.headlineLarge),
      headlineMedium: rocknRollOne(textStyle: textTheme.headlineMedium),
      headlineSmall: rocknRollOne(textStyle: textTheme.headlineSmall),
      titleLarge: rocknRollOne(textStyle: textTheme.titleLarge),
      titleMedium: rocknRollOne(textStyle: textTheme.titleMedium),
      titleSmall: rocknRollOne(textStyle: textTheme.titleSmall),
      bodyLarge: rocknRollOne(textStyle: textTheme.bodyLarge),
      bodyMedium: rocknRollOne(textStyle: textTheme.bodyMedium),
      bodySmall: rocknRollOne(textStyle: textTheme.bodySmall),
      labelLarge: rocknRollOne(textStyle: textTheme.labelLarge),
      labelMedium: rocknRollOne(textStyle: textTheme.labelMedium),
      labelSmall: rocknRollOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rokkitt font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rokkitt
  static TextStyle rokkitt({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a141804c9ba42ba3bacca29d245d1d5744a80d164722026b57765b68130e95d0',
        68480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '499fa815eb6692b21301706a6e2681ee16ce68681e0cd62747f92aa0b65d697b',
        68668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd63ee870e492d78c9d8ecf89e879cbfeba5f0d04e15e30d825273dc316dd6994',
        68704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b3871a1da9022fd88c178fb46309f344464e64dae030115950737830937e4ea',
        68644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9cc3b5a89df1ef73e9453ce7461b66467bfa51c8340f6b03e5919e3295ed4aae',
        68620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed971d1478387568d94ecde369e2260a2c833fb45d49c4d51057a78a9888f34f',
        69124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'abf6f746a8c6d164b9e9b5fb3d342991fc0764bb1f173c222954dab21426c24f',
        69092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6dc7f2353cd254f7c3089702a61cec0b7dc1c02fc6fa57f9bc5d5fa7e9e538e1',
        69172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8da8d96b154b2857b323822a29b8a01065a93889d9bcb595d595206fa0bb60b3',
        68844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2f417e22d9fdf622d8cd12e2639c433e866949d23fba87fa6afedcda9114eb87',
        69812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3b38f5ceebd1cbdf256c759547454665625f10ee5ece4608f7fd9319bccb783e',
        70060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a7ec778d131e5ea97e013ea6d32a29546e216b3be30cbc86e8ab6919f2d6a836',
        70064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '04ada1396bba9789f6d068cdf3dc33b0f9a4a4cc1581495f6a4868c3ca2daf78',
        69884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c183c221f7b5148448b0ba65f7f3558f0477ade84fa0ed980ff1f52ec6f54ccb',
        69972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '24c2616e906ccca2f46ec87944e574f070bbffc619734dfc8b4277e03ddbc1d6',
        70240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8426e9f8aeae1e595c3dc8377d4780be32babaddffe80cb6547eb5e507284f4c',
        70160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4eea94355a617e3e26758b77d3457db345bc29557d0b61ba598cf9d1f601ebc5',
        70260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f4ef17d7b0f58e8f17352058edf7446d2f76f2ed8c64cde3924945dd92200901',
        70096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rokkitt',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rokkitt font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rokkitt
  static TextTheme rokkittTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rokkitt(textStyle: textTheme.displayLarge),
      displayMedium: rokkitt(textStyle: textTheme.displayMedium),
      displaySmall: rokkitt(textStyle: textTheme.displaySmall),
      headlineLarge: rokkitt(textStyle: textTheme.headlineLarge),
      headlineMedium: rokkitt(textStyle: textTheme.headlineMedium),
      headlineSmall: rokkitt(textStyle: textTheme.headlineSmall),
      titleLarge: rokkitt(textStyle: textTheme.titleLarge),
      titleMedium: rokkitt(textStyle: textTheme.titleMedium),
      titleSmall: rokkitt(textStyle: textTheme.titleSmall),
      bodyLarge: rokkitt(textStyle: textTheme.bodyLarge),
      bodyMedium: rokkitt(textStyle: textTheme.bodyMedium),
      bodySmall: rokkitt(textStyle: textTheme.bodySmall),
      labelLarge: rokkitt(textStyle: textTheme.labelLarge),
      labelMedium: rokkitt(textStyle: textTheme.labelMedium),
      labelSmall: rokkitt(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Romanesco font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Romanesco
  static TextStyle romanesco({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51cf475bd5f0d3bca83e619f8d8b0a01713278046bc338656b09a991d21d85e5',
        49464,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Romanesco',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Romanesco font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Romanesco
  static TextTheme romanescoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: romanesco(textStyle: textTheme.displayLarge),
      displayMedium: romanesco(textStyle: textTheme.displayMedium),
      displaySmall: romanesco(textStyle: textTheme.displaySmall),
      headlineLarge: romanesco(textStyle: textTheme.headlineLarge),
      headlineMedium: romanesco(textStyle: textTheme.headlineMedium),
      headlineSmall: romanesco(textStyle: textTheme.headlineSmall),
      titleLarge: romanesco(textStyle: textTheme.titleLarge),
      titleMedium: romanesco(textStyle: textTheme.titleMedium),
      titleSmall: romanesco(textStyle: textTheme.titleSmall),
      bodyLarge: romanesco(textStyle: textTheme.bodyLarge),
      bodyMedium: romanesco(textStyle: textTheme.bodyMedium),
      bodySmall: romanesco(textStyle: textTheme.bodySmall),
      labelLarge: romanesco(textStyle: textTheme.labelLarge),
      labelMedium: romanesco(textStyle: textTheme.labelMedium),
      labelSmall: romanesco(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ropa Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ropa+Sans
  static TextStyle ropaSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7447bcf763f63367b00ad78056e47d4e249957010495be3af2c6b441d216f119',
        36216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f20e8ccf3c3940aa615a0e83d84e9fb8fa82ac6ab399be628da543281d61725b',
        39000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RopaSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ropa Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ropa+Sans
  static TextTheme ropaSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ropaSans(textStyle: textTheme.displayLarge),
      displayMedium: ropaSans(textStyle: textTheme.displayMedium),
      displaySmall: ropaSans(textStyle: textTheme.displaySmall),
      headlineLarge: ropaSans(textStyle: textTheme.headlineLarge),
      headlineMedium: ropaSans(textStyle: textTheme.headlineMedium),
      headlineSmall: ropaSans(textStyle: textTheme.headlineSmall),
      titleLarge: ropaSans(textStyle: textTheme.titleLarge),
      titleMedium: ropaSans(textStyle: textTheme.titleMedium),
      titleSmall: ropaSans(textStyle: textTheme.titleSmall),
      bodyLarge: ropaSans(textStyle: textTheme.bodyLarge),
      bodyMedium: ropaSans(textStyle: textTheme.bodyMedium),
      bodySmall: ropaSans(textStyle: textTheme.bodySmall),
      labelLarge: ropaSans(textStyle: textTheme.labelLarge),
      labelMedium: ropaSans(textStyle: textTheme.labelMedium),
      labelSmall: ropaSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rosario font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rosario
  static TextStyle rosario({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2bfb456f16e63ed0f5f6ee1f3d0f7bb5daa07805e506fa3c09ceb46a2f4e4fbd',
        72908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55beb6c3ffe2617b27bc64f13a919f30d4cca04294d29a7b3e474708aa016623',
        73144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9bebee7de2ae7c9d3da09acd2d39f851343b0cf211c063cd3a35eceb20f51ed',
        73228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cfe0469ab4d7c9308be727a2e18e44e8f0fd93a371088c47406eba02c659900',
        73152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '489162b219a48715c2845edac6e0393959d5ed5f99ca87cb3187e0c10a39b797',
        70964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4acc1b268c60ccbf26e080573556752cd903bd4dfb622f198fdd65c068a046d6',
        71472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c851d42c43231c83e4d879332fbd55d9f39f962a189754e14451a3246b9c9001',
        71336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ebcf9ad33497c7843f37d1213aeea31195cb6dc4c189f630f7550bc797e8f9e3',
        71508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '82a5ff33aecbdc48e6d905cae10510ee93cc453905095daee50ee2c6495b9632',
        71556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3ca97411b8cf5bddb170e9fd43a23b5783a00657fab65df5e4a3588df683a52c',
        71160,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rosario',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rosario font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rosario
  static TextTheme rosarioTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rosario(textStyle: textTheme.displayLarge),
      displayMedium: rosario(textStyle: textTheme.displayMedium),
      displaySmall: rosario(textStyle: textTheme.displaySmall),
      headlineLarge: rosario(textStyle: textTheme.headlineLarge),
      headlineMedium: rosario(textStyle: textTheme.headlineMedium),
      headlineSmall: rosario(textStyle: textTheme.headlineSmall),
      titleLarge: rosario(textStyle: textTheme.titleLarge),
      titleMedium: rosario(textStyle: textTheme.titleMedium),
      titleSmall: rosario(textStyle: textTheme.titleSmall),
      bodyLarge: rosario(textStyle: textTheme.bodyLarge),
      bodyMedium: rosario(textStyle: textTheme.bodyMedium),
      bodySmall: rosario(textStyle: textTheme.bodySmall),
      labelLarge: rosario(textStyle: textTheme.labelLarge),
      labelMedium: rosario(textStyle: textTheme.labelMedium),
      labelSmall: rosario(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rosarivo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rosarivo
  static TextStyle rosarivo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6dc1d7c2af32069889e6508773856318819c5e30b77cb4170fc4473aa0a7828',
        39448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '45d9f8625f2f385eb227a40b5a24007951e8401774a6d9b990ef24502412e60a',
        37444,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rosarivo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rosarivo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rosarivo
  static TextTheme rosarivoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rosarivo(textStyle: textTheme.displayLarge),
      displayMedium: rosarivo(textStyle: textTheme.displayMedium),
      displaySmall: rosarivo(textStyle: textTheme.displaySmall),
      headlineLarge: rosarivo(textStyle: textTheme.headlineLarge),
      headlineMedium: rosarivo(textStyle: textTheme.headlineMedium),
      headlineSmall: rosarivo(textStyle: textTheme.headlineSmall),
      titleLarge: rosarivo(textStyle: textTheme.titleLarge),
      titleMedium: rosarivo(textStyle: textTheme.titleMedium),
      titleSmall: rosarivo(textStyle: textTheme.titleSmall),
      bodyLarge: rosarivo(textStyle: textTheme.bodyLarge),
      bodyMedium: rosarivo(textStyle: textTheme.bodyMedium),
      bodySmall: rosarivo(textStyle: textTheme.bodySmall),
      labelLarge: rosarivo(textStyle: textTheme.labelLarge),
      labelMedium: rosarivo(textStyle: textTheme.labelMedium),
      labelSmall: rosarivo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rouge Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rouge+Script
  static TextStyle rougeScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ca8ace28ef95357bf51311d130cb35ba6aacf16846f657d7e5a53424714eccdd',
        45028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RougeScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rouge Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rouge+Script
  static TextTheme rougeScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rougeScript(textStyle: textTheme.displayLarge),
      displayMedium: rougeScript(textStyle: textTheme.displayMedium),
      displaySmall: rougeScript(textStyle: textTheme.displaySmall),
      headlineLarge: rougeScript(textStyle: textTheme.headlineLarge),
      headlineMedium: rougeScript(textStyle: textTheme.headlineMedium),
      headlineSmall: rougeScript(textStyle: textTheme.headlineSmall),
      titleLarge: rougeScript(textStyle: textTheme.titleLarge),
      titleMedium: rougeScript(textStyle: textTheme.titleMedium),
      titleSmall: rougeScript(textStyle: textTheme.titleSmall),
      bodyLarge: rougeScript(textStyle: textTheme.bodyLarge),
      bodyMedium: rougeScript(textStyle: textTheme.bodyMedium),
      bodySmall: rougeScript(textStyle: textTheme.bodySmall),
      labelLarge: rougeScript(textStyle: textTheme.labelLarge),
      labelMedium: rougeScript(textStyle: textTheme.labelMedium),
      labelSmall: rougeScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rowdies font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rowdies
  static TextStyle rowdies({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '94e80a79987dc227d8e37111629725d1631d5c29df43fc61a7bf1bf3ef618710',
        50672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82cb14b5f4880f3fc710bf7bec932930d482ecd38736eba5c6c76b5179a6a129',
        50388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cfb7468910a71cefbb498fe38fa3bb548aef73c2881fdbc6577ffbc46f2997bc',
        50324,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rowdies',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rowdies font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rowdies
  static TextTheme rowdiesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rowdies(textStyle: textTheme.displayLarge),
      displayMedium: rowdies(textStyle: textTheme.displayMedium),
      displaySmall: rowdies(textStyle: textTheme.displaySmall),
      headlineLarge: rowdies(textStyle: textTheme.headlineLarge),
      headlineMedium: rowdies(textStyle: textTheme.headlineMedium),
      headlineSmall: rowdies(textStyle: textTheme.headlineSmall),
      titleLarge: rowdies(textStyle: textTheme.titleLarge),
      titleMedium: rowdies(textStyle: textTheme.titleMedium),
      titleSmall: rowdies(textStyle: textTheme.titleSmall),
      bodyLarge: rowdies(textStyle: textTheme.bodyLarge),
      bodyMedium: rowdies(textStyle: textTheme.bodyMedium),
      bodySmall: rowdies(textStyle: textTheme.bodySmall),
      labelLarge: rowdies(textStyle: textTheme.labelLarge),
      labelMedium: rowdies(textStyle: textTheme.labelMedium),
      labelSmall: rowdies(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rozha One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rozha+One
  static TextStyle rozhaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd8b564a2294dd0a0864362778ed014526075e307adbec370e860ff6ef7baa846',
        187760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RozhaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rozha One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rozha+One
  static TextTheme rozhaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rozhaOne(textStyle: textTheme.displayLarge),
      displayMedium: rozhaOne(textStyle: textTheme.displayMedium),
      displaySmall: rozhaOne(textStyle: textTheme.displaySmall),
      headlineLarge: rozhaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: rozhaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: rozhaOne(textStyle: textTheme.headlineSmall),
      titleLarge: rozhaOne(textStyle: textTheme.titleLarge),
      titleMedium: rozhaOne(textStyle: textTheme.titleMedium),
      titleSmall: rozhaOne(textStyle: textTheme.titleSmall),
      bodyLarge: rozhaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: rozhaOne(textStyle: textTheme.bodyMedium),
      bodySmall: rozhaOne(textStyle: textTheme.bodySmall),
      labelLarge: rozhaOne(textStyle: textTheme.labelLarge),
      labelMedium: rozhaOne(textStyle: textTheme.labelMedium),
      labelSmall: rozhaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik
  static TextStyle rubik({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82d91bde3707f47d5a45bd3363bf22d57699bb0dfd0caeeb1579b56b26f42ea7',
        174128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '588e33f0e1e07d1853b33b2a610ba613a4d096edfe06e45f31a785ce315d9234',
        174968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f341ec62d7f8662cb57c4d637699f8bd012b4d692be97112640d003eb4c6063',
        175572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '513fd3927d7b4ed8b65d75159743aa77d93c9a14777848d99da607defe2913df',
        175576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e02f783fd3c8e13818d1c3f276c7108a2feb35ee086b478092833f5ccafb5bb',
        175604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1aca64f1e87e2319783c7572ac8664212508aa65404b31a7cb051d534e67b636',
        175500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80e707a3a8d26d7ae3d4e0560c25089e7385066132a34d638cc9b77e35ae690b',
        175172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ab4e304a7169529c6348d55fa50234807144dfbdc96ed3cba179f597a35b5412',
        172544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd8ef973f3fb7d491e801cf05d9adb9a468bbacc19173b03e19463958d413a775',
        173124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7413b40f011cd947609a6e0764a8a09ba4dd20c5470862909e14a93281698c1a',
        173868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd363acbc92f7b0c997b01208ac3fbfcd80934494f3474fef4ed6c7c35700fb2d',
        173996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '168be2ed8556f674539dcd4326501538d5de3fb49a24190520f3da5f7a8dd202',
        173944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e8fbf087b7c73f65c884eae9330e52900e5ded3dd8eb306242ea8e05e9af83de',
        174084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6e91e39e0cd5a223a73d447cf2d34a74018c586568d85816d7afbfddc4e5c562',
        173740,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rubik',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik
  static TextTheme rubikTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubik(textStyle: textTheme.displayLarge),
      displayMedium: rubik(textStyle: textTheme.displayMedium),
      displaySmall: rubik(textStyle: textTheme.displaySmall),
      headlineLarge: rubik(textStyle: textTheme.headlineLarge),
      headlineMedium: rubik(textStyle: textTheme.headlineMedium),
      headlineSmall: rubik(textStyle: textTheme.headlineSmall),
      titleLarge: rubik(textStyle: textTheme.titleLarge),
      titleMedium: rubik(textStyle: textTheme.titleMedium),
      titleSmall: rubik(textStyle: textTheme.titleSmall),
      bodyLarge: rubik(textStyle: textTheme.bodyLarge),
      bodyMedium: rubik(textStyle: textTheme.bodyMedium),
      bodySmall: rubik(textStyle: textTheme.bodySmall),
      labelLarge: rubik(textStyle: textTheme.labelLarge),
      labelMedium: rubik(textStyle: textTheme.labelMedium),
      labelSmall: rubik(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik 80s Fade font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+80s+Fade
  static TextStyle rubik80sFade({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bfc4a936e506f6df6ef9463fe886f610c6ee30cf359672df886a139c82215d56',
        3300676,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rubik80sFade',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik 80s Fade font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+80s+Fade
  static TextTheme rubik80sFadeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubik80sFade(textStyle: textTheme.displayLarge),
      displayMedium: rubik80sFade(textStyle: textTheme.displayMedium),
      displaySmall: rubik80sFade(textStyle: textTheme.displaySmall),
      headlineLarge: rubik80sFade(textStyle: textTheme.headlineLarge),
      headlineMedium: rubik80sFade(textStyle: textTheme.headlineMedium),
      headlineSmall: rubik80sFade(textStyle: textTheme.headlineSmall),
      titleLarge: rubik80sFade(textStyle: textTheme.titleLarge),
      titleMedium: rubik80sFade(textStyle: textTheme.titleMedium),
      titleSmall: rubik80sFade(textStyle: textTheme.titleSmall),
      bodyLarge: rubik80sFade(textStyle: textTheme.bodyLarge),
      bodyMedium: rubik80sFade(textStyle: textTheme.bodyMedium),
      bodySmall: rubik80sFade(textStyle: textTheme.bodySmall),
      labelLarge: rubik80sFade(textStyle: textTheme.labelLarge),
      labelMedium: rubik80sFade(textStyle: textTheme.labelMedium),
      labelSmall: rubik80sFade(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Beastly font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Beastly
  static TextStyle rubikBeastly({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a72ae3f6cf91fe781a049aaa8a201fbf5e073a297b34776cbc3d3c210692b886',
        486848,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikBeastly',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Beastly font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Beastly
  static TextTheme rubikBeastlyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikBeastly(textStyle: textTheme.displayLarge),
      displayMedium: rubikBeastly(textStyle: textTheme.displayMedium),
      displaySmall: rubikBeastly(textStyle: textTheme.displaySmall),
      headlineLarge: rubikBeastly(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikBeastly(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikBeastly(textStyle: textTheme.headlineSmall),
      titleLarge: rubikBeastly(textStyle: textTheme.titleLarge),
      titleMedium: rubikBeastly(textStyle: textTheme.titleMedium),
      titleSmall: rubikBeastly(textStyle: textTheme.titleSmall),
      bodyLarge: rubikBeastly(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikBeastly(textStyle: textTheme.bodyMedium),
      bodySmall: rubikBeastly(textStyle: textTheme.bodySmall),
      labelLarge: rubikBeastly(textStyle: textTheme.labelLarge),
      labelMedium: rubikBeastly(textStyle: textTheme.labelMedium),
      labelSmall: rubikBeastly(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Bubbles font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Bubbles
  static TextStyle rubikBubbles({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '141da16469353130fd351e7733bf9eac9ccff14273f519bb744143fbca48400f',
        207396,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikBubbles',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Bubbles font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Bubbles
  static TextTheme rubikBubblesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikBubbles(textStyle: textTheme.displayLarge),
      displayMedium: rubikBubbles(textStyle: textTheme.displayMedium),
      displaySmall: rubikBubbles(textStyle: textTheme.displaySmall),
      headlineLarge: rubikBubbles(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikBubbles(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikBubbles(textStyle: textTheme.headlineSmall),
      titleLarge: rubikBubbles(textStyle: textTheme.titleLarge),
      titleMedium: rubikBubbles(textStyle: textTheme.titleMedium),
      titleSmall: rubikBubbles(textStyle: textTheme.titleSmall),
      bodyLarge: rubikBubbles(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikBubbles(textStyle: textTheme.bodyMedium),
      bodySmall: rubikBubbles(textStyle: textTheme.bodySmall),
      labelLarge: rubikBubbles(textStyle: textTheme.labelLarge),
      labelMedium: rubikBubbles(textStyle: textTheme.labelMedium),
      labelSmall: rubikBubbles(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Burned font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Burned
  static TextStyle rubikBurned({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33d672af860a647803b8bc3f8ebd52e5e6e46b52d6a44df0811ed693ea34dc54',
        574084,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikBurned',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Burned font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Burned
  static TextTheme rubikBurnedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikBurned(textStyle: textTheme.displayLarge),
      displayMedium: rubikBurned(textStyle: textTheme.displayMedium),
      displaySmall: rubikBurned(textStyle: textTheme.displaySmall),
      headlineLarge: rubikBurned(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikBurned(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikBurned(textStyle: textTheme.headlineSmall),
      titleLarge: rubikBurned(textStyle: textTheme.titleLarge),
      titleMedium: rubikBurned(textStyle: textTheme.titleMedium),
      titleSmall: rubikBurned(textStyle: textTheme.titleSmall),
      bodyLarge: rubikBurned(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikBurned(textStyle: textTheme.bodyMedium),
      bodySmall: rubikBurned(textStyle: textTheme.bodySmall),
      labelLarge: rubikBurned(textStyle: textTheme.labelLarge),
      labelMedium: rubikBurned(textStyle: textTheme.labelMedium),
      labelSmall: rubikBurned(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Dirt font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Dirt
  static TextStyle rubikDirt({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14b8e518b32bf5856d1813e0b5bd6f8eceab9b942cc3c1de9cac773901c44b27',
        1429136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikDirt',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Dirt font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Dirt
  static TextTheme rubikDirtTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikDirt(textStyle: textTheme.displayLarge),
      displayMedium: rubikDirt(textStyle: textTheme.displayMedium),
      displaySmall: rubikDirt(textStyle: textTheme.displaySmall),
      headlineLarge: rubikDirt(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikDirt(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikDirt(textStyle: textTheme.headlineSmall),
      titleLarge: rubikDirt(textStyle: textTheme.titleLarge),
      titleMedium: rubikDirt(textStyle: textTheme.titleMedium),
      titleSmall: rubikDirt(textStyle: textTheme.titleSmall),
      bodyLarge: rubikDirt(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikDirt(textStyle: textTheme.bodyMedium),
      bodySmall: rubikDirt(textStyle: textTheme.bodySmall),
      labelLarge: rubikDirt(textStyle: textTheme.labelLarge),
      labelMedium: rubikDirt(textStyle: textTheme.labelMedium),
      labelSmall: rubikDirt(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Distressed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Distressed
  static TextStyle rubikDistressed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '281b14e112a7b7f9a304e10b3b18f0c823a6848327d96b41a37d2baf17fc31cc',
        851792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikDistressed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Distressed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Distressed
  static TextTheme rubikDistressedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikDistressed(textStyle: textTheme.displayLarge),
      displayMedium: rubikDistressed(textStyle: textTheme.displayMedium),
      displaySmall: rubikDistressed(textStyle: textTheme.displaySmall),
      headlineLarge: rubikDistressed(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikDistressed(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikDistressed(textStyle: textTheme.headlineSmall),
      titleLarge: rubikDistressed(textStyle: textTheme.titleLarge),
      titleMedium: rubikDistressed(textStyle: textTheme.titleMedium),
      titleSmall: rubikDistressed(textStyle: textTheme.titleSmall),
      bodyLarge: rubikDistressed(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikDistressed(textStyle: textTheme.bodyMedium),
      bodySmall: rubikDistressed(textStyle: textTheme.bodySmall),
      labelLarge: rubikDistressed(textStyle: textTheme.labelLarge),
      labelMedium: rubikDistressed(textStyle: textTheme.labelMedium),
      labelSmall: rubikDistressed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Gemstones font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Gemstones
  static TextStyle rubikGemstones({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd122d18f80622014ad72d93271fe4e9842bfd5026b83014194fe4751657b7c7',
        250204,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikGemstones',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Gemstones font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Gemstones
  static TextTheme rubikGemstonesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikGemstones(textStyle: textTheme.displayLarge),
      displayMedium: rubikGemstones(textStyle: textTheme.displayMedium),
      displaySmall: rubikGemstones(textStyle: textTheme.displaySmall),
      headlineLarge: rubikGemstones(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikGemstones(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikGemstones(textStyle: textTheme.headlineSmall),
      titleLarge: rubikGemstones(textStyle: textTheme.titleLarge),
      titleMedium: rubikGemstones(textStyle: textTheme.titleMedium),
      titleSmall: rubikGemstones(textStyle: textTheme.titleSmall),
      bodyLarge: rubikGemstones(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikGemstones(textStyle: textTheme.bodyMedium),
      bodySmall: rubikGemstones(textStyle: textTheme.bodySmall),
      labelLarge: rubikGemstones(textStyle: textTheme.labelLarge),
      labelMedium: rubikGemstones(textStyle: textTheme.labelMedium),
      labelSmall: rubikGemstones(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Glitch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Glitch
  static TextStyle rubikGlitch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f37e1d94da8a99f0c8789fd8a6183fa6de6bdfcbc171d094ffd25aedb614be73',
        384280,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikGlitch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Glitch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Glitch
  static TextTheme rubikGlitchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikGlitch(textStyle: textTheme.displayLarge),
      displayMedium: rubikGlitch(textStyle: textTheme.displayMedium),
      displaySmall: rubikGlitch(textStyle: textTheme.displaySmall),
      headlineLarge: rubikGlitch(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikGlitch(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikGlitch(textStyle: textTheme.headlineSmall),
      titleLarge: rubikGlitch(textStyle: textTheme.titleLarge),
      titleMedium: rubikGlitch(textStyle: textTheme.titleMedium),
      titleSmall: rubikGlitch(textStyle: textTheme.titleSmall),
      bodyLarge: rubikGlitch(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikGlitch(textStyle: textTheme.bodyMedium),
      bodySmall: rubikGlitch(textStyle: textTheme.bodySmall),
      labelLarge: rubikGlitch(textStyle: textTheme.labelLarge),
      labelMedium: rubikGlitch(textStyle: textTheme.labelMedium),
      labelSmall: rubikGlitch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Iso font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Iso
  static TextStyle rubikIso({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cfb5518ff076bcf860a3ed14421b4a7ba5e794cd9ca305c550135316057583a',
        124120,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikIso',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Iso font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Iso
  static TextTheme rubikIsoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikIso(textStyle: textTheme.displayLarge),
      displayMedium: rubikIso(textStyle: textTheme.displayMedium),
      displaySmall: rubikIso(textStyle: textTheme.displaySmall),
      headlineLarge: rubikIso(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikIso(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikIso(textStyle: textTheme.headlineSmall),
      titleLarge: rubikIso(textStyle: textTheme.titleLarge),
      titleMedium: rubikIso(textStyle: textTheme.titleMedium),
      titleSmall: rubikIso(textStyle: textTheme.titleSmall),
      bodyLarge: rubikIso(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikIso(textStyle: textTheme.bodyMedium),
      bodySmall: rubikIso(textStyle: textTheme.bodySmall),
      labelLarge: rubikIso(textStyle: textTheme.labelLarge),
      labelMedium: rubikIso(textStyle: textTheme.labelMedium),
      labelSmall: rubikIso(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Marker Hatch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Marker+Hatch
  static TextStyle rubikMarkerHatch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9f0e19305760e393ee283a6fbb507f336119a6b1b9e281bd65a4be0112f5129',
        344528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikMarkerHatch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Marker Hatch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Marker+Hatch
  static TextTheme rubikMarkerHatchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikMarkerHatch(textStyle: textTheme.displayLarge),
      displayMedium: rubikMarkerHatch(textStyle: textTheme.displayMedium),
      displaySmall: rubikMarkerHatch(textStyle: textTheme.displaySmall),
      headlineLarge: rubikMarkerHatch(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikMarkerHatch(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikMarkerHatch(textStyle: textTheme.headlineSmall),
      titleLarge: rubikMarkerHatch(textStyle: textTheme.titleLarge),
      titleMedium: rubikMarkerHatch(textStyle: textTheme.titleMedium),
      titleSmall: rubikMarkerHatch(textStyle: textTheme.titleSmall),
      bodyLarge: rubikMarkerHatch(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikMarkerHatch(textStyle: textTheme.bodyMedium),
      bodySmall: rubikMarkerHatch(textStyle: textTheme.bodySmall),
      labelLarge: rubikMarkerHatch(textStyle: textTheme.labelLarge),
      labelMedium: rubikMarkerHatch(textStyle: textTheme.labelMedium),
      labelSmall: rubikMarkerHatch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Maze font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Maze
  static TextStyle rubikMaze({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c1d40420fdece1420472a7821524b3bd3cb316b21d7c129b927e00dc1e86cc0',
        437212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikMaze',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Maze font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Maze
  static TextTheme rubikMazeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikMaze(textStyle: textTheme.displayLarge),
      displayMedium: rubikMaze(textStyle: textTheme.displayMedium),
      displaySmall: rubikMaze(textStyle: textTheme.displaySmall),
      headlineLarge: rubikMaze(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikMaze(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikMaze(textStyle: textTheme.headlineSmall),
      titleLarge: rubikMaze(textStyle: textTheme.titleLarge),
      titleMedium: rubikMaze(textStyle: textTheme.titleMedium),
      titleSmall: rubikMaze(textStyle: textTheme.titleSmall),
      bodyLarge: rubikMaze(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikMaze(textStyle: textTheme.bodyMedium),
      bodySmall: rubikMaze(textStyle: textTheme.bodySmall),
      labelLarge: rubikMaze(textStyle: textTheme.labelLarge),
      labelMedium: rubikMaze(textStyle: textTheme.labelMedium),
      labelSmall: rubikMaze(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Microbe font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Microbe
  static TextStyle rubikMicrobe({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '96fccd0700788940f07716f384a505025a90b9d91e1e8d1e610887b459d47a04',
        1379152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikMicrobe',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Microbe font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Microbe
  static TextTheme rubikMicrobeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikMicrobe(textStyle: textTheme.displayLarge),
      displayMedium: rubikMicrobe(textStyle: textTheme.displayMedium),
      displaySmall: rubikMicrobe(textStyle: textTheme.displaySmall),
      headlineLarge: rubikMicrobe(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikMicrobe(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikMicrobe(textStyle: textTheme.headlineSmall),
      titleLarge: rubikMicrobe(textStyle: textTheme.titleLarge),
      titleMedium: rubikMicrobe(textStyle: textTheme.titleMedium),
      titleSmall: rubikMicrobe(textStyle: textTheme.titleSmall),
      bodyLarge: rubikMicrobe(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikMicrobe(textStyle: textTheme.bodyMedium),
      bodySmall: rubikMicrobe(textStyle: textTheme.bodySmall),
      labelLarge: rubikMicrobe(textStyle: textTheme.labelLarge),
      labelMedium: rubikMicrobe(textStyle: textTheme.labelMedium),
      labelSmall: rubikMicrobe(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Mono One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Mono+One
  static TextStyle rubikMonoOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3bfd8e7a9f4144c65fe25715c8afe67596fc3c2b58e5544c9662702d988df8c0',
        73488,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikMonoOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Mono One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Mono+One
  static TextTheme rubikMonoOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikMonoOne(textStyle: textTheme.displayLarge),
      displayMedium: rubikMonoOne(textStyle: textTheme.displayMedium),
      displaySmall: rubikMonoOne(textStyle: textTheme.displaySmall),
      headlineLarge: rubikMonoOne(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikMonoOne(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikMonoOne(textStyle: textTheme.headlineSmall),
      titleLarge: rubikMonoOne(textStyle: textTheme.titleLarge),
      titleMedium: rubikMonoOne(textStyle: textTheme.titleMedium),
      titleSmall: rubikMonoOne(textStyle: textTheme.titleSmall),
      bodyLarge: rubikMonoOne(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikMonoOne(textStyle: textTheme.bodyMedium),
      bodySmall: rubikMonoOne(textStyle: textTheme.bodySmall),
      labelLarge: rubikMonoOne(textStyle: textTheme.labelLarge),
      labelMedium: rubikMonoOne(textStyle: textTheme.labelMedium),
      labelSmall: rubikMonoOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Moonrocks font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Moonrocks
  static TextStyle rubikMoonrocks({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46ce2bf69dfb5a43e2242fbfddd3e1690e59c9ca169e3bb4dcd1d231a58e055f',
        382604,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikMoonrocks',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Moonrocks font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Moonrocks
  static TextTheme rubikMoonrocksTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikMoonrocks(textStyle: textTheme.displayLarge),
      displayMedium: rubikMoonrocks(textStyle: textTheme.displayMedium),
      displaySmall: rubikMoonrocks(textStyle: textTheme.displaySmall),
      headlineLarge: rubikMoonrocks(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikMoonrocks(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikMoonrocks(textStyle: textTheme.headlineSmall),
      titleLarge: rubikMoonrocks(textStyle: textTheme.titleLarge),
      titleMedium: rubikMoonrocks(textStyle: textTheme.titleMedium),
      titleSmall: rubikMoonrocks(textStyle: textTheme.titleSmall),
      bodyLarge: rubikMoonrocks(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikMoonrocks(textStyle: textTheme.bodyMedium),
      bodySmall: rubikMoonrocks(textStyle: textTheme.bodySmall),
      labelLarge: rubikMoonrocks(textStyle: textTheme.labelLarge),
      labelMedium: rubikMoonrocks(textStyle: textTheme.labelMedium),
      labelSmall: rubikMoonrocks(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Pixels font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Pixels
  static TextStyle rubikPixels({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cd7f7aa7710b19f46b74f1ee468e64d4ae8c322bec0bb2adbaf0eb546a5ab3a',
        5425804,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikPixels',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Pixels font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Pixels
  static TextTheme rubikPixelsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikPixels(textStyle: textTheme.displayLarge),
      displayMedium: rubikPixels(textStyle: textTheme.displayMedium),
      displaySmall: rubikPixels(textStyle: textTheme.displaySmall),
      headlineLarge: rubikPixels(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikPixels(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikPixels(textStyle: textTheme.headlineSmall),
      titleLarge: rubikPixels(textStyle: textTheme.titleLarge),
      titleMedium: rubikPixels(textStyle: textTheme.titleMedium),
      titleSmall: rubikPixels(textStyle: textTheme.titleSmall),
      bodyLarge: rubikPixels(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikPixels(textStyle: textTheme.bodyMedium),
      bodySmall: rubikPixels(textStyle: textTheme.bodySmall),
      labelLarge: rubikPixels(textStyle: textTheme.labelLarge),
      labelMedium: rubikPixels(textStyle: textTheme.labelMedium),
      labelSmall: rubikPixels(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Puddles font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Puddles
  static TextStyle rubikPuddles({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df67a7b7f72916e11460cfc15bd08226f90bc05462d2040bfe75fef5c57c52da',
        383712,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikPuddles',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Puddles font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Puddles
  static TextTheme rubikPuddlesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikPuddles(textStyle: textTheme.displayLarge),
      displayMedium: rubikPuddles(textStyle: textTheme.displayMedium),
      displaySmall: rubikPuddles(textStyle: textTheme.displaySmall),
      headlineLarge: rubikPuddles(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikPuddles(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikPuddles(textStyle: textTheme.headlineSmall),
      titleLarge: rubikPuddles(textStyle: textTheme.titleLarge),
      titleMedium: rubikPuddles(textStyle: textTheme.titleMedium),
      titleSmall: rubikPuddles(textStyle: textTheme.titleSmall),
      bodyLarge: rubikPuddles(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikPuddles(textStyle: textTheme.bodyMedium),
      bodySmall: rubikPuddles(textStyle: textTheme.bodySmall),
      labelLarge: rubikPuddles(textStyle: textTheme.labelLarge),
      labelMedium: rubikPuddles(textStyle: textTheme.labelMedium),
      labelSmall: rubikPuddles(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Spray Paint font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Spray+Paint
  static TextStyle rubikSprayPaint({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e6c34931f1175681ffc0a17994fea2ab0c6aec0e7537638808ce9de17ab4048',
        893604,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikSprayPaint',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Spray Paint font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Spray+Paint
  static TextTheme rubikSprayPaintTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikSprayPaint(textStyle: textTheme.displayLarge),
      displayMedium: rubikSprayPaint(textStyle: textTheme.displayMedium),
      displaySmall: rubikSprayPaint(textStyle: textTheme.displaySmall),
      headlineLarge: rubikSprayPaint(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikSprayPaint(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikSprayPaint(textStyle: textTheme.headlineSmall),
      titleLarge: rubikSprayPaint(textStyle: textTheme.titleLarge),
      titleMedium: rubikSprayPaint(textStyle: textTheme.titleMedium),
      titleSmall: rubikSprayPaint(textStyle: textTheme.titleSmall),
      bodyLarge: rubikSprayPaint(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikSprayPaint(textStyle: textTheme.bodyMedium),
      bodySmall: rubikSprayPaint(textStyle: textTheme.bodySmall),
      labelLarge: rubikSprayPaint(textStyle: textTheme.labelLarge),
      labelMedium: rubikSprayPaint(textStyle: textTheme.labelMedium),
      labelSmall: rubikSprayPaint(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Storm font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Storm
  static TextStyle rubikStorm({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '73646e66c570b0ca3d747faecc59fe1f925990894b1dc4e10deb1e8181ae65bc',
        758672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikStorm',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Storm font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Storm
  static TextTheme rubikStormTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikStorm(textStyle: textTheme.displayLarge),
      displayMedium: rubikStorm(textStyle: textTheme.displayMedium),
      displaySmall: rubikStorm(textStyle: textTheme.displaySmall),
      headlineLarge: rubikStorm(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikStorm(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikStorm(textStyle: textTheme.headlineSmall),
      titleLarge: rubikStorm(textStyle: textTheme.titleLarge),
      titleMedium: rubikStorm(textStyle: textTheme.titleMedium),
      titleSmall: rubikStorm(textStyle: textTheme.titleSmall),
      bodyLarge: rubikStorm(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikStorm(textStyle: textTheme.bodyMedium),
      bodySmall: rubikStorm(textStyle: textTheme.bodySmall),
      labelLarge: rubikStorm(textStyle: textTheme.labelLarge),
      labelMedium: rubikStorm(textStyle: textTheme.labelMedium),
      labelSmall: rubikStorm(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Vinyl font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Vinyl
  static TextStyle rubikVinyl({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b866ec0a1a399a86cd5bffe45885d125ef186c05337b11fa114c57cbdb18bba',
        392768,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikVinyl',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Vinyl font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Vinyl
  static TextTheme rubikVinylTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikVinyl(textStyle: textTheme.displayLarge),
      displayMedium: rubikVinyl(textStyle: textTheme.displayMedium),
      displaySmall: rubikVinyl(textStyle: textTheme.displaySmall),
      headlineLarge: rubikVinyl(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikVinyl(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikVinyl(textStyle: textTheme.headlineSmall),
      titleLarge: rubikVinyl(textStyle: textTheme.titleLarge),
      titleMedium: rubikVinyl(textStyle: textTheme.titleMedium),
      titleSmall: rubikVinyl(textStyle: textTheme.titleSmall),
      bodyLarge: rubikVinyl(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikVinyl(textStyle: textTheme.bodyMedium),
      bodySmall: rubikVinyl(textStyle: textTheme.bodySmall),
      labelLarge: rubikVinyl(textStyle: textTheme.labelLarge),
      labelMedium: rubikVinyl(textStyle: textTheme.labelMedium),
      labelSmall: rubikVinyl(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Wet Paint font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Wet+Paint
  static TextStyle rubikWetPaint({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '164e4e6c0d015fc8205770ed061ec3a44a72a50b0bbfcb4f6081c8e3de5a1451',
        418376,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikWetPaint',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Wet Paint font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Wet+Paint
  static TextTheme rubikWetPaintTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikWetPaint(textStyle: textTheme.displayLarge),
      displayMedium: rubikWetPaint(textStyle: textTheme.displayMedium),
      displaySmall: rubikWetPaint(textStyle: textTheme.displaySmall),
      headlineLarge: rubikWetPaint(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikWetPaint(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikWetPaint(textStyle: textTheme.headlineSmall),
      titleLarge: rubikWetPaint(textStyle: textTheme.titleLarge),
      titleMedium: rubikWetPaint(textStyle: textTheme.titleMedium),
      titleSmall: rubikWetPaint(textStyle: textTheme.titleSmall),
      bodyLarge: rubikWetPaint(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikWetPaint(textStyle: textTheme.bodyMedium),
      bodySmall: rubikWetPaint(textStyle: textTheme.bodySmall),
      labelLarge: rubikWetPaint(textStyle: textTheme.labelLarge),
      labelMedium: rubikWetPaint(textStyle: textTheme.labelMedium),
      labelSmall: rubikWetPaint(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ruda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruda
  static TextStyle ruda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5160954ed3e99328d4f57e8dcbbce8d5ce671c5658b3b54c7a7ec6d456715379',
        50532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d22ae597994012cf84d05074c5ef310304e5c22508f3f4a032a85933e94b312',
        50584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eca3c23a94fa4fe860f2539ca728f7143fcac8135491f5f1ccc2896b681fc78d',
        50592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d978bf3411e84c919026ecb67f04a8ead743c8f102238239ae5fecb787c3f72',
        50512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c6bb64e2b513f21f1bd9ee422ad0e7e9f32db9aab125ecb3c56eee3a6e5a827',
        50600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'edf1273c26595739b8a5799e447af2a23ef30eb024bf54afdffe72ecfeaaecae',
        50424,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ruda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ruda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruda
  static TextTheme rudaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ruda(textStyle: textTheme.displayLarge),
      displayMedium: ruda(textStyle: textTheme.displayMedium),
      displaySmall: ruda(textStyle: textTheme.displaySmall),
      headlineLarge: ruda(textStyle: textTheme.headlineLarge),
      headlineMedium: ruda(textStyle: textTheme.headlineMedium),
      headlineSmall: ruda(textStyle: textTheme.headlineSmall),
      titleLarge: ruda(textStyle: textTheme.titleLarge),
      titleMedium: ruda(textStyle: textTheme.titleMedium),
      titleSmall: ruda(textStyle: textTheme.titleSmall),
      bodyLarge: ruda(textStyle: textTheme.bodyLarge),
      bodyMedium: ruda(textStyle: textTheme.bodyMedium),
      bodySmall: ruda(textStyle: textTheme.bodySmall),
      labelLarge: ruda(textStyle: textTheme.labelLarge),
      labelMedium: ruda(textStyle: textTheme.labelMedium),
      labelSmall: ruda(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rufina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rufina
  static TextStyle rufina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '37d67263c3c798e24449037fea8bbe577cf785a89e309ba3b36fe02be8513068',
        38092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e69e1fbcebf9b2b0d4e1e35b6120545d45e453f952d590ea9d81d256f5fdb44b',
        38156,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rufina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rufina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rufina
  static TextTheme rufinaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rufina(textStyle: textTheme.displayLarge),
      displayMedium: rufina(textStyle: textTheme.displayMedium),
      displaySmall: rufina(textStyle: textTheme.displaySmall),
      headlineLarge: rufina(textStyle: textTheme.headlineLarge),
      headlineMedium: rufina(textStyle: textTheme.headlineMedium),
      headlineSmall: rufina(textStyle: textTheme.headlineSmall),
      titleLarge: rufina(textStyle: textTheme.titleLarge),
      titleMedium: rufina(textStyle: textTheme.titleMedium),
      titleSmall: rufina(textStyle: textTheme.titleSmall),
      bodyLarge: rufina(textStyle: textTheme.bodyLarge),
      bodyMedium: rufina(textStyle: textTheme.bodyMedium),
      bodySmall: rufina(textStyle: textTheme.bodySmall),
      labelLarge: rufina(textStyle: textTheme.labelLarge),
      labelMedium: rufina(textStyle: textTheme.labelMedium),
      labelSmall: rufina(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ruge Boogie font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruge+Boogie
  static TextStyle rugeBoogie({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9a5a0be81e802cf1f78141f183e7a7ebc5805cabff1f9020e311f75f85b141a',
        107976,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RugeBoogie',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ruge Boogie font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruge+Boogie
  static TextTheme rugeBoogieTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rugeBoogie(textStyle: textTheme.displayLarge),
      displayMedium: rugeBoogie(textStyle: textTheme.displayMedium),
      displaySmall: rugeBoogie(textStyle: textTheme.displaySmall),
      headlineLarge: rugeBoogie(textStyle: textTheme.headlineLarge),
      headlineMedium: rugeBoogie(textStyle: textTheme.headlineMedium),
      headlineSmall: rugeBoogie(textStyle: textTheme.headlineSmall),
      titleLarge: rugeBoogie(textStyle: textTheme.titleLarge),
      titleMedium: rugeBoogie(textStyle: textTheme.titleMedium),
      titleSmall: rugeBoogie(textStyle: textTheme.titleSmall),
      bodyLarge: rugeBoogie(textStyle: textTheme.bodyLarge),
      bodyMedium: rugeBoogie(textStyle: textTheme.bodyMedium),
      bodySmall: rugeBoogie(textStyle: textTheme.bodySmall),
      labelLarge: rugeBoogie(textStyle: textTheme.labelLarge),
      labelMedium: rugeBoogie(textStyle: textTheme.labelMedium),
      labelSmall: rugeBoogie(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ruluko font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruluko
  static TextStyle ruluko({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '27f8111a1cf185145e375de9da3f6ceec5d1f9a01d17e92e0caa30e36fd5154d',
        24612,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ruluko',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ruluko font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruluko
  static TextTheme rulukoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ruluko(textStyle: textTheme.displayLarge),
      displayMedium: ruluko(textStyle: textTheme.displayMedium),
      displaySmall: ruluko(textStyle: textTheme.displaySmall),
      headlineLarge: ruluko(textStyle: textTheme.headlineLarge),
      headlineMedium: ruluko(textStyle: textTheme.headlineMedium),
      headlineSmall: ruluko(textStyle: textTheme.headlineSmall),
      titleLarge: ruluko(textStyle: textTheme.titleLarge),
      titleMedium: ruluko(textStyle: textTheme.titleMedium),
      titleSmall: ruluko(textStyle: textTheme.titleSmall),
      bodyLarge: ruluko(textStyle: textTheme.bodyLarge),
      bodyMedium: ruluko(textStyle: textTheme.bodyMedium),
      bodySmall: ruluko(textStyle: textTheme.bodySmall),
      labelLarge: ruluko(textStyle: textTheme.labelLarge),
      labelMedium: ruluko(textStyle: textTheme.labelMedium),
      labelSmall: ruluko(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rum Raisin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rum+Raisin
  static TextStyle rumRaisin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5e470839ddd1433527d204e91bbc888f96b4059ff273a81c4de5cd31a43d553',
        59228,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RumRaisin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rum Raisin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rum+Raisin
  static TextTheme rumRaisinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rumRaisin(textStyle: textTheme.displayLarge),
      displayMedium: rumRaisin(textStyle: textTheme.displayMedium),
      displaySmall: rumRaisin(textStyle: textTheme.displaySmall),
      headlineLarge: rumRaisin(textStyle: textTheme.headlineLarge),
      headlineMedium: rumRaisin(textStyle: textTheme.headlineMedium),
      headlineSmall: rumRaisin(textStyle: textTheme.headlineSmall),
      titleLarge: rumRaisin(textStyle: textTheme.titleLarge),
      titleMedium: rumRaisin(textStyle: textTheme.titleMedium),
      titleSmall: rumRaisin(textStyle: textTheme.titleSmall),
      bodyLarge: rumRaisin(textStyle: textTheme.bodyLarge),
      bodyMedium: rumRaisin(textStyle: textTheme.bodyMedium),
      bodySmall: rumRaisin(textStyle: textTheme.bodySmall),
      labelLarge: rumRaisin(textStyle: textTheme.labelLarge),
      labelMedium: rumRaisin(textStyle: textTheme.labelMedium),
      labelSmall: rumRaisin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ruslan Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruslan+Display
  static TextStyle ruslanDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1709a9436a4bf576aca6a914045984428dc987f58e230c4b1100a3d7a80e5955',
        54312,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RuslanDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ruslan Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruslan+Display
  static TextTheme ruslanDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ruslanDisplay(textStyle: textTheme.displayLarge),
      displayMedium: ruslanDisplay(textStyle: textTheme.displayMedium),
      displaySmall: ruslanDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: ruslanDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: ruslanDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: ruslanDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: ruslanDisplay(textStyle: textTheme.titleLarge),
      titleMedium: ruslanDisplay(textStyle: textTheme.titleMedium),
      titleSmall: ruslanDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: ruslanDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: ruslanDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: ruslanDisplay(textStyle: textTheme.bodySmall),
      labelLarge: ruslanDisplay(textStyle: textTheme.labelLarge),
      labelMedium: ruslanDisplay(textStyle: textTheme.labelMedium),
      labelSmall: ruslanDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Russo One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Russo+One
  static TextStyle russoOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd9548de02480e52ed86ab9c683758262f2dddd3030e60b0113141a4703fb7af',
        36792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RussoOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Russo One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Russo+One
  static TextTheme russoOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: russoOne(textStyle: textTheme.displayLarge),
      displayMedium: russoOne(textStyle: textTheme.displayMedium),
      displaySmall: russoOne(textStyle: textTheme.displaySmall),
      headlineLarge: russoOne(textStyle: textTheme.headlineLarge),
      headlineMedium: russoOne(textStyle: textTheme.headlineMedium),
      headlineSmall: russoOne(textStyle: textTheme.headlineSmall),
      titleLarge: russoOne(textStyle: textTheme.titleLarge),
      titleMedium: russoOne(textStyle: textTheme.titleMedium),
      titleSmall: russoOne(textStyle: textTheme.titleSmall),
      bodyLarge: russoOne(textStyle: textTheme.bodyLarge),
      bodyMedium: russoOne(textStyle: textTheme.bodyMedium),
      bodySmall: russoOne(textStyle: textTheme.bodySmall),
      labelLarge: russoOne(textStyle: textTheme.labelLarge),
      labelMedium: russoOne(textStyle: textTheme.labelMedium),
      labelSmall: russoOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ruthie font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruthie
  static TextStyle ruthie({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10734c830bccb48db397efd020d2a54458d5242f571fa84d9a13bf5e1988abb0',
        69948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ruthie',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ruthie font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruthie
  static TextTheme ruthieTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ruthie(textStyle: textTheme.displayLarge),
      displayMedium: ruthie(textStyle: textTheme.displayMedium),
      displaySmall: ruthie(textStyle: textTheme.displaySmall),
      headlineLarge: ruthie(textStyle: textTheme.headlineLarge),
      headlineMedium: ruthie(textStyle: textTheme.headlineMedium),
      headlineSmall: ruthie(textStyle: textTheme.headlineSmall),
      titleLarge: ruthie(textStyle: textTheme.titleLarge),
      titleMedium: ruthie(textStyle: textTheme.titleMedium),
      titleSmall: ruthie(textStyle: textTheme.titleSmall),
      bodyLarge: ruthie(textStyle: textTheme.bodyLarge),
      bodyMedium: ruthie(textStyle: textTheme.bodyMedium),
      bodySmall: ruthie(textStyle: textTheme.bodySmall),
      labelLarge: ruthie(textStyle: textTheme.labelLarge),
      labelMedium: ruthie(textStyle: textTheme.labelMedium),
      labelSmall: ruthie(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ruwudu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruwudu
  static TextStyle ruwudu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '777449cf3ce3920c07bce90e1d63a37a96908bc2b83d98a18ccff6e94575437a',
        103376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50421dc388cdc40b4dd66ee457fee5836df8c2a2478a7363fdc3109c1b7e63b9',
        104228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '619f44113cffb1b9944127f25eb38a9f7c9224eb2b4f83c8b5d255d545d66a9c',
        104700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2c2c5c9d03128ed5d07b1bae58c62e94684107ff3fd7a6144eafcc51c1b8f878',
        105100,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ruwudu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ruwudu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruwudu
  static TextTheme ruwuduTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ruwudu(textStyle: textTheme.displayLarge),
      displayMedium: ruwudu(textStyle: textTheme.displayMedium),
      displaySmall: ruwudu(textStyle: textTheme.displaySmall),
      headlineLarge: ruwudu(textStyle: textTheme.headlineLarge),
      headlineMedium: ruwudu(textStyle: textTheme.headlineMedium),
      headlineSmall: ruwudu(textStyle: textTheme.headlineSmall),
      titleLarge: ruwudu(textStyle: textTheme.titleLarge),
      titleMedium: ruwudu(textStyle: textTheme.titleMedium),
      titleSmall: ruwudu(textStyle: textTheme.titleSmall),
      bodyLarge: ruwudu(textStyle: textTheme.bodyLarge),
      bodyMedium: ruwudu(textStyle: textTheme.bodyMedium),
      bodySmall: ruwudu(textStyle: textTheme.bodySmall),
      labelLarge: ruwudu(textStyle: textTheme.labelLarge),
      labelMedium: ruwudu(textStyle: textTheme.labelMedium),
      labelSmall: ruwudu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rye font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rye
  static TextStyle rye({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2c0463aeec976dc75715e765a815de8e99e823c41f0be0cf9f303ffce874fbac',
        80784,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rye',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rye font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rye
  static TextTheme ryeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rye(textStyle: textTheme.displayLarge),
      displayMedium: rye(textStyle: textTheme.displayMedium),
      displaySmall: rye(textStyle: textTheme.displaySmall),
      headlineLarge: rye(textStyle: textTheme.headlineLarge),
      headlineMedium: rye(textStyle: textTheme.headlineMedium),
      headlineSmall: rye(textStyle: textTheme.headlineSmall),
      titleLarge: rye(textStyle: textTheme.titleLarge),
      titleMedium: rye(textStyle: textTheme.titleMedium),
      titleSmall: rye(textStyle: textTheme.titleSmall),
      bodyLarge: rye(textStyle: textTheme.bodyLarge),
      bodyMedium: rye(textStyle: textTheme.bodyMedium),
      bodySmall: rye(textStyle: textTheme.bodySmall),
      labelLarge: rye(textStyle: textTheme.labelLarge),
      labelMedium: rye(textStyle: textTheme.labelMedium),
      labelSmall: rye(textStyle: textTheme.labelSmall),
    );
  }
}
