// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'O'.
class PartO {
  /// Applies the Odibee Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Odibee+Sans
  static TextStyle odibeeSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dd2a03d510e32d4e4b44e8d58985ed87f8bee0d1a4437f510ee65ed8091342b4',
        28468,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OdibeeSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Odibee Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Odibee+Sans
  static TextTheme odibeeSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: odibeeSans(textStyle: textTheme.displayLarge),
      displayMedium: odibeeSans(textStyle: textTheme.displayMedium),
      displaySmall: odibeeSans(textStyle: textTheme.displaySmall),
      headlineLarge: odibeeSans(textStyle: textTheme.headlineLarge),
      headlineMedium: odibeeSans(textStyle: textTheme.headlineMedium),
      headlineSmall: odibeeSans(textStyle: textTheme.headlineSmall),
      titleLarge: odibeeSans(textStyle: textTheme.titleLarge),
      titleMedium: odibeeSans(textStyle: textTheme.titleMedium),
      titleSmall: odibeeSans(textStyle: textTheme.titleSmall),
      bodyLarge: odibeeSans(textStyle: textTheme.bodyLarge),
      bodyMedium: odibeeSans(textStyle: textTheme.bodyMedium),
      bodySmall: odibeeSans(textStyle: textTheme.bodySmall),
      labelLarge: odibeeSans(textStyle: textTheme.labelLarge),
      labelMedium: odibeeSans(textStyle: textTheme.labelMedium),
      labelSmall: odibeeSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Odor Mean Chey font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Odor+Mean+Chey
  static TextStyle odorMeanChey({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69f4d00a1b39a1cb51ccabad07a1b2d07a383813db087ba7e4cba60253d82466',
        64128,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OdorMeanChey',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Odor Mean Chey font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Odor+Mean+Chey
  static TextTheme odorMeanCheyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: odorMeanChey(textStyle: textTheme.displayLarge),
      displayMedium: odorMeanChey(textStyle: textTheme.displayMedium),
      displaySmall: odorMeanChey(textStyle: textTheme.displaySmall),
      headlineLarge: odorMeanChey(textStyle: textTheme.headlineLarge),
      headlineMedium: odorMeanChey(textStyle: textTheme.headlineMedium),
      headlineSmall: odorMeanChey(textStyle: textTheme.headlineSmall),
      titleLarge: odorMeanChey(textStyle: textTheme.titleLarge),
      titleMedium: odorMeanChey(textStyle: textTheme.titleMedium),
      titleSmall: odorMeanChey(textStyle: textTheme.titleSmall),
      bodyLarge: odorMeanChey(textStyle: textTheme.bodyLarge),
      bodyMedium: odorMeanChey(textStyle: textTheme.bodyMedium),
      bodySmall: odorMeanChey(textStyle: textTheme.bodySmall),
      labelLarge: odorMeanChey(textStyle: textTheme.labelLarge),
      labelMedium: odorMeanChey(textStyle: textTheme.labelMedium),
      labelSmall: odorMeanChey(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Offside font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Offside
  static TextStyle offside({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '31201e2dbf4c83e4efb3db4e362af68b8256fba1bd11d74c5dcc9791e1665894',
        42312,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Offside',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Offside font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Offside
  static TextTheme offsideTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: offside(textStyle: textTheme.displayLarge),
      displayMedium: offside(textStyle: textTheme.displayMedium),
      displaySmall: offside(textStyle: textTheme.displaySmall),
      headlineLarge: offside(textStyle: textTheme.headlineLarge),
      headlineMedium: offside(textStyle: textTheme.headlineMedium),
      headlineSmall: offside(textStyle: textTheme.headlineSmall),
      titleLarge: offside(textStyle: textTheme.titleLarge),
      titleMedium: offside(textStyle: textTheme.titleMedium),
      titleSmall: offside(textStyle: textTheme.titleSmall),
      bodyLarge: offside(textStyle: textTheme.bodyLarge),
      bodyMedium: offside(textStyle: textTheme.bodyMedium),
      bodySmall: offside(textStyle: textTheme.bodySmall),
      labelLarge: offside(textStyle: textTheme.labelLarge),
      labelMedium: offside(textStyle: textTheme.labelMedium),
      labelSmall: offside(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Oi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oi
  static TextStyle oi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2004b0747df5a6a26cf89cb402192a1c8d6308aa1c81a199e2e28490e42ebd18',
        327048,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Oi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Oi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oi
  static TextTheme oiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: oi(textStyle: textTheme.displayLarge),
      displayMedium: oi(textStyle: textTheme.displayMedium),
      displaySmall: oi(textStyle: textTheme.displaySmall),
      headlineLarge: oi(textStyle: textTheme.headlineLarge),
      headlineMedium: oi(textStyle: textTheme.headlineMedium),
      headlineSmall: oi(textStyle: textTheme.headlineSmall),
      titleLarge: oi(textStyle: textTheme.titleLarge),
      titleMedium: oi(textStyle: textTheme.titleMedium),
      titleSmall: oi(textStyle: textTheme.titleSmall),
      bodyLarge: oi(textStyle: textTheme.bodyLarge),
      bodyMedium: oi(textStyle: textTheme.bodyMedium),
      bodySmall: oi(textStyle: textTheme.bodySmall),
      labelLarge: oi(textStyle: textTheme.labelLarge),
      labelMedium: oi(textStyle: textTheme.labelMedium),
      labelSmall: oi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Old Standard TT font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Old+Standard+TT
  static TextStyle oldStandardTt({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0201727d25a16274e9a9db669f54bffc1b4d1d3e978a073b2dd161cb50bf4e34',
        144196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '342348b635cb55e29abf8da14723dcc7431d8c88ff8808021519b07536087440',
        160252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '63203c8a7d14ee495b38fdc3ad47af8ad65ad2e26ff6587933cd4420d3408905',
        143392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OldStandardTT',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Old Standard TT font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Old+Standard+TT
  static TextTheme oldStandardTtTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: oldStandardTt(textStyle: textTheme.displayLarge),
      displayMedium: oldStandardTt(textStyle: textTheme.displayMedium),
      displaySmall: oldStandardTt(textStyle: textTheme.displaySmall),
      headlineLarge: oldStandardTt(textStyle: textTheme.headlineLarge),
      headlineMedium: oldStandardTt(textStyle: textTheme.headlineMedium),
      headlineSmall: oldStandardTt(textStyle: textTheme.headlineSmall),
      titleLarge: oldStandardTt(textStyle: textTheme.titleLarge),
      titleMedium: oldStandardTt(textStyle: textTheme.titleMedium),
      titleSmall: oldStandardTt(textStyle: textTheme.titleSmall),
      bodyLarge: oldStandardTt(textStyle: textTheme.bodyLarge),
      bodyMedium: oldStandardTt(textStyle: textTheme.bodyMedium),
      bodySmall: oldStandardTt(textStyle: textTheme.bodySmall),
      labelLarge: oldStandardTt(textStyle: textTheme.labelLarge),
      labelMedium: oldStandardTt(textStyle: textTheme.labelMedium),
      labelSmall: oldStandardTt(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Oldenburg font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oldenburg
  static TextStyle oldenburg({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b7e8d9e40a5c2d988b80dd02ebec67582a4064b92675e96c997c51ad42178d0',
        42380,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Oldenburg',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Oldenburg font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oldenburg
  static TextTheme oldenburgTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: oldenburg(textStyle: textTheme.displayLarge),
      displayMedium: oldenburg(textStyle: textTheme.displayMedium),
      displaySmall: oldenburg(textStyle: textTheme.displaySmall),
      headlineLarge: oldenburg(textStyle: textTheme.headlineLarge),
      headlineMedium: oldenburg(textStyle: textTheme.headlineMedium),
      headlineSmall: oldenburg(textStyle: textTheme.headlineSmall),
      titleLarge: oldenburg(textStyle: textTheme.titleLarge),
      titleMedium: oldenburg(textStyle: textTheme.titleMedium),
      titleSmall: oldenburg(textStyle: textTheme.titleSmall),
      bodyLarge: oldenburg(textStyle: textTheme.bodyLarge),
      bodyMedium: oldenburg(textStyle: textTheme.bodyMedium),
      bodySmall: oldenburg(textStyle: textTheme.bodySmall),
      labelLarge: oldenburg(textStyle: textTheme.labelLarge),
      labelMedium: oldenburg(textStyle: textTheme.labelMedium),
      labelSmall: oldenburg(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ole font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ole
  static TextStyle ole({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '896ba4dca76eb29e1b70254dcfdd67e4471a2c321f69931b5cf85ae02a4251e3',
        104388,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ole',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ole font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ole
  static TextTheme oleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ole(textStyle: textTheme.displayLarge),
      displayMedium: ole(textStyle: textTheme.displayMedium),
      displaySmall: ole(textStyle: textTheme.displaySmall),
      headlineLarge: ole(textStyle: textTheme.headlineLarge),
      headlineMedium: ole(textStyle: textTheme.headlineMedium),
      headlineSmall: ole(textStyle: textTheme.headlineSmall),
      titleLarge: ole(textStyle: textTheme.titleLarge),
      titleMedium: ole(textStyle: textTheme.titleMedium),
      titleSmall: ole(textStyle: textTheme.titleSmall),
      bodyLarge: ole(textStyle: textTheme.bodyLarge),
      bodyMedium: ole(textStyle: textTheme.bodyMedium),
      bodySmall: ole(textStyle: textTheme.bodySmall),
      labelLarge: ole(textStyle: textTheme.labelLarge),
      labelMedium: ole(textStyle: textTheme.labelMedium),
      labelSmall: ole(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Oleo Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oleo+Script
  static TextStyle oleoScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f4319c5d4f56ab0df7d0fe203c8077e0369fc2cebdc6fc1f0e16f908126c1c4',
        32472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '96a91a861461d5a30b52f49f8f1e260a2076fd68fcf9803c5ff7f6a2a77a0fcb',
        32108,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OleoScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Oleo Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oleo+Script
  static TextTheme oleoScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: oleoScript(textStyle: textTheme.displayLarge),
      displayMedium: oleoScript(textStyle: textTheme.displayMedium),
      displaySmall: oleoScript(textStyle: textTheme.displaySmall),
      headlineLarge: oleoScript(textStyle: textTheme.headlineLarge),
      headlineMedium: oleoScript(textStyle: textTheme.headlineMedium),
      headlineSmall: oleoScript(textStyle: textTheme.headlineSmall),
      titleLarge: oleoScript(textStyle: textTheme.titleLarge),
      titleMedium: oleoScript(textStyle: textTheme.titleMedium),
      titleSmall: oleoScript(textStyle: textTheme.titleSmall),
      bodyLarge: oleoScript(textStyle: textTheme.bodyLarge),
      bodyMedium: oleoScript(textStyle: textTheme.bodyMedium),
      bodySmall: oleoScript(textStyle: textTheme.bodySmall),
      labelLarge: oleoScript(textStyle: textTheme.labelLarge),
      labelMedium: oleoScript(textStyle: textTheme.labelMedium),
      labelSmall: oleoScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Oleo Script Swash Caps font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oleo+Script+Swash+Caps
  static TextStyle oleoScriptSwashCaps({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ce2c9a4990ae5d4406bde1a4564bc68d06f449c440ed620fc8f3512c7a73e12',
        37500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c02d2cb9f21d10bd74c598b8042f60c8e82d9a7c8eb45cc55b82a02229dcceee',
        37232,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OleoScriptSwashCaps',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Oleo Script Swash Caps font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oleo+Script+Swash+Caps
  static TextTheme oleoScriptSwashCapsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: oleoScriptSwashCaps(textStyle: textTheme.displayLarge),
      displayMedium: oleoScriptSwashCaps(textStyle: textTheme.displayMedium),
      displaySmall: oleoScriptSwashCaps(textStyle: textTheme.displaySmall),
      headlineLarge: oleoScriptSwashCaps(textStyle: textTheme.headlineLarge),
      headlineMedium: oleoScriptSwashCaps(textStyle: textTheme.headlineMedium),
      headlineSmall: oleoScriptSwashCaps(textStyle: textTheme.headlineSmall),
      titleLarge: oleoScriptSwashCaps(textStyle: textTheme.titleLarge),
      titleMedium: oleoScriptSwashCaps(textStyle: textTheme.titleMedium),
      titleSmall: oleoScriptSwashCaps(textStyle: textTheme.titleSmall),
      bodyLarge: oleoScriptSwashCaps(textStyle: textTheme.bodyLarge),
      bodyMedium: oleoScriptSwashCaps(textStyle: textTheme.bodyMedium),
      bodySmall: oleoScriptSwashCaps(textStyle: textTheme.bodySmall),
      labelLarge: oleoScriptSwashCaps(textStyle: textTheme.labelLarge),
      labelMedium: oleoScriptSwashCaps(textStyle: textTheme.labelMedium),
      labelSmall: oleoScriptSwashCaps(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Oooh Baby font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oooh+Baby
  static TextStyle ooohBaby({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a8ae600034afd0207126087f5c13114d49f0ce1d6b6ac91a1ea97168540256b6',
        88552,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OoohBaby',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Oooh Baby font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oooh+Baby
  static TextTheme ooohBabyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ooohBaby(textStyle: textTheme.displayLarge),
      displayMedium: ooohBaby(textStyle: textTheme.displayMedium),
      displaySmall: ooohBaby(textStyle: textTheme.displaySmall),
      headlineLarge: ooohBaby(textStyle: textTheme.headlineLarge),
      headlineMedium: ooohBaby(textStyle: textTheme.headlineMedium),
      headlineSmall: ooohBaby(textStyle: textTheme.headlineSmall),
      titleLarge: ooohBaby(textStyle: textTheme.titleLarge),
      titleMedium: ooohBaby(textStyle: textTheme.titleMedium),
      titleSmall: ooohBaby(textStyle: textTheme.titleSmall),
      bodyLarge: ooohBaby(textStyle: textTheme.bodyLarge),
      bodyMedium: ooohBaby(textStyle: textTheme.bodyMedium),
      bodySmall: ooohBaby(textStyle: textTheme.bodySmall),
      labelLarge: ooohBaby(textStyle: textTheme.labelLarge),
      labelMedium: ooohBaby(textStyle: textTheme.labelMedium),
      labelSmall: ooohBaby(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Open Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Open+Sans
  static TextStyle openSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a814fecad98871b77773b3358e64bdace7f179916110ff8d28bcdbaa67924169',
        98516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '889e572c297684af03397f282fe91258be815f8e5eee5f0b04ed123315213997',
        98532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5e57dd001086fd6df425c5d9a2fd1c11549bd2cd18c5b74357b1b3861110919',
        98676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d1cd4d2051cca550bbe7df637cf943db610a4bc84e3cb57cc3087f5532c5dc4',
        98456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '792bdd679ace71e7b4601633e944a3b346e217bc7d7a965a572bf89cfe556450',
        98548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30a5ebcba21117f21796d93dd34f554c30be4d11745022e07ff39bba0ad687d9',
        98964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '17bcb76eb7550dbde7d931cd7c391804dd147132ef18662e1f6188deb51adca7',
        104120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3d1c217313112b14ff11be1a0f317055b5c540d8065dee540ad60b0469b0648c',
        103820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1c9c3d5e209f7fd27a122c6eea30bcdc07d83c0856085769e65d9a7b0efa607d',
        104008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2837a9033bcc1a0b86f6089c9a7c4a7eac65dabb4864c16582214048e2febd23',
        103980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '48ab27fb65881ad0bd6f0fda2b25e424fdb7329651b58cea0b1f3f381e3975af',
        103572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '09b2e65134f891d1c7b60269c7c9e07da8b6d18f6a58d4907a667a2f6e72dd5e',
        104148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OpenSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Open Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Open+Sans
  static TextTheme openSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: openSans(textStyle: textTheme.displayLarge),
      displayMedium: openSans(textStyle: textTheme.displayMedium),
      displaySmall: openSans(textStyle: textTheme.displaySmall),
      headlineLarge: openSans(textStyle: textTheme.headlineLarge),
      headlineMedium: openSans(textStyle: textTheme.headlineMedium),
      headlineSmall: openSans(textStyle: textTheme.headlineSmall),
      titleLarge: openSans(textStyle: textTheme.titleLarge),
      titleMedium: openSans(textStyle: textTheme.titleMedium),
      titleSmall: openSans(textStyle: textTheme.titleSmall),
      bodyLarge: openSans(textStyle: textTheme.bodyLarge),
      bodyMedium: openSans(textStyle: textTheme.bodyMedium),
      bodySmall: openSans(textStyle: textTheme.bodySmall),
      labelLarge: openSans(textStyle: textTheme.labelLarge),
      labelMedium: openSans(textStyle: textTheme.labelMedium),
      labelSmall: openSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Open Sans Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Open+Sans+Condensed
  static TextStyle openSansCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '534179e03aadc7717b088745a09c21f98cd3947bad7f1ae5642eb554b0e99adf',
        62392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0a4c01cd5c43ec0ba40be8d2d99bba9b83697264185b95ea884b8dcb0eb13a66',
        66248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c81d3d6556ebd5e15a18aff55e53cc40e0de66a2109eb60d54866c6ffefadd0e',
        99144,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OpenSansCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Open Sans Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Open+Sans+Condensed
  static TextTheme openSansCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: openSansCondensed(textStyle: textTheme.displayLarge),
      displayMedium: openSansCondensed(textStyle: textTheme.displayMedium),
      displaySmall: openSansCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: openSansCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: openSansCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: openSansCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: openSansCondensed(textStyle: textTheme.titleLarge),
      titleMedium: openSansCondensed(textStyle: textTheme.titleMedium),
      titleSmall: openSansCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: openSansCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: openSansCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: openSansCondensed(textStyle: textTheme.bodySmall),
      labelLarge: openSansCondensed(textStyle: textTheme.labelLarge),
      labelMedium: openSansCondensed(textStyle: textTheme.labelMedium),
      labelSmall: openSansCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Oranienbaum font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oranienbaum
  static TextStyle oranienbaum({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc639ee95e1c8b5bbd81926863c3a9dab47ba3a7091c9988e55db5c4fdbd9c30',
        54820,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Oranienbaum',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Oranienbaum font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oranienbaum
  static TextTheme oranienbaumTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: oranienbaum(textStyle: textTheme.displayLarge),
      displayMedium: oranienbaum(textStyle: textTheme.displayMedium),
      displaySmall: oranienbaum(textStyle: textTheme.displaySmall),
      headlineLarge: oranienbaum(textStyle: textTheme.headlineLarge),
      headlineMedium: oranienbaum(textStyle: textTheme.headlineMedium),
      headlineSmall: oranienbaum(textStyle: textTheme.headlineSmall),
      titleLarge: oranienbaum(textStyle: textTheme.titleLarge),
      titleMedium: oranienbaum(textStyle: textTheme.titleMedium),
      titleSmall: oranienbaum(textStyle: textTheme.titleSmall),
      bodyLarge: oranienbaum(textStyle: textTheme.bodyLarge),
      bodyMedium: oranienbaum(textStyle: textTheme.bodyMedium),
      bodySmall: oranienbaum(textStyle: textTheme.bodySmall),
      labelLarge: oranienbaum(textStyle: textTheme.labelLarge),
      labelMedium: oranienbaum(textStyle: textTheme.labelMedium),
      labelSmall: oranienbaum(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Orbit font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Orbit
  static TextStyle orbit({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25045d62a4a6782039dfcb7493ebcfd4f4f84fa801598125440dbd774fed53f6',
        424200,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Orbit',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Orbit font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Orbit
  static TextTheme orbitTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: orbit(textStyle: textTheme.displayLarge),
      displayMedium: orbit(textStyle: textTheme.displayMedium),
      displaySmall: orbit(textStyle: textTheme.displaySmall),
      headlineLarge: orbit(textStyle: textTheme.headlineLarge),
      headlineMedium: orbit(textStyle: textTheme.headlineMedium),
      headlineSmall: orbit(textStyle: textTheme.headlineSmall),
      titleLarge: orbit(textStyle: textTheme.titleLarge),
      titleMedium: orbit(textStyle: textTheme.titleMedium),
      titleSmall: orbit(textStyle: textTheme.titleSmall),
      bodyLarge: orbit(textStyle: textTheme.bodyLarge),
      bodyMedium: orbit(textStyle: textTheme.bodyMedium),
      bodySmall: orbit(textStyle: textTheme.bodySmall),
      labelLarge: orbit(textStyle: textTheme.labelLarge),
      labelMedium: orbit(textStyle: textTheme.labelMedium),
      labelSmall: orbit(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Orbitron font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Orbitron
  static TextStyle orbitron({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a774a4b363014aa3291679941520090d74cd0037d32063197ee356b7da3560f3',
        17728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cfb4dfbc67171d3dba77d2bb56ccdfc8ae7910bfee821af5efba9e6f036f2f7a',
        17776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3f86bf536664f61ed844266b4e48312be08050d596a471d00191736e4a2a1e1',
        17772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c3fa971c5845c6ac9ea72144c267ceeb345f838bb0cc89e9ce62bde3189c033',
        17684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'feb17e09e85423c53a36cce8fd761667ab5900432b30a4f2d8d75dc7bb6c0ce2',
        17744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8295e5022201292b21cda417062667442262c23e7d3d5f61ca80e845e44a49a8',
        16860,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Orbitron',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Orbitron font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Orbitron
  static TextTheme orbitronTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: orbitron(textStyle: textTheme.displayLarge),
      displayMedium: orbitron(textStyle: textTheme.displayMedium),
      displaySmall: orbitron(textStyle: textTheme.displaySmall),
      headlineLarge: orbitron(textStyle: textTheme.headlineLarge),
      headlineMedium: orbitron(textStyle: textTheme.headlineMedium),
      headlineSmall: orbitron(textStyle: textTheme.headlineSmall),
      titleLarge: orbitron(textStyle: textTheme.titleLarge),
      titleMedium: orbitron(textStyle: textTheme.titleMedium),
      titleSmall: orbitron(textStyle: textTheme.titleSmall),
      bodyLarge: orbitron(textStyle: textTheme.bodyLarge),
      bodyMedium: orbitron(textStyle: textTheme.bodyMedium),
      bodySmall: orbitron(textStyle: textTheme.bodySmall),
      labelLarge: orbitron(textStyle: textTheme.labelLarge),
      labelMedium: orbitron(textStyle: textTheme.labelMedium),
      labelSmall: orbitron(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Oregano font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oregano
  static TextStyle oregano({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '237b48a5205150503c26b448609b474bf912f5245cd7cf486e15d6744fb9ea04',
        77008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e04ae34d8b387a023056ba6d1dcc01dc2c6aecfd68e80cd9bf0a2348f35a4cbd',
        82860,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Oregano',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Oregano font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oregano
  static TextTheme oreganoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: oregano(textStyle: textTheme.displayLarge),
      displayMedium: oregano(textStyle: textTheme.displayMedium),
      displaySmall: oregano(textStyle: textTheme.displaySmall),
      headlineLarge: oregano(textStyle: textTheme.headlineLarge),
      headlineMedium: oregano(textStyle: textTheme.headlineMedium),
      headlineSmall: oregano(textStyle: textTheme.headlineSmall),
      titleLarge: oregano(textStyle: textTheme.titleLarge),
      titleMedium: oregano(textStyle: textTheme.titleMedium),
      titleSmall: oregano(textStyle: textTheme.titleSmall),
      bodyLarge: oregano(textStyle: textTheme.bodyLarge),
      bodyMedium: oregano(textStyle: textTheme.bodyMedium),
      bodySmall: oregano(textStyle: textTheme.bodySmall),
      labelLarge: oregano(textStyle: textTheme.labelLarge),
      labelMedium: oregano(textStyle: textTheme.labelMedium),
      labelSmall: oregano(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Orelega One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Orelega+One
  static TextStyle orelegaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '847d2bbc05eae59d2c462cf77e64437fbd5217814c5e8357d9b91c7dc93d6120',
        83528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OrelegaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Orelega One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Orelega+One
  static TextTheme orelegaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: orelegaOne(textStyle: textTheme.displayLarge),
      displayMedium: orelegaOne(textStyle: textTheme.displayMedium),
      displaySmall: orelegaOne(textStyle: textTheme.displaySmall),
      headlineLarge: orelegaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: orelegaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: orelegaOne(textStyle: textTheme.headlineSmall),
      titleLarge: orelegaOne(textStyle: textTheme.titleLarge),
      titleMedium: orelegaOne(textStyle: textTheme.titleMedium),
      titleSmall: orelegaOne(textStyle: textTheme.titleSmall),
      bodyLarge: orelegaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: orelegaOne(textStyle: textTheme.bodyMedium),
      bodySmall: orelegaOne(textStyle: textTheme.bodySmall),
      labelLarge: orelegaOne(textStyle: textTheme.labelLarge),
      labelMedium: orelegaOne(textStyle: textTheme.labelMedium),
      labelSmall: orelegaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Orienta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Orienta
  static TextStyle orienta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6bd67bc62c6a11bf4e8207ff2f959548958c7005d34032db63869ed63ae3ffe',
        35632,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Orienta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Orienta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Orienta
  static TextTheme orientaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: orienta(textStyle: textTheme.displayLarge),
      displayMedium: orienta(textStyle: textTheme.displayMedium),
      displaySmall: orienta(textStyle: textTheme.displaySmall),
      headlineLarge: orienta(textStyle: textTheme.headlineLarge),
      headlineMedium: orienta(textStyle: textTheme.headlineMedium),
      headlineSmall: orienta(textStyle: textTheme.headlineSmall),
      titleLarge: orienta(textStyle: textTheme.titleLarge),
      titleMedium: orienta(textStyle: textTheme.titleMedium),
      titleSmall: orienta(textStyle: textTheme.titleSmall),
      bodyLarge: orienta(textStyle: textTheme.bodyLarge),
      bodyMedium: orienta(textStyle: textTheme.bodyMedium),
      bodySmall: orienta(textStyle: textTheme.bodySmall),
      labelLarge: orienta(textStyle: textTheme.labelLarge),
      labelMedium: orienta(textStyle: textTheme.labelMedium),
      labelSmall: orienta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Original Surfer font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Original+Surfer
  static TextStyle originalSurfer({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0155e525729bb3ce1ae1f6d0e2262e1e3fdd30b47b1cd8c255d903dbfdfeaad1',
        55208,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OriginalSurfer',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Original Surfer font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Original+Surfer
  static TextTheme originalSurferTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: originalSurfer(textStyle: textTheme.displayLarge),
      displayMedium: originalSurfer(textStyle: textTheme.displayMedium),
      displaySmall: originalSurfer(textStyle: textTheme.displaySmall),
      headlineLarge: originalSurfer(textStyle: textTheme.headlineLarge),
      headlineMedium: originalSurfer(textStyle: textTheme.headlineMedium),
      headlineSmall: originalSurfer(textStyle: textTheme.headlineSmall),
      titleLarge: originalSurfer(textStyle: textTheme.titleLarge),
      titleMedium: originalSurfer(textStyle: textTheme.titleMedium),
      titleSmall: originalSurfer(textStyle: textTheme.titleSmall),
      bodyLarge: originalSurfer(textStyle: textTheme.bodyLarge),
      bodyMedium: originalSurfer(textStyle: textTheme.bodyMedium),
      bodySmall: originalSurfer(textStyle: textTheme.bodySmall),
      labelLarge: originalSurfer(textStyle: textTheme.labelLarge),
      labelMedium: originalSurfer(textStyle: textTheme.labelMedium),
      labelSmall: originalSurfer(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Oswald font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oswald
  static TextStyle oswald({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd06b9f0de4b45d531c525aba8b75b306956c57d680bc75054a1617258223767f',
        86024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd4f83b7eb6f7f055075d49e0d351473a00621c2be4b8e1d5e7c330b5f2ef23b7',
        86288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '681ce58086b45449b1c6896b52a8177b593e845cc2b8651cab2cd7d061727d2b',
        86044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '766bfb7613fd305e42d2d892c69b930dcec406e7fa1b5daa7706f7bcb44ceec3',
        86404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ffa7662ec0982e4715e6317a876eacbe8b142a0179b95d3c0dc48fb0feecc41e',
        86420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '906b5ac6cdd32ef321357c94a6e0e271fd3582351df027cf1dc06d729e4af120',
        86392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Oswald',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Oswald font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oswald
  static TextTheme oswaldTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: oswald(textStyle: textTheme.displayLarge),
      displayMedium: oswald(textStyle: textTheme.displayMedium),
      displaySmall: oswald(textStyle: textTheme.displaySmall),
      headlineLarge: oswald(textStyle: textTheme.headlineLarge),
      headlineMedium: oswald(textStyle: textTheme.headlineMedium),
      headlineSmall: oswald(textStyle: textTheme.headlineSmall),
      titleLarge: oswald(textStyle: textTheme.titleLarge),
      titleMedium: oswald(textStyle: textTheme.titleMedium),
      titleSmall: oswald(textStyle: textTheme.titleSmall),
      bodyLarge: oswald(textStyle: textTheme.bodyLarge),
      bodyMedium: oswald(textStyle: textTheme.bodyMedium),
      bodySmall: oswald(textStyle: textTheme.bodySmall),
      labelLarge: oswald(textStyle: textTheme.labelLarge),
      labelMedium: oswald(textStyle: textTheme.labelMedium),
      labelSmall: oswald(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Outfit font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Outfit
  static TextStyle outfit({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7862cd4b53431575b32ae6509a15cb714d274bde8088481d858a1795cd7b7c0e',
        47520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ffb3337923f8f928ad02b0ed5170bc6d3f57595453b0e8fd2d822552c06fd9eb',
        47872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd50dc4a5ec5b238e67bd0ca121356315cec4f7bceaebb9cc68b3c7b88be34427',
        47792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b667551a8e7d406c089cb2fdf754f2fddfb1dc256a33fcc06c690965c6b9d5d7',
        47820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '593c02128a0077461e58f5c86a2432a3894ad365c8302f13120fc17b2c4aad88',
        47776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b9c6753e282f674c8acfa64c24eba2057c1c123830595cba4e3adbf8c5e9f24',
        48432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d3a851bbdbcef9f4e7bbee2ffdb74271a80d745c40dbb68888e5759d5976477',
        48316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95f91a67031e82a8ddcdbac44fcf4fff74e58f1e017f1759f90087390922f14a',
        48248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f1d36e271d33f7c75eca8ea0c0192635ae255c4b0d39fb5a49779f42a53bcdb7',
        48300,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Outfit',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Outfit font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Outfit
  static TextTheme outfitTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: outfit(textStyle: textTheme.displayLarge),
      displayMedium: outfit(textStyle: textTheme.displayMedium),
      displaySmall: outfit(textStyle: textTheme.displaySmall),
      headlineLarge: outfit(textStyle: textTheme.headlineLarge),
      headlineMedium: outfit(textStyle: textTheme.headlineMedium),
      headlineSmall: outfit(textStyle: textTheme.headlineSmall),
      titleLarge: outfit(textStyle: textTheme.titleLarge),
      titleMedium: outfit(textStyle: textTheme.titleMedium),
      titleSmall: outfit(textStyle: textTheme.titleSmall),
      bodyLarge: outfit(textStyle: textTheme.bodyLarge),
      bodyMedium: outfit(textStyle: textTheme.bodyMedium),
      bodySmall: outfit(textStyle: textTheme.bodySmall),
      labelLarge: outfit(textStyle: textTheme.labelLarge),
      labelMedium: outfit(textStyle: textTheme.labelMedium),
      labelSmall: outfit(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Over the Rainbow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Over+the+Rainbow
  static TextStyle overTheRainbow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47d0d207fa65850d1c7fddcee1b4ca60b7b89fe243c3e2406c18152db7f192a1',
        43704,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OvertheRainbow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Over the Rainbow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Over+the+Rainbow
  static TextTheme overTheRainbowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: overTheRainbow(textStyle: textTheme.displayLarge),
      displayMedium: overTheRainbow(textStyle: textTheme.displayMedium),
      displaySmall: overTheRainbow(textStyle: textTheme.displaySmall),
      headlineLarge: overTheRainbow(textStyle: textTheme.headlineLarge),
      headlineMedium: overTheRainbow(textStyle: textTheme.headlineMedium),
      headlineSmall: overTheRainbow(textStyle: textTheme.headlineSmall),
      titleLarge: overTheRainbow(textStyle: textTheme.titleLarge),
      titleMedium: overTheRainbow(textStyle: textTheme.titleMedium),
      titleSmall: overTheRainbow(textStyle: textTheme.titleSmall),
      bodyLarge: overTheRainbow(textStyle: textTheme.bodyLarge),
      bodyMedium: overTheRainbow(textStyle: textTheme.bodyMedium),
      bodySmall: overTheRainbow(textStyle: textTheme.bodySmall),
      labelLarge: overTheRainbow(textStyle: textTheme.labelLarge),
      labelMedium: overTheRainbow(textStyle: textTheme.labelMedium),
      labelSmall: overTheRainbow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Overlock font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Overlock
  static TextStyle overlock({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d548e35f88ac197d59305e675bfef60d00c7f609344b0cebf999051db17d76a',
        44008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e33489bbcff6e2986233dd66d6edc73b19b51bb070abd16bdf826c3b94df25ad',
        37456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36dec46a588ac846fdd5fc2753dded61f26297799dc6dc1c495adcf6600b8d84',
        36948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd3a73a37dbce9ed7b2e4db57dba916bc851c360bb2775850242b48a032d4dcbf',
        39084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87d61ac5966d9c83d6a9875aa9ac682bc899743b4d46bfbbcdc14260f6955099',
        37672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bad5154d63cf61489b68d14096ed2e01c0272e0e41c53d85002df37cbedd23bc',
        37452,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Overlock',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Overlock font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Overlock
  static TextTheme overlockTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: overlock(textStyle: textTheme.displayLarge),
      displayMedium: overlock(textStyle: textTheme.displayMedium),
      displaySmall: overlock(textStyle: textTheme.displaySmall),
      headlineLarge: overlock(textStyle: textTheme.headlineLarge),
      headlineMedium: overlock(textStyle: textTheme.headlineMedium),
      headlineSmall: overlock(textStyle: textTheme.headlineSmall),
      titleLarge: overlock(textStyle: textTheme.titleLarge),
      titleMedium: overlock(textStyle: textTheme.titleMedium),
      titleSmall: overlock(textStyle: textTheme.titleSmall),
      bodyLarge: overlock(textStyle: textTheme.bodyLarge),
      bodyMedium: overlock(textStyle: textTheme.bodyMedium),
      bodySmall: overlock(textStyle: textTheme.bodySmall),
      labelLarge: overlock(textStyle: textTheme.labelLarge),
      labelMedium: overlock(textStyle: textTheme.labelMedium),
      labelSmall: overlock(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Overlock SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Overlock+SC
  static TextStyle overlockSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aedda7344b0e018cc177a54bdb830216ab3157e0dce6c96a0a3fc949c4a930e5',
        34584,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OverlockSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Overlock SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Overlock+SC
  static TextTheme overlockScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: overlockSc(textStyle: textTheme.displayLarge),
      displayMedium: overlockSc(textStyle: textTheme.displayMedium),
      displaySmall: overlockSc(textStyle: textTheme.displaySmall),
      headlineLarge: overlockSc(textStyle: textTheme.headlineLarge),
      headlineMedium: overlockSc(textStyle: textTheme.headlineMedium),
      headlineSmall: overlockSc(textStyle: textTheme.headlineSmall),
      titleLarge: overlockSc(textStyle: textTheme.titleLarge),
      titleMedium: overlockSc(textStyle: textTheme.titleMedium),
      titleSmall: overlockSc(textStyle: textTheme.titleSmall),
      bodyLarge: overlockSc(textStyle: textTheme.bodyLarge),
      bodyMedium: overlockSc(textStyle: textTheme.bodyMedium),
      bodySmall: overlockSc(textStyle: textTheme.bodySmall),
      labelLarge: overlockSc(textStyle: textTheme.labelLarge),
      labelMedium: overlockSc(textStyle: textTheme.labelMedium),
      labelSmall: overlockSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Overpass font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Overpass
  static TextStyle overpass({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd43d02088c3fe9dbbb3d8bb00b94beec2f03a6adf010419ff0754165b99068e4',
        163536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fdd2b7d9b8f444d71ada561c2aee318967f1a579b60b846dc866d39fcf1a94e',
        164300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee8102561bbd1f4106a646ab1bb9dd32466f516777a853967e67f6539efa01ae',
        164276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '441c94488ed963320f54765e04bf6a2e96b72e199971930f620453a433c63af8',
        164096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '538462d207ad7c113053cf080a32f5ad7c57dcd29b3c2f70945deeb95bf10cd7',
        164228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fadc641d5e232657605b702bb978701b5f854cba52fe33e0f17c0a28bb27273b',
        163916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83b70d07d479eb8c712a57e083875cd16b7b97060f2372e6f628c49d4f806e70',
        164204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4dc437832bb0952c5a904f48b6656722170d18c0fb5710ed814d49847c62b969',
        163580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '91f9cc13cb9ea7e50211e2daed8424c1aba219ad9d1dfcc1e66d81bda20c32e1',
        163508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c04c1e93ea4de294e5f178e459206e66c5676c25e8ac26bf2f786e2ffe34b2e7',
        148024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b868de065b91cff146f797c58cd378aaf2b7471d93e2a620618b9f82328f81f8',
        148148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0de4d69355e8f8164a53aaff68d3c594494f48837559e2570ac2b55723ce3ce5',
        148064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'de437b4bc20e161cf57818927b97548f0c7e5fee4f1f7b52b2712fe65d16d15e',
        147796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '97769880e33f78cf086e379cb8d2df70e0ab5db3a71f640dfbd7b644aee80860',
        147960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1b8216528e38a5ce76a7fb5c1e422d44529784e4ebc720444e6186211860df36',
        148040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b788153cc6ee50ac9206d6dbfea6165358b57f65400839326a6f9c8850eb5e6c',
        148044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '662430aae8f37475aea669895feb96bbcea25bb0c98174a4901261c6ea05d927',
        148624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4444ae1b5f2ce642a0a70ceb04a97061ea296612e1d47736c37fc26a306254e7',
        148616,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Overpass',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Overpass font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Overpass
  static TextTheme overpassTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: overpass(textStyle: textTheme.displayLarge),
      displayMedium: overpass(textStyle: textTheme.displayMedium),
      displaySmall: overpass(textStyle: textTheme.displaySmall),
      headlineLarge: overpass(textStyle: textTheme.headlineLarge),
      headlineMedium: overpass(textStyle: textTheme.headlineMedium),
      headlineSmall: overpass(textStyle: textTheme.headlineSmall),
      titleLarge: overpass(textStyle: textTheme.titleLarge),
      titleMedium: overpass(textStyle: textTheme.titleMedium),
      titleSmall: overpass(textStyle: textTheme.titleSmall),
      bodyLarge: overpass(textStyle: textTheme.bodyLarge),
      bodyMedium: overpass(textStyle: textTheme.bodyMedium),
      bodySmall: overpass(textStyle: textTheme.bodySmall),
      labelLarge: overpass(textStyle: textTheme.labelLarge),
      labelMedium: overpass(textStyle: textTheme.labelMedium),
      labelSmall: overpass(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Overpass Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Overpass+Mono
  static TextStyle overpassMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28284639a6cc49f56b8012e7527b520a6bc7bd87dd6baeffac746e7a74419323',
        173604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25d7f740f2fd31eaf6cb9c1a3995a51e9613ec3580faeaf1c2c6aacde18a3c06',
        174328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f02d7e9f289cb7916dcbf6da2dd55170084426f8cb4fd89c15c5c34aa83924f',
        174328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5977661019a80fb791d4fc51296668b4ec70785307fcb28429507307f67d1748',
        174272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa4758f2455ed59830a11b70e267ab3e0e7ee4ebf0a523739a9db941831cd493',
        174252,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OverpassMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Overpass Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Overpass+Mono
  static TextTheme overpassMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: overpassMono(textStyle: textTheme.displayLarge),
      displayMedium: overpassMono(textStyle: textTheme.displayMedium),
      displaySmall: overpassMono(textStyle: textTheme.displaySmall),
      headlineLarge: overpassMono(textStyle: textTheme.headlineLarge),
      headlineMedium: overpassMono(textStyle: textTheme.headlineMedium),
      headlineSmall: overpassMono(textStyle: textTheme.headlineSmall),
      titleLarge: overpassMono(textStyle: textTheme.titleLarge),
      titleMedium: overpassMono(textStyle: textTheme.titleMedium),
      titleSmall: overpassMono(textStyle: textTheme.titleSmall),
      bodyLarge: overpassMono(textStyle: textTheme.bodyLarge),
      bodyMedium: overpassMono(textStyle: textTheme.bodyMedium),
      bodySmall: overpassMono(textStyle: textTheme.bodySmall),
      labelLarge: overpassMono(textStyle: textTheme.labelLarge),
      labelMedium: overpassMono(textStyle: textTheme.labelMedium),
      labelSmall: overpassMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ovo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ovo
  static TextStyle ovo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4772ff76175118698e1b8a1609662571ac66c152abfa0df326ebe51891f43024',
        46140,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ovo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ovo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ovo
  static TextTheme ovoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ovo(textStyle: textTheme.displayLarge),
      displayMedium: ovo(textStyle: textTheme.displayMedium),
      displaySmall: ovo(textStyle: textTheme.displaySmall),
      headlineLarge: ovo(textStyle: textTheme.headlineLarge),
      headlineMedium: ovo(textStyle: textTheme.headlineMedium),
      headlineSmall: ovo(textStyle: textTheme.headlineSmall),
      titleLarge: ovo(textStyle: textTheme.titleLarge),
      titleMedium: ovo(textStyle: textTheme.titleMedium),
      titleSmall: ovo(textStyle: textTheme.titleSmall),
      bodyLarge: ovo(textStyle: textTheme.bodyLarge),
      bodyMedium: ovo(textStyle: textTheme.bodyMedium),
      bodySmall: ovo(textStyle: textTheme.bodySmall),
      labelLarge: ovo(textStyle: textTheme.labelLarge),
      labelMedium: ovo(textStyle: textTheme.labelMedium),
      labelSmall: ovo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Oxanium font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oxanium
  static TextStyle oxanium({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40e7f2bb98b9ad93ca059f873260b99b1acb2c8dd7a1e3083b6042e9f49f5458',
        24784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7af395177a42535934b6276c4e4d360443fcd6e77e78ff88c0b59c7dfb16e4b0',
        24716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd73d138dbf1145a7b4838809e74c200a0882663a2d519fcc7334444bce69770',
        24644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7942d0bc5d6c0714707c650bd0a114b3a0e40edaea1bbab00a26bc1d453fe5ec',
        24696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e398a361b2e047692ece66bd8a188839a1ff653046c6e9329fb99c85afdf2c0',
        24692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db2340ef59d4d7d143440252f3e7777e0a85673734bf1d53af65f22595cf9be6',
        24604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c6febc72f0478f1a765ea6bd704b960bf391b918d9ba5550edbc3e37a1f3924',
        24668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Oxanium',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Oxanium font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oxanium
  static TextTheme oxaniumTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: oxanium(textStyle: textTheme.displayLarge),
      displayMedium: oxanium(textStyle: textTheme.displayMedium),
      displaySmall: oxanium(textStyle: textTheme.displaySmall),
      headlineLarge: oxanium(textStyle: textTheme.headlineLarge),
      headlineMedium: oxanium(textStyle: textTheme.headlineMedium),
      headlineSmall: oxanium(textStyle: textTheme.headlineSmall),
      titleLarge: oxanium(textStyle: textTheme.titleLarge),
      titleMedium: oxanium(textStyle: textTheme.titleMedium),
      titleSmall: oxanium(textStyle: textTheme.titleSmall),
      bodyLarge: oxanium(textStyle: textTheme.bodyLarge),
      bodyMedium: oxanium(textStyle: textTheme.bodyMedium),
      bodySmall: oxanium(textStyle: textTheme.bodySmall),
      labelLarge: oxanium(textStyle: textTheme.labelLarge),
      labelMedium: oxanium(textStyle: textTheme.labelMedium),
      labelSmall: oxanium(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Oxygen font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oxygen
  static TextStyle oxygen({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b245cc38abd24040a6e60edb56f333ef31497e3c1589e1de95633fd9811ce2b',
        25588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '018516876dd67d3188322375bd244200747d26c662efc13f53bc3c0d650e19c1',
        27320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85b6744c65824ca40e9bd4ec53dc540041328c8af66f65c1a5c41d09045bca47',
        28184,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Oxygen',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Oxygen font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oxygen
  static TextTheme oxygenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: oxygen(textStyle: textTheme.displayLarge),
      displayMedium: oxygen(textStyle: textTheme.displayMedium),
      displaySmall: oxygen(textStyle: textTheme.displaySmall),
      headlineLarge: oxygen(textStyle: textTheme.headlineLarge),
      headlineMedium: oxygen(textStyle: textTheme.headlineMedium),
      headlineSmall: oxygen(textStyle: textTheme.headlineSmall),
      titleLarge: oxygen(textStyle: textTheme.titleLarge),
      titleMedium: oxygen(textStyle: textTheme.titleMedium),
      titleSmall: oxygen(textStyle: textTheme.titleSmall),
      bodyLarge: oxygen(textStyle: textTheme.bodyLarge),
      bodyMedium: oxygen(textStyle: textTheme.bodyMedium),
      bodySmall: oxygen(textStyle: textTheme.bodySmall),
      labelLarge: oxygen(textStyle: textTheme.labelLarge),
      labelMedium: oxygen(textStyle: textTheme.labelMedium),
      labelSmall: oxygen(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Oxygen Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oxygen+Mono
  static TextStyle oxygenMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac90c4df99bc15f74876ec69f50382dc704fcef51ab85c458d43ad1736c7c060',
        26340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'OxygenMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Oxygen Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Oxygen+Mono
  static TextTheme oxygenMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: oxygenMono(textStyle: textTheme.displayLarge),
      displayMedium: oxygenMono(textStyle: textTheme.displayMedium),
      displaySmall: oxygenMono(textStyle: textTheme.displaySmall),
      headlineLarge: oxygenMono(textStyle: textTheme.headlineLarge),
      headlineMedium: oxygenMono(textStyle: textTheme.headlineMedium),
      headlineSmall: oxygenMono(textStyle: textTheme.headlineSmall),
      titleLarge: oxygenMono(textStyle: textTheme.titleLarge),
      titleMedium: oxygenMono(textStyle: textTheme.titleMedium),
      titleSmall: oxygenMono(textStyle: textTheme.titleSmall),
      bodyLarge: oxygenMono(textStyle: textTheme.bodyLarge),
      bodyMedium: oxygenMono(textStyle: textTheme.bodyMedium),
      bodySmall: oxygenMono(textStyle: textTheme.bodySmall),
      labelLarge: oxygenMono(textStyle: textTheme.labelLarge),
      labelMedium: oxygenMono(textStyle: textTheme.labelMedium),
      labelSmall: oxygenMono(textStyle: textTheme.labelSmall),
    );
  }
}
