// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'L'.
class PartL {
  /// Applies the La Belle Aurore font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/La+Belle+Aurore
  static TextStyle laBelleAurore({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c06647cec39f8069c1768c7376877865f527365293d01710e6cde627c793cdef',
        44140,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LaBelleAurore',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the La Belle Aurore font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/La+Belle+Aurore
  static TextTheme laBelleAuroreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: laBelleAurore(textStyle: textTheme.displayLarge),
      displayMedium: laBelleAurore(textStyle: textTheme.displayMedium),
      displaySmall: laBelleAurore(textStyle: textTheme.displaySmall),
      headlineLarge: laBelleAurore(textStyle: textTheme.headlineLarge),
      headlineMedium: laBelleAurore(textStyle: textTheme.headlineMedium),
      headlineSmall: laBelleAurore(textStyle: textTheme.headlineSmall),
      titleLarge: laBelleAurore(textStyle: textTheme.titleLarge),
      titleMedium: laBelleAurore(textStyle: textTheme.titleMedium),
      titleSmall: laBelleAurore(textStyle: textTheme.titleSmall),
      bodyLarge: laBelleAurore(textStyle: textTheme.bodyLarge),
      bodyMedium: laBelleAurore(textStyle: textTheme.bodyMedium),
      bodySmall: laBelleAurore(textStyle: textTheme.bodySmall),
      labelLarge: laBelleAurore(textStyle: textTheme.labelLarge),
      labelMedium: laBelleAurore(textStyle: textTheme.labelMedium),
      labelSmall: laBelleAurore(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Labrada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Labrada
  static TextStyle labrada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e33d16903de0611b8efc22f6a30b03eacd2c21eacc4d0be35456f4799b7b917',
        73564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d90aa379c638f6b93b0eb2948170037c4e78d01f8773f5215c8c25750179cbd',
        73968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e34d05ccc683f8a729522c56b5ebe48fe96a9ed4285b6e89167764d3619d18f7',
        73980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c82443416269cbc26dc687a5aa90ad7503c30928567c3355a57e8517886b198d',
        73520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1fe57ad2c7956ea02f7dd927ae093d95391f13030f6adc97930e9da53e4ac35e',
        74076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c899209b9629638c0dd8d63fd964735c57f9c615af016b1b2ad8304f1e637530',
        74652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5ae2ca2663b6a7f99a65aecc0a05b29d0c1ff0f376ca0464a6a19a6faed3e79',
        74640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6695cf14558b81b67b0c86d0b4eb53c55fef69be60490f326a69168e1ce77b52',
        80496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '938a43acf661ee816b329c93f48bd61970dd2987a0069802c25cb5701a3c6bec',
        79620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5c938f5910880bcb57145ccd16a0d7a9010aaa58b959e71e4d68d49ac637eb2d',
        72576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4b645b39b96fdb7fdd1bc2900b5f4c82257d2f6c44e116ce0e0bdbb6a21f1cdc',
        72952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dc3f645ad5d74167e48d3652438031ae0cc1fe565132224c2b1f54f3c33c2b80',
        73108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f9062bd88c81bc8425fb6aef199ff8eb226a26dafba055c2a9e1e861c2f4a5ab',
        72728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1b7cc73e8156e4482bb169d37e8a7473a37d7cfe476fb336a5351e83755519f5',
        73116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd27d3306f96ec8556d0fb88b692165b6f67217955a8b1c937c5cbc01e5deb9ae',
        73236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7a65abf876ec60922f44563da756b17b2b51815359930aa05a109b57f7157f66',
        78008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4a30531865328b365a3c16607e9971a539d5d3d89075fb250bf3aca69ea0a06e',
        78148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '86e4e54fa3e6dccf52bbfd3f2e117bf29edbc7f48a1a6a55eedc8ec607450ebb',
        77740,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Labrada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Labrada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Labrada
  static TextTheme labradaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: labrada(textStyle: textTheme.displayLarge),
      displayMedium: labrada(textStyle: textTheme.displayMedium),
      displaySmall: labrada(textStyle: textTheme.displaySmall),
      headlineLarge: labrada(textStyle: textTheme.headlineLarge),
      headlineMedium: labrada(textStyle: textTheme.headlineMedium),
      headlineSmall: labrada(textStyle: textTheme.headlineSmall),
      titleLarge: labrada(textStyle: textTheme.titleLarge),
      titleMedium: labrada(textStyle: textTheme.titleMedium),
      titleSmall: labrada(textStyle: textTheme.titleSmall),
      bodyLarge: labrada(textStyle: textTheme.bodyLarge),
      bodyMedium: labrada(textStyle: textTheme.bodyMedium),
      bodySmall: labrada(textStyle: textTheme.bodySmall),
      labelLarge: labrada(textStyle: textTheme.labelLarge),
      labelMedium: labrada(textStyle: textTheme.labelMedium),
      labelSmall: labrada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lacquer font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lacquer
  static TextStyle lacquer({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bbdfb039f1c10cff70fd5b04bfe8f0fc8baa2226c1774b2f7d168c27254b69c8',
        203048,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lacquer',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lacquer font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lacquer
  static TextTheme lacquerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lacquer(textStyle: textTheme.displayLarge),
      displayMedium: lacquer(textStyle: textTheme.displayMedium),
      displaySmall: lacquer(textStyle: textTheme.displaySmall),
      headlineLarge: lacquer(textStyle: textTheme.headlineLarge),
      headlineMedium: lacquer(textStyle: textTheme.headlineMedium),
      headlineSmall: lacquer(textStyle: textTheme.headlineSmall),
      titleLarge: lacquer(textStyle: textTheme.titleLarge),
      titleMedium: lacquer(textStyle: textTheme.titleMedium),
      titleSmall: lacquer(textStyle: textTheme.titleSmall),
      bodyLarge: lacquer(textStyle: textTheme.bodyLarge),
      bodyMedium: lacquer(textStyle: textTheme.bodyMedium),
      bodySmall: lacquer(textStyle: textTheme.bodySmall),
      labelLarge: lacquer(textStyle: textTheme.labelLarge),
      labelMedium: lacquer(textStyle: textTheme.labelMedium),
      labelSmall: lacquer(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Laila font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Laila
  static TextStyle laila({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05dbe700f5e513caf8e55453c3069607b7dde637b876b29be7d089e4bbe2a4a0',
        198232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd5474ad31acd43da058c6c51f1009720b3a23f899dbc0d565c6f4702d6d34173',
        199212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1df19efb6c5a8459a3c9085514e398bebbcd12c7ae006c95cfeca343038d307b',
        197344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03a35ab5bdcbb59917dfab119084386a1bab386652918b2738f2aff6b776c008',
        197216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c55c2f37201597af087329a7bc1a845e8cf88dd1006dd2af3a3b67ebf280468',
        196084,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Laila',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Laila font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Laila
  static TextTheme lailaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: laila(textStyle: textTheme.displayLarge),
      displayMedium: laila(textStyle: textTheme.displayMedium),
      displaySmall: laila(textStyle: textTheme.displaySmall),
      headlineLarge: laila(textStyle: textTheme.headlineLarge),
      headlineMedium: laila(textStyle: textTheme.headlineMedium),
      headlineSmall: laila(textStyle: textTheme.headlineSmall),
      titleLarge: laila(textStyle: textTheme.titleLarge),
      titleMedium: laila(textStyle: textTheme.titleMedium),
      titleSmall: laila(textStyle: textTheme.titleSmall),
      bodyLarge: laila(textStyle: textTheme.bodyLarge),
      bodyMedium: laila(textStyle: textTheme.bodyMedium),
      bodySmall: laila(textStyle: textTheme.bodySmall),
      labelLarge: laila(textStyle: textTheme.labelLarge),
      labelMedium: laila(textStyle: textTheme.labelMedium),
      labelSmall: laila(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lakki Reddy font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lakki+Reddy
  static TextStyle lakkiReddy({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f08fb84f2d120df6327946f8606f23beaf5c7aa0539bf271d62364b507cfc042',
        354844,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LakkiReddy',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lakki Reddy font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lakki+Reddy
  static TextTheme lakkiReddyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lakkiReddy(textStyle: textTheme.displayLarge),
      displayMedium: lakkiReddy(textStyle: textTheme.displayMedium),
      displaySmall: lakkiReddy(textStyle: textTheme.displaySmall),
      headlineLarge: lakkiReddy(textStyle: textTheme.headlineLarge),
      headlineMedium: lakkiReddy(textStyle: textTheme.headlineMedium),
      headlineSmall: lakkiReddy(textStyle: textTheme.headlineSmall),
      titleLarge: lakkiReddy(textStyle: textTheme.titleLarge),
      titleMedium: lakkiReddy(textStyle: textTheme.titleMedium),
      titleSmall: lakkiReddy(textStyle: textTheme.titleSmall),
      bodyLarge: lakkiReddy(textStyle: textTheme.bodyLarge),
      bodyMedium: lakkiReddy(textStyle: textTheme.bodyMedium),
      bodySmall: lakkiReddy(textStyle: textTheme.bodySmall),
      labelLarge: lakkiReddy(textStyle: textTheme.labelLarge),
      labelMedium: lakkiReddy(textStyle: textTheme.labelMedium),
      labelSmall: lakkiReddy(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lalezar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lalezar
  static TextStyle lalezar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1788a04c896f11a4421af62ffa29d5f2894e71f732ddd22ddfaa27a2b26a0efe',
        177672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lalezar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lalezar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lalezar
  static TextTheme lalezarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lalezar(textStyle: textTheme.displayLarge),
      displayMedium: lalezar(textStyle: textTheme.displayMedium),
      displaySmall: lalezar(textStyle: textTheme.displaySmall),
      headlineLarge: lalezar(textStyle: textTheme.headlineLarge),
      headlineMedium: lalezar(textStyle: textTheme.headlineMedium),
      headlineSmall: lalezar(textStyle: textTheme.headlineSmall),
      titleLarge: lalezar(textStyle: textTheme.titleLarge),
      titleMedium: lalezar(textStyle: textTheme.titleMedium),
      titleSmall: lalezar(textStyle: textTheme.titleSmall),
      bodyLarge: lalezar(textStyle: textTheme.bodyLarge),
      bodyMedium: lalezar(textStyle: textTheme.bodyMedium),
      bodySmall: lalezar(textStyle: textTheme.bodySmall),
      labelLarge: lalezar(textStyle: textTheme.labelLarge),
      labelMedium: lalezar(textStyle: textTheme.labelMedium),
      labelSmall: lalezar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lancelot font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lancelot
  static TextStyle lancelot({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '418d6278c97231d8c7c60f8c60653c97a2c0974b69a78767dc8b7155e30adcce',
        24412,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lancelot',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lancelot font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lancelot
  static TextTheme lancelotTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lancelot(textStyle: textTheme.displayLarge),
      displayMedium: lancelot(textStyle: textTheme.displayMedium),
      displaySmall: lancelot(textStyle: textTheme.displaySmall),
      headlineLarge: lancelot(textStyle: textTheme.headlineLarge),
      headlineMedium: lancelot(textStyle: textTheme.headlineMedium),
      headlineSmall: lancelot(textStyle: textTheme.headlineSmall),
      titleLarge: lancelot(textStyle: textTheme.titleLarge),
      titleMedium: lancelot(textStyle: textTheme.titleMedium),
      titleSmall: lancelot(textStyle: textTheme.titleSmall),
      bodyLarge: lancelot(textStyle: textTheme.bodyLarge),
      bodyMedium: lancelot(textStyle: textTheme.bodyMedium),
      bodySmall: lancelot(textStyle: textTheme.bodySmall),
      labelLarge: lancelot(textStyle: textTheme.labelLarge),
      labelMedium: lancelot(textStyle: textTheme.labelMedium),
      labelSmall: lancelot(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Langar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Langar
  static TextStyle langar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b3632d2c8c8bd37790a2c4068c50293beced62f0b77891361e8513d4625b3d3e',
        137468,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Langar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Langar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Langar
  static TextTheme langarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: langar(textStyle: textTheme.displayLarge),
      displayMedium: langar(textStyle: textTheme.displayMedium),
      displaySmall: langar(textStyle: textTheme.displaySmall),
      headlineLarge: langar(textStyle: textTheme.headlineLarge),
      headlineMedium: langar(textStyle: textTheme.headlineMedium),
      headlineSmall: langar(textStyle: textTheme.headlineSmall),
      titleLarge: langar(textStyle: textTheme.titleLarge),
      titleMedium: langar(textStyle: textTheme.titleMedium),
      titleSmall: langar(textStyle: textTheme.titleSmall),
      bodyLarge: langar(textStyle: textTheme.bodyLarge),
      bodyMedium: langar(textStyle: textTheme.bodyMedium),
      bodySmall: langar(textStyle: textTheme.bodySmall),
      labelLarge: langar(textStyle: textTheme.labelLarge),
      labelMedium: langar(textStyle: textTheme.labelMedium),
      labelSmall: langar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lateef font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lateef
  static TextStyle lateef({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4121cc149b0267076c6587f23e8a3dc828955cb8d70baa714217d20665dc3b43',
        182196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a5c22bb288de540c4492cbc52b4d2cc11dc95cc8c99d5874608b97bde3e9fe85',
        181448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '861cdd29c22f1605fba5bb76b354a6207b8f7a0c7f7d62eb1f726159f61583e3',
        182328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ea9fcaedd5e7112b7de219ac13e1d25ddedaa7f4ec799314316decd8fc5ea2b7',
        183280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '608590a924114eb860d9646c179e2ba9f361bc1a72d45126a2e13d6a80a7c353',
        183420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dd476f31c8df011299fdc0bdb50b9d19f030e857b24ec275eae5cf2db070673e',
        184200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee32c71e06596cd8aefa6b333937819c99ce7a93c363ca7f08e2a39ffdb1ee54',
        184660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lateef',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lateef font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lateef
  static TextTheme lateefTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lateef(textStyle: textTheme.displayLarge),
      displayMedium: lateef(textStyle: textTheme.displayMedium),
      displaySmall: lateef(textStyle: textTheme.displaySmall),
      headlineLarge: lateef(textStyle: textTheme.headlineLarge),
      headlineMedium: lateef(textStyle: textTheme.headlineMedium),
      headlineSmall: lateef(textStyle: textTheme.headlineSmall),
      titleLarge: lateef(textStyle: textTheme.titleLarge),
      titleMedium: lateef(textStyle: textTheme.titleMedium),
      titleSmall: lateef(textStyle: textTheme.titleSmall),
      bodyLarge: lateef(textStyle: textTheme.bodyLarge),
      bodyMedium: lateef(textStyle: textTheme.bodyMedium),
      bodySmall: lateef(textStyle: textTheme.bodySmall),
      labelLarge: lateef(textStyle: textTheme.labelLarge),
      labelMedium: lateef(textStyle: textTheme.labelMedium),
      labelSmall: lateef(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lato font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lato
  static TextStyle lato({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bdeed3215d96c48ad8dd5237a1e60317ec6880c4fbec433cd7e0043804c932ef',
        35368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1f0fdef9af712c39a7770cf35712c08abfdd4ccc01665d3fb2ec67559018d0ad',
        33960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8b8bb46e0f9d42cb83e6cd722f6dc0ddcfcd64ad68ee4e1227ee74ee1028cfa',
        33288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b75fa5b0a60e22d0b15904a3c4fc6837a84e527a0a97a41281df880920dfea76',
        34472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5ced1045820caaac87af3f61ded09bacc90881f158d04c59dcce436fd02ad368',
        33408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4b73aa5035797a21734eb2805ae3ad62de986410d20e956146b379ad9cd9537f',
        34560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af2c9fa2534c5e1605d24015fabe84c697e5381b0549e4ad3a1bedc21df911ae',
        33996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0df2d41932fc1c1b4a445e686733496168788fb4d4a1a1ec0584800ff8b9cd0e',
        34704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ea4d535c8d7443f9b269dda3c28eef6aef7ffe002a780b428de75102777d84e8',
        33772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd91fd5dfbe26a450a2c129143894275818bcae41aba08bf9d244db6d94942674',
        34620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lato',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lato font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lato
  static TextTheme latoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lato(textStyle: textTheme.displayLarge),
      displayMedium: lato(textStyle: textTheme.displayMedium),
      displaySmall: lato(textStyle: textTheme.displaySmall),
      headlineLarge: lato(textStyle: textTheme.headlineLarge),
      headlineMedium: lato(textStyle: textTheme.headlineMedium),
      headlineSmall: lato(textStyle: textTheme.headlineSmall),
      titleLarge: lato(textStyle: textTheme.titleLarge),
      titleMedium: lato(textStyle: textTheme.titleMedium),
      titleSmall: lato(textStyle: textTheme.titleSmall),
      bodyLarge: lato(textStyle: textTheme.bodyLarge),
      bodyMedium: lato(textStyle: textTheme.bodyMedium),
      bodySmall: lato(textStyle: textTheme.bodySmall),
      labelLarge: lato(textStyle: textTheme.labelLarge),
      labelMedium: lato(textStyle: textTheme.labelMedium),
      labelSmall: lato(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lavishly Yours font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lavishly+Yours
  static TextStyle lavishlyYours({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d6ad9c158ffea85da136dfcdb23804f7ee813870c45b8171e512fd8993e9a1f',
        96164,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LavishlyYours',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lavishly Yours font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lavishly+Yours
  static TextTheme lavishlyYoursTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lavishlyYours(textStyle: textTheme.displayLarge),
      displayMedium: lavishlyYours(textStyle: textTheme.displayMedium),
      displaySmall: lavishlyYours(textStyle: textTheme.displaySmall),
      headlineLarge: lavishlyYours(textStyle: textTheme.headlineLarge),
      headlineMedium: lavishlyYours(textStyle: textTheme.headlineMedium),
      headlineSmall: lavishlyYours(textStyle: textTheme.headlineSmall),
      titleLarge: lavishlyYours(textStyle: textTheme.titleLarge),
      titleMedium: lavishlyYours(textStyle: textTheme.titleMedium),
      titleSmall: lavishlyYours(textStyle: textTheme.titleSmall),
      bodyLarge: lavishlyYours(textStyle: textTheme.bodyLarge),
      bodyMedium: lavishlyYours(textStyle: textTheme.bodyMedium),
      bodySmall: lavishlyYours(textStyle: textTheme.bodySmall),
      labelLarge: lavishlyYours(textStyle: textTheme.labelLarge),
      labelMedium: lavishlyYours(textStyle: textTheme.labelMedium),
      labelSmall: lavishlyYours(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the League Gothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/League+Gothic
  static TextStyle leagueGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3620e40817b43d0d9037cb6447f5b538c2d4a7ea7a10a25e504d77cd866944c4',
        37340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LeagueGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the League Gothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/League+Gothic
  static TextTheme leagueGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: leagueGothic(textStyle: textTheme.displayLarge),
      displayMedium: leagueGothic(textStyle: textTheme.displayMedium),
      displaySmall: leagueGothic(textStyle: textTheme.displaySmall),
      headlineLarge: leagueGothic(textStyle: textTheme.headlineLarge),
      headlineMedium: leagueGothic(textStyle: textTheme.headlineMedium),
      headlineSmall: leagueGothic(textStyle: textTheme.headlineSmall),
      titleLarge: leagueGothic(textStyle: textTheme.titleLarge),
      titleMedium: leagueGothic(textStyle: textTheme.titleMedium),
      titleSmall: leagueGothic(textStyle: textTheme.titleSmall),
      bodyLarge: leagueGothic(textStyle: textTheme.bodyLarge),
      bodyMedium: leagueGothic(textStyle: textTheme.bodyMedium),
      bodySmall: leagueGothic(textStyle: textTheme.bodySmall),
      labelLarge: leagueGothic(textStyle: textTheme.labelLarge),
      labelMedium: leagueGothic(textStyle: textTheme.labelMedium),
      labelSmall: leagueGothic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the League Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/League+Script
  static TextStyle leagueScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fcdbbd415480a9c1485a186c51210bdab59d7e6006b334a75c2cf62bcd9ba223',
        37984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LeagueScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the League Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/League+Script
  static TextTheme leagueScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: leagueScript(textStyle: textTheme.displayLarge),
      displayMedium: leagueScript(textStyle: textTheme.displayMedium),
      displaySmall: leagueScript(textStyle: textTheme.displaySmall),
      headlineLarge: leagueScript(textStyle: textTheme.headlineLarge),
      headlineMedium: leagueScript(textStyle: textTheme.headlineMedium),
      headlineSmall: leagueScript(textStyle: textTheme.headlineSmall),
      titleLarge: leagueScript(textStyle: textTheme.titleLarge),
      titleMedium: leagueScript(textStyle: textTheme.titleMedium),
      titleSmall: leagueScript(textStyle: textTheme.titleSmall),
      bodyLarge: leagueScript(textStyle: textTheme.bodyLarge),
      bodyMedium: leagueScript(textStyle: textTheme.bodyMedium),
      bodySmall: leagueScript(textStyle: textTheme.bodySmall),
      labelLarge: leagueScript(textStyle: textTheme.labelLarge),
      labelMedium: leagueScript(textStyle: textTheme.labelMedium),
      labelSmall: leagueScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the League Spartan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/League+Spartan
  static TextStyle leagueSpartan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4384ca99cc78a69b5870a29f528d6f9f5c14d4f8f1138d6b275ca7f448f973a0',
        52832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46b429c508ea6798f08da9e28fe7c22e45fbeb90cdcd098092a2d2c69944e15c',
        52884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5258b7714e3ef7331bb3d7ff8da79cf76e3b1b3445548bf2ead6b7e931680072',
        52848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5ae198bdbfcae1762bdfc671c4f3d045e4d2918355598f386aa0b88d92a232a7',
        52848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05c4df0e3046446e185fd6b578ac6349fe4ad9fe59b3644996753fb4bbb75113',
        52868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7e5b6f2e69bc4228f227d9f976a17b839d8501fb8170b4c327fe46b880ad086a',
        52948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e3acc2490f52e0063d70c6ffa335c99cb1d079d59270084eecd131019af6c59',
        53004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ede566f4924a586fe97bade3270c100756df42cb4c5bbaa76969e0ffc9f4a98e',
        53228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd0e63f246783c63cd4623c7267270b9edc9cb2774820df16c05c3eb6be7a186',
        53096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LeagueSpartan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the League Spartan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/League+Spartan
  static TextTheme leagueSpartanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: leagueSpartan(textStyle: textTheme.displayLarge),
      displayMedium: leagueSpartan(textStyle: textTheme.displayMedium),
      displaySmall: leagueSpartan(textStyle: textTheme.displaySmall),
      headlineLarge: leagueSpartan(textStyle: textTheme.headlineLarge),
      headlineMedium: leagueSpartan(textStyle: textTheme.headlineMedium),
      headlineSmall: leagueSpartan(textStyle: textTheme.headlineSmall),
      titleLarge: leagueSpartan(textStyle: textTheme.titleLarge),
      titleMedium: leagueSpartan(textStyle: textTheme.titleMedium),
      titleSmall: leagueSpartan(textStyle: textTheme.titleSmall),
      bodyLarge: leagueSpartan(textStyle: textTheme.bodyLarge),
      bodyMedium: leagueSpartan(textStyle: textTheme.bodyMedium),
      bodySmall: leagueSpartan(textStyle: textTheme.bodySmall),
      labelLarge: leagueSpartan(textStyle: textTheme.labelLarge),
      labelMedium: leagueSpartan(textStyle: textTheme.labelMedium),
      labelSmall: leagueSpartan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Leckerli One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Leckerli+One
  static TextStyle leckerliOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bda9397d82e8ba5d5f118ce0e5fcc5773edd3babfc9024f2dd085347fc2d3e2',
        41024,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LeckerliOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Leckerli One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Leckerli+One
  static TextTheme leckerliOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: leckerliOne(textStyle: textTheme.displayLarge),
      displayMedium: leckerliOne(textStyle: textTheme.displayMedium),
      displaySmall: leckerliOne(textStyle: textTheme.displaySmall),
      headlineLarge: leckerliOne(textStyle: textTheme.headlineLarge),
      headlineMedium: leckerliOne(textStyle: textTheme.headlineMedium),
      headlineSmall: leckerliOne(textStyle: textTheme.headlineSmall),
      titleLarge: leckerliOne(textStyle: textTheme.titleLarge),
      titleMedium: leckerliOne(textStyle: textTheme.titleMedium),
      titleSmall: leckerliOne(textStyle: textTheme.titleSmall),
      bodyLarge: leckerliOne(textStyle: textTheme.bodyLarge),
      bodyMedium: leckerliOne(textStyle: textTheme.bodyMedium),
      bodySmall: leckerliOne(textStyle: textTheme.bodySmall),
      labelLarge: leckerliOne(textStyle: textTheme.labelLarge),
      labelMedium: leckerliOne(textStyle: textTheme.labelMedium),
      labelSmall: leckerliOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ledger font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ledger
  static TextStyle ledger({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de543530ee8b98ff99ef035f72dccc07c968e9b50b730ec74f244be7a41d7f25',
        60016,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ledger',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ledger font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ledger
  static TextTheme ledgerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ledger(textStyle: textTheme.displayLarge),
      displayMedium: ledger(textStyle: textTheme.displayMedium),
      displaySmall: ledger(textStyle: textTheme.displaySmall),
      headlineLarge: ledger(textStyle: textTheme.headlineLarge),
      headlineMedium: ledger(textStyle: textTheme.headlineMedium),
      headlineSmall: ledger(textStyle: textTheme.headlineSmall),
      titleLarge: ledger(textStyle: textTheme.titleLarge),
      titleMedium: ledger(textStyle: textTheme.titleMedium),
      titleSmall: ledger(textStyle: textTheme.titleSmall),
      bodyLarge: ledger(textStyle: textTheme.bodyLarge),
      bodyMedium: ledger(textStyle: textTheme.bodyMedium),
      bodySmall: ledger(textStyle: textTheme.bodySmall),
      labelLarge: ledger(textStyle: textTheme.labelLarge),
      labelMedium: ledger(textStyle: textTheme.labelMedium),
      labelSmall: ledger(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lekton font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lekton
  static TextStyle lekton({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a3fb462a967e44088d64703e6c4bce48dbf8d2896edc064c48953c3591a491f',
        36732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0fa708fe39ee0d046d91e8f871bdd90ff2a884bb1b7c55d6dcc1e86eda2c23dd',
        17920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c68d3c141d7077dea89c9a5b09b6d95afea5d4602b75bb8daef7b0d9983ec76',
        36552,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lekton',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lekton font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lekton
  static TextTheme lektonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lekton(textStyle: textTheme.displayLarge),
      displayMedium: lekton(textStyle: textTheme.displayMedium),
      displaySmall: lekton(textStyle: textTheme.displaySmall),
      headlineLarge: lekton(textStyle: textTheme.headlineLarge),
      headlineMedium: lekton(textStyle: textTheme.headlineMedium),
      headlineSmall: lekton(textStyle: textTheme.headlineSmall),
      titleLarge: lekton(textStyle: textTheme.titleLarge),
      titleMedium: lekton(textStyle: textTheme.titleMedium),
      titleSmall: lekton(textStyle: textTheme.titleSmall),
      bodyLarge: lekton(textStyle: textTheme.bodyLarge),
      bodyMedium: lekton(textStyle: textTheme.bodyMedium),
      bodySmall: lekton(textStyle: textTheme.bodySmall),
      labelLarge: lekton(textStyle: textTheme.labelLarge),
      labelMedium: lekton(textStyle: textTheme.labelMedium),
      labelSmall: lekton(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lemon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lemon
  static TextStyle lemon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed112c6a6a100a1762ac415e996af2537037f982f277bb8f9a602e30072ee8e7',
        52844,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lemon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lemon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lemon
  static TextTheme lemonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lemon(textStyle: textTheme.displayLarge),
      displayMedium: lemon(textStyle: textTheme.displayMedium),
      displaySmall: lemon(textStyle: textTheme.displaySmall),
      headlineLarge: lemon(textStyle: textTheme.headlineLarge),
      headlineMedium: lemon(textStyle: textTheme.headlineMedium),
      headlineSmall: lemon(textStyle: textTheme.headlineSmall),
      titleLarge: lemon(textStyle: textTheme.titleLarge),
      titleMedium: lemon(textStyle: textTheme.titleMedium),
      titleSmall: lemon(textStyle: textTheme.titleSmall),
      bodyLarge: lemon(textStyle: textTheme.bodyLarge),
      bodyMedium: lemon(textStyle: textTheme.bodyMedium),
      bodySmall: lemon(textStyle: textTheme.bodySmall),
      labelLarge: lemon(textStyle: textTheme.labelLarge),
      labelMedium: lemon(textStyle: textTheme.labelMedium),
      labelSmall: lemon(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lemonada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lemonada
  static TextStyle lemonada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56dac910aca613d5d64904ce3e5f6ebddfe332d43d93e44403619862508ee65a',
        89364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c4079281640cf9f83eeb3bed6d8e24deeefca6e5e733256d94149ac90f0d31e',
        89616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fde8a3418221691c69cb8dec7e8526d2d511cfc3a145cd6ca608a6093129f4c8',
        89700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbffbbd7869bd3d5f561357ef95d84b33ab8c57ae7c4af80379eed905972cfab',
        89696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '23be12c3c2073655db1d92f4c5bdb48219c7f23fce4866097577e0956a2ed2c6',
        89504,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lemonada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lemonada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lemonada
  static TextTheme lemonadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lemonada(textStyle: textTheme.displayLarge),
      displayMedium: lemonada(textStyle: textTheme.displayMedium),
      displaySmall: lemonada(textStyle: textTheme.displaySmall),
      headlineLarge: lemonada(textStyle: textTheme.headlineLarge),
      headlineMedium: lemonada(textStyle: textTheme.headlineMedium),
      headlineSmall: lemonada(textStyle: textTheme.headlineSmall),
      titleLarge: lemonada(textStyle: textTheme.titleLarge),
      titleMedium: lemonada(textStyle: textTheme.titleMedium),
      titleSmall: lemonada(textStyle: textTheme.titleSmall),
      bodyLarge: lemonada(textStyle: textTheme.bodyLarge),
      bodyMedium: lemonada(textStyle: textTheme.bodyMedium),
      bodySmall: lemonada(textStyle: textTheme.bodySmall),
      labelLarge: lemonada(textStyle: textTheme.labelLarge),
      labelMedium: lemonada(textStyle: textTheme.labelMedium),
      labelSmall: lemonada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lexend font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend
  static TextStyle lexend({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a074ce785c70dab93daed7e6233754ac7e057515861eb08d2a93ca163f01e523',
        70780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '20e306f948421deda15fd208aaf2178cad6823023742f210497a3e7b2e80663e',
        70856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3c5c3fcf522832da0c6051d4d5ac77881ab8aa34fd321527c365c17b926ccdd5',
        70996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '198ee27dbd243163e806c57f840c1f07a7eaad012fb108418cac7a8ff6b32c21',
        70676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56988f9f0f5a04235bde51b1c286bfc1595a7698ff1ba5146adf1b81c9774122',
        71012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'feb6b0e91736434ef407de3c9b79541691a273c295a18f890be0a9f79af18b62',
        71056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fcb392c9317e0b9da44817c3cda1f6d85a802746be689a2189ca14e7c9e4e236',
        70928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '513a48ab30c82db55ec953815a94e2578ebba601f0933e9bf4a79a45fcd3bc23',
        71044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7500d4248d74da0cf931ca6917e8e75db02529d4190d9c84713d26f7689c0e92',
        70828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lexend',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lexend font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend
  static TextTheme lexendTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lexend(textStyle: textTheme.displayLarge),
      displayMedium: lexend(textStyle: textTheme.displayMedium),
      displaySmall: lexend(textStyle: textTheme.displaySmall),
      headlineLarge: lexend(textStyle: textTheme.headlineLarge),
      headlineMedium: lexend(textStyle: textTheme.headlineMedium),
      headlineSmall: lexend(textStyle: textTheme.headlineSmall),
      titleLarge: lexend(textStyle: textTheme.titleLarge),
      titleMedium: lexend(textStyle: textTheme.titleMedium),
      titleSmall: lexend(textStyle: textTheme.titleSmall),
      bodyLarge: lexend(textStyle: textTheme.bodyLarge),
      bodyMedium: lexend(textStyle: textTheme.bodyMedium),
      bodySmall: lexend(textStyle: textTheme.bodySmall),
      labelLarge: lexend(textStyle: textTheme.labelLarge),
      labelMedium: lexend(textStyle: textTheme.labelMedium),
      labelSmall: lexend(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lexend Deca font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Deca
  static TextStyle lexendDeca({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52fd65a7f82d72e3d412c460f8d309fff674ed11fe0d66b50d758db9a7a359b1',
        70816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '91850d8cb7a1abd490a655a458755cf66de5443f2fcb0d4199346e0cb51d6bb3',
        70892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ff2e3f8037aa4b656b56252fe10072f730b7e8059ed5150841a79388e639b51',
        71032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8759b52d65975f43b1dfe209f8187b226a9d93e4015213fb5657cb4ecb57aad8',
        70712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '96343cfee08842a7a0cde35d21f4dee7c38938a8eb062b5732c891a31d344524',
        71048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '463fea8614fd22dd0c655da7bb37614004fefd2aa234aec7632588fd7e70b4d4',
        71092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd5bc0ac1839d2704eb89fcae5d6ced52e2e0681c5946bf9717269b7f8acca9c',
        70964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '683dcc47682c93544a4c167f8e51ff469e3cfaa8d45a26c48978f663311dcd39',
        71080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6c9e1af5c6e3e1f0664947361d954e7446d56dc9a7aa9ae4a62df8d7b919cd1',
        70864,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LexendDeca',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lexend Deca font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Deca
  static TextTheme lexendDecaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lexendDeca(textStyle: textTheme.displayLarge),
      displayMedium: lexendDeca(textStyle: textTheme.displayMedium),
      displaySmall: lexendDeca(textStyle: textTheme.displaySmall),
      headlineLarge: lexendDeca(textStyle: textTheme.headlineLarge),
      headlineMedium: lexendDeca(textStyle: textTheme.headlineMedium),
      headlineSmall: lexendDeca(textStyle: textTheme.headlineSmall),
      titleLarge: lexendDeca(textStyle: textTheme.titleLarge),
      titleMedium: lexendDeca(textStyle: textTheme.titleMedium),
      titleSmall: lexendDeca(textStyle: textTheme.titleSmall),
      bodyLarge: lexendDeca(textStyle: textTheme.bodyLarge),
      bodyMedium: lexendDeca(textStyle: textTheme.bodyMedium),
      bodySmall: lexendDeca(textStyle: textTheme.bodySmall),
      labelLarge: lexendDeca(textStyle: textTheme.labelLarge),
      labelMedium: lexendDeca(textStyle: textTheme.labelMedium),
      labelSmall: lexendDeca(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lexend Exa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Exa
  static TextStyle lexendExa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'be067c77492ebe93535ad5b045b444a7aaedc7c6dc00a6a8c20da88211c8f17c',
        71276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4dd6e8f5a8fa89fc5c1e8331effdd05a9f7f154d11b71e1bfa8b2c765b13f37c',
        71484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '598b26fac82a96247c280c6091166ef2ed43209c41b8d99dbd99a062a3033e75',
        71436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67f13cd61dcbf35e6dcb22eb68b0cb810cb7e36ecc4744f253532f7efc0d5470',
        71232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c204a80e3133e377cf12fc2c6c0c7a9ca8d6e65e95022e25ae86785ce29b5321',
        71624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5e9f7379c0f3d6fd44bd885f65731cb562b77434b24ed7406f5d0f5258787e13',
        71608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd5a0a0e89216ca2259ff90685867bf4f3e2719458870bf255876b891c27fbef1',
        71536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8186ff01c6eb5edc88fbad13748db871e1a5802de8c66862f90817ed784ced2a',
        71576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '778f99080a56b51da812b39c2989421e6cc72b828cd1e9c93cba1fb25cd1f8d0',
        71424,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LexendExa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lexend Exa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Exa
  static TextTheme lexendExaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lexendExa(textStyle: textTheme.displayLarge),
      displayMedium: lexendExa(textStyle: textTheme.displayMedium),
      displaySmall: lexendExa(textStyle: textTheme.displaySmall),
      headlineLarge: lexendExa(textStyle: textTheme.headlineLarge),
      headlineMedium: lexendExa(textStyle: textTheme.headlineMedium),
      headlineSmall: lexendExa(textStyle: textTheme.headlineSmall),
      titleLarge: lexendExa(textStyle: textTheme.titleLarge),
      titleMedium: lexendExa(textStyle: textTheme.titleMedium),
      titleSmall: lexendExa(textStyle: textTheme.titleSmall),
      bodyLarge: lexendExa(textStyle: textTheme.bodyLarge),
      bodyMedium: lexendExa(textStyle: textTheme.bodyMedium),
      bodySmall: lexendExa(textStyle: textTheme.bodySmall),
      labelLarge: lexendExa(textStyle: textTheme.labelLarge),
      labelMedium: lexendExa(textStyle: textTheme.labelMedium),
      labelSmall: lexendExa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lexend Giga font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Giga
  static TextStyle lexendGiga({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '030a231db66b7f81e39ba9b5272669c04985f5405de39a36cbc7651a6eaa0f3d',
        71348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2fe1358ea594c380bbfd86392f30ee64412c77dc0f0e0b9dacc458995d590e7b',
        71648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e3fa6e848860e11fcc1e1c657b8b73538d62d3c9c96a135d6ae6ecf93f7967c',
        71652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f987b0138822f7b905e6f288c97e32b770e27cb135baf275ed0aa5c9d011450',
        71460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2696597b5c65b1d8973c87ac4c5dfbff4b831b959286f08dde9d95122009d21d',
        71744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c07959904de19b9c776a7e572c75c130f00825fea3ce277c41e50ff6a14e4f94',
        71832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '301bad03039ddbdb612786ebc0a782235edb6479fb1c37b47d899a1155e38cec',
        71704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5133daf8f0bb6454e7d5907d646664a332657773eb7d874ae91472f037fd7881',
        71648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '091a30064c2307ff61e10201c75afb87461b9d1fdbb8256955f6d5acc2455c7b',
        71608,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LexendGiga',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lexend Giga font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Giga
  static TextTheme lexendGigaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lexendGiga(textStyle: textTheme.displayLarge),
      displayMedium: lexendGiga(textStyle: textTheme.displayMedium),
      displaySmall: lexendGiga(textStyle: textTheme.displaySmall),
      headlineLarge: lexendGiga(textStyle: textTheme.headlineLarge),
      headlineMedium: lexendGiga(textStyle: textTheme.headlineMedium),
      headlineSmall: lexendGiga(textStyle: textTheme.headlineSmall),
      titleLarge: lexendGiga(textStyle: textTheme.titleLarge),
      titleMedium: lexendGiga(textStyle: textTheme.titleMedium),
      titleSmall: lexendGiga(textStyle: textTheme.titleSmall),
      bodyLarge: lexendGiga(textStyle: textTheme.bodyLarge),
      bodyMedium: lexendGiga(textStyle: textTheme.bodyMedium),
      bodySmall: lexendGiga(textStyle: textTheme.bodySmall),
      labelLarge: lexendGiga(textStyle: textTheme.labelLarge),
      labelMedium: lexendGiga(textStyle: textTheme.labelMedium),
      labelSmall: lexendGiga(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lexend Mega font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Mega
  static TextStyle lexendMega({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8db6e66a919835b64eb299f9e2c947802b7571ee2702f806068ad865ecc428c1',
        71492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8950dedb4fc6de1f6cdfe6098b2f5c723d26cc98b588aa5750fe5d4ce6451e57',
        71676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b98a61d2d6bae7abef8c164f92a929f4ef1120844cc417e900ba201e80fae441',
        71656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '544576fd00c8933b2ac61f5367ccda2270e82a1f994a059ba371d472aa42f55b',
        71444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ec6a339e6c7af204468a6f0e337d5ce086cf17a4369c26d14280ea62ba2685f',
        71768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '42df74aa7a3c2d24cc94dc1e367346f14e8f4b8dbffac56e5e7497a2a6485635',
        71864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '08fc3b7c8c0e0fe6dd15c8d994129d0317cad662241b72adf9d9206cb97b5b93',
        71760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c4c2e08312dffe0c992f2f43733b6215a0bd3472fb537a30e4963ad3d983569',
        71700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82cc0b2dc500d1f0062664f9fe5575f0a0c22c6865fef3b709104ae87fcf30cc',
        71672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LexendMega',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lexend Mega font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Mega
  static TextTheme lexendMegaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lexendMega(textStyle: textTheme.displayLarge),
      displayMedium: lexendMega(textStyle: textTheme.displayMedium),
      displaySmall: lexendMega(textStyle: textTheme.displaySmall),
      headlineLarge: lexendMega(textStyle: textTheme.headlineLarge),
      headlineMedium: lexendMega(textStyle: textTheme.headlineMedium),
      headlineSmall: lexendMega(textStyle: textTheme.headlineSmall),
      titleLarge: lexendMega(textStyle: textTheme.titleLarge),
      titleMedium: lexendMega(textStyle: textTheme.titleMedium),
      titleSmall: lexendMega(textStyle: textTheme.titleSmall),
      bodyLarge: lexendMega(textStyle: textTheme.bodyLarge),
      bodyMedium: lexendMega(textStyle: textTheme.bodyMedium),
      bodySmall: lexendMega(textStyle: textTheme.bodySmall),
      labelLarge: lexendMega(textStyle: textTheme.labelLarge),
      labelMedium: lexendMega(textStyle: textTheme.labelMedium),
      labelSmall: lexendMega(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lexend Peta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Peta
  static TextStyle lexendPeta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d92feda8e167275247d1b178d0e13ef811d405e243f2b316f96e914ac1645d5',
        71604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7e44d9dc3885caac6b103433f8485633519c9a2883169bb998e6678d18f56fae',
        71788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28ab6455acaff43c245a13d8d7ddc951d1e66eaa4f58df9234eb7cce1d9d1ced',
        71740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b3ed957cec4f6a666f36d6e574acf51f22fc874904163e0fc1337bbf305686c',
        71460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3262ec4188b7416306be9881b4eaddf65c3635df7645e3e84200ce0f18b114a9',
        71832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28d22441aea665fa7f790645a0baf8d121c087170c95b4fffc27a869cb26b7f9',
        71864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c1b311195e30a1a4ccba707a92e23666b1ebf147cf6c867e7a0fa4b905b0164',
        71824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0fb7718299905be43ead1940463c7356c42034ad387f6f24b35b7224c3a83458',
        71788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3154c8a5bb77903177e304d7489bcdeb8f6a2599918f3a474e7f500cb5cb08a7',
        71660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LexendPeta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lexend Peta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Peta
  static TextTheme lexendPetaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lexendPeta(textStyle: textTheme.displayLarge),
      displayMedium: lexendPeta(textStyle: textTheme.displayMedium),
      displaySmall: lexendPeta(textStyle: textTheme.displaySmall),
      headlineLarge: lexendPeta(textStyle: textTheme.headlineLarge),
      headlineMedium: lexendPeta(textStyle: textTheme.headlineMedium),
      headlineSmall: lexendPeta(textStyle: textTheme.headlineSmall),
      titleLarge: lexendPeta(textStyle: textTheme.titleLarge),
      titleMedium: lexendPeta(textStyle: textTheme.titleMedium),
      titleSmall: lexendPeta(textStyle: textTheme.titleSmall),
      bodyLarge: lexendPeta(textStyle: textTheme.bodyLarge),
      bodyMedium: lexendPeta(textStyle: textTheme.bodyMedium),
      bodySmall: lexendPeta(textStyle: textTheme.bodySmall),
      labelLarge: lexendPeta(textStyle: textTheme.labelLarge),
      labelMedium: lexendPeta(textStyle: textTheme.labelMedium),
      labelSmall: lexendPeta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lexend Tera font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Tera
  static TextStyle lexendTera({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b230f60ab6208e098f0568ef8b7bd304053030d5eb5973ee52cf36035abadcae',
        71588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04932bff94a4eb6dd84b12fb7de95ca44000a94fde42feee885106f08e1ea2d1',
        71792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9b161066b49a1330432fa3ad1757e8efca3c7c0fd5dc15c221806745292fa95',
        71756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7d463321ddd2fa8fc003c62d9c604939ef14677f4820540be98fa309f22eac07',
        71544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa4de4c729b35769963db5a7c681ad57f7216808c88cd144ea388c5f965304cb',
        71888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a219a288f7eaa4933789e5bb743355bd40ac3cf8510b9f520ddf1e7218404504',
        71948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4eb0adbabd489f451d3ac047026d42fe50a2a9e7ff363004c2ab1e37ee3b467d',
        71860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '26a909dead8f3e3a34027542425c9fca46f81bdfe6c57bc67e9746158ba9d8fc',
        71800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5edcddc95b07674f9e2fa848a9d74acb9950313f28b37301113338297d20dc45',
        71628,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LexendTera',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lexend Tera font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Tera
  static TextTheme lexendTeraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lexendTera(textStyle: textTheme.displayLarge),
      displayMedium: lexendTera(textStyle: textTheme.displayMedium),
      displaySmall: lexendTera(textStyle: textTheme.displaySmall),
      headlineLarge: lexendTera(textStyle: textTheme.headlineLarge),
      headlineMedium: lexendTera(textStyle: textTheme.headlineMedium),
      headlineSmall: lexendTera(textStyle: textTheme.headlineSmall),
      titleLarge: lexendTera(textStyle: textTheme.titleLarge),
      titleMedium: lexendTera(textStyle: textTheme.titleMedium),
      titleSmall: lexendTera(textStyle: textTheme.titleSmall),
      bodyLarge: lexendTera(textStyle: textTheme.bodyLarge),
      bodyMedium: lexendTera(textStyle: textTheme.bodyMedium),
      bodySmall: lexendTera(textStyle: textTheme.bodySmall),
      labelLarge: lexendTera(textStyle: textTheme.labelLarge),
      labelMedium: lexendTera(textStyle: textTheme.labelMedium),
      labelSmall: lexendTera(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lexend Zetta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Zetta
  static TextStyle lexendZetta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '816e5714a77afc4a8b2ca9bf1ada6cfd9bf598cfff0ee1b226f65a5a88f0844f',
        71512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f9dc306d1a7983094c763bd6c98de6647300fa5c360c5af8a3035ee7e613f35',
        71852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43fec11b5838f38d33b0d88e32d5306e9a3787b3196ad5ae3a1d355cdd8bf4fb',
        71904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e00fd0e0cd814a6053ba08bd5fc04b5662cef9e5099a86dba0beb9c7a3aee380',
        71516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9490d1b6b5ed131d7597f95291a3a519576e82b8766dfad11214d82ebb50db42',
        71872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '760daec0f374a6c9b6d1326fde45c2af887be1272adb5795970630b7f25f58fc',
        71908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8a4905de8d21ea1932091d876872e4b575ce85266bb679ca7626176212d55050',
        71856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c0a4c6062b6241baf5f6c5cfb3564579554ce5b89bbbb16ecf7707feb229303b',
        71828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33aceb43242556935571467ab18ce903b19884792e058e3adf65179685fcee01',
        71712,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LexendZetta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lexend Zetta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lexend+Zetta
  static TextTheme lexendZettaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lexendZetta(textStyle: textTheme.displayLarge),
      displayMedium: lexendZetta(textStyle: textTheme.displayMedium),
      displaySmall: lexendZetta(textStyle: textTheme.displaySmall),
      headlineLarge: lexendZetta(textStyle: textTheme.headlineLarge),
      headlineMedium: lexendZetta(textStyle: textTheme.headlineMedium),
      headlineSmall: lexendZetta(textStyle: textTheme.headlineSmall),
      titleLarge: lexendZetta(textStyle: textTheme.titleLarge),
      titleMedium: lexendZetta(textStyle: textTheme.titleMedium),
      titleSmall: lexendZetta(textStyle: textTheme.titleSmall),
      bodyLarge: lexendZetta(textStyle: textTheme.bodyLarge),
      bodyMedium: lexendZetta(textStyle: textTheme.bodyMedium),
      bodySmall: lexendZetta(textStyle: textTheme.bodySmall),
      labelLarge: lexendZetta(textStyle: textTheme.labelLarge),
      labelMedium: lexendZetta(textStyle: textTheme.labelMedium),
      labelSmall: lexendZetta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Libre Barcode 128 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+128
  static TextStyle libreBarcode128({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '260e3d3d7c90c60b37a3a34095ddbfe9ae22a94d07e8272ef08bddb2ceb7f2ab',
        12936,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LibreBarcode128',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Libre Barcode 128 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+128
  static TextTheme libreBarcode128TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: libreBarcode128(textStyle: textTheme.displayLarge),
      displayMedium: libreBarcode128(textStyle: textTheme.displayMedium),
      displaySmall: libreBarcode128(textStyle: textTheme.displaySmall),
      headlineLarge: libreBarcode128(textStyle: textTheme.headlineLarge),
      headlineMedium: libreBarcode128(textStyle: textTheme.headlineMedium),
      headlineSmall: libreBarcode128(textStyle: textTheme.headlineSmall),
      titleLarge: libreBarcode128(textStyle: textTheme.titleLarge),
      titleMedium: libreBarcode128(textStyle: textTheme.titleMedium),
      titleSmall: libreBarcode128(textStyle: textTheme.titleSmall),
      bodyLarge: libreBarcode128(textStyle: textTheme.bodyLarge),
      bodyMedium: libreBarcode128(textStyle: textTheme.bodyMedium),
      bodySmall: libreBarcode128(textStyle: textTheme.bodySmall),
      labelLarge: libreBarcode128(textStyle: textTheme.labelLarge),
      labelMedium: libreBarcode128(textStyle: textTheme.labelMedium),
      labelSmall: libreBarcode128(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Libre Barcode 128 Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+128+Text
  static TextStyle libreBarcode128Text({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c290664397b9159e0a0d913f85c0a56fd0cf606e7071a1b6892d351408cc82c',
        29996,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LibreBarcode128Text',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Libre Barcode 128 Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+128+Text
  static TextTheme libreBarcode128TextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: libreBarcode128Text(textStyle: textTheme.displayLarge),
      displayMedium: libreBarcode128Text(textStyle: textTheme.displayMedium),
      displaySmall: libreBarcode128Text(textStyle: textTheme.displaySmall),
      headlineLarge: libreBarcode128Text(textStyle: textTheme.headlineLarge),
      headlineMedium: libreBarcode128Text(textStyle: textTheme.headlineMedium),
      headlineSmall: libreBarcode128Text(textStyle: textTheme.headlineSmall),
      titleLarge: libreBarcode128Text(textStyle: textTheme.titleLarge),
      titleMedium: libreBarcode128Text(textStyle: textTheme.titleMedium),
      titleSmall: libreBarcode128Text(textStyle: textTheme.titleSmall),
      bodyLarge: libreBarcode128Text(textStyle: textTheme.bodyLarge),
      bodyMedium: libreBarcode128Text(textStyle: textTheme.bodyMedium),
      bodySmall: libreBarcode128Text(textStyle: textTheme.bodySmall),
      labelLarge: libreBarcode128Text(textStyle: textTheme.labelLarge),
      labelMedium: libreBarcode128Text(textStyle: textTheme.labelMedium),
      labelSmall: libreBarcode128Text(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Libre Barcode 39 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+39
  static TextStyle libreBarcode39({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a25d156d437de61fd0000652114599b4d454496b7c82a255a6c2ae7fce3052ab',
        7628,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LibreBarcode39',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Libre Barcode 39 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+39
  static TextTheme libreBarcode39TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: libreBarcode39(textStyle: textTheme.displayLarge),
      displayMedium: libreBarcode39(textStyle: textTheme.displayMedium),
      displaySmall: libreBarcode39(textStyle: textTheme.displaySmall),
      headlineLarge: libreBarcode39(textStyle: textTheme.headlineLarge),
      headlineMedium: libreBarcode39(textStyle: textTheme.headlineMedium),
      headlineSmall: libreBarcode39(textStyle: textTheme.headlineSmall),
      titleLarge: libreBarcode39(textStyle: textTheme.titleLarge),
      titleMedium: libreBarcode39(textStyle: textTheme.titleMedium),
      titleSmall: libreBarcode39(textStyle: textTheme.titleSmall),
      bodyLarge: libreBarcode39(textStyle: textTheme.bodyLarge),
      bodyMedium: libreBarcode39(textStyle: textTheme.bodyMedium),
      bodySmall: libreBarcode39(textStyle: textTheme.bodySmall),
      labelLarge: libreBarcode39(textStyle: textTheme.labelLarge),
      labelMedium: libreBarcode39(textStyle: textTheme.labelMedium),
      labelSmall: libreBarcode39(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Libre Barcode 39 Extended font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+39+Extended
  static TextStyle libreBarcode39Extended({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5597ea986d40d61bfa41f69d7be0b5ae36260ccc618c5efd4b6c852868b7c8e',
        10092,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LibreBarcode39Extended',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Libre Barcode 39 Extended font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+39+Extended
  static TextTheme libreBarcode39ExtendedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: libreBarcode39Extended(textStyle: textTheme.displayLarge),
      displayMedium: libreBarcode39Extended(textStyle: textTheme.displayMedium),
      displaySmall: libreBarcode39Extended(textStyle: textTheme.displaySmall),
      headlineLarge: libreBarcode39Extended(textStyle: textTheme.headlineLarge),
      headlineMedium:
          libreBarcode39Extended(textStyle: textTheme.headlineMedium),
      headlineSmall: libreBarcode39Extended(textStyle: textTheme.headlineSmall),
      titleLarge: libreBarcode39Extended(textStyle: textTheme.titleLarge),
      titleMedium: libreBarcode39Extended(textStyle: textTheme.titleMedium),
      titleSmall: libreBarcode39Extended(textStyle: textTheme.titleSmall),
      bodyLarge: libreBarcode39Extended(textStyle: textTheme.bodyLarge),
      bodyMedium: libreBarcode39Extended(textStyle: textTheme.bodyMedium),
      bodySmall: libreBarcode39Extended(textStyle: textTheme.bodySmall),
      labelLarge: libreBarcode39Extended(textStyle: textTheme.labelLarge),
      labelMedium: libreBarcode39Extended(textStyle: textTheme.labelMedium),
      labelSmall: libreBarcode39Extended(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Libre Barcode 39 Extended Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+39+Extended+Text
  static TextStyle libreBarcode39ExtendedText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e37336e25abf7a323606fe47716a9f7b97c149583abdf6fcbd73a66cabb671e',
        21332,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LibreBarcode39ExtendedText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Libre Barcode 39 Extended Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+39+Extended+Text
  static TextTheme libreBarcode39ExtendedTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          libreBarcode39ExtendedText(textStyle: textTheme.displayLarge),
      displayMedium:
          libreBarcode39ExtendedText(textStyle: textTheme.displayMedium),
      displaySmall:
          libreBarcode39ExtendedText(textStyle: textTheme.displaySmall),
      headlineLarge:
          libreBarcode39ExtendedText(textStyle: textTheme.headlineLarge),
      headlineMedium:
          libreBarcode39ExtendedText(textStyle: textTheme.headlineMedium),
      headlineSmall:
          libreBarcode39ExtendedText(textStyle: textTheme.headlineSmall),
      titleLarge: libreBarcode39ExtendedText(textStyle: textTheme.titleLarge),
      titleMedium: libreBarcode39ExtendedText(textStyle: textTheme.titleMedium),
      titleSmall: libreBarcode39ExtendedText(textStyle: textTheme.titleSmall),
      bodyLarge: libreBarcode39ExtendedText(textStyle: textTheme.bodyLarge),
      bodyMedium: libreBarcode39ExtendedText(textStyle: textTheme.bodyMedium),
      bodySmall: libreBarcode39ExtendedText(textStyle: textTheme.bodySmall),
      labelLarge: libreBarcode39ExtendedText(textStyle: textTheme.labelLarge),
      labelMedium: libreBarcode39ExtendedText(textStyle: textTheme.labelMedium),
      labelSmall: libreBarcode39ExtendedText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Libre Barcode 39 Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+39+Text
  static TextStyle libreBarcode39Text({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bf8ea99fa9702a9be34643106b0d77a7e990c3f25198ad9356164e1fd27ade2f',
        12776,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LibreBarcode39Text',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Libre Barcode 39 Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+39+Text
  static TextTheme libreBarcode39TextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: libreBarcode39Text(textStyle: textTheme.displayLarge),
      displayMedium: libreBarcode39Text(textStyle: textTheme.displayMedium),
      displaySmall: libreBarcode39Text(textStyle: textTheme.displaySmall),
      headlineLarge: libreBarcode39Text(textStyle: textTheme.headlineLarge),
      headlineMedium: libreBarcode39Text(textStyle: textTheme.headlineMedium),
      headlineSmall: libreBarcode39Text(textStyle: textTheme.headlineSmall),
      titleLarge: libreBarcode39Text(textStyle: textTheme.titleLarge),
      titleMedium: libreBarcode39Text(textStyle: textTheme.titleMedium),
      titleSmall: libreBarcode39Text(textStyle: textTheme.titleSmall),
      bodyLarge: libreBarcode39Text(textStyle: textTheme.bodyLarge),
      bodyMedium: libreBarcode39Text(textStyle: textTheme.bodyMedium),
      bodySmall: libreBarcode39Text(textStyle: textTheme.bodySmall),
      labelLarge: libreBarcode39Text(textStyle: textTheme.labelLarge),
      labelMedium: libreBarcode39Text(textStyle: textTheme.labelMedium),
      labelSmall: libreBarcode39Text(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Libre Barcode EAN13 Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+EAN13+Text
  static TextStyle libreBarcodeEan13Text({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd600da4229dd5f01b7fc1f88afb6b1b4465ed38c36f9f82dd81e55227a7006b9',
        55092,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LibreBarcodeEAN13Text',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Libre Barcode EAN13 Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Barcode+EAN13+Text
  static TextTheme libreBarcodeEan13TextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: libreBarcodeEan13Text(textStyle: textTheme.displayLarge),
      displayMedium: libreBarcodeEan13Text(textStyle: textTheme.displayMedium),
      displaySmall: libreBarcodeEan13Text(textStyle: textTheme.displaySmall),
      headlineLarge: libreBarcodeEan13Text(textStyle: textTheme.headlineLarge),
      headlineMedium:
          libreBarcodeEan13Text(textStyle: textTheme.headlineMedium),
      headlineSmall: libreBarcodeEan13Text(textStyle: textTheme.headlineSmall),
      titleLarge: libreBarcodeEan13Text(textStyle: textTheme.titleLarge),
      titleMedium: libreBarcodeEan13Text(textStyle: textTheme.titleMedium),
      titleSmall: libreBarcodeEan13Text(textStyle: textTheme.titleSmall),
      bodyLarge: libreBarcodeEan13Text(textStyle: textTheme.bodyLarge),
      bodyMedium: libreBarcodeEan13Text(textStyle: textTheme.bodyMedium),
      bodySmall: libreBarcodeEan13Text(textStyle: textTheme.bodySmall),
      labelLarge: libreBarcodeEan13Text(textStyle: textTheme.labelLarge),
      labelMedium: libreBarcodeEan13Text(textStyle: textTheme.labelMedium),
      labelSmall: libreBarcodeEan13Text(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Libre Baskerville font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Baskerville
  static TextStyle libreBaskerville({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'da3c66f8c68b65d31611ad23cc7699924b3525ad8cc0e29cd36e3da5be1c7b23',
        93896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9968638d0769bbcfa14c179f011f7c79b162f9a63405c2bf79376367538ceeae',
        112008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '86914ab6f48f701c8f0eeb2665404b36d9a9f4f5123d18779efa529a98c511c3',
        94076,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LibreBaskerville',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Libre Baskerville font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Baskerville
  static TextTheme libreBaskervilleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: libreBaskerville(textStyle: textTheme.displayLarge),
      displayMedium: libreBaskerville(textStyle: textTheme.displayMedium),
      displaySmall: libreBaskerville(textStyle: textTheme.displaySmall),
      headlineLarge: libreBaskerville(textStyle: textTheme.headlineLarge),
      headlineMedium: libreBaskerville(textStyle: textTheme.headlineMedium),
      headlineSmall: libreBaskerville(textStyle: textTheme.headlineSmall),
      titleLarge: libreBaskerville(textStyle: textTheme.titleLarge),
      titleMedium: libreBaskerville(textStyle: textTheme.titleMedium),
      titleSmall: libreBaskerville(textStyle: textTheme.titleSmall),
      bodyLarge: libreBaskerville(textStyle: textTheme.bodyLarge),
      bodyMedium: libreBaskerville(textStyle: textTheme.bodyMedium),
      bodySmall: libreBaskerville(textStyle: textTheme.bodySmall),
      labelLarge: libreBaskerville(textStyle: textTheme.labelLarge),
      labelMedium: libreBaskerville(textStyle: textTheme.labelMedium),
      labelSmall: libreBaskerville(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Libre Bodoni font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Bodoni
  static TextStyle libreBodoni({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3fd93e2cb52112040e0d0de215d0247f227b5d088a3bf078b329f9d6e02a2a2a',
        71940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '99318070a8cadab3e3eaaacb4eeb99bf954fb19570cb6a8740c3cf246def335e',
        72236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a5d938872e8449102e12b279162ae64c62d4baa096a52eca8f0969b41bf9fb09',
        72296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30cd6b875088baa0b5c8687fed973ba492a7d44b01f7b0b792665964d6f09c15',
        72016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4ba9d9182325c336532fad10417fe1f2d89bd4230f3d3661a0a1e20a000eca60',
        72164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '08eb9a91d9a388b74d8806d510e121295fe6ea1a087d58aac2a739cb62c47a62',
        72592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '24845f919f485c6ad52cfc0a1df40e5945aef094977559f045fee51c90faeeb1',
        72652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '36b606f0df8a1ae71b3f4ba0c28ddeb015c1580a9c0f9712e94334feeba9924f',
        72492,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LibreBodoni',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Libre Bodoni font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Bodoni
  static TextTheme libreBodoniTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: libreBodoni(textStyle: textTheme.displayLarge),
      displayMedium: libreBodoni(textStyle: textTheme.displayMedium),
      displaySmall: libreBodoni(textStyle: textTheme.displaySmall),
      headlineLarge: libreBodoni(textStyle: textTheme.headlineLarge),
      headlineMedium: libreBodoni(textStyle: textTheme.headlineMedium),
      headlineSmall: libreBodoni(textStyle: textTheme.headlineSmall),
      titleLarge: libreBodoni(textStyle: textTheme.titleLarge),
      titleMedium: libreBodoni(textStyle: textTheme.titleMedium),
      titleSmall: libreBodoni(textStyle: textTheme.titleSmall),
      bodyLarge: libreBodoni(textStyle: textTheme.bodyLarge),
      bodyMedium: libreBodoni(textStyle: textTheme.bodyMedium),
      bodySmall: libreBodoni(textStyle: textTheme.bodySmall),
      labelLarge: libreBodoni(textStyle: textTheme.labelLarge),
      labelMedium: libreBodoni(textStyle: textTheme.labelMedium),
      labelSmall: libreBodoni(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Libre Caslon Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Caslon+Display
  static TextStyle libreCaslonDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6d8af94b1b021b7e66456850a9cd86b6a4879bbab0001030f984a105a9069b3',
        63516,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LibreCaslonDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Libre Caslon Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Caslon+Display
  static TextTheme libreCaslonDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: libreCaslonDisplay(textStyle: textTheme.displayLarge),
      displayMedium: libreCaslonDisplay(textStyle: textTheme.displayMedium),
      displaySmall: libreCaslonDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: libreCaslonDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: libreCaslonDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: libreCaslonDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: libreCaslonDisplay(textStyle: textTheme.titleLarge),
      titleMedium: libreCaslonDisplay(textStyle: textTheme.titleMedium),
      titleSmall: libreCaslonDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: libreCaslonDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: libreCaslonDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: libreCaslonDisplay(textStyle: textTheme.bodySmall),
      labelLarge: libreCaslonDisplay(textStyle: textTheme.labelLarge),
      labelMedium: libreCaslonDisplay(textStyle: textTheme.labelMedium),
      labelSmall: libreCaslonDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Libre Caslon Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Caslon+Text
  static TextStyle libreCaslonText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2bfab10fe10d3499c3f59f7eec1fd40735d93b6f72d0a780cfaba8574a70000b',
        63144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8aeef94a3ada41d22c976c7cf50b2d40720cb6b18af7699410a56449331bb693',
        68688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba4d1de3e986843f924c50ab2ce0b96afa60c8ad983169917d6689faafa9f5e6',
        62732,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LibreCaslonText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Libre Caslon Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Caslon+Text
  static TextTheme libreCaslonTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: libreCaslonText(textStyle: textTheme.displayLarge),
      displayMedium: libreCaslonText(textStyle: textTheme.displayMedium),
      displaySmall: libreCaslonText(textStyle: textTheme.displaySmall),
      headlineLarge: libreCaslonText(textStyle: textTheme.headlineLarge),
      headlineMedium: libreCaslonText(textStyle: textTheme.headlineMedium),
      headlineSmall: libreCaslonText(textStyle: textTheme.headlineSmall),
      titleLarge: libreCaslonText(textStyle: textTheme.titleLarge),
      titleMedium: libreCaslonText(textStyle: textTheme.titleMedium),
      titleSmall: libreCaslonText(textStyle: textTheme.titleSmall),
      bodyLarge: libreCaslonText(textStyle: textTheme.bodyLarge),
      bodyMedium: libreCaslonText(textStyle: textTheme.bodyMedium),
      bodySmall: libreCaslonText(textStyle: textTheme.bodySmall),
      labelLarge: libreCaslonText(textStyle: textTheme.labelLarge),
      labelMedium: libreCaslonText(textStyle: textTheme.labelMedium),
      labelSmall: libreCaslonText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Libre Franklin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Franklin
  static TextStyle libreFranklin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48c4bdbae909a7b05a2adb9d0ae285d69e507a6d7ea1a2a1de93a557e43e9890',
        61496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24fe3952e13e5cacf0684cf65c3e38bacf17d1ae5f75164e42e01f0609b561f9',
        61620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b2a73c896d783b6ecde7ac09c493481cb7f43656ce6ecb89720b30b83bd42bf',
        61636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e34b6d112b52c16176871dc1aa8dc490bd7e66e3d0d18b0ce3fb5d19e28de8f',
        61644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f086cebd30533ea43d0adaf71d5788b762f72caec897105eb3528481d4ae26ac',
        61664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e055845db23bd5a19c6d3881637bd8f60c07a624f1ac0bbf2750a4bdea5f3b30',
        61680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6135d5f7a0984d505bff44ab1f54829326eddb2766397aa8a19f70a921939b0',
        61564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f674067269c44a2fd521cc039b58b52356bc20308faecf5d8e905df4238b7a9',
        61608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0dca2f59a5abba87a93f7e13d5ffd0db7a0841118e526f4764434696cc16aeee',
        61540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '82e524eb3dc316bc6d1c53624f1fd5d2c7c304476aa3cd61e96e1d48c8cf8838',
        66340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9760e387def5b421a8653a4d8523d4e3e2fda93a1dd4a3e5390c10f1bf0a9247',
        66492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1c6c0884add5a760f732850b40dd0628847a4c4a140eb8ff135a30b9b5999a03',
        66448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5139f8a3ac7eb00e80b26f2d643db9de4728913128c4674da2cd9682883a580a',
        66396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8467801b2a3c283a14908da87f3662bc538ecbf5053b146c3800abda94f83d81',
        66552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b894a4667971666a121ea5ef78c0a955013f481b1fa287b9ecc48041a29c464d',
        66548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ae0ab7de8514935b8b64a3a6aef569778fedf75c5a033b4735074ae1168d64d0',
        66352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8700bde3fef5c44bdde7c3662130021ae051838c0b480d7ff8c9e86efd8b1b7f',
        66500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ab4662791d8d63b7cc0b282d223db2e64031ef8ab3464882831efc968f20ae13',
        66432,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LibreFranklin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Libre Franklin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Libre+Franklin
  static TextTheme libreFranklinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: libreFranklin(textStyle: textTheme.displayLarge),
      displayMedium: libreFranklin(textStyle: textTheme.displayMedium),
      displaySmall: libreFranklin(textStyle: textTheme.displaySmall),
      headlineLarge: libreFranklin(textStyle: textTheme.headlineLarge),
      headlineMedium: libreFranklin(textStyle: textTheme.headlineMedium),
      headlineSmall: libreFranklin(textStyle: textTheme.headlineSmall),
      titleLarge: libreFranklin(textStyle: textTheme.titleLarge),
      titleMedium: libreFranklin(textStyle: textTheme.titleMedium),
      titleSmall: libreFranklin(textStyle: textTheme.titleSmall),
      bodyLarge: libreFranklin(textStyle: textTheme.bodyLarge),
      bodyMedium: libreFranklin(textStyle: textTheme.bodyMedium),
      bodySmall: libreFranklin(textStyle: textTheme.bodySmall),
      labelLarge: libreFranklin(textStyle: textTheme.labelLarge),
      labelMedium: libreFranklin(textStyle: textTheme.labelMedium),
      labelSmall: libreFranklin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Licorice font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Licorice
  static TextStyle licorice({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa3cb68a0cd6c6415dc144c5bff87aba26660387c9bb1db299846b3bf098a916',
        106488,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Licorice',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Licorice font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Licorice
  static TextTheme licoriceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: licorice(textStyle: textTheme.displayLarge),
      displayMedium: licorice(textStyle: textTheme.displayMedium),
      displaySmall: licorice(textStyle: textTheme.displaySmall),
      headlineLarge: licorice(textStyle: textTheme.headlineLarge),
      headlineMedium: licorice(textStyle: textTheme.headlineMedium),
      headlineSmall: licorice(textStyle: textTheme.headlineSmall),
      titleLarge: licorice(textStyle: textTheme.titleLarge),
      titleMedium: licorice(textStyle: textTheme.titleMedium),
      titleSmall: licorice(textStyle: textTheme.titleSmall),
      bodyLarge: licorice(textStyle: textTheme.bodyLarge),
      bodyMedium: licorice(textStyle: textTheme.bodyMedium),
      bodySmall: licorice(textStyle: textTheme.bodySmall),
      labelLarge: licorice(textStyle: textTheme.labelLarge),
      labelMedium: licorice(textStyle: textTheme.labelMedium),
      labelSmall: licorice(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Life Savers font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Life+Savers
  static TextStyle lifeSavers({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a054e492650f48d2c3b0e11f609df807fa8659bdb6e09bb4e615e925ef0727ba',
        123184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ee94f3cf7576b61e262dac2718765894e064147df3fe51a275339c1176723a1',
        96272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b46219d77eaab1b3082b4ae85a9679c26bf80867fbc5b3e830e4f9dc863b9c5',
        126732,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LifeSavers',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Life Savers font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Life+Savers
  static TextTheme lifeSaversTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lifeSavers(textStyle: textTheme.displayLarge),
      displayMedium: lifeSavers(textStyle: textTheme.displayMedium),
      displaySmall: lifeSavers(textStyle: textTheme.displaySmall),
      headlineLarge: lifeSavers(textStyle: textTheme.headlineLarge),
      headlineMedium: lifeSavers(textStyle: textTheme.headlineMedium),
      headlineSmall: lifeSavers(textStyle: textTheme.headlineSmall),
      titleLarge: lifeSavers(textStyle: textTheme.titleLarge),
      titleMedium: lifeSavers(textStyle: textTheme.titleMedium),
      titleSmall: lifeSavers(textStyle: textTheme.titleSmall),
      bodyLarge: lifeSavers(textStyle: textTheme.bodyLarge),
      bodyMedium: lifeSavers(textStyle: textTheme.bodyMedium),
      bodySmall: lifeSavers(textStyle: textTheme.bodySmall),
      labelLarge: lifeSavers(textStyle: textTheme.labelLarge),
      labelMedium: lifeSavers(textStyle: textTheme.labelMedium),
      labelSmall: lifeSavers(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lilita One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lilita+One
  static TextStyle lilitaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9608d62e809e4a35b12c9b5eedc93a48141177cc5d62249e933535b3024dca4',
        26308,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LilitaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lilita One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lilita+One
  static TextTheme lilitaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lilitaOne(textStyle: textTheme.displayLarge),
      displayMedium: lilitaOne(textStyle: textTheme.displayMedium),
      displaySmall: lilitaOne(textStyle: textTheme.displaySmall),
      headlineLarge: lilitaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: lilitaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: lilitaOne(textStyle: textTheme.headlineSmall),
      titleLarge: lilitaOne(textStyle: textTheme.titleLarge),
      titleMedium: lilitaOne(textStyle: textTheme.titleMedium),
      titleSmall: lilitaOne(textStyle: textTheme.titleSmall),
      bodyLarge: lilitaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: lilitaOne(textStyle: textTheme.bodyMedium),
      bodySmall: lilitaOne(textStyle: textTheme.bodySmall),
      labelLarge: lilitaOne(textStyle: textTheme.labelLarge),
      labelMedium: lilitaOne(textStyle: textTheme.labelMedium),
      labelSmall: lilitaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lily Script One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lily+Script+One
  static TextStyle lilyScriptOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '415fbc61420e7e62d72a64ec3f134f047c52b2d478e1eaf6b7bbc2a928280742',
        34992,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LilyScriptOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lily Script One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lily+Script+One
  static TextTheme lilyScriptOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lilyScriptOne(textStyle: textTheme.displayLarge),
      displayMedium: lilyScriptOne(textStyle: textTheme.displayMedium),
      displaySmall: lilyScriptOne(textStyle: textTheme.displaySmall),
      headlineLarge: lilyScriptOne(textStyle: textTheme.headlineLarge),
      headlineMedium: lilyScriptOne(textStyle: textTheme.headlineMedium),
      headlineSmall: lilyScriptOne(textStyle: textTheme.headlineSmall),
      titleLarge: lilyScriptOne(textStyle: textTheme.titleLarge),
      titleMedium: lilyScriptOne(textStyle: textTheme.titleMedium),
      titleSmall: lilyScriptOne(textStyle: textTheme.titleSmall),
      bodyLarge: lilyScriptOne(textStyle: textTheme.bodyLarge),
      bodyMedium: lilyScriptOne(textStyle: textTheme.bodyMedium),
      bodySmall: lilyScriptOne(textStyle: textTheme.bodySmall),
      labelLarge: lilyScriptOne(textStyle: textTheme.labelLarge),
      labelMedium: lilyScriptOne(textStyle: textTheme.labelMedium),
      labelSmall: lilyScriptOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Limelight font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Limelight
  static TextStyle limelight({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e217ae085639d54690b9c2df25fbfd783640d80fbdad703cf06e7d146d857e45',
        59948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Limelight',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Limelight font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Limelight
  static TextTheme limelightTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: limelight(textStyle: textTheme.displayLarge),
      displayMedium: limelight(textStyle: textTheme.displayMedium),
      displaySmall: limelight(textStyle: textTheme.displaySmall),
      headlineLarge: limelight(textStyle: textTheme.headlineLarge),
      headlineMedium: limelight(textStyle: textTheme.headlineMedium),
      headlineSmall: limelight(textStyle: textTheme.headlineSmall),
      titleLarge: limelight(textStyle: textTheme.titleLarge),
      titleMedium: limelight(textStyle: textTheme.titleMedium),
      titleSmall: limelight(textStyle: textTheme.titleSmall),
      bodyLarge: limelight(textStyle: textTheme.bodyLarge),
      bodyMedium: limelight(textStyle: textTheme.bodyMedium),
      bodySmall: limelight(textStyle: textTheme.bodySmall),
      labelLarge: limelight(textStyle: textTheme.labelLarge),
      labelMedium: limelight(textStyle: textTheme.labelMedium),
      labelSmall: limelight(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Linden Hill font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Linden+Hill
  static TextStyle lindenHill({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b79038d2da2dbfd206664de112bc6f8591189eb3d135d227ef79667fddc6379',
        87432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c8c5e67180a038a2d45957ab8a02fab90b0e1b1c9b06c33543fb6b011fc800bf',
        72476,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LindenHill',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Linden Hill font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Linden+Hill
  static TextTheme lindenHillTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lindenHill(textStyle: textTheme.displayLarge),
      displayMedium: lindenHill(textStyle: textTheme.displayMedium),
      displaySmall: lindenHill(textStyle: textTheme.displaySmall),
      headlineLarge: lindenHill(textStyle: textTheme.headlineLarge),
      headlineMedium: lindenHill(textStyle: textTheme.headlineMedium),
      headlineSmall: lindenHill(textStyle: textTheme.headlineSmall),
      titleLarge: lindenHill(textStyle: textTheme.titleLarge),
      titleMedium: lindenHill(textStyle: textTheme.titleMedium),
      titleSmall: lindenHill(textStyle: textTheme.titleSmall),
      bodyLarge: lindenHill(textStyle: textTheme.bodyLarge),
      bodyMedium: lindenHill(textStyle: textTheme.bodyMedium),
      bodySmall: lindenHill(textStyle: textTheme.bodySmall),
      labelLarge: lindenHill(textStyle: textTheme.labelLarge),
      labelMedium: lindenHill(textStyle: textTheme.labelMedium),
      labelSmall: lindenHill(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lisu Bosa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lisu+Bosa
  static TextStyle lisuBosa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11b323404c19cfe5ad33e5d6071abc92c53fd788f3cef479cdd4357fb79d46b6',
        39832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ada3eedecf43eece27650d806f97f1a60ee4ff5766680595390926972386ce3a',
        49688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '437c62894d6f50779b6ee8adcf19cdbf8cb23ba71988cc01eaf9926396ada126',
        39712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5a18f88ea09e4a4201c37ea494f5bf3741fc54d7346f3cd684c16c7e7925d97f',
        49492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '341a711334cbe076f5a3ba06324f4085d6435fe85ffaca7399c8b791a5cbed0f',
        39640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bcb031e0f41c99bb47eb02b3c2a03ff4a60bcae514892438ce11ec8ed23a88d8',
        49700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd59bb40fa1948198c7e46a5b7f938e8243e0b716b090ebe7057d624b0c9ec875',
        39576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8210d66ed93479ef1926539d7c9bada18ea94fe80bd7eb412cb0fd4eb7aeea58',
        49628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ef957311f52d8167fdf07df1a5b35a042ad44441f4e90c8861244bdbb1411ae',
        39616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a20ec113dfc0bfcd6123241d54a9111522b8e2b3459bf7e7d73bbe4833213130',
        49688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '738da3f5e074c6d354017e6c5843d12336a93518c6ad834e73da3e64b7229f11',
        39520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '895cc80e46ad720f0c3996c6a0ce60a7f3980b04e2648617167a2d135c7bd25b',
        49872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eedbc79bf128003b38e07f763cc6763a07b6ee4b99defdec40c36b4411fc77dd',
        39688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0adbbd016a8d2f3c4327679aa6511b5aee67bce72a05803cc3fd749199d8b5f9',
        50116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9311824e98a60aaf5955b18f3c2686a1298effa020ea3af306b7d3b7b34b4c5',
        39708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '52c857e7acfd0cde1c42d1f0cdf7566c5fecfc82d2182f993c9aa55220d065bc',
        50220,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LisuBosa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lisu Bosa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lisu+Bosa
  static TextTheme lisuBosaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lisuBosa(textStyle: textTheme.displayLarge),
      displayMedium: lisuBosa(textStyle: textTheme.displayMedium),
      displaySmall: lisuBosa(textStyle: textTheme.displaySmall),
      headlineLarge: lisuBosa(textStyle: textTheme.headlineLarge),
      headlineMedium: lisuBosa(textStyle: textTheme.headlineMedium),
      headlineSmall: lisuBosa(textStyle: textTheme.headlineSmall),
      titleLarge: lisuBosa(textStyle: textTheme.titleLarge),
      titleMedium: lisuBosa(textStyle: textTheme.titleMedium),
      titleSmall: lisuBosa(textStyle: textTheme.titleSmall),
      bodyLarge: lisuBosa(textStyle: textTheme.bodyLarge),
      bodyMedium: lisuBosa(textStyle: textTheme.bodyMedium),
      bodySmall: lisuBosa(textStyle: textTheme.bodySmall),
      labelLarge: lisuBosa(textStyle: textTheme.labelLarge),
      labelMedium: lisuBosa(textStyle: textTheme.labelMedium),
      labelSmall: lisuBosa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Literata font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Literata
  static TextStyle literata({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '305ad3487932b1424810a47010288348166c83dfee0011504597f43bc45cdd69',
        169972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd3c858429e9ac69a4fdbc0515304d3ece3e5232575cc75b34740f8b1ffbbc48',
        170776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b48d380795e304ad1f0d05d29866e6f5163aad70b3aec139f50634be73d98a3a',
        170644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2203f56cf475e313f5a67a7497e1f1c0e5615d013a89c403650f8ee74ffd63ff',
        170788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7cebb4bbab7a3a93357843ac9888baded78b1c9c14637add52f5c3f4fa51ccfc',
        170924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '76da78646dd084fa25b649f72dd72f2a279e46c129041d834860d5c6be1689b8',
        173924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae32942ffd0785a607f89e97625b1a76b711052b51c67cb78a73501833db44d4',
        173980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '84a95bbc4b69c47a0f16dc0029b1da97327ae4cd500743c7329244a5db84535d',
        173588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f0de5316c0d8974fcd758d689af051b7f3cfdc7d30cbef5723308f60ba03df6a',
        166328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2a74c9e3095a0d9f23efbd3cce6784ffb41ffa4dfbeaccecdc12d26d562a0047',
        166316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4468c6437ec8b751e1061500ae257884d3feb738d6470083eb8dfbb4546a143d',
        166048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e11a4d797e48d353626fe2aaa6ab02a2a2a72d15baf2248554c0c2e8ae8f690f',
        166416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b3b39004888a60cf123f8a1acfc351001b26024202bc13e3dc5936db9a3ec5d2',
        166460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2ae92b94fb0edf9343fff08045a317f62a97ef6fb08070d45c17214b4c0a16ad',
        169332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '25440565da80981341ea7fe3d8fde7eac4fe07ec0b7a1613556f1c3b618b9039',
        169468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '191d813a9622b7c8fda8bf78465d57b803b1a978ca3f9652f49ad857c565147f',
        169368,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Literata',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Literata font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Literata
  static TextTheme literataTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: literata(textStyle: textTheme.displayLarge),
      displayMedium: literata(textStyle: textTheme.displayMedium),
      displaySmall: literata(textStyle: textTheme.displaySmall),
      headlineLarge: literata(textStyle: textTheme.headlineLarge),
      headlineMedium: literata(textStyle: textTheme.headlineMedium),
      headlineSmall: literata(textStyle: textTheme.headlineSmall),
      titleLarge: literata(textStyle: textTheme.titleLarge),
      titleMedium: literata(textStyle: textTheme.titleMedium),
      titleSmall: literata(textStyle: textTheme.titleSmall),
      bodyLarge: literata(textStyle: textTheme.bodyLarge),
      bodyMedium: literata(textStyle: textTheme.bodyMedium),
      bodySmall: literata(textStyle: textTheme.bodySmall),
      labelLarge: literata(textStyle: textTheme.labelLarge),
      labelMedium: literata(textStyle: textTheme.labelMedium),
      labelSmall: literata(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Liu Jian Mao Cao font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Liu+Jian+Mao+Cao
  static TextStyle liuJianMaoCao({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a4c459db0f69ea76da4e90a31d311250b2bf461f9292eb4786e37daa5029347',
        4939624,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LiuJianMaoCao',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Liu Jian Mao Cao font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Liu+Jian+Mao+Cao
  static TextTheme liuJianMaoCaoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: liuJianMaoCao(textStyle: textTheme.displayLarge),
      displayMedium: liuJianMaoCao(textStyle: textTheme.displayMedium),
      displaySmall: liuJianMaoCao(textStyle: textTheme.displaySmall),
      headlineLarge: liuJianMaoCao(textStyle: textTheme.headlineLarge),
      headlineMedium: liuJianMaoCao(textStyle: textTheme.headlineMedium),
      headlineSmall: liuJianMaoCao(textStyle: textTheme.headlineSmall),
      titleLarge: liuJianMaoCao(textStyle: textTheme.titleLarge),
      titleMedium: liuJianMaoCao(textStyle: textTheme.titleMedium),
      titleSmall: liuJianMaoCao(textStyle: textTheme.titleSmall),
      bodyLarge: liuJianMaoCao(textStyle: textTheme.bodyLarge),
      bodyMedium: liuJianMaoCao(textStyle: textTheme.bodyMedium),
      bodySmall: liuJianMaoCao(textStyle: textTheme.bodySmall),
      labelLarge: liuJianMaoCao(textStyle: textTheme.labelLarge),
      labelMedium: liuJianMaoCao(textStyle: textTheme.labelMedium),
      labelSmall: liuJianMaoCao(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Livvic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Livvic
  static TextStyle livvic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6964b822890a33c03890b7472cff6b2a234e8d27d8ed76fa646924e3b0747c1c',
        79592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '824b0ae027ea5cc3787cd33dbff89165e2188b42445d2b8858f4de81def862ca',
        80828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7adfae90b559b31ee3ca396a99affd8eb49ea93e86901d66b1bb744f29512989',
        79796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8c2138f09a2e80b085d8dd87c6534b1555f1db51a46902a5479214f34f9431ab',
        81100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb257b6961a0520ac180e813634c154e8ef541f49feeb23dc3c5ebe3523a6e8e',
        79704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b76df8ba73cff09b81509a4974d7b672b8370ef99ee120efb7f0a424f57866d9',
        81132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d36055090b3d3c21e47a041ccb812d4997a2d1d1eda4cfa879f5dc386a8cb64',
        79548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5207ebdfecdb49cac77671fec46f3fd0319f4104ad65e8a0ee64c4bb2ab64c28',
        81044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f84089d7b10de711365a6a98dafdf8645c56b74eeb415b7b5c2e5a2bad84fe0',
        79792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '60c3bf59eccc2e6583386f39e5cdb0e924cb13a9051c4c16e44fb31d0b6de3f1',
        81172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f082e292e390a4224980a59c592b219450318348ac1dcfbd50160e1f32b509e1',
        79940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9f1579706530cb747568124f7879daf48982c7711366601f953508cd5b14912c',
        81072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cae1f51a1ab73aea7e4fb08782a3bb6ac79a2bde0b43d2228613d51ffe40d567',
        79992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '260db24b39c21e42bc4a1aa9802bfaefcedf1d840ca9d2893f8dec0359f0795f',
        81036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b86195d0e99a76fc1b36601f9ed9679c1238dbf73e49760fc4e9fc373bf30108',
        80120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '556a4e9434a17a693ce62781c2de5122064353f1f46049fd7e8b9ba2652f59ba',
        81132,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Livvic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Livvic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Livvic
  static TextTheme livvicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: livvic(textStyle: textTheme.displayLarge),
      displayMedium: livvic(textStyle: textTheme.displayMedium),
      displaySmall: livvic(textStyle: textTheme.displaySmall),
      headlineLarge: livvic(textStyle: textTheme.headlineLarge),
      headlineMedium: livvic(textStyle: textTheme.headlineMedium),
      headlineSmall: livvic(textStyle: textTheme.headlineSmall),
      titleLarge: livvic(textStyle: textTheme.titleLarge),
      titleMedium: livvic(textStyle: textTheme.titleMedium),
      titleSmall: livvic(textStyle: textTheme.titleSmall),
      bodyLarge: livvic(textStyle: textTheme.bodyLarge),
      bodyMedium: livvic(textStyle: textTheme.bodyMedium),
      bodySmall: livvic(textStyle: textTheme.bodySmall),
      labelLarge: livvic(textStyle: textTheme.labelLarge),
      labelMedium: livvic(textStyle: textTheme.labelMedium),
      labelSmall: livvic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lobster font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lobster
  static TextStyle lobster({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bcc991b3c5526270f429044e4ffffe31f79b74457131ce78861ccb286f28ff24',
        201400,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lobster',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lobster font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lobster
  static TextTheme lobsterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lobster(textStyle: textTheme.displayLarge),
      displayMedium: lobster(textStyle: textTheme.displayMedium),
      displaySmall: lobster(textStyle: textTheme.displaySmall),
      headlineLarge: lobster(textStyle: textTheme.headlineLarge),
      headlineMedium: lobster(textStyle: textTheme.headlineMedium),
      headlineSmall: lobster(textStyle: textTheme.headlineSmall),
      titleLarge: lobster(textStyle: textTheme.titleLarge),
      titleMedium: lobster(textStyle: textTheme.titleMedium),
      titleSmall: lobster(textStyle: textTheme.titleSmall),
      bodyLarge: lobster(textStyle: textTheme.bodyLarge),
      bodyMedium: lobster(textStyle: textTheme.bodyMedium),
      bodySmall: lobster(textStyle: textTheme.bodySmall),
      labelLarge: lobster(textStyle: textTheme.labelLarge),
      labelMedium: lobster(textStyle: textTheme.labelMedium),
      labelSmall: lobster(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lobster Two font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lobster+Two
  static TextStyle lobsterTwo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6d7712f5b09d919fecc2dc2c7d45e3cb7e33fcb177f9dd9f6b104e1a67f4f81',
        86192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '59e87ee18f45be60e8f134a661844826b9612407a2029fd0ce2fc3a4e128fb92',
        87900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e28f61b77609a7b1bb1d935a2104341d0b5e95c4b8d13278a104ab950510bdb1',
        85088,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3296840d8dd26776a1b3b4035e50cfe8274d33da7edf58122a019fc41656c963',
        87816,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LobsterTwo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lobster Two font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lobster+Two
  static TextTheme lobsterTwoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lobsterTwo(textStyle: textTheme.displayLarge),
      displayMedium: lobsterTwo(textStyle: textTheme.displayMedium),
      displaySmall: lobsterTwo(textStyle: textTheme.displaySmall),
      headlineLarge: lobsterTwo(textStyle: textTheme.headlineLarge),
      headlineMedium: lobsterTwo(textStyle: textTheme.headlineMedium),
      headlineSmall: lobsterTwo(textStyle: textTheme.headlineSmall),
      titleLarge: lobsterTwo(textStyle: textTheme.titleLarge),
      titleMedium: lobsterTwo(textStyle: textTheme.titleMedium),
      titleSmall: lobsterTwo(textStyle: textTheme.titleSmall),
      bodyLarge: lobsterTwo(textStyle: textTheme.bodyLarge),
      bodyMedium: lobsterTwo(textStyle: textTheme.bodyMedium),
      bodySmall: lobsterTwo(textStyle: textTheme.bodySmall),
      labelLarge: lobsterTwo(textStyle: textTheme.labelLarge),
      labelMedium: lobsterTwo(textStyle: textTheme.labelMedium),
      labelSmall: lobsterTwo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Londrina Outline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Londrina+Outline
  static TextStyle londrinaOutline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9fc2ed19278d215fe23240374fe907ca7960583aa59fb4fa5dcbfe472b47cbdc',
        97436,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LondrinaOutline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Londrina Outline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Londrina+Outline
  static TextTheme londrinaOutlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: londrinaOutline(textStyle: textTheme.displayLarge),
      displayMedium: londrinaOutline(textStyle: textTheme.displayMedium),
      displaySmall: londrinaOutline(textStyle: textTheme.displaySmall),
      headlineLarge: londrinaOutline(textStyle: textTheme.headlineLarge),
      headlineMedium: londrinaOutline(textStyle: textTheme.headlineMedium),
      headlineSmall: londrinaOutline(textStyle: textTheme.headlineSmall),
      titleLarge: londrinaOutline(textStyle: textTheme.titleLarge),
      titleMedium: londrinaOutline(textStyle: textTheme.titleMedium),
      titleSmall: londrinaOutline(textStyle: textTheme.titleSmall),
      bodyLarge: londrinaOutline(textStyle: textTheme.bodyLarge),
      bodyMedium: londrinaOutline(textStyle: textTheme.bodyMedium),
      bodySmall: londrinaOutline(textStyle: textTheme.bodySmall),
      labelLarge: londrinaOutline(textStyle: textTheme.labelLarge),
      labelMedium: londrinaOutline(textStyle: textTheme.labelMedium),
      labelSmall: londrinaOutline(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Londrina Shadow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Londrina+Shadow
  static TextStyle londrinaShadow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05d8614f2e2b1a0193d341552e88984241ca7d9854e87ed7c464725c698a2cad',
        97348,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LondrinaShadow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Londrina Shadow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Londrina+Shadow
  static TextTheme londrinaShadowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: londrinaShadow(textStyle: textTheme.displayLarge),
      displayMedium: londrinaShadow(textStyle: textTheme.displayMedium),
      displaySmall: londrinaShadow(textStyle: textTheme.displaySmall),
      headlineLarge: londrinaShadow(textStyle: textTheme.headlineLarge),
      headlineMedium: londrinaShadow(textStyle: textTheme.headlineMedium),
      headlineSmall: londrinaShadow(textStyle: textTheme.headlineSmall),
      titleLarge: londrinaShadow(textStyle: textTheme.titleLarge),
      titleMedium: londrinaShadow(textStyle: textTheme.titleMedium),
      titleSmall: londrinaShadow(textStyle: textTheme.titleSmall),
      bodyLarge: londrinaShadow(textStyle: textTheme.bodyLarge),
      bodyMedium: londrinaShadow(textStyle: textTheme.bodyMedium),
      bodySmall: londrinaShadow(textStyle: textTheme.bodySmall),
      labelLarge: londrinaShadow(textStyle: textTheme.labelLarge),
      labelMedium: londrinaShadow(textStyle: textTheme.labelMedium),
      labelSmall: londrinaShadow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Londrina Sketch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Londrina+Sketch
  static TextStyle londrinaSketch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1e120f66adaa5dd805ca98005d520626b1995e6a0a29cfbded0245cac9fc9c9f',
        222572,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LondrinaSketch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Londrina Sketch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Londrina+Sketch
  static TextTheme londrinaSketchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: londrinaSketch(textStyle: textTheme.displayLarge),
      displayMedium: londrinaSketch(textStyle: textTheme.displayMedium),
      displaySmall: londrinaSketch(textStyle: textTheme.displaySmall),
      headlineLarge: londrinaSketch(textStyle: textTheme.headlineLarge),
      headlineMedium: londrinaSketch(textStyle: textTheme.headlineMedium),
      headlineSmall: londrinaSketch(textStyle: textTheme.headlineSmall),
      titleLarge: londrinaSketch(textStyle: textTheme.titleLarge),
      titleMedium: londrinaSketch(textStyle: textTheme.titleMedium),
      titleSmall: londrinaSketch(textStyle: textTheme.titleSmall),
      bodyLarge: londrinaSketch(textStyle: textTheme.bodyLarge),
      bodyMedium: londrinaSketch(textStyle: textTheme.bodyMedium),
      bodySmall: londrinaSketch(textStyle: textTheme.bodySmall),
      labelLarge: londrinaSketch(textStyle: textTheme.labelLarge),
      labelMedium: londrinaSketch(textStyle: textTheme.labelMedium),
      labelSmall: londrinaSketch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Londrina Solid font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Londrina+Solid
  static TextStyle londrinaSolid({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9348632393f204f3286186658855b3de3469193a0ca884838fcec9949a37b526',
        55656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b19098f313a61e786c451b0f6b6fdad975758e3e4bbe39e37508687b1b97808',
        57252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '517a5f1d02e55c27a2d170dae5dd1dd77a41bd6f73e41f097a5a66fbff6adde7',
        61240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '322d0c32db6f0a9b86334019441ec241c484a1ecf1e9f1e57a006f4e9b10485e',
        57996,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LondrinaSolid',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Londrina Solid font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Londrina+Solid
  static TextTheme londrinaSolidTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: londrinaSolid(textStyle: textTheme.displayLarge),
      displayMedium: londrinaSolid(textStyle: textTheme.displayMedium),
      displaySmall: londrinaSolid(textStyle: textTheme.displaySmall),
      headlineLarge: londrinaSolid(textStyle: textTheme.headlineLarge),
      headlineMedium: londrinaSolid(textStyle: textTheme.headlineMedium),
      headlineSmall: londrinaSolid(textStyle: textTheme.headlineSmall),
      titleLarge: londrinaSolid(textStyle: textTheme.titleLarge),
      titleMedium: londrinaSolid(textStyle: textTheme.titleMedium),
      titleSmall: londrinaSolid(textStyle: textTheme.titleSmall),
      bodyLarge: londrinaSolid(textStyle: textTheme.bodyLarge),
      bodyMedium: londrinaSolid(textStyle: textTheme.bodyMedium),
      bodySmall: londrinaSolid(textStyle: textTheme.bodySmall),
      labelLarge: londrinaSolid(textStyle: textTheme.labelLarge),
      labelMedium: londrinaSolid(textStyle: textTheme.labelMedium),
      labelSmall: londrinaSolid(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Long Cang font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Long+Cang
  static TextStyle longCang({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f626a05f45d156332017025fc68902a92f57f51ac57bb4a79097ee7bb1a97352',
        5150448,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LongCang',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Long Cang font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Long+Cang
  static TextTheme longCangTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: longCang(textStyle: textTheme.displayLarge),
      displayMedium: longCang(textStyle: textTheme.displayMedium),
      displaySmall: longCang(textStyle: textTheme.displaySmall),
      headlineLarge: longCang(textStyle: textTheme.headlineLarge),
      headlineMedium: longCang(textStyle: textTheme.headlineMedium),
      headlineSmall: longCang(textStyle: textTheme.headlineSmall),
      titleLarge: longCang(textStyle: textTheme.titleLarge),
      titleMedium: longCang(textStyle: textTheme.titleMedium),
      titleSmall: longCang(textStyle: textTheme.titleSmall),
      bodyLarge: longCang(textStyle: textTheme.bodyLarge),
      bodyMedium: longCang(textStyle: textTheme.bodyMedium),
      bodySmall: longCang(textStyle: textTheme.bodySmall),
      labelLarge: longCang(textStyle: textTheme.labelLarge),
      labelMedium: longCang(textStyle: textTheme.labelMedium),
      labelSmall: longCang(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lora font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lora
  static TextStyle lora({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81c1d8bb53ed86bcffaf6058413204e53a55c96f42bbe9f2cc49480e15da139f',
        132952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '025ba99430c0cbc202fe5677388e799ab1dbd25af5dfae755c97a3b000af5a7c',
        132964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '986ac4ea1310c1cb8806179c82de25a2285cb04ecfe6fa4e9e26781738ea984f',
        133332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f7c7da149b44a17c4fdf70a3e02a3e8a741dadccc24e315009625c2e37c5420',
        132860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6a574f0862a0ad1a59239d4bb437ac3fc6169101c2dc8ef5e53a02c0fac4013c',
        138352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0542fd42d9ed3e20738c58e346424d2f6e068c61b32c37160476d7fab04258d8',
        139244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd265f2242086f0acbcee6bee4b9a4d545ddac433f81686c3443ec2f4c2e87433',
        139288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cb5f35cd51c075ce92da9925845dad90ae37e351295b031b345a86a9a41f8915',
        139284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lora',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lora font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lora
  static TextTheme loraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lora(textStyle: textTheme.displayLarge),
      displayMedium: lora(textStyle: textTheme.displayMedium),
      displaySmall: lora(textStyle: textTheme.displaySmall),
      headlineLarge: lora(textStyle: textTheme.headlineLarge),
      headlineMedium: lora(textStyle: textTheme.headlineMedium),
      headlineSmall: lora(textStyle: textTheme.headlineSmall),
      titleLarge: lora(textStyle: textTheme.titleLarge),
      titleMedium: lora(textStyle: textTheme.titleMedium),
      titleSmall: lora(textStyle: textTheme.titleSmall),
      bodyLarge: lora(textStyle: textTheme.bodyLarge),
      bodyMedium: lora(textStyle: textTheme.bodyMedium),
      bodySmall: lora(textStyle: textTheme.bodySmall),
      labelLarge: lora(textStyle: textTheme.labelLarge),
      labelMedium: lora(textStyle: textTheme.labelMedium),
      labelSmall: lora(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Love Light font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Love+Light
  static TextStyle loveLight({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d9dd144def109b14ba888b7bcf5c0fed2a7e68fcf8b6de1c06408a9f2ef5662',
        102772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LoveLight',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Love Light font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Love+Light
  static TextTheme loveLightTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: loveLight(textStyle: textTheme.displayLarge),
      displayMedium: loveLight(textStyle: textTheme.displayMedium),
      displaySmall: loveLight(textStyle: textTheme.displaySmall),
      headlineLarge: loveLight(textStyle: textTheme.headlineLarge),
      headlineMedium: loveLight(textStyle: textTheme.headlineMedium),
      headlineSmall: loveLight(textStyle: textTheme.headlineSmall),
      titleLarge: loveLight(textStyle: textTheme.titleLarge),
      titleMedium: loveLight(textStyle: textTheme.titleMedium),
      titleSmall: loveLight(textStyle: textTheme.titleSmall),
      bodyLarge: loveLight(textStyle: textTheme.bodyLarge),
      bodyMedium: loveLight(textStyle: textTheme.bodyMedium),
      bodySmall: loveLight(textStyle: textTheme.bodySmall),
      labelLarge: loveLight(textStyle: textTheme.labelLarge),
      labelMedium: loveLight(textStyle: textTheme.labelMedium),
      labelSmall: loveLight(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Love Ya Like A Sister font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Love+Ya+Like+A+Sister
  static TextStyle loveYaLikeASister({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14f984111857efdce2eef5d32b761a265155ca290b496e43ae5c4fe22d659e36',
        269092,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LoveYaLikeASister',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Love Ya Like A Sister font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Love+Ya+Like+A+Sister
  static TextTheme loveYaLikeASisterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: loveYaLikeASister(textStyle: textTheme.displayLarge),
      displayMedium: loveYaLikeASister(textStyle: textTheme.displayMedium),
      displaySmall: loveYaLikeASister(textStyle: textTheme.displaySmall),
      headlineLarge: loveYaLikeASister(textStyle: textTheme.headlineLarge),
      headlineMedium: loveYaLikeASister(textStyle: textTheme.headlineMedium),
      headlineSmall: loveYaLikeASister(textStyle: textTheme.headlineSmall),
      titleLarge: loveYaLikeASister(textStyle: textTheme.titleLarge),
      titleMedium: loveYaLikeASister(textStyle: textTheme.titleMedium),
      titleSmall: loveYaLikeASister(textStyle: textTheme.titleSmall),
      bodyLarge: loveYaLikeASister(textStyle: textTheme.bodyLarge),
      bodyMedium: loveYaLikeASister(textStyle: textTheme.bodyMedium),
      bodySmall: loveYaLikeASister(textStyle: textTheme.bodySmall),
      labelLarge: loveYaLikeASister(textStyle: textTheme.labelLarge),
      labelMedium: loveYaLikeASister(textStyle: textTheme.labelMedium),
      labelSmall: loveYaLikeASister(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Loved by the King font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Loved+by+the+King
  static TextStyle lovedByTheKing({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bca936d0e3732555d26dd50201a6ffdc3fea2863bd378d24a560fff95fd87521',
        24648,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LovedbytheKing',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Loved by the King font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Loved+by+the+King
  static TextTheme lovedByTheKingTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lovedByTheKing(textStyle: textTheme.displayLarge),
      displayMedium: lovedByTheKing(textStyle: textTheme.displayMedium),
      displaySmall: lovedByTheKing(textStyle: textTheme.displaySmall),
      headlineLarge: lovedByTheKing(textStyle: textTheme.headlineLarge),
      headlineMedium: lovedByTheKing(textStyle: textTheme.headlineMedium),
      headlineSmall: lovedByTheKing(textStyle: textTheme.headlineSmall),
      titleLarge: lovedByTheKing(textStyle: textTheme.titleLarge),
      titleMedium: lovedByTheKing(textStyle: textTheme.titleMedium),
      titleSmall: lovedByTheKing(textStyle: textTheme.titleSmall),
      bodyLarge: lovedByTheKing(textStyle: textTheme.bodyLarge),
      bodyMedium: lovedByTheKing(textStyle: textTheme.bodyMedium),
      bodySmall: lovedByTheKing(textStyle: textTheme.bodySmall),
      labelLarge: lovedByTheKing(textStyle: textTheme.labelLarge),
      labelMedium: lovedByTheKing(textStyle: textTheme.labelMedium),
      labelSmall: lovedByTheKing(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lovers Quarrel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lovers+Quarrel
  static TextStyle loversQuarrel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '44c12808d2367b75f92c40e915f6508a51971650bb789a0f00d599f2cc92a788',
        67276,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LoversQuarrel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lovers Quarrel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lovers+Quarrel
  static TextTheme loversQuarrelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: loversQuarrel(textStyle: textTheme.displayLarge),
      displayMedium: loversQuarrel(textStyle: textTheme.displayMedium),
      displaySmall: loversQuarrel(textStyle: textTheme.displaySmall),
      headlineLarge: loversQuarrel(textStyle: textTheme.headlineLarge),
      headlineMedium: loversQuarrel(textStyle: textTheme.headlineMedium),
      headlineSmall: loversQuarrel(textStyle: textTheme.headlineSmall),
      titleLarge: loversQuarrel(textStyle: textTheme.titleLarge),
      titleMedium: loversQuarrel(textStyle: textTheme.titleMedium),
      titleSmall: loversQuarrel(textStyle: textTheme.titleSmall),
      bodyLarge: loversQuarrel(textStyle: textTheme.bodyLarge),
      bodyMedium: loversQuarrel(textStyle: textTheme.bodyMedium),
      bodySmall: loversQuarrel(textStyle: textTheme.bodySmall),
      labelLarge: loversQuarrel(textStyle: textTheme.labelLarge),
      labelMedium: loversQuarrel(textStyle: textTheme.labelMedium),
      labelSmall: loversQuarrel(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Luckiest Guy font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Luckiest+Guy
  static TextStyle luckiestGuy({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c4f869794d4cbddf4b71e511364d211e9e48f6c1bf0a89064b815db21c1a81dc',
        57376,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LuckiestGuy',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Luckiest Guy font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Luckiest+Guy
  static TextTheme luckiestGuyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: luckiestGuy(textStyle: textTheme.displayLarge),
      displayMedium: luckiestGuy(textStyle: textTheme.displayMedium),
      displaySmall: luckiestGuy(textStyle: textTheme.displaySmall),
      headlineLarge: luckiestGuy(textStyle: textTheme.headlineLarge),
      headlineMedium: luckiestGuy(textStyle: textTheme.headlineMedium),
      headlineSmall: luckiestGuy(textStyle: textTheme.headlineSmall),
      titleLarge: luckiestGuy(textStyle: textTheme.titleLarge),
      titleMedium: luckiestGuy(textStyle: textTheme.titleMedium),
      titleSmall: luckiestGuy(textStyle: textTheme.titleSmall),
      bodyLarge: luckiestGuy(textStyle: textTheme.bodyLarge),
      bodyMedium: luckiestGuy(textStyle: textTheme.bodyMedium),
      bodySmall: luckiestGuy(textStyle: textTheme.bodySmall),
      labelLarge: luckiestGuy(textStyle: textTheme.labelLarge),
      labelMedium: luckiestGuy(textStyle: textTheme.labelMedium),
      labelSmall: luckiestGuy(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lugrasimo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lugrasimo
  static TextStyle lugrasimo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b2e3f9802882905cab96ab9fd3beb0e08a58d5f635f2e7b1bb153449ec40fd83',
        31752,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lugrasimo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lugrasimo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lugrasimo
  static TextTheme lugrasimoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lugrasimo(textStyle: textTheme.displayLarge),
      displayMedium: lugrasimo(textStyle: textTheme.displayMedium),
      displaySmall: lugrasimo(textStyle: textTheme.displaySmall),
      headlineLarge: lugrasimo(textStyle: textTheme.headlineLarge),
      headlineMedium: lugrasimo(textStyle: textTheme.headlineMedium),
      headlineSmall: lugrasimo(textStyle: textTheme.headlineSmall),
      titleLarge: lugrasimo(textStyle: textTheme.titleLarge),
      titleMedium: lugrasimo(textStyle: textTheme.titleMedium),
      titleSmall: lugrasimo(textStyle: textTheme.titleSmall),
      bodyLarge: lugrasimo(textStyle: textTheme.bodyLarge),
      bodyMedium: lugrasimo(textStyle: textTheme.bodyMedium),
      bodySmall: lugrasimo(textStyle: textTheme.bodySmall),
      labelLarge: lugrasimo(textStyle: textTheme.labelLarge),
      labelMedium: lugrasimo(textStyle: textTheme.labelMedium),
      labelSmall: lugrasimo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lumanosimo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lumanosimo
  static TextStyle lumanosimo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba8f118f4dd79156516aa75fc454097d2ff8edcf18926430905f7cb62282e000',
        37996,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lumanosimo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lumanosimo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lumanosimo
  static TextTheme lumanosimoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lumanosimo(textStyle: textTheme.displayLarge),
      displayMedium: lumanosimo(textStyle: textTheme.displayMedium),
      displaySmall: lumanosimo(textStyle: textTheme.displaySmall),
      headlineLarge: lumanosimo(textStyle: textTheme.headlineLarge),
      headlineMedium: lumanosimo(textStyle: textTheme.headlineMedium),
      headlineSmall: lumanosimo(textStyle: textTheme.headlineSmall),
      titleLarge: lumanosimo(textStyle: textTheme.titleLarge),
      titleMedium: lumanosimo(textStyle: textTheme.titleMedium),
      titleSmall: lumanosimo(textStyle: textTheme.titleSmall),
      bodyLarge: lumanosimo(textStyle: textTheme.bodyLarge),
      bodyMedium: lumanosimo(textStyle: textTheme.bodyMedium),
      bodySmall: lumanosimo(textStyle: textTheme.bodySmall),
      labelLarge: lumanosimo(textStyle: textTheme.labelLarge),
      labelMedium: lumanosimo(textStyle: textTheme.labelMedium),
      labelSmall: lumanosimo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lunasima font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lunasima
  static TextStyle lunasima({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd9ca470cd41f75f15fcf7c2f1d9bec917d5ee0e8f0c5bee1ad353cfd6bc0becd',
        193324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6cf4a91ecd17c5c17cddd4e851bc645caad05d4311f9ce67b1f14e35eb286a0',
        194644,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lunasima',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lunasima font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lunasima
  static TextTheme lunasimaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lunasima(textStyle: textTheme.displayLarge),
      displayMedium: lunasima(textStyle: textTheme.displayMedium),
      displaySmall: lunasima(textStyle: textTheme.displaySmall),
      headlineLarge: lunasima(textStyle: textTheme.headlineLarge),
      headlineMedium: lunasima(textStyle: textTheme.headlineMedium),
      headlineSmall: lunasima(textStyle: textTheme.headlineSmall),
      titleLarge: lunasima(textStyle: textTheme.titleLarge),
      titleMedium: lunasima(textStyle: textTheme.titleMedium),
      titleSmall: lunasima(textStyle: textTheme.titleSmall),
      bodyLarge: lunasima(textStyle: textTheme.bodyLarge),
      bodyMedium: lunasima(textStyle: textTheme.bodyMedium),
      bodySmall: lunasima(textStyle: textTheme.bodySmall),
      labelLarge: lunasima(textStyle: textTheme.labelLarge),
      labelMedium: lunasima(textStyle: textTheme.labelMedium),
      labelSmall: lunasima(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lusitana font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lusitana
  static TextStyle lusitana({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5d742aebeb4080d00c1887529c6b59532097e23d50ac1df7d36f330d76acabb5',
        28212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '194712af67a359068c1a5210e9ad6baf482eeab01bd7235a88328c4c37e12f94',
        27348,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lusitana',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lusitana font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lusitana
  static TextTheme lusitanaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lusitana(textStyle: textTheme.displayLarge),
      displayMedium: lusitana(textStyle: textTheme.displayMedium),
      displaySmall: lusitana(textStyle: textTheme.displaySmall),
      headlineLarge: lusitana(textStyle: textTheme.headlineLarge),
      headlineMedium: lusitana(textStyle: textTheme.headlineMedium),
      headlineSmall: lusitana(textStyle: textTheme.headlineSmall),
      titleLarge: lusitana(textStyle: textTheme.titleLarge),
      titleMedium: lusitana(textStyle: textTheme.titleMedium),
      titleSmall: lusitana(textStyle: textTheme.titleSmall),
      bodyLarge: lusitana(textStyle: textTheme.bodyLarge),
      bodyMedium: lusitana(textStyle: textTheme.bodyMedium),
      bodySmall: lusitana(textStyle: textTheme.bodySmall),
      labelLarge: lusitana(textStyle: textTheme.labelLarge),
      labelMedium: lusitana(textStyle: textTheme.labelMedium),
      labelSmall: lusitana(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Lustria font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lustria
  static TextStyle lustria({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '422e0ad50d1c98831279589bb3ae18eed2118b61e53ef63a41bb0ebf8ad7c951',
        34776,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Lustria',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Lustria font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Lustria
  static TextTheme lustriaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: lustria(textStyle: textTheme.displayLarge),
      displayMedium: lustria(textStyle: textTheme.displayMedium),
      displaySmall: lustria(textStyle: textTheme.displaySmall),
      headlineLarge: lustria(textStyle: textTheme.headlineLarge),
      headlineMedium: lustria(textStyle: textTheme.headlineMedium),
      headlineSmall: lustria(textStyle: textTheme.headlineSmall),
      titleLarge: lustria(textStyle: textTheme.titleLarge),
      titleMedium: lustria(textStyle: textTheme.titleMedium),
      titleSmall: lustria(textStyle: textTheme.titleSmall),
      bodyLarge: lustria(textStyle: textTheme.bodyLarge),
      bodyMedium: lustria(textStyle: textTheme.bodyMedium),
      bodySmall: lustria(textStyle: textTheme.bodySmall),
      labelLarge: lustria(textStyle: textTheme.labelLarge),
      labelMedium: lustria(textStyle: textTheme.labelMedium),
      labelSmall: lustria(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Luxurious Roman font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Luxurious+Roman
  static TextStyle luxuriousRoman({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1579a50f2e3e954fdc0188f4156caa15b1fca74ed9a8cd378488ce59e06d38f6',
        95244,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LuxuriousRoman',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Luxurious Roman font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Luxurious+Roman
  static TextTheme luxuriousRomanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: luxuriousRoman(textStyle: textTheme.displayLarge),
      displayMedium: luxuriousRoman(textStyle: textTheme.displayMedium),
      displaySmall: luxuriousRoman(textStyle: textTheme.displaySmall),
      headlineLarge: luxuriousRoman(textStyle: textTheme.headlineLarge),
      headlineMedium: luxuriousRoman(textStyle: textTheme.headlineMedium),
      headlineSmall: luxuriousRoman(textStyle: textTheme.headlineSmall),
      titleLarge: luxuriousRoman(textStyle: textTheme.titleLarge),
      titleMedium: luxuriousRoman(textStyle: textTheme.titleMedium),
      titleSmall: luxuriousRoman(textStyle: textTheme.titleSmall),
      bodyLarge: luxuriousRoman(textStyle: textTheme.bodyLarge),
      bodyMedium: luxuriousRoman(textStyle: textTheme.bodyMedium),
      bodySmall: luxuriousRoman(textStyle: textTheme.bodySmall),
      labelLarge: luxuriousRoman(textStyle: textTheme.labelLarge),
      labelMedium: luxuriousRoman(textStyle: textTheme.labelMedium),
      labelSmall: luxuriousRoman(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Luxurious Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Luxurious+Script
  static TextStyle luxuriousScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e52cb028a05a55570e840d5401750cc3507d14f3e304c02da8a16418b7682709',
        129504,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'LuxuriousScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Luxurious Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Luxurious+Script
  static TextTheme luxuriousScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: luxuriousScript(textStyle: textTheme.displayLarge),
      displayMedium: luxuriousScript(textStyle: textTheme.displayMedium),
      displaySmall: luxuriousScript(textStyle: textTheme.displaySmall),
      headlineLarge: luxuriousScript(textStyle: textTheme.headlineLarge),
      headlineMedium: luxuriousScript(textStyle: textTheme.headlineMedium),
      headlineSmall: luxuriousScript(textStyle: textTheme.headlineSmall),
      titleLarge: luxuriousScript(textStyle: textTheme.titleLarge),
      titleMedium: luxuriousScript(textStyle: textTheme.titleMedium),
      titleSmall: luxuriousScript(textStyle: textTheme.titleSmall),
      bodyLarge: luxuriousScript(textStyle: textTheme.bodyLarge),
      bodyMedium: luxuriousScript(textStyle: textTheme.bodyMedium),
      bodySmall: luxuriousScript(textStyle: textTheme.bodySmall),
      labelLarge: luxuriousScript(textStyle: textTheme.labelLarge),
      labelMedium: luxuriousScript(textStyle: textTheme.labelMedium),
      labelSmall: luxuriousScript(textStyle: textTheme.labelSmall),
    );
  }
}
