// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'F'.
class PartF {
  /// Applies the Fahkwang font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fahkwang
  static TextStyle fahkwang({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0cb8fd061f024de62b282a85795b56b1b88e2a298b384d00c0da6e1b82952702',
        79476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '264ec7a8227b83f6b3909bcc96015f61ae98b339958fd414cf1630944b64b91f',
        82060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad984fc7acc2a3b0f217cab459bc76ae77a4c91bf912130f20b537da0445e057',
        79520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '42bcb606e75b04d975540e954cd96b583e4e496150a5bac4e3f89dd0757a3db7',
        82128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '472d87bc12ee548390dfcfa8d71af03c5d41077a357ba2cf9e14d906e1ffdab1',
        79356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ba6e001317e8a3f0044776a08bb748f38e592df0acc5551dfb032e5bdf2ac50f',
        82044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e1eb3160395f61ae21bf0b369ab17a42fd82ffd509822f48ec66ff5225da678a',
        79100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd0c733c9c41386a8e357d7954a1ef6ff3c4b9b444b7eac7ffe311532bfa920f2',
        82064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bab6190f47708fab574d1c4b55c29483f22b2113e4f6d4a516ccbf888673ce02',
        79136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f380eb48e3b5d0916182203845c5f181ef71b024c97cae157685b2966ab0311f',
        82048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c11cf7f035234d25ab7f689109c8028b1f4f5e57392166b930e081ee7b60aae',
        78988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '15c8800ebdd3426fe179cc54afc50ee748abb21ae22330d5b2d4c6f06978940a',
        81940,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Fahkwang',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fahkwang font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fahkwang
  static TextTheme fahkwangTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fahkwang(textStyle: textTheme.displayLarge),
      displayMedium: fahkwang(textStyle: textTheme.displayMedium),
      displaySmall: fahkwang(textStyle: textTheme.displaySmall),
      headlineLarge: fahkwang(textStyle: textTheme.headlineLarge),
      headlineMedium: fahkwang(textStyle: textTheme.headlineMedium),
      headlineSmall: fahkwang(textStyle: textTheme.headlineSmall),
      titleLarge: fahkwang(textStyle: textTheme.titleLarge),
      titleMedium: fahkwang(textStyle: textTheme.titleMedium),
      titleSmall: fahkwang(textStyle: textTheme.titleSmall),
      bodyLarge: fahkwang(textStyle: textTheme.bodyLarge),
      bodyMedium: fahkwang(textStyle: textTheme.bodyMedium),
      bodySmall: fahkwang(textStyle: textTheme.bodySmall),
      labelLarge: fahkwang(textStyle: textTheme.labelLarge),
      labelMedium: fahkwang(textStyle: textTheme.labelMedium),
      labelSmall: fahkwang(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Familjen Grotesk font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Familjen+Grotesk
  static TextStyle familjenGrotesk({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7259b43c31917813bb8cc21c5ae9072fd8302721f9fb2e38efb520ef5fc60735',
        55772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a61390724fcfee39ddaffcfcf9b8963414afa73612ca68cb79e4af1e2e31e963',
        56452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f1d6ea3145fa9c0c31589eafcbd5318475d23ca845b4da5ca432a0428544ec0',
        56496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7fbda7b01adc85b61c37b8573ad6fe39f7406916da0aecf2d827371a2d657066',
        56228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '70b08556272dab3e5e4023d43557079f176b631e032183b851f6aada9d0ca6f9',
        57804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0837b47daa96aa9448ac0f93157bc49be63b16180a3614d226a4b3a2352665b7',
        58664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6c552909af287e6376505584196dfd80759f1bcff34a50e83a8ed93a98594244',
        58692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6976331a1f4e5b469b0991373583c28377ceab49be4c7acb079ee45670fb1bae',
        58420,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FamiljenGrotesk',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Familjen Grotesk font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Familjen+Grotesk
  static TextTheme familjenGroteskTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: familjenGrotesk(textStyle: textTheme.displayLarge),
      displayMedium: familjenGrotesk(textStyle: textTheme.displayMedium),
      displaySmall: familjenGrotesk(textStyle: textTheme.displaySmall),
      headlineLarge: familjenGrotesk(textStyle: textTheme.headlineLarge),
      headlineMedium: familjenGrotesk(textStyle: textTheme.headlineMedium),
      headlineSmall: familjenGrotesk(textStyle: textTheme.headlineSmall),
      titleLarge: familjenGrotesk(textStyle: textTheme.titleLarge),
      titleMedium: familjenGrotesk(textStyle: textTheme.titleMedium),
      titleSmall: familjenGrotesk(textStyle: textTheme.titleSmall),
      bodyLarge: familjenGrotesk(textStyle: textTheme.bodyLarge),
      bodyMedium: familjenGrotesk(textStyle: textTheme.bodyMedium),
      bodySmall: familjenGrotesk(textStyle: textTheme.bodySmall),
      labelLarge: familjenGrotesk(textStyle: textTheme.labelLarge),
      labelMedium: familjenGrotesk(textStyle: textTheme.labelMedium),
      labelSmall: familjenGrotesk(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fanwood Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fanwood+Text
  static TextStyle fanwoodText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aafd3294f9a09da2b894a790ca6bacc4f7f4fe0ba95f476c0740ef015e719d6f',
        78540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8e1314a398cc06f258cdc39571392c94f722070a96bf360fb189240d36496576',
        86116,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FanwoodText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fanwood Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fanwood+Text
  static TextTheme fanwoodTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fanwoodText(textStyle: textTheme.displayLarge),
      displayMedium: fanwoodText(textStyle: textTheme.displayMedium),
      displaySmall: fanwoodText(textStyle: textTheme.displaySmall),
      headlineLarge: fanwoodText(textStyle: textTheme.headlineLarge),
      headlineMedium: fanwoodText(textStyle: textTheme.headlineMedium),
      headlineSmall: fanwoodText(textStyle: textTheme.headlineSmall),
      titleLarge: fanwoodText(textStyle: textTheme.titleLarge),
      titleMedium: fanwoodText(textStyle: textTheme.titleMedium),
      titleSmall: fanwoodText(textStyle: textTheme.titleSmall),
      bodyLarge: fanwoodText(textStyle: textTheme.bodyLarge),
      bodyMedium: fanwoodText(textStyle: textTheme.bodyMedium),
      bodySmall: fanwoodText(textStyle: textTheme.bodySmall),
      labelLarge: fanwoodText(textStyle: textTheme.labelLarge),
      labelMedium: fanwoodText(textStyle: textTheme.labelMedium),
      labelSmall: fanwoodText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Farro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Farro
  static TextStyle farro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5b1744cf5aa0a196e398c550490a2d253be12dc44c4414ee877c8899460296d7',
        39988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c28286e2ca113cc6e81b591003493aadeb26ce0d365b5f94ab9de4ec9cca48cc',
        39848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a621e533c3477021bd85c4f7327f15f62f76cee551243167078dcdccdcede2c',
        39896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b7061421e99be871b4d46f64408076a0c5f1c9db9858402b20ac6bbafd98e52e',
        39308,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Farro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Farro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Farro
  static TextTheme farroTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: farro(textStyle: textTheme.displayLarge),
      displayMedium: farro(textStyle: textTheme.displayMedium),
      displaySmall: farro(textStyle: textTheme.displaySmall),
      headlineLarge: farro(textStyle: textTheme.headlineLarge),
      headlineMedium: farro(textStyle: textTheme.headlineMedium),
      headlineSmall: farro(textStyle: textTheme.headlineSmall),
      titleLarge: farro(textStyle: textTheme.titleLarge),
      titleMedium: farro(textStyle: textTheme.titleMedium),
      titleSmall: farro(textStyle: textTheme.titleSmall),
      bodyLarge: farro(textStyle: textTheme.bodyLarge),
      bodyMedium: farro(textStyle: textTheme.bodyMedium),
      bodySmall: farro(textStyle: textTheme.bodySmall),
      labelLarge: farro(textStyle: textTheme.labelLarge),
      labelMedium: farro(textStyle: textTheme.labelMedium),
      labelSmall: farro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Farsan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Farsan
  static TextStyle farsan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '38b260a621b1d96225cc2a8eadf167ef133fc6d5cc4ae9a4b40ed6c942a69007',
        241320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Farsan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Farsan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Farsan
  static TextTheme farsanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: farsan(textStyle: textTheme.displayLarge),
      displayMedium: farsan(textStyle: textTheme.displayMedium),
      displaySmall: farsan(textStyle: textTheme.displaySmall),
      headlineLarge: farsan(textStyle: textTheme.headlineLarge),
      headlineMedium: farsan(textStyle: textTheme.headlineMedium),
      headlineSmall: farsan(textStyle: textTheme.headlineSmall),
      titleLarge: farsan(textStyle: textTheme.titleLarge),
      titleMedium: farsan(textStyle: textTheme.titleMedium),
      titleSmall: farsan(textStyle: textTheme.titleSmall),
      bodyLarge: farsan(textStyle: textTheme.bodyLarge),
      bodyMedium: farsan(textStyle: textTheme.bodyMedium),
      bodySmall: farsan(textStyle: textTheme.bodySmall),
      labelLarge: farsan(textStyle: textTheme.labelLarge),
      labelMedium: farsan(textStyle: textTheme.labelMedium),
      labelSmall: farsan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fascinate font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fascinate
  static TextStyle fascinate({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '413110c729e64ab9bb2e2b3d75f4503a81a9c244a20f18f48e0fb0307950532e',
        48032,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Fascinate',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fascinate font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fascinate
  static TextTheme fascinateTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fascinate(textStyle: textTheme.displayLarge),
      displayMedium: fascinate(textStyle: textTheme.displayMedium),
      displaySmall: fascinate(textStyle: textTheme.displaySmall),
      headlineLarge: fascinate(textStyle: textTheme.headlineLarge),
      headlineMedium: fascinate(textStyle: textTheme.headlineMedium),
      headlineSmall: fascinate(textStyle: textTheme.headlineSmall),
      titleLarge: fascinate(textStyle: textTheme.titleLarge),
      titleMedium: fascinate(textStyle: textTheme.titleMedium),
      titleSmall: fascinate(textStyle: textTheme.titleSmall),
      bodyLarge: fascinate(textStyle: textTheme.bodyLarge),
      bodyMedium: fascinate(textStyle: textTheme.bodyMedium),
      bodySmall: fascinate(textStyle: textTheme.bodySmall),
      labelLarge: fascinate(textStyle: textTheme.labelLarge),
      labelMedium: fascinate(textStyle: textTheme.labelMedium),
      labelSmall: fascinate(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fascinate Inline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fascinate+Inline
  static TextStyle fascinateInline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2d55a8008b8cae16f166c5583cecd8aee312c58ab127b9883969a3f0c6c41c1',
        55516,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FascinateInline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fascinate Inline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fascinate+Inline
  static TextTheme fascinateInlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fascinateInline(textStyle: textTheme.displayLarge),
      displayMedium: fascinateInline(textStyle: textTheme.displayMedium),
      displaySmall: fascinateInline(textStyle: textTheme.displaySmall),
      headlineLarge: fascinateInline(textStyle: textTheme.headlineLarge),
      headlineMedium: fascinateInline(textStyle: textTheme.headlineMedium),
      headlineSmall: fascinateInline(textStyle: textTheme.headlineSmall),
      titleLarge: fascinateInline(textStyle: textTheme.titleLarge),
      titleMedium: fascinateInline(textStyle: textTheme.titleMedium),
      titleSmall: fascinateInline(textStyle: textTheme.titleSmall),
      bodyLarge: fascinateInline(textStyle: textTheme.bodyLarge),
      bodyMedium: fascinateInline(textStyle: textTheme.bodyMedium),
      bodySmall: fascinateInline(textStyle: textTheme.bodySmall),
      labelLarge: fascinateInline(textStyle: textTheme.labelLarge),
      labelMedium: fascinateInline(textStyle: textTheme.labelMedium),
      labelSmall: fascinateInline(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Faster One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Faster+One
  static TextStyle fasterOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8234af82a4476fd4dd484e3aea9a5c868ed98ab7d164d721bb504d88f7ad1242',
        48940,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FasterOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Faster One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Faster+One
  static TextTheme fasterOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fasterOne(textStyle: textTheme.displayLarge),
      displayMedium: fasterOne(textStyle: textTheme.displayMedium),
      displaySmall: fasterOne(textStyle: textTheme.displaySmall),
      headlineLarge: fasterOne(textStyle: textTheme.headlineLarge),
      headlineMedium: fasterOne(textStyle: textTheme.headlineMedium),
      headlineSmall: fasterOne(textStyle: textTheme.headlineSmall),
      titleLarge: fasterOne(textStyle: textTheme.titleLarge),
      titleMedium: fasterOne(textStyle: textTheme.titleMedium),
      titleSmall: fasterOne(textStyle: textTheme.titleSmall),
      bodyLarge: fasterOne(textStyle: textTheme.bodyLarge),
      bodyMedium: fasterOne(textStyle: textTheme.bodyMedium),
      bodySmall: fasterOne(textStyle: textTheme.bodySmall),
      labelLarge: fasterOne(textStyle: textTheme.labelLarge),
      labelMedium: fasterOne(textStyle: textTheme.labelMedium),
      labelSmall: fasterOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fasthand font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fasthand
  static TextStyle fasthand({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c5322dbb1195a6c5d1721cb512775ccd814fc0748e475d148affce6fbeea914',
        169044,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Fasthand',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fasthand font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fasthand
  static TextTheme fasthandTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fasthand(textStyle: textTheme.displayLarge),
      displayMedium: fasthand(textStyle: textTheme.displayMedium),
      displaySmall: fasthand(textStyle: textTheme.displaySmall),
      headlineLarge: fasthand(textStyle: textTheme.headlineLarge),
      headlineMedium: fasthand(textStyle: textTheme.headlineMedium),
      headlineSmall: fasthand(textStyle: textTheme.headlineSmall),
      titleLarge: fasthand(textStyle: textTheme.titleLarge),
      titleMedium: fasthand(textStyle: textTheme.titleMedium),
      titleSmall: fasthand(textStyle: textTheme.titleSmall),
      bodyLarge: fasthand(textStyle: textTheme.bodyLarge),
      bodyMedium: fasthand(textStyle: textTheme.bodyMedium),
      bodySmall: fasthand(textStyle: textTheme.bodySmall),
      labelLarge: fasthand(textStyle: textTheme.labelLarge),
      labelMedium: fasthand(textStyle: textTheme.labelMedium),
      labelSmall: fasthand(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fauna One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fauna+One
  static TextStyle faunaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48a8976b95e3c0a58d1da9665995f5bd8ee04ad651eeae3ad75e80b95ebbc6bb',
        36672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FaunaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fauna One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fauna+One
  static TextTheme faunaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: faunaOne(textStyle: textTheme.displayLarge),
      displayMedium: faunaOne(textStyle: textTheme.displayMedium),
      displaySmall: faunaOne(textStyle: textTheme.displaySmall),
      headlineLarge: faunaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: faunaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: faunaOne(textStyle: textTheme.headlineSmall),
      titleLarge: faunaOne(textStyle: textTheme.titleLarge),
      titleMedium: faunaOne(textStyle: textTheme.titleMedium),
      titleSmall: faunaOne(textStyle: textTheme.titleSmall),
      bodyLarge: faunaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: faunaOne(textStyle: textTheme.bodyMedium),
      bodySmall: faunaOne(textStyle: textTheme.bodySmall),
      labelLarge: faunaOne(textStyle: textTheme.labelLarge),
      labelMedium: faunaOne(textStyle: textTheme.labelMedium),
      labelSmall: faunaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Faustina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Faustina
  static TextStyle faustina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a625513eb984f115d79d3507c74bda76f6b99d363cf7713c4f77e6a626c9a23',
        69308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'efb4c183a4c6e8cdc593af93adadea6dea9ce647454d39c7f7b3fd4e2068122d',
        69464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8064c05d29d17a9cb10ffef380f1c1f3cf1f4da165181ee992bd9554e05cf5cb',
        69564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11e2ea82747c58afaa06c21869ddeb12c5b3b30b6e63d8a1161547ba34c32e34',
        69500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4fa14e1fc56ce27be0430a32a6eddc2ca431fb4e5800d9c518a8143e2160b731',
        69328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2fa5cc845e1bf42800604b29014f11017446276a0b2ebeaecd3f53cd3bbb83e0',
        69516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5d95d3f7f5835219904e868967d018eba8e5401d3035b834f857c78e16b85294',
        70980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '20f4652bde21faf78ff6142e45ca2376ab3ed905b5a13826373333499634dbc5',
        70808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f8484d35ac20426b400f50f3dd5ad8fe9983491976de9bbe1b5c13fb2aadfc4b',
        71000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a8d4237a337047864fe16f02c75bdb5033c620e4c08d8bda087a17059a9048a6',
        70968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b04bb75c42acb0e1c3637edff96486081180423f24a59573862fc3688b968458',
        70836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f04a6a938d3c0473360163571e5448b62efa3fd9071303bc5c5ed92c167c5237',
        70964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Faustina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Faustina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Faustina
  static TextTheme faustinaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: faustina(textStyle: textTheme.displayLarge),
      displayMedium: faustina(textStyle: textTheme.displayMedium),
      displaySmall: faustina(textStyle: textTheme.displaySmall),
      headlineLarge: faustina(textStyle: textTheme.headlineLarge),
      headlineMedium: faustina(textStyle: textTheme.headlineMedium),
      headlineSmall: faustina(textStyle: textTheme.headlineSmall),
      titleLarge: faustina(textStyle: textTheme.titleLarge),
      titleMedium: faustina(textStyle: textTheme.titleMedium),
      titleSmall: faustina(textStyle: textTheme.titleSmall),
      bodyLarge: faustina(textStyle: textTheme.bodyLarge),
      bodyMedium: faustina(textStyle: textTheme.bodyMedium),
      bodySmall: faustina(textStyle: textTheme.bodySmall),
      labelLarge: faustina(textStyle: textTheme.labelLarge),
      labelMedium: faustina(textStyle: textTheme.labelMedium),
      labelSmall: faustina(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Federant font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Federant
  static TextStyle federant({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '959a385543adfe511b552ae0794ccc1f2ba70936153554318a22e3d35931e9d0',
        29860,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Federant',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Federant font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Federant
  static TextTheme federantTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: federant(textStyle: textTheme.displayLarge),
      displayMedium: federant(textStyle: textTheme.displayMedium),
      displaySmall: federant(textStyle: textTheme.displaySmall),
      headlineLarge: federant(textStyle: textTheme.headlineLarge),
      headlineMedium: federant(textStyle: textTheme.headlineMedium),
      headlineSmall: federant(textStyle: textTheme.headlineSmall),
      titleLarge: federant(textStyle: textTheme.titleLarge),
      titleMedium: federant(textStyle: textTheme.titleMedium),
      titleSmall: federant(textStyle: textTheme.titleSmall),
      bodyLarge: federant(textStyle: textTheme.bodyLarge),
      bodyMedium: federant(textStyle: textTheme.bodyMedium),
      bodySmall: federant(textStyle: textTheme.bodySmall),
      labelLarge: federant(textStyle: textTheme.labelLarge),
      labelMedium: federant(textStyle: textTheme.labelMedium),
      labelSmall: federant(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Federo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Federo
  static TextStyle federo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '35a22539fea972ddd3a96d78981681adbdf58d50fac0b8dc95ca6e64224b1605',
        32456,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Federo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Federo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Federo
  static TextTheme federoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: federo(textStyle: textTheme.displayLarge),
      displayMedium: federo(textStyle: textTheme.displayMedium),
      displaySmall: federo(textStyle: textTheme.displaySmall),
      headlineLarge: federo(textStyle: textTheme.headlineLarge),
      headlineMedium: federo(textStyle: textTheme.headlineMedium),
      headlineSmall: federo(textStyle: textTheme.headlineSmall),
      titleLarge: federo(textStyle: textTheme.titleLarge),
      titleMedium: federo(textStyle: textTheme.titleMedium),
      titleSmall: federo(textStyle: textTheme.titleSmall),
      bodyLarge: federo(textStyle: textTheme.bodyLarge),
      bodyMedium: federo(textStyle: textTheme.bodyMedium),
      bodySmall: federo(textStyle: textTheme.bodySmall),
      labelLarge: federo(textStyle: textTheme.labelLarge),
      labelMedium: federo(textStyle: textTheme.labelMedium),
      labelSmall: federo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Felipa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Felipa
  static TextStyle felipa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ffd7301be382fdb76b332ebfdc0d7d3420ff1d461385da1505b03888961ef687',
        37508,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Felipa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Felipa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Felipa
  static TextTheme felipaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: felipa(textStyle: textTheme.displayLarge),
      displayMedium: felipa(textStyle: textTheme.displayMedium),
      displaySmall: felipa(textStyle: textTheme.displaySmall),
      headlineLarge: felipa(textStyle: textTheme.headlineLarge),
      headlineMedium: felipa(textStyle: textTheme.headlineMedium),
      headlineSmall: felipa(textStyle: textTheme.headlineSmall),
      titleLarge: felipa(textStyle: textTheme.titleLarge),
      titleMedium: felipa(textStyle: textTheme.titleMedium),
      titleSmall: felipa(textStyle: textTheme.titleSmall),
      bodyLarge: felipa(textStyle: textTheme.bodyLarge),
      bodyMedium: felipa(textStyle: textTheme.bodyMedium),
      bodySmall: felipa(textStyle: textTheme.bodySmall),
      labelLarge: felipa(textStyle: textTheme.labelLarge),
      labelMedium: felipa(textStyle: textTheme.labelMedium),
      labelSmall: felipa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fenix font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fenix
  static TextStyle fenix({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae1e4a9a9e8d0d701e76261ffa6691a42e0fc5800027d4c4a2dfc501703f7a77',
        40672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Fenix',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fenix font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fenix
  static TextTheme fenixTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fenix(textStyle: textTheme.displayLarge),
      displayMedium: fenix(textStyle: textTheme.displayMedium),
      displaySmall: fenix(textStyle: textTheme.displaySmall),
      headlineLarge: fenix(textStyle: textTheme.headlineLarge),
      headlineMedium: fenix(textStyle: textTheme.headlineMedium),
      headlineSmall: fenix(textStyle: textTheme.headlineSmall),
      titleLarge: fenix(textStyle: textTheme.titleLarge),
      titleMedium: fenix(textStyle: textTheme.titleMedium),
      titleSmall: fenix(textStyle: textTheme.titleSmall),
      bodyLarge: fenix(textStyle: textTheme.bodyLarge),
      bodyMedium: fenix(textStyle: textTheme.bodyMedium),
      bodySmall: fenix(textStyle: textTheme.bodySmall),
      labelLarge: fenix(textStyle: textTheme.labelLarge),
      labelMedium: fenix(textStyle: textTheme.labelMedium),
      labelSmall: fenix(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Festive font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Festive
  static TextStyle festive({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2eccfdb5fa672f597d1bfeaefb20ae3511ed192e6724d2b528278681a8bb9c50',
        422872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Festive',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Festive font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Festive
  static TextTheme festiveTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: festive(textStyle: textTheme.displayLarge),
      displayMedium: festive(textStyle: textTheme.displayMedium),
      displaySmall: festive(textStyle: textTheme.displaySmall),
      headlineLarge: festive(textStyle: textTheme.headlineLarge),
      headlineMedium: festive(textStyle: textTheme.headlineMedium),
      headlineSmall: festive(textStyle: textTheme.headlineSmall),
      titleLarge: festive(textStyle: textTheme.titleLarge),
      titleMedium: festive(textStyle: textTheme.titleMedium),
      titleSmall: festive(textStyle: textTheme.titleSmall),
      bodyLarge: festive(textStyle: textTheme.bodyLarge),
      bodyMedium: festive(textStyle: textTheme.bodyMedium),
      bodySmall: festive(textStyle: textTheme.bodySmall),
      labelLarge: festive(textStyle: textTheme.labelLarge),
      labelMedium: festive(textStyle: textTheme.labelMedium),
      labelSmall: festive(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Figtree font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Figtree
  static TextStyle figtree({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4bcd90a09c0bb27e3cda83cb206623ad858e8cef5f0a60e7873e467947bf349f',
        36484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2824ed89b9bda29d377106145026862f8764f883b4dd5cdefdfc7c67150d8e25',
        36604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f2273bf511e1c23bc509228a4ee630ea5825cddaa1103d456680667a1a9338c6',
        36628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3936af5ce7e4c37dfeb953334c6b3ea5943cd3133f475611769f9b586d8a681a',
        36884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11f5828ea316be172317189d9ade6fecb5eba512bb3aee2f49b3fa26b91de400',
        36840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a460b8a0b2849763f0ce2dc159b9f33a5a09b3bdc9ba36b78665aa6ef79982d2',
        36916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '12a4e1c083579af36cbd073fb488e36f437d0f597388a9f2477aef60641f5e74',
        36868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4222de1430f352d09f75dc916beafde70d017f20d92f50e36285ab4bfd41c1a9',
        36568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'eaaef27943753a90770ef9daaeeffb0be7f87f168b4a149e6e253b338fa1f07e',
        36604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '015b9d6a07b8e224437b5222af64bbefbdcc204086384b906fefba5e0d6709cb',
        36732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1d9c119ecb7ce586904b25cbd67028039399a6eeb6dc01f7bebe77260b21f23a',
        37004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ea8c7ba4be512c64769a5d0f628d68e4d2c8e6a39fecca8ef0b5da65aade93d4',
        36932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '27f87eb7bf5b505cecfab95b995c1337d124e416d4cb24c195f44e6f2d7cc13c',
        37016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fc2f2d65800c80438c62e6d7c5bad5e407bd58df0bc56d13a32e4d9fbbf80f8e',
        36892,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Figtree',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Figtree font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Figtree
  static TextTheme figtreeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: figtree(textStyle: textTheme.displayLarge),
      displayMedium: figtree(textStyle: textTheme.displayMedium),
      displaySmall: figtree(textStyle: textTheme.displaySmall),
      headlineLarge: figtree(textStyle: textTheme.headlineLarge),
      headlineMedium: figtree(textStyle: textTheme.headlineMedium),
      headlineSmall: figtree(textStyle: textTheme.headlineSmall),
      titleLarge: figtree(textStyle: textTheme.titleLarge),
      titleMedium: figtree(textStyle: textTheme.titleMedium),
      titleSmall: figtree(textStyle: textTheme.titleSmall),
      bodyLarge: figtree(textStyle: textTheme.bodyLarge),
      bodyMedium: figtree(textStyle: textTheme.bodyMedium),
      bodySmall: figtree(textStyle: textTheme.bodySmall),
      labelLarge: figtree(textStyle: textTheme.labelLarge),
      labelMedium: figtree(textStyle: textTheme.labelMedium),
      labelSmall: figtree(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Finger Paint font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Finger+Paint
  static TextStyle fingerPaint({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2affb87d6ee5d46c1770682a1b4b879713e2b4d38b60dd5d1c33504e718bc7d6',
        99632,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FingerPaint',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Finger Paint font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Finger+Paint
  static TextTheme fingerPaintTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fingerPaint(textStyle: textTheme.displayLarge),
      displayMedium: fingerPaint(textStyle: textTheme.displayMedium),
      displaySmall: fingerPaint(textStyle: textTheme.displaySmall),
      headlineLarge: fingerPaint(textStyle: textTheme.headlineLarge),
      headlineMedium: fingerPaint(textStyle: textTheme.headlineMedium),
      headlineSmall: fingerPaint(textStyle: textTheme.headlineSmall),
      titleLarge: fingerPaint(textStyle: textTheme.titleLarge),
      titleMedium: fingerPaint(textStyle: textTheme.titleMedium),
      titleSmall: fingerPaint(textStyle: textTheme.titleSmall),
      bodyLarge: fingerPaint(textStyle: textTheme.bodyLarge),
      bodyMedium: fingerPaint(textStyle: textTheme.bodyMedium),
      bodySmall: fingerPaint(textStyle: textTheme.bodySmall),
      labelLarge: fingerPaint(textStyle: textTheme.labelLarge),
      labelMedium: fingerPaint(textStyle: textTheme.labelMedium),
      labelSmall: fingerPaint(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Finlandica font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Finlandica
  static TextStyle finlandica({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe19bdd80a0cb7a4215f7f73871f268d1d73feb369129db66609731b96e11860',
        81184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f265e89f57137b55bf1b90bc857445e01f79c3a4c78a4365621ce080afbe9f5f',
        81320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11272a112b69a4c8c2c44a82a0167680268cdd0694bd18c7303b54036909baa8',
        81208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '62f1da1e9f88c1febf12b68008abcee00d1e54e3a2c12e55097b12cf2e88d7b1',
        80944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0ad4e769ba93affcb7bd410dec172d00317ab0a269b337f673ea2231e341cbac',
        85660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2b7504f10db51fa90a2adad274321c42c8dd32a7c6974a80c7ef24f1757898b7',
        85920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '55e504e9b9cb9a4aeaa65ce4fc7dab7c01e4187301f0cc13856ab51cd9b3b983',
        85952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4c79a4f6e05c80956f6f15f8a93aea6ccfce3e1c9044628413f05f7da1238fc3',
        85612,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Finlandica',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Finlandica font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Finlandica
  static TextTheme finlandicaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: finlandica(textStyle: textTheme.displayLarge),
      displayMedium: finlandica(textStyle: textTheme.displayMedium),
      displaySmall: finlandica(textStyle: textTheme.displaySmall),
      headlineLarge: finlandica(textStyle: textTheme.headlineLarge),
      headlineMedium: finlandica(textStyle: textTheme.headlineMedium),
      headlineSmall: finlandica(textStyle: textTheme.headlineSmall),
      titleLarge: finlandica(textStyle: textTheme.titleLarge),
      titleMedium: finlandica(textStyle: textTheme.titleMedium),
      titleSmall: finlandica(textStyle: textTheme.titleSmall),
      bodyLarge: finlandica(textStyle: textTheme.bodyLarge),
      bodyMedium: finlandica(textStyle: textTheme.bodyMedium),
      bodySmall: finlandica(textStyle: textTheme.bodySmall),
      labelLarge: finlandica(textStyle: textTheme.labelLarge),
      labelMedium: finlandica(textStyle: textTheme.labelMedium),
      labelSmall: finlandica(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fira Code font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fira+Code
  static TextStyle firaCode({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '59ae3f902919a8fc253572fcd979f416c27b85cc6c72c64d23a69efd30346dcf',
        179004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c885308226a16fcd522832b15a724535b3901f301283d2a73dc474fb3de43b7',
        178804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a6068095d3fa1a26a3ffd2cdd52f9fd069206558715a63a2687258f72f62950',
        178796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8cb39eeef3e606eb5431d41a86b66266fcf59c091bcadc69b50cb025d1beadbb',
        179152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '63b8b21b584f9545be49196c5294408380118100b347967a51d5120a0c29f3bf',
        179424,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FiraCode',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fira Code font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fira+Code
  static TextTheme firaCodeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: firaCode(textStyle: textTheme.displayLarge),
      displayMedium: firaCode(textStyle: textTheme.displayMedium),
      displaySmall: firaCode(textStyle: textTheme.displaySmall),
      headlineLarge: firaCode(textStyle: textTheme.headlineLarge),
      headlineMedium: firaCode(textStyle: textTheme.headlineMedium),
      headlineSmall: firaCode(textStyle: textTheme.headlineSmall),
      titleLarge: firaCode(textStyle: textTheme.titleLarge),
      titleMedium: firaCode(textStyle: textTheme.titleMedium),
      titleSmall: firaCode(textStyle: textTheme.titleSmall),
      bodyLarge: firaCode(textStyle: textTheme.bodyLarge),
      bodyMedium: firaCode(textStyle: textTheme.bodyMedium),
      bodySmall: firaCode(textStyle: textTheme.bodySmall),
      labelLarge: firaCode(textStyle: textTheme.labelLarge),
      labelMedium: firaCode(textStyle: textTheme.labelMedium),
      labelSmall: firaCode(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fira Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fira+Mono
  static TextStyle firaMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '08ea808f1d45f38b37e0b7b58e69057c9679694990903b85291d1b15db14d660',
        121444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '008de620468faa52a4c3b90908a473813571a0bb7305806725a022cc731f91d8',
        121056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6d750308a3d94ea50c65c29acc574c75481e25ef51ac2c206a73cceb7f9d6148',
        121116,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FiraMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fira Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fira+Mono
  static TextTheme firaMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: firaMono(textStyle: textTheme.displayLarge),
      displayMedium: firaMono(textStyle: textTheme.displayMedium),
      displaySmall: firaMono(textStyle: textTheme.displaySmall),
      headlineLarge: firaMono(textStyle: textTheme.headlineLarge),
      headlineMedium: firaMono(textStyle: textTheme.headlineMedium),
      headlineSmall: firaMono(textStyle: textTheme.headlineSmall),
      titleLarge: firaMono(textStyle: textTheme.titleLarge),
      titleMedium: firaMono(textStyle: textTheme.titleMedium),
      titleSmall: firaMono(textStyle: textTheme.titleSmall),
      bodyLarge: firaMono(textStyle: textTheme.bodyLarge),
      bodyMedium: firaMono(textStyle: textTheme.bodyMedium),
      bodySmall: firaMono(textStyle: textTheme.bodySmall),
      labelLarge: firaMono(textStyle: textTheme.labelLarge),
      labelMedium: firaMono(textStyle: textTheme.labelMedium),
      labelSmall: firaMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fira Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fira+Sans
  static TextStyle firaSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c302e040d34245992eb133cf08e1693b42febc2eea01e0117d13c7ae2f59f19',
        233420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '151a53f4331b8c484b1ee3152e324af7baf998c8a9ab2cf2e7a4dc91363223fa',
        245024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9d0f72d71b286f308226c2b978b5c8fee051daaff3a127c8d4412b5d0168d98',
        236064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2dbacbee625e8e70e85fc45ba18c47b81f60371d6c33b870ccb6b965b719a4d7',
        247432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a20f37112998cb904d77b51fb927dd03b49e5b49b5e156e8b80df45d02010a9',
        235784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd8050eed47cdd26324076943605187dc894ecad961b3d653211cec6558574952',
        246760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5fdba08c2d2c4b4bd8c1b55cb493819eed4dad004f651b0f94fc329db9d15df8',
        235388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1fefeb817e680589e8b6ef12ad6af96789e9df3355637fd87d36a85378581276',
        246320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '01488426d3c090aa18253b49e1d64e0d4a9756612d2943f08f96d7a96b964465',
        235804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd1e300dc1d4601a115f848258971e2fc5cf5ced7e5ac7c19738f8ff023632a96',
        246692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '66ddf8d3f1f24d5c585987960783f473d98beb07d4d07d99c909063022f8a2a6',
        235720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a9202dbb913e0d9a9c8c3445f33fd4380e407700c8acd81c0feaff698b2033f0',
        246904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5aaa26c6509238f767e1bc7399fa4f1fb1671de13741bec5257356316586b47b',
        235776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '82442dffbc9a9b6132a997e53182711adf18d5bd1c7be7469ead5e361ffd787e',
        246628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c3363ea10f6722cf026dc6598bdf2b71df9c7d0effb0b17c50b37d0ed33a3a5',
        235600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1c2fb98f866484f29e535ffab89ce03b282284efbb5f9b98a0f9be33c8d59cba',
        246232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ccddd95d823c849d57f9d0290560614d98f9ab13c1a3ffc1daabd5bf57053278',
        235332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1f0bc9665acb25acf4ea285775f48093079deaa5795b0fd290a9bc7cf248dbd3',
        246416,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FiraSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fira Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fira+Sans
  static TextTheme firaSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: firaSans(textStyle: textTheme.displayLarge),
      displayMedium: firaSans(textStyle: textTheme.displayMedium),
      displaySmall: firaSans(textStyle: textTheme.displaySmall),
      headlineLarge: firaSans(textStyle: textTheme.headlineLarge),
      headlineMedium: firaSans(textStyle: textTheme.headlineMedium),
      headlineSmall: firaSans(textStyle: textTheme.headlineSmall),
      titleLarge: firaSans(textStyle: textTheme.titleLarge),
      titleMedium: firaSans(textStyle: textTheme.titleMedium),
      titleSmall: firaSans(textStyle: textTheme.titleSmall),
      bodyLarge: firaSans(textStyle: textTheme.bodyLarge),
      bodyMedium: firaSans(textStyle: textTheme.bodyMedium),
      bodySmall: firaSans(textStyle: textTheme.bodySmall),
      labelLarge: firaSans(textStyle: textTheme.labelLarge),
      labelMedium: firaSans(textStyle: textTheme.labelMedium),
      labelSmall: firaSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fira Sans Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fira+Sans+Condensed
  static TextStyle firaSansCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ba697ab8e3c5b75e99ebcc4bc829e4a6285f264a7562f55a5c3cc2d00c1ac28',
        232648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '574894781807ceea4adcbb149af68eb8952a2562893a897d0ee4f71c63512c75',
        244300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '64c320e0eee9997d6b1974c69d8ea8752a8b278bf53c7d48169a97b061504e78',
        235160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '42f420b20d8a468617d0b180a61ec0337bc245313aa53ec9f7db22ab3f17ec0a',
        246588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b81707bdf21ef8dadfc143b07eb836cef61f43635bb068ba7fabd1b711c942a',
        235192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5bc9760361df604c665a709dfb23227aad25cfcca7a5d8ae554b774a9d0b146f',
        246176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6c7cad7c52655003099f4c011786eb91c100ea7a34ca29876a9be81d8d795d9',
        234880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b952f77a82e315a404f702a9e9363cc49d2b4b0bdaa0ba288bb4e88c527dbf7d',
        245352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05dd5f07887f3932facd2ea01093cdbc942c384bc84ba09f83de3595f95f302d',
        235080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4790aa9264985273ade79a33eac09b3d7f4f25535243a01e92cb952a40648cd3',
        246220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb77ae62ab1ef041d827ef61be8354d4f6fa010c5f6385d6b55df34b52837041',
        234780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3673cb51e9cc9bf28d2f9e890da00da25f431de229fef439faf3b8acd3624e69',
        245940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b79671f3fd5d200a6c31cece939b69256de361e7e4f4cb04a5fc3b37d769db4',
        235280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e8ed8a133423a9550a1cf8c1a36adc4179574b1f6d3477dc71cda4160a829f31',
        245952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6935e2694b53e53f29bca67c5fea0f79895c725c363c849588c758a0c6d63b0',
        235436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dde2ca3bf1b4af123cd117cfb2503e8d92fdcaac7dabca664fc0cea08f344ae2',
        245968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a87bae50a9ffaac7e64a793751790b5ca43a7ffe7888dca20bb44bb79094b89',
        235012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '07af82b3d03ae8f68070f77a311c6c8b1bfc37d3e6ab45248806bb51f306e461',
        245828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FiraSansCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fira Sans Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fira+Sans+Condensed
  static TextTheme firaSansCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: firaSansCondensed(textStyle: textTheme.displayLarge),
      displayMedium: firaSansCondensed(textStyle: textTheme.displayMedium),
      displaySmall: firaSansCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: firaSansCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: firaSansCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: firaSansCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: firaSansCondensed(textStyle: textTheme.titleLarge),
      titleMedium: firaSansCondensed(textStyle: textTheme.titleMedium),
      titleSmall: firaSansCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: firaSansCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: firaSansCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: firaSansCondensed(textStyle: textTheme.bodySmall),
      labelLarge: firaSansCondensed(textStyle: textTheme.labelLarge),
      labelMedium: firaSansCondensed(textStyle: textTheme.labelMedium),
      labelSmall: firaSansCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fira Sans Extra Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fira+Sans+Extra+Condensed
  static TextStyle firaSansExtraCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53606f36d0e17c9d4fc873a26e96ec92cf959c501a5b0242936a3d5ced588230',
        231744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6f0eac1d7e3b7f8a14f515e2b52cc0dc7e43bf2873c9bf7243c0084f88e49907',
        243792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '656df7e5c063f4dd826045845546c539416bbefc98a6bc1703466ad78a3d8fe1',
        234108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fcd4323faccae55c194d2784d07e8c589c25b9628642e9ecea50ac120369a6bf',
        246268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe0090ce2ffea99f71885678491a8e7aa82933aca5b93f6d9108e69646bbcb70',
        233632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7f57a7576e5c58cf7bcd79371919ed84e777f428fdae28a0d42934e36410e229',
        245768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1cec65774f3fe1b1314a30d94172c8cac12b03fbf773d6552e2ed4c2caa7353d',
        234108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c8aa5bbe371725aa3d7e5737eb855c6a069b5273501ea6e528fa71428efc82f1',
        245412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd4b21198654280b5ba1c4789a87d71d393ea4c7c06b8fa7000da6e94073b08da',
        234848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '14730d588bf5b1852dab586ebe84a4806e92b41a0f736e36810d1cfc4fb6c438',
        246008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a37abfec0f19412c3c80177560594951b9bc5171f4d387f809dfcc112680b4a7',
        234720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b328c24fc8682f15a3582a08d6da35cfc18056625bafeadf86cef4b17eea6f29',
        245824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04f71f02152fce30db4ad4cbc1a46b55931bd440fac30e8c78dccc584b179342',
        234736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f1fec06931388f4c6b56dfb0f04392a9a1fcf98a86794c56371eb4098a33008c',
        245884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '082c933d2056c9961e55631e4e594f5885499cd0d4200658015a5da4f40d3f80',
        234744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '25a7c761fb9d62b22cbd0f1c557f1a1da307bcc8edaaf89de20a24f15cc4c354',
        246184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '39b4b03c5da675546f368ec119ed78118e7be5b465d55108962903b0c2b330c1',
        235032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fac7a28b443c9836c57b0f46a1f10e0c2686fbe270c12d5fb59450c22592e60b',
        247440,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FiraSansExtraCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fira Sans Extra Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fira+Sans+Extra+Condensed
  static TextTheme firaSansExtraCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: firaSansExtraCondensed(textStyle: textTheme.displayLarge),
      displayMedium: firaSansExtraCondensed(textStyle: textTheme.displayMedium),
      displaySmall: firaSansExtraCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: firaSansExtraCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium:
          firaSansExtraCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: firaSansExtraCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: firaSansExtraCondensed(textStyle: textTheme.titleLarge),
      titleMedium: firaSansExtraCondensed(textStyle: textTheme.titleMedium),
      titleSmall: firaSansExtraCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: firaSansExtraCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: firaSansExtraCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: firaSansExtraCondensed(textStyle: textTheme.bodySmall),
      labelLarge: firaSansExtraCondensed(textStyle: textTheme.labelLarge),
      labelMedium: firaSansExtraCondensed(textStyle: textTheme.labelMedium),
      labelSmall: firaSansExtraCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fjalla One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fjalla+One
  static TextStyle fjallaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '84257b8ad8c644985567fb5ccc146a716b1a47b4a17da1703d1d1661e514d660',
        178820,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FjallaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fjalla One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fjalla+One
  static TextTheme fjallaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fjallaOne(textStyle: textTheme.displayLarge),
      displayMedium: fjallaOne(textStyle: textTheme.displayMedium),
      displaySmall: fjallaOne(textStyle: textTheme.displaySmall),
      headlineLarge: fjallaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: fjallaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: fjallaOne(textStyle: textTheme.headlineSmall),
      titleLarge: fjallaOne(textStyle: textTheme.titleLarge),
      titleMedium: fjallaOne(textStyle: textTheme.titleMedium),
      titleSmall: fjallaOne(textStyle: textTheme.titleSmall),
      bodyLarge: fjallaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: fjallaOne(textStyle: textTheme.bodyMedium),
      bodySmall: fjallaOne(textStyle: textTheme.bodySmall),
      labelLarge: fjallaOne(textStyle: textTheme.labelLarge),
      labelMedium: fjallaOne(textStyle: textTheme.labelMedium),
      labelSmall: fjallaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fjord One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fjord+One
  static TextStyle fjordOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47129679f42e28f9a8d6efd369a1307e2d62b816e0084a5ec74c2cf87ba8668b',
        48724,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FjordOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fjord One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fjord+One
  static TextTheme fjordOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fjordOne(textStyle: textTheme.displayLarge),
      displayMedium: fjordOne(textStyle: textTheme.displayMedium),
      displaySmall: fjordOne(textStyle: textTheme.displaySmall),
      headlineLarge: fjordOne(textStyle: textTheme.headlineLarge),
      headlineMedium: fjordOne(textStyle: textTheme.headlineMedium),
      headlineSmall: fjordOne(textStyle: textTheme.headlineSmall),
      titleLarge: fjordOne(textStyle: textTheme.titleLarge),
      titleMedium: fjordOne(textStyle: textTheme.titleMedium),
      titleSmall: fjordOne(textStyle: textTheme.titleSmall),
      bodyLarge: fjordOne(textStyle: textTheme.bodyLarge),
      bodyMedium: fjordOne(textStyle: textTheme.bodyMedium),
      bodySmall: fjordOne(textStyle: textTheme.bodySmall),
      labelLarge: fjordOne(textStyle: textTheme.labelLarge),
      labelMedium: fjordOne(textStyle: textTheme.labelMedium),
      labelSmall: fjordOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Flamenco font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Flamenco
  static TextStyle flamenco({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '65876609e536c172694b648f2b3ce895d7ae0008681644e89b20fbb57ed8751c',
        32828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4500269c0e0f0d9c7888b28c22c7eebf10afa68927231c44a6c6c2c39851d551',
        34848,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Flamenco',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Flamenco font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Flamenco
  static TextTheme flamencoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: flamenco(textStyle: textTheme.displayLarge),
      displayMedium: flamenco(textStyle: textTheme.displayMedium),
      displaySmall: flamenco(textStyle: textTheme.displaySmall),
      headlineLarge: flamenco(textStyle: textTheme.headlineLarge),
      headlineMedium: flamenco(textStyle: textTheme.headlineMedium),
      headlineSmall: flamenco(textStyle: textTheme.headlineSmall),
      titleLarge: flamenco(textStyle: textTheme.titleLarge),
      titleMedium: flamenco(textStyle: textTheme.titleMedium),
      titleSmall: flamenco(textStyle: textTheme.titleSmall),
      bodyLarge: flamenco(textStyle: textTheme.bodyLarge),
      bodyMedium: flamenco(textStyle: textTheme.bodyMedium),
      bodySmall: flamenco(textStyle: textTheme.bodySmall),
      labelLarge: flamenco(textStyle: textTheme.labelLarge),
      labelMedium: flamenco(textStyle: textTheme.labelMedium),
      labelSmall: flamenco(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Flavors font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Flavors
  static TextStyle flavors({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd3008ee81fb0a909bde35aa56f02a5b5800f2df98445aad762dff3bb1a8a21e9',
        184368,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Flavors',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Flavors font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Flavors
  static TextTheme flavorsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: flavors(textStyle: textTheme.displayLarge),
      displayMedium: flavors(textStyle: textTheme.displayMedium),
      displaySmall: flavors(textStyle: textTheme.displaySmall),
      headlineLarge: flavors(textStyle: textTheme.headlineLarge),
      headlineMedium: flavors(textStyle: textTheme.headlineMedium),
      headlineSmall: flavors(textStyle: textTheme.headlineSmall),
      titleLarge: flavors(textStyle: textTheme.titleLarge),
      titleMedium: flavors(textStyle: textTheme.titleMedium),
      titleSmall: flavors(textStyle: textTheme.titleSmall),
      bodyLarge: flavors(textStyle: textTheme.bodyLarge),
      bodyMedium: flavors(textStyle: textTheme.bodyMedium),
      bodySmall: flavors(textStyle: textTheme.bodySmall),
      labelLarge: flavors(textStyle: textTheme.labelLarge),
      labelMedium: flavors(textStyle: textTheme.labelMedium),
      labelSmall: flavors(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fleur De Leah font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fleur+De+Leah
  static TextStyle fleurDeLeah({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5cfa5cde0a12b8af3dab9539a4dc50811973961425a82e31aac8f83514249acb',
        133672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FleurDeLeah',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fleur De Leah font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fleur+De+Leah
  static TextTheme fleurDeLeahTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fleurDeLeah(textStyle: textTheme.displayLarge),
      displayMedium: fleurDeLeah(textStyle: textTheme.displayMedium),
      displaySmall: fleurDeLeah(textStyle: textTheme.displaySmall),
      headlineLarge: fleurDeLeah(textStyle: textTheme.headlineLarge),
      headlineMedium: fleurDeLeah(textStyle: textTheme.headlineMedium),
      headlineSmall: fleurDeLeah(textStyle: textTheme.headlineSmall),
      titleLarge: fleurDeLeah(textStyle: textTheme.titleLarge),
      titleMedium: fleurDeLeah(textStyle: textTheme.titleMedium),
      titleSmall: fleurDeLeah(textStyle: textTheme.titleSmall),
      bodyLarge: fleurDeLeah(textStyle: textTheme.bodyLarge),
      bodyMedium: fleurDeLeah(textStyle: textTheme.bodyMedium),
      bodySmall: fleurDeLeah(textStyle: textTheme.bodySmall),
      labelLarge: fleurDeLeah(textStyle: textTheme.labelLarge),
      labelMedium: fleurDeLeah(textStyle: textTheme.labelMedium),
      labelSmall: fleurDeLeah(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Flow Block font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Flow+Block
  static TextStyle flowBlock({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a921a26678ab2f89f9c27c9af2e5ef27e5e03bd41ce60fd92867391d617a2cd',
        29928,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FlowBlock',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Flow Block font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Flow+Block
  static TextTheme flowBlockTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: flowBlock(textStyle: textTheme.displayLarge),
      displayMedium: flowBlock(textStyle: textTheme.displayMedium),
      displaySmall: flowBlock(textStyle: textTheme.displaySmall),
      headlineLarge: flowBlock(textStyle: textTheme.headlineLarge),
      headlineMedium: flowBlock(textStyle: textTheme.headlineMedium),
      headlineSmall: flowBlock(textStyle: textTheme.headlineSmall),
      titleLarge: flowBlock(textStyle: textTheme.titleLarge),
      titleMedium: flowBlock(textStyle: textTheme.titleMedium),
      titleSmall: flowBlock(textStyle: textTheme.titleSmall),
      bodyLarge: flowBlock(textStyle: textTheme.bodyLarge),
      bodyMedium: flowBlock(textStyle: textTheme.bodyMedium),
      bodySmall: flowBlock(textStyle: textTheme.bodySmall),
      labelLarge: flowBlock(textStyle: textTheme.labelLarge),
      labelMedium: flowBlock(textStyle: textTheme.labelMedium),
      labelSmall: flowBlock(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Flow Circular font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Flow+Circular
  static TextStyle flowCircular({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4039133efa2a0f5126c7c60a1d66e787478bb24152a10279ebaa88fea0594d41',
        36448,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FlowCircular',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Flow Circular font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Flow+Circular
  static TextTheme flowCircularTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: flowCircular(textStyle: textTheme.displayLarge),
      displayMedium: flowCircular(textStyle: textTheme.displayMedium),
      displaySmall: flowCircular(textStyle: textTheme.displaySmall),
      headlineLarge: flowCircular(textStyle: textTheme.headlineLarge),
      headlineMedium: flowCircular(textStyle: textTheme.headlineMedium),
      headlineSmall: flowCircular(textStyle: textTheme.headlineSmall),
      titleLarge: flowCircular(textStyle: textTheme.titleLarge),
      titleMedium: flowCircular(textStyle: textTheme.titleMedium),
      titleSmall: flowCircular(textStyle: textTheme.titleSmall),
      bodyLarge: flowCircular(textStyle: textTheme.bodyLarge),
      bodyMedium: flowCircular(textStyle: textTheme.bodyMedium),
      bodySmall: flowCircular(textStyle: textTheme.bodySmall),
      labelLarge: flowCircular(textStyle: textTheme.labelLarge),
      labelMedium: flowCircular(textStyle: textTheme.labelMedium),
      labelSmall: flowCircular(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Flow Rounded font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Flow+Rounded
  static TextStyle flowRounded({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e7744cc5f582b3429d8fa976ee8f64e83ad2e830ef8b8b2bfe7e07847910bcd7',
        34432,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FlowRounded',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Flow Rounded font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Flow+Rounded
  static TextTheme flowRoundedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: flowRounded(textStyle: textTheme.displayLarge),
      displayMedium: flowRounded(textStyle: textTheme.displayMedium),
      displaySmall: flowRounded(textStyle: textTheme.displaySmall),
      headlineLarge: flowRounded(textStyle: textTheme.headlineLarge),
      headlineMedium: flowRounded(textStyle: textTheme.headlineMedium),
      headlineSmall: flowRounded(textStyle: textTheme.headlineSmall),
      titleLarge: flowRounded(textStyle: textTheme.titleLarge),
      titleMedium: flowRounded(textStyle: textTheme.titleMedium),
      titleSmall: flowRounded(textStyle: textTheme.titleSmall),
      bodyLarge: flowRounded(textStyle: textTheme.bodyLarge),
      bodyMedium: flowRounded(textStyle: textTheme.bodyMedium),
      bodySmall: flowRounded(textStyle: textTheme.bodySmall),
      labelLarge: flowRounded(textStyle: textTheme.labelLarge),
      labelMedium: flowRounded(textStyle: textTheme.labelMedium),
      labelSmall: flowRounded(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Foldit font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Foldit
  static TextStyle foldit({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '993d269374910263a87d5112cf819fedfbf39404a3d86de4f838db37bdb737a1',
        307152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30cb8b2e36430d0c625cfec7be9497b4a4abccb70e66f17d062bdcc59a3c11e8',
        310392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '44e5095cb09fc97e1a6a05238d7da27d40ca6f699ff5d62acfc1ef7f142f5762',
        311528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6d98cd1e2e2b092b0da87a5188a4e431f2392763cd1514514cf03bbb7f19b35',
        312476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ae56414e74e85e5e46c62bcaf0e6b6780a9928524450024824914a28adcd0bc',
        313568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c3667dc3036f9e4bed11ee9b0efa8cfe53311038be5105d65b15b982d5b073b',
        313936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '91a937b28d4773985fa04ca2ee1f77c92e6d1a76717627ea9075d012fe47c39c',
        314576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '959b90ebeb4ff21fd47473174176c50a51e3d3e22f145a012dfd3075512ee1ee',
        315060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e6878d1574b80115a0ebe95c5960027a38d313b0a778e435af0cd62e48b8d1e',
        314024,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Foldit',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Foldit font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Foldit
  static TextTheme folditTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: foldit(textStyle: textTheme.displayLarge),
      displayMedium: foldit(textStyle: textTheme.displayMedium),
      displaySmall: foldit(textStyle: textTheme.displaySmall),
      headlineLarge: foldit(textStyle: textTheme.headlineLarge),
      headlineMedium: foldit(textStyle: textTheme.headlineMedium),
      headlineSmall: foldit(textStyle: textTheme.headlineSmall),
      titleLarge: foldit(textStyle: textTheme.titleLarge),
      titleMedium: foldit(textStyle: textTheme.titleMedium),
      titleSmall: foldit(textStyle: textTheme.titleSmall),
      bodyLarge: foldit(textStyle: textTheme.bodyLarge),
      bodyMedium: foldit(textStyle: textTheme.bodyMedium),
      bodySmall: foldit(textStyle: textTheme.bodySmall),
      labelLarge: foldit(textStyle: textTheme.labelLarge),
      labelMedium: foldit(textStyle: textTheme.labelMedium),
      labelSmall: foldit(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fondamento font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fondamento
  static TextStyle fondamento({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eccab6b3be5e0b95607b9eced707ae4e3b9fa4251c942e217464d1675b490cb7',
        82976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '944dfd218277e723fe28520889e339316cf8dd45622ff395f8911aa52a833b78',
        63488,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Fondamento',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fondamento font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fondamento
  static TextTheme fondamentoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fondamento(textStyle: textTheme.displayLarge),
      displayMedium: fondamento(textStyle: textTheme.displayMedium),
      displaySmall: fondamento(textStyle: textTheme.displaySmall),
      headlineLarge: fondamento(textStyle: textTheme.headlineLarge),
      headlineMedium: fondamento(textStyle: textTheme.headlineMedium),
      headlineSmall: fondamento(textStyle: textTheme.headlineSmall),
      titleLarge: fondamento(textStyle: textTheme.titleLarge),
      titleMedium: fondamento(textStyle: textTheme.titleMedium),
      titleSmall: fondamento(textStyle: textTheme.titleSmall),
      bodyLarge: fondamento(textStyle: textTheme.bodyLarge),
      bodyMedium: fondamento(textStyle: textTheme.bodyMedium),
      bodySmall: fondamento(textStyle: textTheme.bodySmall),
      labelLarge: fondamento(textStyle: textTheme.labelLarge),
      labelMedium: fondamento(textStyle: textTheme.labelMedium),
      labelSmall: fondamento(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fontdiner Swanky font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fontdiner+Swanky
  static TextStyle fontdinerSwanky({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '01e11b1d90a7e10f016230edaac4f985ad96462a2ed2c4c0a3bebab56de0c286',
        43740,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FontdinerSwanky',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fontdiner Swanky font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fontdiner+Swanky
  static TextTheme fontdinerSwankyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fontdinerSwanky(textStyle: textTheme.displayLarge),
      displayMedium: fontdinerSwanky(textStyle: textTheme.displayMedium),
      displaySmall: fontdinerSwanky(textStyle: textTheme.displaySmall),
      headlineLarge: fontdinerSwanky(textStyle: textTheme.headlineLarge),
      headlineMedium: fontdinerSwanky(textStyle: textTheme.headlineMedium),
      headlineSmall: fontdinerSwanky(textStyle: textTheme.headlineSmall),
      titleLarge: fontdinerSwanky(textStyle: textTheme.titleLarge),
      titleMedium: fontdinerSwanky(textStyle: textTheme.titleMedium),
      titleSmall: fontdinerSwanky(textStyle: textTheme.titleSmall),
      bodyLarge: fontdinerSwanky(textStyle: textTheme.bodyLarge),
      bodyMedium: fontdinerSwanky(textStyle: textTheme.bodyMedium),
      bodySmall: fontdinerSwanky(textStyle: textTheme.bodySmall),
      labelLarge: fontdinerSwanky(textStyle: textTheme.labelLarge),
      labelMedium: fontdinerSwanky(textStyle: textTheme.labelMedium),
      labelSmall: fontdinerSwanky(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Forum font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Forum
  static TextStyle forum({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d3d28dec115a097a9f3aac1f87da71ac8a7ba6154b2ecbf390865a8b694212e',
        126504,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Forum',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Forum font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Forum
  static TextTheme forumTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: forum(textStyle: textTheme.displayLarge),
      displayMedium: forum(textStyle: textTheme.displayMedium),
      displaySmall: forum(textStyle: textTheme.displaySmall),
      headlineLarge: forum(textStyle: textTheme.headlineLarge),
      headlineMedium: forum(textStyle: textTheme.headlineMedium),
      headlineSmall: forum(textStyle: textTheme.headlineSmall),
      titleLarge: forum(textStyle: textTheme.titleLarge),
      titleMedium: forum(textStyle: textTheme.titleMedium),
      titleSmall: forum(textStyle: textTheme.titleSmall),
      bodyLarge: forum(textStyle: textTheme.bodyLarge),
      bodyMedium: forum(textStyle: textTheme.bodyMedium),
      bodySmall: forum(textStyle: textTheme.bodySmall),
      labelLarge: forum(textStyle: textTheme.labelLarge),
      labelMedium: forum(textStyle: textTheme.labelMedium),
      labelSmall: forum(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fragment Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fragment+Mono
  static TextStyle fragmentMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c691e5b9c961873bd6e9a288eb0fcc907e2ec16a44f342efb3545bdf1ec6295c',
        67088,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9b80183188dd3eba86abf9bba440518cfe4cd63b01c948195bd72ebb60400214',
        68888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FragmentMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fragment Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fragment+Mono
  static TextTheme fragmentMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fragmentMono(textStyle: textTheme.displayLarge),
      displayMedium: fragmentMono(textStyle: textTheme.displayMedium),
      displaySmall: fragmentMono(textStyle: textTheme.displaySmall),
      headlineLarge: fragmentMono(textStyle: textTheme.headlineLarge),
      headlineMedium: fragmentMono(textStyle: textTheme.headlineMedium),
      headlineSmall: fragmentMono(textStyle: textTheme.headlineSmall),
      titleLarge: fragmentMono(textStyle: textTheme.titleLarge),
      titleMedium: fragmentMono(textStyle: textTheme.titleMedium),
      titleSmall: fragmentMono(textStyle: textTheme.titleSmall),
      bodyLarge: fragmentMono(textStyle: textTheme.bodyLarge),
      bodyMedium: fragmentMono(textStyle: textTheme.bodyMedium),
      bodySmall: fragmentMono(textStyle: textTheme.bodySmall),
      labelLarge: fragmentMono(textStyle: textTheme.labelLarge),
      labelMedium: fragmentMono(textStyle: textTheme.labelMedium),
      labelSmall: fragmentMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Francois One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Francois+One
  static TextStyle francoisOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '152ca1e2339af763185113a3c1ca79d45f5d4c33926f4ef0c8546b32d42d00e6',
        52360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FrancoisOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Francois One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Francois+One
  static TextTheme francoisOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: francoisOne(textStyle: textTheme.displayLarge),
      displayMedium: francoisOne(textStyle: textTheme.displayMedium),
      displaySmall: francoisOne(textStyle: textTheme.displaySmall),
      headlineLarge: francoisOne(textStyle: textTheme.headlineLarge),
      headlineMedium: francoisOne(textStyle: textTheme.headlineMedium),
      headlineSmall: francoisOne(textStyle: textTheme.headlineSmall),
      titleLarge: francoisOne(textStyle: textTheme.titleLarge),
      titleMedium: francoisOne(textStyle: textTheme.titleMedium),
      titleSmall: francoisOne(textStyle: textTheme.titleSmall),
      bodyLarge: francoisOne(textStyle: textTheme.bodyLarge),
      bodyMedium: francoisOne(textStyle: textTheme.bodyMedium),
      bodySmall: francoisOne(textStyle: textTheme.bodySmall),
      labelLarge: francoisOne(textStyle: textTheme.labelLarge),
      labelMedium: francoisOne(textStyle: textTheme.labelMedium),
      labelSmall: francoisOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Frank Ruhl Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Frank+Ruhl+Libre
  static TextStyle frankRuhlLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ecf3c85ff388bfbae62cd2258158b836cbed8b56c2c2dc4f058c4b3f6aea645',
        66688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '780e5e6276a39dfe7a542388cc3d3fbc6f5d0688e95e2dcbb06a292d07fc9376',
        66824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47ea7ca19b18a0c60402e856754aefab86a571511b84dce3d3c3c113efc87c49',
        66716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '64655ee277752b5c236e04ea1edbdac30da63b2e76ec8c824af6b557ab17771d',
        66860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40fa8d517ccae20f9567908549402815d27dcb06710f9746cc2478fe54ef7e28',
        66892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd80c140851cd0b1d6f55369fe980905c33838291b72f7e5858b920822236750',
        67024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25fbdcc4865e7e82cb814371c687016dda71402f303dec6171e6380e4b656819',
        66824,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FrankRuhlLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Frank Ruhl Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Frank+Ruhl+Libre
  static TextTheme frankRuhlLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: frankRuhlLibre(textStyle: textTheme.displayLarge),
      displayMedium: frankRuhlLibre(textStyle: textTheme.displayMedium),
      displaySmall: frankRuhlLibre(textStyle: textTheme.displaySmall),
      headlineLarge: frankRuhlLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: frankRuhlLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: frankRuhlLibre(textStyle: textTheme.headlineSmall),
      titleLarge: frankRuhlLibre(textStyle: textTheme.titleLarge),
      titleMedium: frankRuhlLibre(textStyle: textTheme.titleMedium),
      titleSmall: frankRuhlLibre(textStyle: textTheme.titleSmall),
      bodyLarge: frankRuhlLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: frankRuhlLibre(textStyle: textTheme.bodyMedium),
      bodySmall: frankRuhlLibre(textStyle: textTheme.bodySmall),
      labelLarge: frankRuhlLibre(textStyle: textTheme.labelLarge),
      labelMedium: frankRuhlLibre(textStyle: textTheme.labelMedium),
      labelSmall: frankRuhlLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fraunces font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fraunces
  static TextStyle fraunces({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '693b8b438861584442b0c00d292053123ef12cc7fd261ba48022f009383e0f68',
        71216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f19fe5dda60cde14721341ef0169b3e75ff22d1cde44e5a1490e07d8b02c4df',
        71472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1972ad8176cc064f0fd367ce0af0e78b8433996d8dfe21bda50fac06f335d61b',
        71536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '108c8b2e9e3577975e00019f389d9e73369ce43433c1c38fce106058fc4ce69c',
        71556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc8b5e12d7b8cf29dd85bf12ca2ba365854fa4ab36b87185b706e1fdfa875918',
        71572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8e178d02ade546126b73308c1eab0c521f281b9f65682f99888968651d8a3734',
        71608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5771c664bbbd7d0826de211dd5ec951c2fa35dbeaaf636bc40f29fd5361a7819',
        71564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c994f43fbd1de9c63d83411ffa682b6eba1308d758bb146b60b843392a6d33f1',
        71620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e61a4cb17c3c6a15deb9c34fdd50938c41790fed8ab58e3e814af5cf56a848e1',
        71664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '114813f8baad4e4aec5814fac143573944f05e3838e77c30b007e0ceb77dea3a',
        84824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e045365ea30bbebf9a9f6b0c629e339f1c45a71ccc5fefe72e5a31b3123fb142',
        85000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '694eda78816db6e2c4bd489f137693eb45a8539649b1b0e1fc77ccdc57a729fd',
        85056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '252a4e8a816facb9b439a1d647461c40eb4b442848149295c34ef1571c684d59',
        85004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6495c7b67a118ffecdc1bc69521979ab1887557a0209c46401227c46901c72d2',
        85084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f186752ce9ec917ea3b16cf8f537127e542da7dd2eaf9d3360ba7867d40b3b91',
        85152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5843b0ac271f65e1fd9cea59fc40ee70720e0fd93fe0d53a5494c8dcf6e195c0',
        85052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd3730036c96cbd0253c352a2d2a268c3805e1840722a3a458039827def599b1e',
        85084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'eea1d4902c413e5181917b37cb632ed8ee555c299ce5566e716d81f988f11681',
        85036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Fraunces',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fraunces font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fraunces
  static TextTheme frauncesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fraunces(textStyle: textTheme.displayLarge),
      displayMedium: fraunces(textStyle: textTheme.displayMedium),
      displaySmall: fraunces(textStyle: textTheme.displaySmall),
      headlineLarge: fraunces(textStyle: textTheme.headlineLarge),
      headlineMedium: fraunces(textStyle: textTheme.headlineMedium),
      headlineSmall: fraunces(textStyle: textTheme.headlineSmall),
      titleLarge: fraunces(textStyle: textTheme.titleLarge),
      titleMedium: fraunces(textStyle: textTheme.titleMedium),
      titleSmall: fraunces(textStyle: textTheme.titleSmall),
      bodyLarge: fraunces(textStyle: textTheme.bodyLarge),
      bodyMedium: fraunces(textStyle: textTheme.bodyMedium),
      bodySmall: fraunces(textStyle: textTheme.bodySmall),
      labelLarge: fraunces(textStyle: textTheme.labelLarge),
      labelMedium: fraunces(textStyle: textTheme.labelMedium),
      labelSmall: fraunces(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Freckle Face font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Freckle+Face
  static TextStyle freckleFace({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19ce2bd81ae7c7b609d93e1d3aa51f120f65265b6b2713534c90341543ae1777',
        105988,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FreckleFace',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Freckle Face font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Freckle+Face
  static TextTheme freckleFaceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: freckleFace(textStyle: textTheme.displayLarge),
      displayMedium: freckleFace(textStyle: textTheme.displayMedium),
      displaySmall: freckleFace(textStyle: textTheme.displaySmall),
      headlineLarge: freckleFace(textStyle: textTheme.headlineLarge),
      headlineMedium: freckleFace(textStyle: textTheme.headlineMedium),
      headlineSmall: freckleFace(textStyle: textTheme.headlineSmall),
      titleLarge: freckleFace(textStyle: textTheme.titleLarge),
      titleMedium: freckleFace(textStyle: textTheme.titleMedium),
      titleSmall: freckleFace(textStyle: textTheme.titleSmall),
      bodyLarge: freckleFace(textStyle: textTheme.bodyLarge),
      bodyMedium: freckleFace(textStyle: textTheme.bodyMedium),
      bodySmall: freckleFace(textStyle: textTheme.bodySmall),
      labelLarge: freckleFace(textStyle: textTheme.labelLarge),
      labelMedium: freckleFace(textStyle: textTheme.labelMedium),
      labelSmall: freckleFace(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fredericka the Great font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fredericka+the+Great
  static TextStyle frederickaTheGreat({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe045833e0e825b5a7b4467390cf709cd732b6204eb411fe1a242b48e461319f',
        483876,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FrederickatheGreat',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fredericka the Great font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fredericka+the+Great
  static TextTheme frederickaTheGreatTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: frederickaTheGreat(textStyle: textTheme.displayLarge),
      displayMedium: frederickaTheGreat(textStyle: textTheme.displayMedium),
      displaySmall: frederickaTheGreat(textStyle: textTheme.displaySmall),
      headlineLarge: frederickaTheGreat(textStyle: textTheme.headlineLarge),
      headlineMedium: frederickaTheGreat(textStyle: textTheme.headlineMedium),
      headlineSmall: frederickaTheGreat(textStyle: textTheme.headlineSmall),
      titleLarge: frederickaTheGreat(textStyle: textTheme.titleLarge),
      titleMedium: frederickaTheGreat(textStyle: textTheme.titleMedium),
      titleSmall: frederickaTheGreat(textStyle: textTheme.titleSmall),
      bodyLarge: frederickaTheGreat(textStyle: textTheme.bodyLarge),
      bodyMedium: frederickaTheGreat(textStyle: textTheme.bodyMedium),
      bodySmall: frederickaTheGreat(textStyle: textTheme.bodySmall),
      labelLarge: frederickaTheGreat(textStyle: textTheme.labelLarge),
      labelMedium: frederickaTheGreat(textStyle: textTheme.labelMedium),
      labelSmall: frederickaTheGreat(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fredoka font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fredoka
  static TextStyle fredoka({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4005e941354c2352a3570e1f7c54b10005633b5f2869eeb63867754c0c680e49',
        48716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '125cc34039587d0926961da82659002e686518af02c0771f7224c40a63f2c144',
        48832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa3c58dcf129a67237d2f4284691f0cb1455816149c446a873d29e3868dcc53a',
        48768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70d1c0745883e965e3ae80c61a32ee2e547f444e0804649d673a700989447a29',
        48744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e646f1ecd8e27d6468396ddecc96774207d41706edee7fd82d1a1385ba98d29f',
        48564,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Fredoka',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fredoka font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fredoka
  static TextTheme fredokaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fredoka(textStyle: textTheme.displayLarge),
      displayMedium: fredoka(textStyle: textTheme.displayMedium),
      displaySmall: fredoka(textStyle: textTheme.displaySmall),
      headlineLarge: fredoka(textStyle: textTheme.headlineLarge),
      headlineMedium: fredoka(textStyle: textTheme.headlineMedium),
      headlineSmall: fredoka(textStyle: textTheme.headlineSmall),
      titleLarge: fredoka(textStyle: textTheme.titleLarge),
      titleMedium: fredoka(textStyle: textTheme.titleMedium),
      titleSmall: fredoka(textStyle: textTheme.titleSmall),
      bodyLarge: fredoka(textStyle: textTheme.bodyLarge),
      bodyMedium: fredoka(textStyle: textTheme.bodyMedium),
      bodySmall: fredoka(textStyle: textTheme.bodySmall),
      labelLarge: fredoka(textStyle: textTheme.labelLarge),
      labelMedium: fredoka(textStyle: textTheme.labelMedium),
      labelSmall: fredoka(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Freehand font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Freehand
  static TextStyle freehand({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'daff5e36778ad94ca188cb8200750c233b3f3d317502e2645b7fd9f97b1e3e35',
        176892,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Freehand',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Freehand font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Freehand
  static TextTheme freehandTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: freehand(textStyle: textTheme.displayLarge),
      displayMedium: freehand(textStyle: textTheme.displayMedium),
      displaySmall: freehand(textStyle: textTheme.displaySmall),
      headlineLarge: freehand(textStyle: textTheme.headlineLarge),
      headlineMedium: freehand(textStyle: textTheme.headlineMedium),
      headlineSmall: freehand(textStyle: textTheme.headlineSmall),
      titleLarge: freehand(textStyle: textTheme.titleLarge),
      titleMedium: freehand(textStyle: textTheme.titleMedium),
      titleSmall: freehand(textStyle: textTheme.titleSmall),
      bodyLarge: freehand(textStyle: textTheme.bodyLarge),
      bodyMedium: freehand(textStyle: textTheme.bodyMedium),
      bodySmall: freehand(textStyle: textTheme.bodySmall),
      labelLarge: freehand(textStyle: textTheme.labelLarge),
      labelMedium: freehand(textStyle: textTheme.labelMedium),
      labelSmall: freehand(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fresca font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fresca
  static TextStyle fresca({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8de5fc492647e6ccb18b4fc84cb02a7d99e2b6eebfc07ef585e3bb701702f42f',
        26184,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Fresca',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fresca font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fresca
  static TextTheme frescaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fresca(textStyle: textTheme.displayLarge),
      displayMedium: fresca(textStyle: textTheme.displayMedium),
      displaySmall: fresca(textStyle: textTheme.displaySmall),
      headlineLarge: fresca(textStyle: textTheme.headlineLarge),
      headlineMedium: fresca(textStyle: textTheme.headlineMedium),
      headlineSmall: fresca(textStyle: textTheme.headlineSmall),
      titleLarge: fresca(textStyle: textTheme.titleLarge),
      titleMedium: fresca(textStyle: textTheme.titleMedium),
      titleSmall: fresca(textStyle: textTheme.titleSmall),
      bodyLarge: fresca(textStyle: textTheme.bodyLarge),
      bodyMedium: fresca(textStyle: textTheme.bodyMedium),
      bodySmall: fresca(textStyle: textTheme.bodySmall),
      labelLarge: fresca(textStyle: textTheme.labelLarge),
      labelMedium: fresca(textStyle: textTheme.labelMedium),
      labelSmall: fresca(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Frijole font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Frijole
  static TextStyle frijole({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '35cfe99cb2ca170eeae6f6b1842b5cfec0731addb5734a4c09950fc68e106b69',
        225572,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Frijole',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Frijole font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Frijole
  static TextTheme frijoleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: frijole(textStyle: textTheme.displayLarge),
      displayMedium: frijole(textStyle: textTheme.displayMedium),
      displaySmall: frijole(textStyle: textTheme.displaySmall),
      headlineLarge: frijole(textStyle: textTheme.headlineLarge),
      headlineMedium: frijole(textStyle: textTheme.headlineMedium),
      headlineSmall: frijole(textStyle: textTheme.headlineSmall),
      titleLarge: frijole(textStyle: textTheme.titleLarge),
      titleMedium: frijole(textStyle: textTheme.titleMedium),
      titleSmall: frijole(textStyle: textTheme.titleSmall),
      bodyLarge: frijole(textStyle: textTheme.bodyLarge),
      bodyMedium: frijole(textStyle: textTheme.bodyMedium),
      bodySmall: frijole(textStyle: textTheme.bodySmall),
      labelLarge: frijole(textStyle: textTheme.labelLarge),
      labelMedium: frijole(textStyle: textTheme.labelMedium),
      labelSmall: frijole(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fruktur font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fruktur
  static TextStyle fruktur({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c581ec7fef9069ac8cfa0f3e8803f96af5458a593ab697fd74005d3e685f5177',
        182368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '200b402a6a83604f2c9972bb1ad03c31960ef7771c3ada1e95396c68e8d1c538',
        182784,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Fruktur',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fruktur font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fruktur
  static TextTheme frukturTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fruktur(textStyle: textTheme.displayLarge),
      displayMedium: fruktur(textStyle: textTheme.displayMedium),
      displaySmall: fruktur(textStyle: textTheme.displaySmall),
      headlineLarge: fruktur(textStyle: textTheme.headlineLarge),
      headlineMedium: fruktur(textStyle: textTheme.headlineMedium),
      headlineSmall: fruktur(textStyle: textTheme.headlineSmall),
      titleLarge: fruktur(textStyle: textTheme.titleLarge),
      titleMedium: fruktur(textStyle: textTheme.titleMedium),
      titleSmall: fruktur(textStyle: textTheme.titleSmall),
      bodyLarge: fruktur(textStyle: textTheme.bodyLarge),
      bodyMedium: fruktur(textStyle: textTheme.bodyMedium),
      bodySmall: fruktur(textStyle: textTheme.bodySmall),
      labelLarge: fruktur(textStyle: textTheme.labelLarge),
      labelMedium: fruktur(textStyle: textTheme.labelMedium),
      labelSmall: fruktur(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fugaz One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fugaz+One
  static TextStyle fugazOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '97b68263411764696e4ae45e32e2a3dec8fd61cb6d758f5ac1ae7282ea259ee7',
        25420,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FugazOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fugaz One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fugaz+One
  static TextTheme fugazOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fugazOne(textStyle: textTheme.displayLarge),
      displayMedium: fugazOne(textStyle: textTheme.displayMedium),
      displaySmall: fugazOne(textStyle: textTheme.displaySmall),
      headlineLarge: fugazOne(textStyle: textTheme.headlineLarge),
      headlineMedium: fugazOne(textStyle: textTheme.headlineMedium),
      headlineSmall: fugazOne(textStyle: textTheme.headlineSmall),
      titleLarge: fugazOne(textStyle: textTheme.titleLarge),
      titleMedium: fugazOne(textStyle: textTheme.titleMedium),
      titleSmall: fugazOne(textStyle: textTheme.titleSmall),
      bodyLarge: fugazOne(textStyle: textTheme.bodyLarge),
      bodyMedium: fugazOne(textStyle: textTheme.bodyMedium),
      bodySmall: fugazOne(textStyle: textTheme.bodySmall),
      labelLarge: fugazOne(textStyle: textTheme.labelLarge),
      labelMedium: fugazOne(textStyle: textTheme.labelMedium),
      labelSmall: fugazOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fuggles font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fuggles
  static TextStyle fuggles({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4dd1b180700e4a9e4ff79b8cd1e22239378e07594cbd55fd1571b7a2d0b6ca41',
        99592,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Fuggles',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fuggles font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fuggles
  static TextTheme fugglesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fuggles(textStyle: textTheme.displayLarge),
      displayMedium: fuggles(textStyle: textTheme.displayMedium),
      displaySmall: fuggles(textStyle: textTheme.displaySmall),
      headlineLarge: fuggles(textStyle: textTheme.headlineLarge),
      headlineMedium: fuggles(textStyle: textTheme.headlineMedium),
      headlineSmall: fuggles(textStyle: textTheme.headlineSmall),
      titleLarge: fuggles(textStyle: textTheme.titleLarge),
      titleMedium: fuggles(textStyle: textTheme.titleMedium),
      titleSmall: fuggles(textStyle: textTheme.titleSmall),
      bodyLarge: fuggles(textStyle: textTheme.bodyLarge),
      bodyMedium: fuggles(textStyle: textTheme.bodyMedium),
      bodySmall: fuggles(textStyle: textTheme.bodySmall),
      labelLarge: fuggles(textStyle: textTheme.labelLarge),
      labelMedium: fuggles(textStyle: textTheme.labelMedium),
      labelSmall: fuggles(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Fuzzy Bubbles font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fuzzy+Bubbles
  static TextStyle fuzzyBubbles({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e01f4e5c556a3763a277db9d6b9407868246bdb30fa64e9b028233dc5f4a75d',
        95896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b2f4c2085281de8fadddbfe5acb7cfff3fb9109a6e01fda70408f7b54b700d3',
        88996,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'FuzzyBubbles',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Fuzzy Bubbles font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Fuzzy+Bubbles
  static TextTheme fuzzyBubblesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: fuzzyBubbles(textStyle: textTheme.displayLarge),
      displayMedium: fuzzyBubbles(textStyle: textTheme.displayMedium),
      displaySmall: fuzzyBubbles(textStyle: textTheme.displaySmall),
      headlineLarge: fuzzyBubbles(textStyle: textTheme.headlineLarge),
      headlineMedium: fuzzyBubbles(textStyle: textTheme.headlineMedium),
      headlineSmall: fuzzyBubbles(textStyle: textTheme.headlineSmall),
      titleLarge: fuzzyBubbles(textStyle: textTheme.titleLarge),
      titleMedium: fuzzyBubbles(textStyle: textTheme.titleMedium),
      titleSmall: fuzzyBubbles(textStyle: textTheme.titleSmall),
      bodyLarge: fuzzyBubbles(textStyle: textTheme.bodyLarge),
      bodyMedium: fuzzyBubbles(textStyle: textTheme.bodyMedium),
      bodySmall: fuzzyBubbles(textStyle: textTheme.bodySmall),
      labelLarge: fuzzyBubbles(textStyle: textTheme.labelLarge),
      labelMedium: fuzzyBubbles(textStyle: textTheme.labelMedium),
      labelSmall: fuzzyBubbles(textStyle: textTheme.labelSmall),
    );
  }
}
