package nl.sonck.streamplayer.util

import androidx.media3.common.PlaybackException
import androidx.media3.common.Player

fun Player.listenToError(callback: (error: PlaybackException?) -> Unit) {
    addListener(object : Player.Listener {
        override fun onPlayerError(error: PlaybackException) {
            callback(error)
        }

        override fun onIsPlayingChanged(isPlaying: Boolean) {
            callback(null)
        }
    })
    callback(playerError)
}