package nl.sonck.streamplayer.ui

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.LibraryMusic
import androidx.compose.material.icons.filled.MusicNote
import androidx.compose.material3.HorizontalDivider
import androidx.compose.material3.Icon
import androidx.compose.material3.ListItem
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import nl.sonck.streamplayer.radioknop.Radio

@Composable
fun RadioknopRadioScreen(
    modifier: Modifier = Modifier,
    radios: Map<String, List<Radio>>,
    onRadioSelect: (url: String) -> Unit = {},
    genre: String
) {
    Column {
        ListItem(
            headlineContent = { Text(text = genre) },
            leadingContent = { Icon(Icons.Filled.LibraryMusic, contentDescription = "Genre") },
        )

        HorizontalDivider(thickness = 4.dp)

        LazyColumn(modifier = modifier) {
            items(radios.get(genre) ?: emptyList()) {
                ListItem(
                    modifier = Modifier.clickable { onRadioSelect(it.url) },
                    headlineContent = { Text(text = it.name) },
                    supportingContent = { Text(text = it.description) },
                    leadingContent = {
                        Icon(
                            Icons.Filled.MusicNote, contentDescription = "Station",
                        )
                    }
                )
            }
        }
    }
}

@Preview
@Composable
fun RadioknopRadioScreenPreview() {
    RadioknopRadioScreen(radios = mapOf(
        "ambient" to listOf(
            Radio("Perfect ambiance", "The station with perfect ambiance", "https://perfect-ambiance.org/stream.mp3"),
            Radio("Radiance", "Brighter than the sun", "https://burning.com/radiance.ogg")
        )
    ), genre = "ambient")
}