package nl.sonck.streamplayer.settings

import androidx.compose.runtime.Composable
import androidx.compose.runtime.MutableState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import com.russhwolf.settings.Settings

@Composable
fun rememberStringSettingState(
    key: String,
    settings: Settings = Settings(),
): MutableState<String?> {
    return remember {
        StringSettingValueState(
            settings = settings,
            key = key,
        )
    }
}

class StringSettingValueState(
    private val settings: Settings,
    val key: String,
) : MutableState<String?> {
    private var _value by mutableStateOf(settings.getStringOrNull(key))

    override var value: String?
        get() = _value
        set(value) {
            _value = value
            settings.putString(key, value.orEmpty())
        }

    override fun component1(): String? = _value

    override fun component2(): (String?) -> Unit = { _value = it }
}