package nl.sonck.streamplayer

import android.util.Log
import androidx.media3.common.Player

class StopEnforcer(val player: Player) : Player.Listener {
    init {
        player.addListener(this)
    }

    override fun onIsPlayingChanged(isPlaying: Boolean) {
        if (!isPlaying) {
            when (player.playbackState) {
                Player.STATE_IDLE, Player.STATE_ENDED, Player.STATE_READY -> {
                    Log.d("StopEnforcerer", "Forcing stop")
                    player.stop()
                }

                Player.STATE_BUFFERING -> {
                    Log.d("StopEnforcerer", "Ignoring")
                }
            }
        }
    }
}