package nl.sonck.streamplayer.util

import androidx.media3.common.MediaMetadata
import androidx.media3.common.Player

fun Player.listenToMetadata(callback: (mediaMetadata: MediaMetadata) -> Unit) {
    addListener(object : Player.Listener {
        override fun onMediaMetadataChanged(mediaMetadata: MediaMetadata) {
            callback(mediaMetadata)
        }
    })
    callback(mediaMetadata)
}
