package nl.sonck.streamplayer.ui

import androidx.compose.foundation.clickable
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.LibraryMusic
import androidx.compose.material3.Icon
import androidx.compose.material3.ListItem
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import nl.sonck.streamplayer.radioknop.Radio

@Composable
fun RadioknopGenreScreen(
    modifier: Modifier = Modifier,
    radios: Map<String, List<Radio>>,
    onGenreSelect: (String) -> Unit = {},
) {
    LazyColumn(modifier = modifier) {
        items(radios.entries.toList()) {
            ListItem(
                modifier = Modifier.clickable { onGenreSelect(it.key) },
                headlineContent = { Text(text = it.key) },
                leadingContent = { Icon(Icons.Filled.LibraryMusic, contentDescription = "Genre") }
            )
        }
    }
}

@Preview
@Composable
fun RadioknopScreenPreview() {
    RadioknopGenreScreen(radios = mapOf(
        "ambient" to listOf(),
        "bass" to listOf(),
    ))
}