package nl.sonck.streamplayer.radioknop

import android.util.Log
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import retrofit2.Call
import retrofit2.Retrofit
import retrofit2.await
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.http.GET
import kotlin.math.pow

interface API {
    @GET("api.php")
    fun getRadios(): Call<Map<String, List<Radio>>>
}

@Composable
fun rememberAPI(): API {
    return remember {
        val retrofit = Retrofit.Builder().baseUrl("https://radioknop.nl")
            .addConverterFactory(GsonConverterFactory.create()).build()

        retrofit.create(API::class.java)
    }
}

@Composable
fun radios(): Radios {
    val api = rememberAPI()


    var radioItems by remember {
        mutableStateOf<Map<String, List<Radio>>>(emptyMap())
    }

    LaunchedEffect(Unit) {
        var retries = 0

        while (true) {
            try {
                radioItems = api.getRadios().await()
                kotlinx.coroutines.delay(24 * 60 * 60 * 1000)
                retries = 0
            } catch (e: Exception) {
                Log.w("RadioKnopAPI", "Api fetch failed", e)
                kotlinx.coroutines.delay((2f.pow(retries) * 5000).toLong())

                if (retries < 15) {
                    retries++
                }
            }
        }
    }

    val reverse = HashMap<String, Radio>()
    radioItems.entries.forEach { genre ->
        genre.value.forEach { radio ->
            reverse[radio.url] = radio
        }
    }

    return Radios(radioItems, reverse)
}