/*
 *  This file is part of eduVPN.
 *
 *     eduVPN is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     eduVPN is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with eduVPN.  If not, see <http://www.gnu.org/licenses/>.
 */
package nl.eduvpn.app

import android.content.Context
import android.os.StrictMode
import de.blinkt.openvpn.core.ICSOpenVPNApplication
import nl.eduvpn.app.inject.EduVPNComponent
import nl.eduvpn.app.inject.EduVPNComponent.Initializer.init
import nl.eduvpn.app.utils.SimpleActivityLifecycleCallbacks

/**
 * Application object which keeps track of the app lifecycle.
 * Created by Daniel Zolnai on 2016-09-14.
 */
class EduVPNApplication : ICSOpenVPNApplication() {
    private lateinit var _component: EduVPNComponent

    var runningActivities = 0
        private set

    override fun onCreate() {
        super.onCreate()
        // Set up the injector
        _component = init(this)

        // The base class sets a strict VM policy for debug builds, which do not work well with OkHttp
        // (see this issue: https://github.com/square/okhttp/issues/3537)
        // For now, the best solution seems to be disabling strict mode
        val policy = StrictMode.VmPolicy.Builder().build()
        StrictMode.setVmPolicy(policy)

        registerActivityLifecycleCallbacks(object : SimpleActivityLifecycleCallbacks() {
            override fun onActivityStarted(activity: android.app.Activity) {
                super.onActivityStarted(activity)
                runningActivities++
            }

            override fun onActivityStopped(activity: android.app.Activity) {
                super.onActivityStopped(activity)
                runningActivities--
            }
        })
    }

    fun hasOpenWindows(): Boolean {
        return runningActivities > 0
    }

    fun component(): EduVPNComponent {
        return _component
    }

    companion object {
        fun get(context: Context): EduVPNApplication {
            return context.applicationContext as EduVPNApplication
        }
    }
}
