/*
 * Copyright (c) 2012-2016 Arne Schwabe
 * Distributed under the GNU GPL v2 with additional terms. For full terms see the file doc/LICENSE.txt
 */

package de.blinkt.openvpn.core;

/**
 * Created by arne on 15.11.16.
 */

interface IOpenVPNServiceInternal {

    boolean protect(int fd);

    void userPause(boolean b);

    /**
     * @param replaceConnection True if the VPN is connected by a new connection.
     * @return true if there was a process that has been send a stop signal
     */
    boolean stopVPN(boolean replaceConnection);

    void addAllowedExternalApp(String packagename);

    boolean isAllowedExternalApp(String packagename);

    void challengeResponse(String repsonse);

    /**
    * User of this library is responsible for showing a notification and calling startForeground
    *
    * @param id The identifier for this notification as per
    * {@link NotificationManager#notify(int, Notification)
    * NotificationManager.notify(int, Notification)};
    * @param notification The Notification to be displayed.
    */
    void startForeground(int id, in Notification notification);
}
