#!/bin/bash

# Check for wget or curl
if command -v wget &> /dev/null; then
    DOWNLOAD_CMD="wget -q -O"
elif command -v curl &> /dev/null; then
    DOWNLOAD_CMD="curl -s -o"
else
    echo "Error: Neither wget nor curl is installed. Please install wget or curl to proceed."
    exit 1
fi

echo "Getting and verifying discovery files..."

# Download function
download() {
    URL=$1
    DEST=$2
    $DOWNLOAD_CMD "$DEST" "$URL"
}

# Download files
download "https://disco.eduvpn.org/v2/organization_list.json" "eduvpn-common/internal/discovery/organization_list.json"
download "https://disco.eduvpn.org/v2/organization_list.json.minisig" "eduvpn-common/internal/discovery/organization_list.json.minisig"

download "https://disco.eduvpn.org/v2/server_list.json" "eduvpn-common/internal/discovery/server_list.json"
download "https://disco.eduvpn.org/v2/server_list.json.minisig" "eduvpn-common/internal/discovery/server_list.json.minisig"

# Verify signatures
minisign -Vm "eduvpn-common/internal/discovery/organization_list.json" -P RWRtBSX1alxyGX+Xn3LuZnWUT0w//B6EmTJvgaAxBMYzlQeI+jdrO6KF \
    || minisign -Vm "eduvpn-common/internal/discovery/organization_list.json" -P RWQKqtqvd0R7rUDp0rWzbtYPA3towPWcLDCl7eY9pBMMI/ohCmrS0WiM

minisign -Vm "eduvpn-common/internal/discovery/server_list.json" -P RWRtBSX1alxyGX+Xn3LuZnWUT0w//B6EmTJvgaAxBMYzlQeI+jdrO6KF \
    || minisign -Vm "eduvpn-common/internal/discovery/server_list.json" -P RWQKqtqvd0R7rUDp0rWzbtYPA3towPWcLDCl7eY9pBMMI/ohCmrS0WiM
