# Introduction

This is the eduVPN / Let's Connect! for Android application.

You can clone this repository by executing the following command (provided you have git installed):
    
```bash
$ git clone --recurse-submodules https://codeberg.org/eduVPN/android
```

# Download the app

## Stores

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
     alt="Get it on F-Droid"
     height="80">](https://f-droid.org/packages/nl.eduvpn.app/)
[<img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
     alt="Get it on Google Play"
     height="80">](https://play.google.com/store/apps/details?id=nl.eduvpn.app)

## APKs

* [APKs for eduVPN](https://app.eduvpn.org/#android)
* [APKs for Let's Connect!](https://app.letsconnect-vpn.org/#android)

# Running with Android Studio

First install the `swig` and `go` packages with your operating system package manager.

Make sure you have the latest stable version of Android Studio installed, you can download it from [here](https://developer.android.com/studio).
Open the project by opening the build.gradle in the root of this repository with Android Studio.
Make sure that you have the following packages installed in the SDK Manager (Tools -> SDK Manager):
* SDK Platforms - Android 15
* SDK Tools - Android SDK Build Tools
* SDK Tools - LLDB
* SDK Tools - CMake
* SDK Tools - Android SDK Platform-Tools
* SDK Tools - Android SDK Tools
* SDK Tools - NDK - 28.0.13004108 version (a later version might work, but is untested)

To find a specific version of a package (for the NDK), check the option 'Show Package Details'
in the bottom-lower corner of the SDK Manager.

The app should now build when selecting Run -> Run 'app', or clicking the green play button next
to the device selector.

# Building

**NOTE**: building Android applications takes a lot of resources. The VM used
to build the Let's Connect! application has 6GB of memory and 50G disk. 
Anything lower was not tested, but 1GB of memory definitely does not work.

The builder will spew a lot of backtraces/warnings, but does seem to complete 
eventually.

## Dependencies

### Fedora

```bash
$ sudo dnf -y install \
    unzip \
    tar \
    git \
    swig \
    go \
    java \
    java-devel \
    ncurses-compat-libs \
    ninja-build \
    cmake \
    pv \
    gcc-c++ \
    minisign
```

### Debian >= 12

These instructions were last used on 2025-06-02 with Debian 12.

```bash
$ sudo apt -y install \
    git \
    build-essential \
    golang-go \
    default-jdk \
    cmake \
    swig \
    unzip \
    minisign \
    curl
```

In addition, you MUST install an up to date Go release. The Debian _backports_ 
of the Go compiler MAY not be sufficient. You can use these instructions to 
install the Go compiler that is also used for building the eduVPN server 
packages:

```bash
echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/go+repo@tuxed.net.gpg] https://repo.tuxed.net/golang/v1/deb $(lsb_release -c -s) main" | sudo tee /etc/apt/sources.list.d/golang_v1.list >/dev/null
wget -O- https://repo.tuxed.net/golang/v1/deb/go+repo@tuxed.net.gpg | sudo tee /usr/share/keyrings/go+repo@tuxed.net.gpg >/dev/null
sudo apt update
sudo apt -y dist-upgrade
sudo apt autoremove
```

See [this](https://www.tuxed.net/fkooman/blog/golang-backports.html) post for
more details.

## Key Store

Generate a key store for signing the Android application:

```bash
$ keytool \
    -genkey \
    -keystore ${HOME}/android.jks \
    -keyalg RSA \
    -keysize 4096 \
    -sigalg SHA256withRSA \
    -dname "CN=eduVPN for Android" \
    -validity 10000 \
    -alias eduVPN
```

Additional documentation 
[here](https://developer.android.com/studio/publish/app-signing#signing-manually).

## Setup

```bash
$ ./builder_setup.sh
```

## Build

### Git

To build the app from git, i.e. tag, branch or commit, use the following after 
modifying the file if necessary. Use this if you want to build a test or 
development release.

```bash
$ ./build_app_git.sh
```

You'll find the signed output APK in `${HOME}/Projects`.

### Tar

To build the app from tar, i.e. the archive that contains the full source code
including all submodules, use the following after modifying the file if 
necessary. Use this if you want to use an official release.

```bash
$ ./build_app_tar.sh
```

You'll find the signed output APK in `${HOME}/Projects`.

# Testing

To run all tests, execute the following command:

```bash
$ ./gradlew :app:connectedBasicDebugAndroidTest
```
