package nl.eduvpn.app.utils

import android.view.View
import android.widget.TextView
import com.google.android.material.snackbar.Snackbar
import nl.eduvpn.app.R

/**
 * Modified snackbar, which:
 * - does not hide automatically
 * - has a dismiss button
 * - can display longer messages than the default max 2 lines
 */
object ErrorSnackbar {

    fun make(
        view: View,
        text: CharSequence
    ): Snackbar {
        val snackbar = Snackbar.make(view, text, Snackbar.LENGTH_INDEFINITE)
        val snackbarView = snackbar.view
        val snackTextView = snackbarView.findViewById<View>(com.google.android.material.R.id.snackbar_text) as TextView
        snackTextView.maxLines = 8

        snackbar.setAction(R.string.error_popup_dismiss) {
            snackbar.dismiss()
        }
        return snackbar
    }
}