package org.thoughtcrime.securesms

import android.os.Bundle
import android.view.Window
import android.view.WindowManager
import androidx.compose.runtime.Composable
import org.thoughtcrime.securesms.FullComposeActivity.Companion.applyCommonPropertiesForCompose
import org.thoughtcrime.securesms.ui.setComposeContent

/**
 * Base class for activities that use Compose UI for their full content.
 *
 * It fine-tunes options so that Compose can take over the entire screen.
 */
abstract class FullComposeScreenLockActivity : ScreenLockActionBarActivity() {
    @Composable
    abstract fun ComposeContent()

    final override val applyDefaultWindowInsets: Boolean
        get() = false

    override fun onCreate(savedInstanceState: Bundle?) {
        applyCommonPropertiesForCompose()

        super.onCreate(savedInstanceState)
    }

    override fun onCreate(savedInstanceState: Bundle?, ready: Boolean) {
        super.onCreate(savedInstanceState, ready)

        setComposeContent {
            ComposeContent()
        }
    }
}
