package org.session.libsession.messaging.sending_receiving

import network.loki.messenger.libsession_util.SessionEncrypt
import network.loki.messenger.libsession_util.util.BlindKeyAPI
import network.loki.messenger.libsession_util.util.KeyPair
import org.session.libsession.messaging.MessagingModuleConfiguration
import org.session.libsession.messaging.sending_receiving.MessageReceiver.Error
import org.session.libsignal.utilities.Hex
import org.session.libsignal.utilities.Log
import org.session.libsignal.utilities.removingIdPrefixIfNeeded

@Deprecated("This class is deprecated and new code should try to decrypt/decode message using SessionProtocol API")
object MessageDecrypter {

    /**
     * Decrypts `ciphertext` using the Session protocol and `x25519KeyPair`.
     *
     * @param ciphertext the data to decrypt.
     * @param x25519KeyPair the key pair to use for decryption. This could be the current user's key pair, or the key pair of a closed group.
     *
     * @return the padded plaintext.
     */
    fun decrypt(ciphertext: ByteArray, x25519KeyPair: KeyPair): Pair<ByteArray, String> {
        val recipientX25519PrivateKey = x25519KeyPair.secretKey.data
        val recipientX25519PublicKey = x25519KeyPair.pubKey.data.removingIdPrefixIfNeeded()
        val (id, data) = SessionEncrypt.decryptIncoming(
            x25519PubKey = recipientX25519PublicKey,
            x25519PrivKey = recipientX25519PrivateKey,
            ciphertext = ciphertext
        )

        return data.data to id
    }

    fun decryptBlinded(
        message: ByteArray,
        isOutgoing: Boolean,
        otherBlindedPublicKey: String,
        serverPublicKey: String
    ): Pair<ByteArray, String> {
        val userEdKeyPair = MessagingModuleConfiguration.shared.storage.getUserED25519KeyPair()
            ?: throw Error.NoUserED25519KeyPair
        val blindedKeyPair = BlindKeyAPI.blind15KeyPairOrNull(
            ed25519SecretKey = userEdKeyPair.secretKey.data,
            serverPubKey = Hex.fromStringCondensed(serverPublicKey),
        ) ?: throw Error.DecryptionFailed
        val otherKeyBytes =
            Hex.fromStringCondensed(otherBlindedPublicKey.removingIdPrefixIfNeeded())

        val senderKeyBytes: ByteArray
        val recipientKeyBytes: ByteArray

        if (isOutgoing) {
            senderKeyBytes = blindedKeyPair.pubKey.data
            recipientKeyBytes = otherKeyBytes
        } else {
            senderKeyBytes = otherKeyBytes
            recipientKeyBytes = blindedKeyPair.pubKey.data
        }

        try {
            val (sessionId, plainText) = SessionEncrypt.decryptForBlindedRecipient(
                ciphertext = message,
                myEd25519Privkey = userEdKeyPair.secretKey.data,
                openGroupPubkey = Hex.fromStringCondensed(serverPublicKey),
                senderBlindedId = byteArrayOf(0x15) + senderKeyBytes,
                recipientBlindId = byteArrayOf(0x15) + recipientKeyBytes,
            )

            return plainText.data to sessionId
        } catch (e: Exception) {
            Log.e("MessageDecrypter", "Failed to decrypt blinded message", e)
            throw Error.DecryptionFailed
        }
    }
}