package org.session.libsession.messaging.messages.control

import org.session.libsession.database.MessageDataProvider
import org.session.libsession.messaging.messages.copyExpiration
import org.session.libsignal.protos.SignalServiceProtos

class ReadReceipt() : ControlMessage() {
    var timestamps: List<Long>? = null

    override fun isValid(): Boolean {
        if (!super.isValid()) return false
        val timestamps = timestamps ?: return false
        if (timestamps.isNotEmpty()) { return true }
        return false
    }

    override fun shouldDiscardIfBlocked(): Boolean = true

    companion object {
        const val TAG = "ReadReceipt"

        fun fromProto(proto: SignalServiceProtos.Content): ReadReceipt? {
            val receiptProto = if (proto.hasReceiptMessage()) proto.receiptMessage else return null
            if (receiptProto.type != SignalServiceProtos.ReceiptMessage.Type.READ) return null
            val timestamps = receiptProto.timestampMsList
            if (timestamps.isEmpty()) return null
            return ReadReceipt(timestamps = timestamps)
                    .copyExpiration(proto)
        }
    }

    constructor(timestamps: List<Long>?) : this() {
        this.timestamps = timestamps
    }

    protected override fun buildProto(
        builder: SignalServiceProtos.Content.Builder,
        messageDataProvider: MessageDataProvider
    ) {
        builder
            .receiptMessageBuilder
            .setType(SignalServiceProtos.ReceiptMessage.Type.READ)
            .addAllTimestampMs(requireNotNull(timestamps) {
                "Timestamps is null"
            })
    }
}