<!-- ---------- Header ---------- -->
<div align="center">
  <img width="200" height="200"src="fastlane/metadata/android/en-US/images/icon.png">
  <h1>Transport You</h1>
<p>Privacy focused public transport app built with MD3.</p>

<!-- ---------- Badges ---------- -->
  <div align="center">
    <img alt="License" src="https://img.shields.io/github/license/you-apps/TransportYou?color=c3e7ff&style=flat-square">
    <img alt="Downloads" src="https://img.shields.io/github/downloads/you-apps/TransportYou/total.svg?color=c3e7ff&style=flat-square">
    <img alt="Last commit" src="https://img.shields.io/github/last-commit/you-apps/TransportYou?color=c3e7ff&style=flat-square">
    <img alt="Repo size" src="https://img.shields.io/github/repo-size/you-apps/TransportYou?color=c3e7ff&style=flat-square">
    <img alt="Stars" src="https://img.shields.io/github/stars/you-apps/TransportYou?color=c3e7ff&style=flat-square">
    <br>
</div>
</div>

> [!NOTE]
> The data is obtained via the <a href='https://github.com/schildbach/public-transport-enabler'>public-transport-enabler</a> library, we do **not** guarantee for its correctness.
<!-- ---------- Description ---------- -->
## Features

- [x] Querying trips and train stations
- [x] Dashboard and widget of current departures at a train station
- [x] Bookmarking locations and trips
- [x] Support for many public transport providers
- [x] Viewing trips on a map via [MapLibre](https://maplibre.org/) and [OpenFreeMap](https://openfreemap.org/)

<!-- ---------- Download ---------- -->
## Download
  <div align="center">

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/net.youapps.transport/)
[<img src="https://raw.githubusercontent.com/vadret/android/master/assets/get-github.png" alt="Get it on GitHub" height="80">](https://github.com/you-apps/TransportYou/releases/latest)

</div>

<!-- ---------- Screenshots ---------- -->
## Screenshots

<div style="display: flex;">
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1-home.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2-departures.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3-routes.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/4-trip.png" width=30%>

</div>

<!-- ---------- Contribution ---------- -->
## Feedback and contributions
***All contributions are very welcome!***

* Feel free to join the [Matrix room](https://matrix.to/#/#you-apps:matrix.org) for discussions about the app.
* Bug reports and feature requests can be submitted [here](https://github.com/you-apps/TransportYou/issues) (please make sure to fill out all the requested information properly!).
* If you are a developer and wish to contribute to the app, please **fork** the project and submit a [**pull request**](https://help.github.com/articles/about-pull-requests/).

## Translation
<a href="https://hosted.weblate.org/projects/you-apps/transport-you/">
<img src="https://hosted.weblate.org/widgets/you-apps/-/transport-you/287x66-grey.png" alt="Translation status" />
</a>

## License

Transport You is licensed under the [**GNU General Public License**](https://www.gnu.org/licenses/gpl.html): You can use, study and share it as you want.
