/**
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Copyright (C) 2025 Gijs van Tulder
 */

import { msg } from "@lingui/core/macro";
import { Atlas } from "../Atlas";

export const SnubSquareFreeAtlas = Atlas.fromDefinition({
    id: "SnubSquareFreeAtlas",
    name: msg({
        id: "atlas.SnubSquareFreeAtlas.friendlyName",
        message: "Snub square free",
    }),
    tilingName: msg({
        id: "atlas.SnubSquareFreeAtlas.tilingName",
        message: "Snub square tiling",
    }),
    shapes: {
        S: {
            name: "square",
            angles: [90, 90, 90, 90],
            frequency: 1,
            colorPatterns: [
                [[0, 1, 2, 3]],
                [
                    [0, 0, 1, 1],
                    [0, 1, 1, 0],
                ],
                [[0, 0, 0, 0]],
            ],
            preferredAngles: {
                setupAtlas: 315,
            },
        },
        T: {
            name: "triangle",
            angles: [60, 60, 60],
            frequency: 2,
            colorPatterns: [
                [[0, 1, 2]],
                [
                    [0, 0, 1],
                    [0, 1, 0],
                    [1, 0, 0],
                ],
                [[0, 0, 0]],
            ],
        },
    },
});
