"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rule = exports.name = void 0;
const create_rule_1 = require("../create-rule");
const helpers_1 = require("../helpers");
exports.name = 'no-trans-inside-trans';
exports.rule = (0, create_rule_1.createRule)({
    name: exports.name,
    meta: {
        docs: {
            description: "doesn't allow Trans component be inside Trans component",
            recommended: 'error',
        },
        messages: {
            default: "Trans couldn't be wrapped into Trans",
        },
        schema: [
            {
                type: 'object',
                properties: {},
                additionalProperties: false,
            },
        ],
        type: 'problem',
    },
    defaultOptions: [],
    create: function (context) {
        return {
            [`${helpers_1.LinguiTransQuery} ${helpers_1.LinguiTransQuery}`](node) {
                context.report({
                    node,
                    messageId: 'default',
                });
                return;
            },
        };
    },
});
//# sourceMappingURL=no-trans-inside-trans.js.map