"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rule = exports.name = void 0;
const utils_1 = require("@typescript-eslint/utils");
const helpers_1 = require("../helpers");
const create_rule_1 = require("../create-rule");
exports.name = 'no-single-variables-to-translate';
exports.rule = (0, create_rule_1.createRule)({
    name: exports.name,
    meta: {
        docs: {
            description: "doesn't allow single variables without text to translate",
            recommended: 'error',
        },
        messages: {
            asJsx: "You couldn't translate just a variable, remove Trans or add some text inside",
            asFunction: "You couldn't translate just a variable, remove t`` or add some text inside",
        },
        schema: [
            {
                type: 'object',
                properties: {},
                additionalProperties: false,
            },
        ],
        type: 'problem',
    },
    defaultOptions: [],
    create: function (context) {
        const hasSomeJSXTextWithContent = (nodes) => {
            return nodes.some((jsxChild) => {
                switch (jsxChild.type) {
                    case utils_1.TSESTree.AST_NODE_TYPES.JSXText:
                        return jsxChild.value.trim().length > 0;
                    case utils_1.TSESTree.AST_NODE_TYPES.JSXElement:
                    case utils_1.TSESTree.AST_NODE_TYPES.JSXFragment:
                        return hasSomeJSXTextWithContent(jsxChild.children);
                    default:
                        return false;
                }
            });
        };
        return {
            'JSXElement[openingElement.name.name=Trans]'(node) {
                const hasIdProperty = node.openingElement.attributes.find((attr) => (0, helpers_1.isJSXAttribute)(attr) && attr.name.name === 'id') !== undefined;
                if (!hasSomeJSXTextWithContent(node.children) && !hasIdProperty) {
                    context.report({
                        node,
                        messageId: 'asJsx',
                    });
                }
            },
            [`${helpers_1.LinguiTaggedTemplateExpressionMessageQuery}, ${helpers_1.LinguiCallExpressionMessageQuery}`](node) {
                if (!(0, helpers_1.getText)(node)) {
                    context.report({
                        node,
                        messageId: 'asFunction',
                    });
                }
                return;
            },
        };
    },
});
//# sourceMappingURL=no-single-variables-to-translate.js.map