"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rule = exports.name = void 0;
const utils_1 = require("@typescript-eslint/utils");
const create_rule_1 = require("../create-rule");
const helpers_1 = require("../helpers");
exports.name = 'no-single-tag-to-translate';
exports.rule = (0, create_rule_1.createRule)({
    name: exports.name,
    meta: {
        docs: {
            description: "doesn't allow <Trans></Trans> to wrap a single element unnecessarily.",
            recommended: 'error',
        },
        messages: {
            default: '<Trans></Trans> should not wrap a single element unnecessarily',
        },
        schema: [
            {
                type: 'object',
                properties: {},
                additionalProperties: false,
            },
        ],
        type: 'problem',
    },
    defaultOptions: [],
    create: function (context) {
        return {
            [helpers_1.LinguiTransQuery](node) {
                // delete all spaces or breaks
                const filteredChildren = node.children.filter((child) => {
                    var _a;
                    switch (child.type) {
                        case utils_1.TSESTree.AST_NODE_TYPES.JSXText:
                            return ((_a = child.value) === null || _a === void 0 ? void 0 : _a.trim()) !== '';
                        default:
                            return true;
                    }
                });
                if (filteredChildren.length === 1 &&
                    filteredChildren[0].type !== utils_1.TSESTree.AST_NODE_TYPES.JSXText) {
                    context.report({
                        node,
                        messageId: 'default',
                    });
                }
            },
        };
    },
});
//# sourceMappingURL=no-single-tag-to-translate.js.map