"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
const noExpressionInMessageRule = __importStar(require("./rules/no-expression-in-message"));
const noUnlocalizedStringsRule = __importStar(require("./rules/no-unlocalized-strings"));
const noSingleTagToTranslateRule = __importStar(require("./rules/no-single-tag-to-translate"));
const noSingleVariablesToTranslateRule = __importStar(require("./rules/no-single-variables-to-translate"));
const tCallInFunctionRule = __importStar(require("./rules/t-call-in-function"));
const textRestrictionsRule = __importStar(require("./rules/text-restrictions"));
const noTransInsideTransRule = __importStar(require("./rules/no-trans-inside-trans"));
const consistentPluralFormatRule = __importStar(require("./rules/consistent-plural-format"));
const rules = {
    [noExpressionInMessageRule.name]: noExpressionInMessageRule.rule,
    [noUnlocalizedStringsRule.name]: noUnlocalizedStringsRule.rule,
    [noSingleTagToTranslateRule.name]: noSingleTagToTranslateRule.rule,
    [noSingleVariablesToTranslateRule.name]: noSingleVariablesToTranslateRule.rule,
    [tCallInFunctionRule.name]: tCallInFunctionRule.rule,
    [textRestrictionsRule.name]: textRestrictionsRule.rule,
    [noTransInsideTransRule.name]: noTransInsideTransRule.rule,
    [consistentPluralFormatRule.name]: consistentPluralFormatRule.rule,
};
const plugin = {
    meta: {
        name: 'eslint-plugin-lingui',
    },
    configs: {},
    rules,
};
const recommendedRules = {
    'lingui/t-call-in-function': 'error',
    'lingui/no-single-tag-to-translate': 'warn',
    'lingui/no-single-variables-to-translate': 'warn',
    'lingui/no-trans-inside-trans': 'warn',
    'lingui/no-expression-in-message': 'warn',
};
// Assign configs here so we can reference `plugin`
Object.assign(plugin.configs, {
    recommended: {
        plugins: ['lingui'],
        rules: recommendedRules,
    },
    'flat/recommended': {
        plugins: {
            lingui: plugin,
        },
        rules: recommendedRules,
    },
});
module.exports = plugin;
//# sourceMappingURL=index.js.map