"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const parser_1 = require("@typescript-eslint/parser");
const helpers_1 = require("./helpers");
describe('buildCalleePath', () => {
    function buildCallExp(code) {
        const t = (0, parser_1.parse)(code);
        return t.body[0].expression;
    }
    it('Should build callee path', () => {
        const exp = buildCallExp('one.two.three.four()');
        expect((0, helpers_1.buildCalleePath)(exp.callee)).toBe('one.two.three.four');
    });
    it('Should build with dynamic element', () => {
        const exp = buildCallExp('one.two.three[getProp()]()');
        expect((0, helpers_1.buildCalleePath)(exp.callee)).toBe('one.two.three.$');
    });
    it('Should build with dynamic first element', () => {
        const exp = buildCallExp('getData().two.three.four()');
        expect((0, helpers_1.buildCalleePath)(exp.callee)).toBe('$.two.three.four');
    });
});
//# sourceMappingURL=helpers.test.js.map