"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildCalleePath = exports.isJSXAttribute = exports.isMemberExpression = exports.isIdentifier = exports.isTemplateLiteral = exports.isLiteral = exports.getIdentifierName = exports.getText = exports.getNearestAncestor = exports.isAllowedDOMAttr = exports.isSvgTag = exports.isNativeDOMTag = exports.LinguiPluralComponentQuery = exports.LinguiCallExpressionPluralQuery = exports.LinguiTransQuery = exports.LinguiCallExpressionMessageQuery = exports.LinguiTaggedTemplateExpressionMessageQuery = void 0;
const utils_1 = require("@typescript-eslint/utils");
const constants_1 = require("./constants");
/**
 * Queries for TemplateLiteral in TaggedTemplateExpression expressions:
 *
 * t`Hello`
 * msg`Hello`
 * defineMessage`Hello`
 */
exports.LinguiTaggedTemplateExpressionMessageQuery = ':matches(TaggedTemplateExpression[tag.name=t], TaggedTemplateExpression[tag.name=msg], TaggedTemplateExpression[tag.name=defineMessage]) TemplateLiteral';
/**
 * Queries for TemplateLiteral | StringLiteral in CallExpression expressions:
 *
 * t({message: ``}); t({message: ''})
 * msg({message: ``}); msg({message: ''})
 * defineMessage({message: ``}); defineMessage({message: ''})
 */
exports.LinguiCallExpressionMessageQuery = ':matches(CallExpression[callee.name=t], CallExpression[callee.name=msg], CallExpression[callee.name=defineMessage]) :matches(TemplateLiteral, Literal)';
/**
 * Queries for Trans
 *
 * <Trans></Trans>
 */
exports.LinguiTransQuery = 'JSXElement[openingElement.name.name=Trans]';
/**
 * Queries for plural CallExpression expressions and JSX elements
 *
 * CallExpression: plural(numBooks, { one: "# book", other: "# books" });
 * Component/JSX: <Plural value={messagesCount} one="There's # message in your inbox" other="There are # messages in your inbox" />
 */
exports.LinguiCallExpressionPluralQuery = 'CallExpression[callee.name=plural]';
exports.LinguiPluralComponentQuery = 'JSXElement[openingElement.name.name=Plural]';
function isNativeDOMTag(str) {
    return constants_1.DOM_TAGS.includes(str);
}
exports.isNativeDOMTag = isNativeDOMTag;
function isSvgTag(str) {
    return constants_1.SVG_TAGS.includes(str);
}
exports.isSvgTag = isSvgTag;
const blacklistAttrs = ['placeholder', 'alt', 'aria-label', 'value'];
function isAllowedDOMAttr(tag, attr, attributeNames) {
    if (isSvgTag(tag))
        return true;
    if (isNativeDOMTag(tag)) {
        return !blacklistAttrs.includes(attr);
    }
    return false;
}
exports.isAllowedDOMAttr = isAllowedDOMAttr;
function getNearestAncestor(node, type) {
    let temp = node.parent;
    while (temp) {
        if (temp.type === type) {
            return temp;
        }
        temp = temp.parent;
    }
    return null;
}
exports.getNearestAncestor = getNearestAncestor;
const getText = (node, trimmed = true) => {
    let result = '';
    if (node.type === utils_1.TSESTree.AST_NODE_TYPES.TemplateLiteral) {
        result = node.quasis.map((quasis) => quasis.value.cooked).join('');
    }
    else {
        result = node.value.toString();
    }
    return trimmed ? result.trim() : result;
};
exports.getText = getText;
function getIdentifierName(jsxTagNameExpression) {
    switch (jsxTagNameExpression.type) {
        case utils_1.TSESTree.AST_NODE_TYPES.JSXIdentifier:
            return jsxTagNameExpression.name;
        default:
            return null;
    }
}
exports.getIdentifierName = getIdentifierName;
function isLiteral(node) {
    return (node === null || node === void 0 ? void 0 : node.type) === utils_1.TSESTree.AST_NODE_TYPES.Literal;
}
exports.isLiteral = isLiteral;
function isTemplateLiteral(node) {
    return (node === null || node === void 0 ? void 0 : node.type) === utils_1.TSESTree.AST_NODE_TYPES.TemplateLiteral;
}
exports.isTemplateLiteral = isTemplateLiteral;
function isIdentifier(node) {
    return (node === null || node === void 0 ? void 0 : node.type) === utils_1.TSESTree.AST_NODE_TYPES.Identifier;
}
exports.isIdentifier = isIdentifier;
function isMemberExpression(node) {
    return (node === null || node === void 0 ? void 0 : node.type) === utils_1.TSESTree.AST_NODE_TYPES.MemberExpression;
}
exports.isMemberExpression = isMemberExpression;
function isJSXAttribute(node) {
    return (node === null || node === void 0 ? void 0 : node.type) === utils_1.TSESTree.AST_NODE_TYPES.JSXAttribute;
}
exports.isJSXAttribute = isJSXAttribute;
function buildCalleePath(node) {
    let current = node;
    const path = [];
    const push = (exp) => {
        if (isIdentifier(exp)) {
            path.push(exp.name);
        }
        else {
            path.push('$');
        }
    };
    while (isMemberExpression(current)) {
        push(current.property);
        current = current.object;
    }
    push(current);
    return path.reverse().join('.');
}
exports.buildCalleePath = buildCalleePath;
//# sourceMappingURL=helpers.js.map