import { TSESTree } from '@typescript-eslint/utils';
/**
 * Queries for TemplateLiteral in TaggedTemplateExpression expressions:
 *
 * t`Hello`
 * msg`Hello`
 * defineMessage`Hello`
 */
export declare const LinguiTaggedTemplateExpressionMessageQuery = ":matches(TaggedTemplateExpression[tag.name=t], TaggedTemplateExpression[tag.name=msg], TaggedTemplateExpression[tag.name=defineMessage]) TemplateLiteral";
/**
 * Queries for TemplateLiteral | StringLiteral in CallExpression expressions:
 *
 * t({message: ``}); t({message: ''})
 * msg({message: ``}); msg({message: ''})
 * defineMessage({message: ``}); defineMessage({message: ''})
 */
export declare const LinguiCallExpressionMessageQuery = ":matches(CallExpression[callee.name=t], CallExpression[callee.name=msg], CallExpression[callee.name=defineMessage]) :matches(TemplateLiteral, Literal)";
/**
 * Queries for Trans
 *
 * <Trans></Trans>
 */
export declare const LinguiTransQuery = "JSXElement[openingElement.name.name=Trans]";
/**
 * Queries for plural CallExpression expressions and JSX elements
 *
 * CallExpression: plural(numBooks, { one: "# book", other: "# books" });
 * Component/JSX: <Plural value={messagesCount} one="There's # message in your inbox" other="There are # messages in your inbox" />
 */
export declare const LinguiCallExpressionPluralQuery = "CallExpression[callee.name=plural]";
export declare const LinguiPluralComponentQuery = "JSXElement[openingElement.name.name=Plural]";
export declare function isNativeDOMTag(str: string): boolean;
export declare function isSvgTag(str: string): boolean;
export declare function isAllowedDOMAttr(tag: string, attr: string, attributeNames: string[]): boolean;
export declare function getNearestAncestor<Type>(node: any, type: string): Type | null;
export declare const getText: (node: TSESTree.TemplateLiteral | TSESTree.Literal | TSESTree.JSXText, trimmed?: boolean) => string;
export declare function getIdentifierName(jsxTagNameExpression: TSESTree.JSXTagNameExpression): string;
export declare function isLiteral(node: TSESTree.Node | undefined): node is TSESTree.Literal;
export declare function isTemplateLiteral(node: TSESTree.Node | undefined): node is TSESTree.TemplateLiteral;
export declare function isIdentifier(node: TSESTree.Node | undefined): node is TSESTree.Identifier;
export declare function isMemberExpression(node: TSESTree.Node | undefined): node is TSESTree.MemberExpression;
export declare function isJSXAttribute(node: TSESTree.Node | undefined): node is TSESTree.JSXAttribute;
export declare function buildCalleePath(node: TSESTree.Expression): string;
