"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Handle", {
  enumerable: true,
  get: function () {
    return _WorkerFarm.Handle;
  }
});
Object.defineProperty(exports, "bus", {
  enumerable: true,
  get: function () {
    return _bus.default;
  }
});
exports.default = void 0;
function _assert() {
  const data = _interopRequireDefault(require("assert"));
  _assert = function () {
    return data;
  };
  return data;
}
var _WorkerFarm = _interopRequireWildcard(require("./WorkerFarm"));
function _logger() {
  const data = _interopRequireDefault(require("@parcel/logger"));
  _logger = function () {
    return data;
  };
  return data;
}
var _bus = _interopRequireDefault(require("./bus"));
function _profiler() {
  const data = require("@parcel/profiler");
  _profiler = function () {
    return data;
  };
  return data;
}
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
if (!_WorkerFarm.default.isWorker()) {
  // Forward all logger events originating from workers into the main process
  _bus.default.on('logEvent', e => {
    switch (e.level) {
      case 'info':
        _logger().default.info(e.diagnostics);
        break;
      case 'progress':
        (0, _assert().default)(typeof e.message === 'string');
        _logger().default.progress(e.message);
        break;
      case 'verbose':
        _logger().default.verbose(e.diagnostics);
        break;
      case 'warn':
        _logger().default.warn(e.diagnostics);
        break;
      case 'error':
        _logger().default.error(e.diagnostics);
        break;
      default:
        throw new Error('Unknown log level');
    }
  });

  // Forward all trace events originating from workers into the main process
  _bus.default.on('traceEvent', e => {
    _profiler().tracer.trace(e);
  });
}
var _default = exports.default = _WorkerFarm.default;