"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function _plugin() {
  const data = require("@parcel/plugin");
  _plugin = function () {
    return data;
  };
  return data;
}
function _path() {
  const data = _interopRequireDefault(require("path"));
  _path = function () {
    return data;
  };
  return data;
}
function _sass() {
  const data = _interopRequireDefault(require("sass"));
  _sass = function () {
    return data;
  };
  return data;
}
var _legacy = require("./legacy");
var _modern = require("./modern");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = new (_plugin().Transformer)({
  async loadConfig({
    config,
    options
  }) {
    let configFile = await config.getConfig(['.sassrc', '.sassrc.json', '.sassrc.js', '.sassrc.cjs', '.sassrc.mjs'], {
      packageKey: 'sass'
    });
    let configResult = configFile ? configFile.contents : {};

    // Some packages in the wild declare a field `sass` in the package.json that
    // is a relative path to the sass entrypoint. In those cases we simply
    // initialize the config to an empty object.
    if (typeof configResult === 'string') {
      configResult = {};
    }
    let version = detectVersion(configResult);
    if (version === 'legacy') {
      // Resolve relative paths from config file
      if (configFile && configResult.includePaths) {
        configResult.includePaths = configResult.includePaths.map(p => _path().default.resolve(_path().default.dirname(configFile.filePath), p));
      }
      if (configResult.importer === undefined) {
        configResult.importer = [];
      } else if (!Array.isArray(configResult.importer)) {
        configResult.importer = [configResult.importer];
      }

      // Always emit sourcemap
      configResult.sourceMap = true;
      // sources are created relative to the directory of outFile
      configResult.outFile = _path().default.join(options.projectRoot, 'style.css.map');
      configResult.omitSourceMapUrl = true;
      configResult.sourceMapContents = false;
    } else if (version === 'modern') {
      // Resolve relative paths from config file
      if (configFile && configResult.loadPaths) {
        configResult.loadPaths = configResult.loadPaths.map(p => _path().default.resolve(_path().default.dirname(configFile.filePath), p));
      }

      // Always emit sourcemap
      configResult.sourceMap = true;
    }
    return {
      version,
      config: configResult
    };
  },
  async transform({
    asset,
    options,
    config: {
      version,
      config
    },
    resolve
  }) {
    if (version === 'legacy') {
      await (0, _legacy.transformLegacy)(asset, config, resolve, options);
    } else {
      await (0, _modern.transformModern)(asset, config, resolve, options);
    }
    return [asset];
  }
});
function detectVersion(config) {
  if (!_sass().default.compileStringAsync) {
    return 'legacy';
  }
  for (let legacyOption of ['data', 'indentType', 'indentWidth', 'linefeed', 'outputStyle', 'importer', 'pkgImporter', 'includePaths', 'omitSourceMapUrl', 'outFile', 'sourceMapContents', 'sourceMapEmbed', 'sourceMapRoot']) {
    if (config[legacyOption] != null) {
      return 'legacy';
    }
  }
  for (let modernOption of ['loadPaths', 'sourceMapIncludeSources', 'style', 'importers']) {
    if (config[modernOption] != null) {
      return 'modern';
    }
  }
  if (typeof config.sourceMap === 'string') {
    return 'legacy';
  }
  if (config.functions && typeof config.functions === 'object' && Object.keys(config.functions).length > 0) {
    for (let key in config.functions) {
      let fn = config.functions[key];
      if (typeof fn === 'function' && fn.length > 1) {
        return 'legacy';
      }
    }
  }
  return 'modern';
}