"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function _assert() {
  const data = _interopRequireDefault(require("assert"));
  _assert = function () {
    return data;
  };
  return data;
}
function _plugin() {
  const data = require("@parcel/plugin");
  _plugin = function () {
    return data;
  };
  return data;
}
function _utils() {
  const data = require("@parcel/utils");
  _utils = function () {
    return data;
  };
  return data;
}
function _path() {
  const data = _interopRequireDefault(require("path"));
  _path = function () {
    return data;
  };
  return data;
}
function _nullthrows() {
  const data = _interopRequireDefault(require("nullthrows"));
  _nullthrows = function () {
    return data;
  };
  return data;
}
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = new (_plugin().Reporter)({
  async report({
    event,
    options
  }) {
    if (event.type !== 'buildSuccess') {
      return;
    }
    let bundlesByTarget = new (_utils().DefaultMap)(() => []);
    for (let bundle of event.bundleGraph.getBundles()) {
      bundlesByTarget.get(bundle.target.name).push(bundle);
    }
    let reportsDir = _path().default.join(options.projectRoot, 'parcel-bundle-reports');
    await options.outputFS.mkdirp(reportsDir);
    await Promise.all([...bundlesByTarget.entries()].map(async ([targetName, bundles]) => {
      return options.outputFS.writeFile(_path().default.join(reportsDir, `${targetName}.html`), `
          <html>
            <head>
              <meta charset="utf-8">
              <title>📦Parcel Bundle Analyzer | ${targetName}</title>
              <style>
                body {
                  margin: 0;
                }

                .tooltip {
                  background-color: rgba(255, 255, 255, 0.7);
                  left: 0;
                  padding: 20px;
                  pointer-events: none;
                  position: absolute;
                  top: 0;
                  transform: translate3d(0, 0, 0);
                }

                .tooltip-content {
                  font-family: monospace;
                }

                .tooltip-content dl div {
                  display: flex;
                }

                .tooltip-title {
                  font-size: 18px;
                }
              </style>
              <script>
                ${await options.inputFS.readFile(_path().default.resolve(__dirname, '../client/vendor/foamtree/carrotsearch.foamtree.js'), 'utf8')}
              </script>
              <script id="bundle-data" type="application/json">
                ${JSON.stringify(await getBundleData(bundles, options))}
              </script>
            </head>
            <body>
              <script>
                ${await options.inputFS.readFile(_path().default.resolve(__dirname, '../client/index.js'), 'utf8')}
              </script>
            </body>
          </html>
        `);
    }));
  }
});
async function getBundleData(bundles, options) {
  let groups = await Promise.all(bundles.map(bundle => getBundleNode(bundle, options)));
  return {
    groups
  };
}
let createMap = () => new (_utils().DefaultMap)(() => createMap());
async function getBundleNode(bundle, options) {
  let buildMetrics = await (0, _utils().generateBuildMetrics)([bundle], options.outputFS, options.projectRoot);
  let bundleData = buildMetrics.bundles[0];
  let dirMap = createMap();
  for (let asset of bundleData.assets) {
    let relativePath = _path().default.relative(options.projectRoot, asset.filePath);
    let parts = relativePath.split(_path().default.sep);
    let dirs = parts.slice(0, parts.length - 1);
    let basename = _path().default.basename(asset.filePath);
    let map = dirMap;
    for (let dir of dirs) {
      (0, _assert().default)(map instanceof _utils().DefaultMap);
      map = map.get(dir);
    }
    (0, _assert().default)(map instanceof _utils().DefaultMap);
    map.set(basename, {
      basename,
      size: asset.size
    });
  }
  return {
    label: _path().default.relative(options.projectRoot, bundle.filePath),
    weight: bundle.stats.size,
    groups: generateGroups(dirMap)
  };
}
function generateGroups(dirMap) {
  let groups = [];
  for (let [directoryName, contents] of dirMap) {
    if (contents instanceof _utils().DefaultMap) {
      let childrenGroups = generateGroups(contents);
      if (childrenGroups.length === 1) {
        let firstChild = childrenGroups[0];
        groups.push({
          ...firstChild,
          label: _path().default.join(directoryName, firstChild.label)
        });
      } else {
        groups.push({
          label: directoryName,
          weight: childrenGroups.reduce((acc, g) => acc + (0, _nullthrows().default)(g.weight), 0),
          groups: childrenGroups
        });
      }
    } else {
      // file
      groups.push({
        label: contents.basename === '' ? 'Code from unknown source files' : contents.basename,
        weight: contents.size
      });
    }
  }
  return groups;
}