"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function _assert() {
  const data = _interopRequireDefault(require("assert"));
  _assert = function () {
    return data;
  };
  return data;
}
function _plugin() {
  const data = require("@parcel/plugin");
  _plugin = function () {
    return data;
  };
  return data;
}
function _utils() {
  const data = require("@parcel/utils");
  _utils = function () {
    return data;
  };
  return data;
}
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = new (_plugin().Packager)({
  async package({
    bundle,
    bundleGraph
  }) {
    let assets = [];
    bundle.traverseAssets(asset => {
      assets.push(asset);
    });
    _assert().default.equal(assets.length, 1, 'Raw bundles must only contain one asset');
    let {
      contents
    } = (0, _utils().replaceURLReferences)({
      bundle,
      bundleGraph,
      contents: await assets[0].getCode(),
      relative: false,
      getReplacement: s => s
    });
    return {
      contents
    };
  }
});